--**************************************************************
--  Copyright (c) 2008 Xilinx, Inc.  All rights reserved.
--  File Name    : simprim_Vcomponents_mti.vhd
--  Library      : simprim
--  Release      : 11.1
--  Entity Count : 275
--  Time         : Fri Apr  9 22:51:31 2010
--  Generated by : gencomp.pl
--**************************************************************

library IEEE;
use IEEE.STD_LOGIC_1164.all;
library IEEE;
use IEEE.VITAL_Timing.all;
package VCOMPONENTS is


-- synopsys translate_off

-----------------------------------------
-----------   FPGA Globals --------------
-----------------------------------------
signal GSR : std_logic := '0';
signal GTS : std_logic := '0';
signal GWE : std_logic := '0';
signal PLL_LOCKG : std_logic := 'H';

-----------------------------------------
-----------   CPLD Globals --------------
-----------------------------------------
signal PRLD : std_logic := '0';

-----------------------------------------
-----------   JTAG Globals --------------
-----------------------------------------
signal JTAG_TDO_GLBL  : std_logic;
signal JTAG_TDI_GLBL  : std_logic := '0';
signal JTAG_TMS_GLBL  : std_logic := '0';
signal JTAG_TCK_GLBL  : std_logic := '0';
signal JTAG_TRST_GLBL : std_logic := '0';

signal JTAG_CAPTURE_GLBL : std_logic := '0';
signal JTAG_RESET_GLBL : std_logic   := '1';
signal JTAG_SHIFT_GLBL : std_logic   := '1';
signal JTAG_UPDATE_GLBL : std_logic  := '0';
signal JTAG_RUNTEST_GLBL : std_logic  := '0';

signal JTAG_SEL1_GLBL : std_logic := '0';
signal JTAG_SEL2_GLBL : std_logic := '0';
signal JTAG_SEL3_GLBL : std_logic := '0';
signal JTAG_SEL4_GLBL : std_logic := '0';

signal JTAG_USER_TDO1_GLBL : std_logic := 'Z';
signal JTAG_USER_TDO2_GLBL : std_logic := 'Z';
signal JTAG_USER_TDO3_GLBL : std_logic := 'Z';
signal JTAG_USER_TDO4_GLBL : std_logic := 'Z';

-- synopsys translate_on

-- START COMPONENT
----- component DOUT_OSERDESE1_VHD -----
component DOUT_OSERDESE1_VHD
  generic (
     DATA_RATE_OQ : string := "DDR";
     INIT_OQ : bit := '0';
     INTERFACE_TYPE : string := "DEFAULT";
     SRVAL_OQ : bit := '0'
  );
  port (
     D2RNK2_OUT : out std_ulogic;
     OQ : out std_ulogic;
     BUFO : in std_ulogic;
     CLK : in std_ulogic;
     DATA1 : in std_ulogic;
     DATA2 : in std_ulogic;
     DDR3_MODE : in std_ulogic;
     OCE : in std_ulogic;
     SR : in std_ulogic
  );
end component;

----- component FIFO_ADDR_OSERDESE1_VHD -----
component FIFO_ADDR_OSERDESE1_VHD
  port (
     EXTRA : out std_ulogic;
     QRD : out std_logic_vector (1 downto 0);
     QWC : out std_logic_vector (1 downto 0);
     RD_GAP1 : out std_ulogic;
     BUFG_CLK : in std_ulogic;
     BUFOP_CLK : in std_ulogic;
     BUFO_CLK : in std_ulogic;
     DATA : in std_ulogic;
     RST_BUFG_WC : in std_ulogic;
     RST_BUFOP_RC : in std_ulogic;
     RST_BUFO_RC : in std_ulogic
  );
end component;

----- component FIFO_RESET_OSERDESE1_VHD -----
component FIFO_RESET_OSERDESE1_VHD
  port (
     RST_BUFG_P : out std_ulogic;
     RST_BUFG_WC : out std_ulogic;
     RST_BUFOP_RC : out std_ulogic;
     RST_BUFO_P : out std_ulogic;
     RST_BUFO_RC : out std_ulogic;
     BUFG_CLK : in std_ulogic;
     BUFOP_CLK : in std_ulogic;
     BUFO_CLK : in std_ulogic;
     CLKDIV : in std_ulogic;
     DIVIDE_2 : in std_ulogic;
     RST : in std_ulogic;
     RST_CNTR : in std_ulogic
  );
end component;

----- component FIFO_TDPIPE_OSERDESE1_VHD -----
component FIFO_TDPIPE_OSERDESE1_VHD
  port (
     MUXOUT : out std_ulogic;
     BUFG_CLK : in std_ulogic;
     BUFO_CLK : in std_ulogic;
     DDR3_DATA : in std_ulogic;
     DDR3_MODE : in std_ulogic;
     DIN : in std_ulogic;
     EXTRA : in std_ulogic;
     ODV : in std_ulogic;
     QRD : in std_logic_vector (1 downto 0);
     QWC : in std_logic_vector (1 downto 0);
     RD_GAP1 : in std_ulogic;
     RST_BUFG_P : in std_ulogic;
     RST_BUFO_P : in std_ulogic
  );
end component;

----- component IODLYCTRL_NPRE_OSERDESE1_VHD -----
component IODLYCTRL_NPRE_OSERDESE1_VHD
  port (
     BUFO_OUT : out std_ulogic;
     IODELAY_STATE : out std_ulogic;
     RST_CNTR : out std_ulogic;
     BUFG_CLK : in std_ulogic;
     BUFG_CLKDIV : in std_ulogic;
     BUFO_CLK : in std_ulogic;
     DDR3_DIMM : in std_ulogic;
     RST : in std_ulogic;
     TRIF : in std_ulogic;
     WC : in std_ulogic;
     WL6 : in std_ulogic
  );
end component;

----- component RANK12D_OSERDESE1_VHD -----
component RANK12D_OSERDESE1_VHD
  generic (
     DATA_RATE_OQ : string := "DDR";
     DATA_WIDTH : integer := 4;
     INIT_OQ : bit := '0';
     SERDES_MODE : string := "MASTER";
     SRVAL_OQ : bit := '1'
  );
  port (
     DATA1_OUT : out std_ulogic;
     DATA2_OUT : out std_ulogic;
     IOCLK_GLITCH : out std_ulogic;
     LOAD : out std_ulogic;
     SHIFTOUT1 : out std_ulogic;
     SHIFTOUT2 : out std_ulogic;
     C : in std_ulogic;
     CLKDIV : in std_ulogic;
     D1 : in std_ulogic;
     D2 : in std_ulogic;
     D2RNK2 : in std_ulogic;
     D3 : in std_ulogic;
     D4 : in std_ulogic;
     D5 : in std_ulogic;
     D6 : in std_ulogic;
     OCE : in std_ulogic;
     SHIFTIN1 : in std_ulogic;
     SHIFTIN2 : in std_ulogic;
     SR : in std_ulogic
  );
end component;

----- component TOUT_OSERDESE1_VHD -----
component TOUT_OSERDESE1_VHD
  generic (
     INIT_TQ : bit := '0';
     SRVAL_TQ : bit := '1';
     TRISTATE_WIDTH : integer := 1
  );
  port (
     TQ : out std_ulogic;
     BUFO : in std_ulogic;
     CLK : in std_ulogic;
     DATA1 : in std_ulogic;
     DATA2 : in std_ulogic;
     DDR3_MODE : in std_ulogic;
     SR : in std_ulogic;
     TCE : in std_ulogic
  );
end component;

----- component TRIF_OSERDESE1_VHD -----
component TRIF_OSERDESE1_VHD
  generic (
     INIT_TQ : bit := '0';
     SRVAL_TQ : bit := '1';
     TRISTATE_WIDTH : integer := 1
  );
  port (
     DATA1_OUT : out std_ulogic;
     DATA2_OUT : out std_ulogic;
     C : in std_ulogic;
     CLKDIV : in std_ulogic;
     LOAD : in std_ulogic;
     SR : in std_ulogic;
     T1 : in std_ulogic;
     T2 : in std_ulogic;
     T3 : in std_ulogic;
     T4 : in std_ulogic;
     TCE : in std_ulogic
  );
end component;

----- component TXBUFFER_OSERDESE1_VHD -----
component TXBUFFER_OSERDESE1_VHD
  port (
     EXTRA : out std_ulogic;
     IODELAY_STATE : out std_ulogic;
     QMUX1 : out std_ulogic;
     QMUX2 : out std_ulogic;
     TMUX1 : out std_ulogic;
     TMUX2 : out std_ulogic;
     BUFO : in std_ulogic;
     BUFOP : in std_ulogic;
     CLK : in std_ulogic;
     CLKDIV : in std_ulogic;
     D1 : in std_ulogic;
     D2 : in std_ulogic;
     DDR3_DATA : in std_ulogic;
     DDR3_MODE : in std_ulogic;
     ODELAY_USED : in std_ulogic;
     ODV : in std_ulogic;
     RST : in std_ulogic;
     T1 : in std_ulogic;
     T2 : in std_ulogic;
     TRIF : in std_ulogic;
     WC : in std_ulogic
  );
end component;

----- component X_AND16 -----
component X_AND16
  generic (
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     Xon : boolean := true;
     tipd_I0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I10 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I11 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I12 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I13 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I14 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I15 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I2 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I3 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I4 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I5 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I6 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I7 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I8 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I9 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I0_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I10_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I11_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I12_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I13_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I14_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I15_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I1_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I2_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I3_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I4_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I5_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I6_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I7_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I8_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I9_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I10 : in std_ulogic;
     I11 : in std_ulogic;
     I12 : in std_ulogic;
     I13 : in std_ulogic;
     I14 : in std_ulogic;
     I15 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic;
     I5 : in std_ulogic;
     I6 : in std_ulogic;
     I7 : in std_ulogic;
     I8 : in std_ulogic;
     I9 : in std_ulogic
  );
end component;

----- component X_AND2 -----
component X_AND2
  generic (
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     Xon : boolean := true;
     tipd_I0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I0_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I1_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic
  );
end component;

----- component X_AND2B1L -----
component X_AND2B1L
  generic (
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     Xon : boolean := true;
     tipd_DI : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_SRI : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_DI_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_SRI_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     DI : in std_ulogic;
     SRI : in std_ulogic
  );
end component;

----- component X_AND3 -----
component X_AND3
  generic (
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     Xon : boolean := true;
     tipd_I0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I2 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I0_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I1_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I2_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic
  );
end component;

----- component X_AND32 -----
component X_AND32
  generic (
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     Xon : boolean := true;
     tipd_I0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I10 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I11 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I12 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I13 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I14 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I15 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I16 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I17 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I18 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I19 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I2 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I20 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I21 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I22 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I23 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I24 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I25 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I26 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I27 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I28 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I29 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I3 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I30 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I31 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I4 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I5 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I6 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I7 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I8 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I9 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I0_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I10_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I11_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I12_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I13_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I14_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I15_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I16_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I17_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I18_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I19_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I1_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I20_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I21_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I22_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I23_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I24_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I25_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I26_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I27_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I28_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I29_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I2_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I30_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I31_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I3_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I4_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I5_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I6_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I7_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I8_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I9_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I10 : in std_ulogic;
     I11 : in std_ulogic;
     I12 : in std_ulogic;
     I13 : in std_ulogic;
     I14 : in std_ulogic;
     I15 : in std_ulogic;
     I16 : in std_ulogic;
     I17 : in std_ulogic;
     I18 : in std_ulogic;
     I19 : in std_ulogic;
     I2 : in std_ulogic;
     I20 : in std_ulogic;
     I21 : in std_ulogic;
     I22 : in std_ulogic;
     I23 : in std_ulogic;
     I24 : in std_ulogic;
     I25 : in std_ulogic;
     I26 : in std_ulogic;
     I27 : in std_ulogic;
     I28 : in std_ulogic;
     I29 : in std_ulogic;
     I3 : in std_ulogic;
     I30 : in std_ulogic;
     I31 : in std_ulogic;
     I4 : in std_ulogic;
     I5 : in std_ulogic;
     I6 : in std_ulogic;
     I7 : in std_ulogic;
     I8 : in std_ulogic;
     I9 : in std_ulogic
  );
end component;

----- component X_AND4 -----
component X_AND4
  generic (
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     Xon : boolean := true;
     tipd_I0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I2 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I3 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I0_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I1_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I2_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I3_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic
  );
end component;

----- component X_AND5 -----
component X_AND5
  generic (
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     Xon : boolean := true;
     tipd_I0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I2 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I3 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I4 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I0_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I1_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I2_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I3_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I4_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic
  );
end component;

----- component X_AND6 -----
component X_AND6
  generic (
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     Xon : boolean := true;
     tipd_I0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I2 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I3 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I4 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I5 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I0_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I1_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I2_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I3_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I4_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I5_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic;
     I5 : in std_ulogic
  );
end component;

----- component X_AND7 -----
component X_AND7
  generic (
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     Xon : boolean := true;
     tipd_I0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I2 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I3 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I4 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I5 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I6 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I0_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I1_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I2_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I3_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I4_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I5_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I6_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic;
     I5 : in std_ulogic;
     I6 : in std_ulogic
  );
end component;

----- component X_AND8 -----
component X_AND8
  generic (
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     Xon : boolean := true;
     tipd_I0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I2 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I3 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I4 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I5 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I6 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I7 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I0_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I1_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I2_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I3_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I4_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I5_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I6_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I7_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic;
     I5 : in std_ulogic;
     I6 : in std_ulogic;
     I7 : in std_ulogic
  );
end component;

----- component X_AND9 -----
component X_AND9
  generic (
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     Xon : boolean := true;
     tipd_I0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I2 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I3 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I4 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I5 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I6 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I7 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I8 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I0_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I1_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I2_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I3_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I4_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I5_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I6_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I7_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I8_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic;
     I5 : in std_ulogic;
     I6 : in std_ulogic;
     I7 : in std_ulogic;
     I8 : in std_ulogic
  );
end component;

----- component X_AUTOBUF -----
component X_AUTOBUF
  generic (
     BUFFER_TYPE : string := "AUTO";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     PATHPULSE : time := 0 ps;
     Xon : boolean := true;
     tipd_I : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;

----- component X_BPAD -----
component X_BPAD
  generic (
     LOC : string := "UNPLACED"
  );
  port (
     PAD : inout std_ulogic
  );
end component;

----- component X_BSCAN_FPGACORE -----
component X_BSCAN_FPGACORE
  port (
     CAPTURE : out std_ulogic := 'H';
     DRCK1 : out std_ulogic := 'H';
     DRCK2 : out std_ulogic := 'H';
     RESET : out std_ulogic := 'H';
     SEL1 : out std_ulogic := 'L';
     SEL2 : out std_ulogic := 'L';
     SHIFT : out std_ulogic := 'L';
     TDI : out std_ulogic := 'L';
     UPDATE : out std_ulogic := 'L';
     TDO1 : in std_ulogic := 'X';
     TDO2 : in std_ulogic := 'X'
  );
end component;

----- component X_BSCAN_SPARTAN3 -----
component X_BSCAN_SPARTAN3
  port (
     CAPTURE : out std_ulogic := 'H';
     DRCK1 : out std_ulogic := 'L';
     DRCK2 : out std_ulogic := 'L';
     RESET : out std_ulogic := 'L';
     SEL1 : out std_ulogic := 'L';
     SEL2 : out std_ulogic := 'L';
     SHIFT : out std_ulogic := 'L';
     TDI : out std_ulogic := 'L';
     UPDATE : out std_ulogic := 'L';
     TDO1 : in std_ulogic := 'X';
     TDO2 : in std_ulogic := 'X'
  );
end component;

----- component X_BSCAN_SPARTAN3A -----
component X_BSCAN_SPARTAN3A
  generic (
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     TimingChecksOn : boolean := true;
     Xon : boolean := true
  );
  port (
     CAPTURE : out std_ulogic := 'H';
     DRCK1 : out std_ulogic := 'L';
     DRCK2 : out std_ulogic := 'L';
     RESET : out std_ulogic := 'L';
     SEL1 : out std_ulogic := 'L';
     SEL2 : out std_ulogic := 'L';
     SHIFT : out std_ulogic := 'L';
     TCK : out std_ulogic := 'L';
     TDI : out std_ulogic := 'L';
     TMS : out std_ulogic := 'L';
     UPDATE : out std_ulogic := 'L';
     TDO1 : in std_ulogic := 'X';
     TDO2 : in std_ulogic := 'X'
  );
end component;

----- component X_BSCAN_SPARTAN6 -----
component X_BSCAN_SPARTAN6
  generic (
     JTAG_CHAIN : integer := 1;
     LOC : string := "UNPLACED";
     tipd_TDO : VitalDelayType01 := (0 ps, 0 ps)
  );
  port (
     CAPTURE : out std_ulogic := 'H';
     DRCK : out std_ulogic := 'H';
     RESET : out std_ulogic := 'H';
     RUNTEST : out std_ulogic := 'L';
     SEL : out std_ulogic := 'L';
     SHIFT : out std_ulogic := 'L';
     TCK : out std_ulogic := 'L';
     TDI : out std_ulogic := 'L';
     TMS : out std_ulogic := 'L';
     UPDATE : out std_ulogic := 'L';
     TDO : in std_ulogic := '0'
  );
end component;

----- component X_BSCAN_VIRTEX4 -----
component X_BSCAN_VIRTEX4
  generic (
     InstancePath : string := "*";
     JTAG_CHAIN : integer := 1;
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     TimingChecksOn : boolean := true;
     Xon : boolean := true
  );
  port (
     CAPTURE : out std_ulogic := 'H';
     DRCK : out std_ulogic := 'H';
     RESET : out std_ulogic := 'H';
     SEL : out std_ulogic := 'L';
     SHIFT : out std_ulogic := 'L';
     TDI : out std_ulogic := 'L';
     UPDATE : out std_ulogic := 'L';
     TDO : in std_ulogic := 'X'
  );
end component;

----- component X_BSCAN_VIRTEX5 -----
component X_BSCAN_VIRTEX5
  generic (
     JTAG_CHAIN : integer := 1;
     LOC : string := "UNPLACED"
  );
  port (
     CAPTURE : out std_ulogic := 'H';
     DRCK : out std_ulogic := 'H';
     RESET : out std_ulogic := 'H';
     SEL : out std_ulogic := 'L';
     SHIFT : out std_ulogic := 'L';
     TDI : out std_ulogic := 'L';
     UPDATE : out std_ulogic := 'L';
     TDO : in std_ulogic := 'X'
  );
end component;

----- component X_BSCAN_VIRTEX6 -----
component X_BSCAN_VIRTEX6
  generic (
     DISABLE_JTAG : boolean := FALSE;
     JTAG_CHAIN : integer := 1;
     LOC : string := "UNPLACED";
     tipd_TDO : VitalDelayType01 := (0 ps, 0 ps)
  );
  port (
     CAPTURE : out std_ulogic := 'H';
     DRCK : out std_ulogic := 'H';
     RESET : out std_ulogic := 'H';
     RUNTEST : out std_ulogic := 'L';
     SEL : out std_ulogic := 'L';
     SHIFT : out std_ulogic := 'L';
     TCK : out std_ulogic := 'L';
     TDI : out std_ulogic := 'L';
     TMS : out std_ulogic := 'L';
     UPDATE : out std_ulogic := 'L';
     TDO : in std_ulogic := '0'
  );
end component;

----- component X_BUF -----
component X_BUF
  generic (
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     PATHPULSE : time := 0 ps;
     Xon : boolean := true;
     tipd_I : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;

----- component X_BUFGCTRL -----
component X_BUFGCTRL
  generic (
     INIT_OUT : integer := 0;
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     PRESELECT_I0 : boolean := false;
     PRESELECT_I1 : boolean := false;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     thold_CE0_I0_negedge_negedge : VitalDelayType := 0 ps;
     thold_CE0_I0_negedge_posedge : VitalDelayType := 0 ps;
     thold_CE0_I0_posedge_negedge : VitalDelayType := 0 ps;
     thold_CE0_I0_posedge_posedge : VitalDelayType := 0 ps;
     thold_CE0_I1_negedge_negedge : VitalDelayType := 0 ps;
     thold_CE0_I1_negedge_posedge : VitalDelayType := 0 ps;
     thold_CE0_I1_posedge_negedge : VitalDelayType := 0 ps;
     thold_CE0_I1_posedge_posedge : VitalDelayType := 0 ps;
     thold_CE1_I0_negedge_negedge : VitalDelayType := 0 ps;
     thold_CE1_I0_negedge_posedge : VitalDelayType := 0 ps;
     thold_CE1_I0_posedge_negedge : VitalDelayType := 0 ps;
     thold_CE1_I0_posedge_posedge : VitalDelayType := 0 ps;
     thold_CE1_I1_negedge_negedge : VitalDelayType := 0 ps;
     thold_CE1_I1_negedge_posedge : VitalDelayType := 0 ps;
     thold_CE1_I1_posedge_negedge : VitalDelayType := 0 ps;
     thold_CE1_I1_posedge_posedge : VitalDelayType := 0 ps;
     thold_S0_I0_negedge_negedge : VitalDelayType := 0 ps;
     thold_S0_I0_negedge_posedge : VitalDelayType := 0 ps;
     thold_S0_I0_posedge_negedge : VitalDelayType := 0 ps;
     thold_S0_I0_posedge_posedge : VitalDelayType := 0 ps;
     thold_S0_I1_negedge_negedge : VitalDelayType := 0 ps;
     thold_S0_I1_negedge_posedge : VitalDelayType := 0 ps;
     thold_S0_I1_posedge_negedge : VitalDelayType := 0 ps;
     thold_S0_I1_posedge_posedge : VitalDelayType := 0 ps;
     thold_S1_I0_negedge_negedge : VitalDelayType := 0 ps;
     thold_S1_I0_negedge_posedge : VitalDelayType := 0 ps;
     thold_S1_I0_posedge_negedge : VitalDelayType := 0 ps;
     thold_S1_I0_posedge_posedge : VitalDelayType := 0 ps;
     thold_S1_I1_negedge_negedge : VitalDelayType := 0 ps;
     thold_S1_I1_negedge_posedge : VitalDelayType := 0 ps;
     thold_S1_I1_posedge_negedge : VitalDelayType := 0 ps;
     thold_S1_I1_posedge_posedge : VitalDelayType := 0 ps;
     ticd_I0 : VitalDelayType := 0.0 ps;
     ticd_I1 : VitalDelayType := 0.0 ps;
     tipd_CE0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CE1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_I0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_I1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_IGNORE0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_IGNORE1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_S0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_S1 : VitalDelayType01 := (0 ps, 0 ps);
     tisd_CE0_I0 : VitalDelayType := 0.0 ps;
     tisd_CE0_I1 : VitalDelayType := 0.0 ps;
     tisd_CE1_I0 : VitalDelayType := 0.0 ps;
     tisd_CE1_I1 : VitalDelayType := 0.0 ps;
     tisd_I0_I1 : VitalDelayType := 0.0 ps;
     tisd_I1_I0 : VitalDelayType := 0.0 ps;
     tisd_IGNORE0_I0 : VitalDelayType := 0.0 ps;
     tisd_IGNORE1_I1 : VitalDelayType := 0.0 ps;
     tisd_S0_I0 : VitalDelayType := 0.0 ps;
     tisd_S0_I1 : VitalDelayType := 0.0 ps;
     tisd_S1_I0 : VitalDelayType := 0.0 ps;
     tisd_S1_I1 : VitalDelayType := 0.0 ps;
     tpd_I0_O : VitalDelayType01 := (0 ps, 0 ps);
     tpd_I1_O : VitalDelayType01 := (0 ps, 0 ps);
     tperiod_I0_posedge : VitalDelayType := 0 ps;
     tperiod_I1_posedge : VitalDelayType := 0 ps;
     tpw_I0_negedge : VitalDelayType := 0 ps;
     tpw_I0_posedge : VitalDelayType := 0 ps;
     tpw_I1_negedge : VitalDelayType := 0 ps;
     tpw_I1_posedge : VitalDelayType := 0 ps;
     tsetup_CE0_I0_negedge_negedge : VitalDelayType := 0 ps;
     tsetup_CE0_I0_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CE0_I0_posedge_negedge : VitalDelayType := 0 ps;
     tsetup_CE0_I0_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CE0_I1_negedge_negedge : VitalDelayType := 0 ps;
     tsetup_CE0_I1_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CE0_I1_posedge_negedge : VitalDelayType := 0 ps;
     tsetup_CE0_I1_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CE1_I0_negedge_negedge : VitalDelayType := 0 ps;
     tsetup_CE1_I0_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CE1_I0_posedge_negedge : VitalDelayType := 0 ps;
     tsetup_CE1_I0_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CE1_I1_negedge_negedge : VitalDelayType := 0 ps;
     tsetup_CE1_I1_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CE1_I1_posedge_negedge : VitalDelayType := 0 ps;
     tsetup_CE1_I1_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_I0_I1_negedge_negedge : VitalDelayType := 0 ps;
     tsetup_I0_I1_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_I0_I1_posedge_negedge : VitalDelayType := 0 ps;
     tsetup_I0_I1_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_I1_I0_negedge_negedge : VitalDelayType := 0 ps;
     tsetup_I1_I0_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_I1_I0_posedge_negedge : VitalDelayType := 0 ps;
     tsetup_I1_I0_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_S0_I0_negedge_negedge : VitalDelayType := 0 ps;
     tsetup_S0_I0_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_S0_I0_posedge_negedge : VitalDelayType := 0 ps;
     tsetup_S0_I0_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_S0_I1_negedge_negedge : VitalDelayType := 0 ps;
     tsetup_S0_I1_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_S0_I1_posedge_negedge : VitalDelayType := 0 ps;
     tsetup_S0_I1_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_S1_I0_negedge_negedge : VitalDelayType := 0 ps;
     tsetup_S1_I0_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_S1_I0_posedge_negedge : VitalDelayType := 0 ps;
     tsetup_S1_I0_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_S1_I1_negedge_negedge : VitalDelayType := 0 ps;
     tsetup_S1_I1_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_S1_I1_posedge_negedge : VitalDelayType := 0 ps;
     tsetup_S1_I1_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     O : out std_ulogic;
     CE0 : in std_ulogic;
     CE1 : in std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     IGNORE0 : in std_ulogic;
     IGNORE1 : in std_ulogic;
     S0 : in std_ulogic;
     S1 : in std_ulogic
  );
end component;

----- component X_BUFGMUX -----
component X_BUFGMUX
  generic (
     CLK_SEL_TYPE : string := "SYNC";
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := false;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     tbpd_S_O_I0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tbpd_S_O_I1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     thold_S_I0_posedge_negedge : VitalDelayType := 0.000 ns;
     thold_S_I1_negedge_negedge : VitalDelayType := 0.000 ns;
     ticd_I0 : VitalDelayType := 0.000 ns;
     ticd_I1 : VitalDelayType := 0.000 ns;
     ticd_S : VitalDelayType := 0 ps;
     tipd_I0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_S : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tisd_S_I0 : VitalDelayType := 0.000 ns;
     tisd_S_I1 : VitalDelayType := 0.000 ns;
     tpd_I0_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I1_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_S_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tperiod_I0_posedge : VitalDelayType := 0 ps;
     tperiod_I1_posedge : VitalDelayType := 0 ps;
     tpw_I0_negedge : VitalDelayType := 0.000 ns;
     tpw_I0_posedge : VitalDelayType := 0.000 ns;
     tpw_I1_negedge : VitalDelayType := 0.000 ns;
     tpw_I1_posedge : VitalDelayType := 0.000 ns;
     tsetup_S_I0_posedge_negedge : VitalDelayType := 0.000 ns;
     tsetup_S_I1_negedge_negedge : VitalDelayType := 0.000 ns
  );
  port (
     O : out std_ulogic;
     I0 : in std_ulogic := '0';
     I1 : in std_ulogic := '0';
     S : in std_ulogic
  );
end component;

----- component X_BUFGMUX_1 -----
component X_BUFGMUX_1
  generic (
     CLK_SEL_TYPE : string := "SYNC";
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := false;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     tbpd_S_O_I0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tbpd_S_O_I1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     thold_S_I0_posedge_posedge : VitalDelayType := 0.000 ns;
     thold_S_I1_negedge_posedge : VitalDelayType := 0.000 ns;
     ticd_I0 : VitalDelayType := 0.000 ns;
     ticd_I1 : VitalDelayType := 0.000 ns;
     ticd_S : VitalDelayType := 0 ps;
     tipd_I0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_S : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tisd_S_I0 : VitalDelayType := 0.000 ns;
     tisd_S_I1 : VitalDelayType := 0.000 ns;
     tpd_I0_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I1_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_S_O : VitalDelayType01 := (0 ps, 0 ps);
     tperiod_I0_posedge : VitalDelayType := 0 ps;
     tperiod_I1_posedge : VitalDelayType := 0 ps;
     tpw_I0_negedge : VitalDelayType := 0.000 ns;
     tpw_I0_posedge : VitalDelayType := 0.000 ns;
     tpw_I1_negedge : VitalDelayType := 0.000 ns;
     tpw_I1_posedge : VitalDelayType := 0.000 ns;
     tsetup_S_I0_posedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_S_I1_negedge_posedge : VitalDelayType := 0.000 ns
  );
  port (
     O : out std_ulogic;
     I0 : in std_ulogic := '1';
     I1 : in std_ulogic := '1';
     S : in std_ulogic
  );
end component;

----- component X_BUFHCE -----
component X_BUFHCE
  generic (
     INIT_OUT : integer := 0;
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := FALSE;
     TimingChecksOn : boolean := TRUE;
     Xon : boolean := TRUE;
     thold_CE_I_negedge_negedge : VitalDelayType := 0 ps;
     thold_CE_I_negedge_posedge : VitalDelayType := 0 ps;
     thold_CE_I_posedge_negedge : VitalDelayType := 0 ps;
     thold_CE_I_posedge_posedge : VitalDelayType := 0 ps;
     ticd_I : VitalDelayType := 0 ps;
     tipd_CE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_I : VitalDelayType01 := (0 ps, 0 ps);
     tisd_CE_I : VitalDelayType := 0 ps;
     tpd_I_O : VitalDelayType01 := (0 ps, 0 ps);
     tperiod_I_posedge : VitalDelayType := 0 ps;
     tsetup_CE_I_negedge_negedge : VitalDelayType := 0 ps;
     tsetup_CE_I_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CE_I_posedge_negedge : VitalDelayType := 0 ps;
     tsetup_CE_I_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     O : out std_ulogic;
     CE : in std_ulogic;
     I : in std_ulogic
  );
end component;

----- component X_BUFIO2 -----
component X_BUFIO2
  generic (
     DIVIDE : integer := 1;
     DIVIDE_BYPASS : boolean := TRUE;
     I_INVERT : boolean := FALSE;
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     TimingChecksOn : boolean := true;
     USE_DOUBLER : boolean := FALSE;
     Xon : boolean := true;
     ticd_I : VitalDelayType := 0 ps;
     tipd_I : VitalDelayType01 := (0 ps, 0 ps);
     tpd_I_DIVCLK : VitalDelayType01 := (100 ps, 100 ps);
     tpd_I_IOCLK : VitalDelayType01 := (0 ps, 0 ps);
     tpd_I_SERDESSTROBE : VitalDelayType01 := (100 ps, 100 ps)
  );
  port (
     DIVCLK : out std_ulogic;
     IOCLK : out std_ulogic;
     SERDESSTROBE : out std_ulogic;
     I : in std_ulogic
  );
end component;

----- component X_BUFIO2FB -----
component X_BUFIO2FB
  generic (
     DIVIDE_BYPASS : boolean := TRUE;
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     tipd_I : VitalDelayType01 := (0 ps, 0 ps);
     tpd_I_O : VitalDelayType01 := (0 ps, 0 ps)
  );
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;

----- component X_BUFIO2_2CLK -----
component X_BUFIO2_2CLK
  generic (
     DIVIDE : integer := 2;
     I_INVERT : boolean := FALSE;
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     ticd_I : VitalDelayType := 0 ps;
     ticd_IB : VitalDelayType := 0 ps;
     tipd_I : VitalDelayType01 := (0 ps, 0 ps);
     tipd_IB : VitalDelayType01 := (0 ps, 0 ps);
     tpd_IB_DIVCLK : VitalDelayType01 := (100 ps, 100 ps);
     tpd_IB_IOCLK : VitalDelayType01 := (0 ps, 0 ps);
     tpd_IB_SERDESSTROBE : VitalDelayType01 := (100 ps, 100 ps);
     tpd_I_DIVCLK : VitalDelayType01 := (100 ps, 100 ps);
     tpd_I_IOCLK : VitalDelayType01 := (0 ps, 0 ps);
     tpd_I_SERDESSTROBE : VitalDelayType01 := (100 ps, 100 ps)
  );
  port (
     DIVCLK : out std_ulogic;
     IOCLK : out std_ulogic;
     SERDESSTROBE : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;

----- component X_BUFIODQS -----
component X_BUFIODQS
  generic (
     DQSMASK_ENABLE : boolean := FALSE;
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     tipd_DQSMASK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_I : VitalDelayType01 := (0 ps, 0 ps);
     tpd_DQSMASK_O : VitalDelayType01 := (0 ps, 0 ps);
     tpd_I_O : VitalDelayType01 := (0 ps, 0 ps);
     tperiod_I_posedge : VitalDelayType := 0 ps
  );
  port (
     O : out std_ulogic;
     DQSMASK : in std_ulogic;
     I : in std_ulogic
  );
end component;

----- component X_BUFPLL -----
component X_BUFPLL
  generic (
     DIVIDE : integer := 1;
     ENABLE_SYNC : boolean := TRUE;
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     ticd_GCLK : VitalDelayType := 0 ps;
     ticd_LOCKED : VitalDelayType := 0 ps;
     ticd_PLLIN : VitalDelayType := 0 ps;
     tipd_GCLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_LOCKED : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PLLIN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PLLIN_IOCLK : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PLLIN_LOCK : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PLLIN_SERDESSTROBE : VitalDelayType01 := (100 ps, 100 ps);
     tperiod_PLLIN_posedge : VitalDelayType := 0 ps
  );
  port (
     IOCLK : out std_ulogic;
     LOCK : out std_ulogic;
     SERDESSTROBE : out std_ulogic;
     GCLK : in std_ulogic;
     LOCKED : in std_ulogic;
     PLLIN : in std_ulogic
  );
end component;

----- component X_BUFPLL_MCB -----
component X_BUFPLL_MCB
  generic (
     DIVIDE : integer := 2;
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     LOCK_SRC : string := "LOCK_TO_0";
     MsgOn : boolean := true;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     ticd_PLLIN0 : VitalDelayType := 0 ps;
     ticd_PLLIN1 : VitalDelayType := 0 ps;
     tipd_PLLIN0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PLLIN1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PLLIN0_IOCLK0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PLLIN0_SERDESSTROBE0 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_PLLIN1_IOCLK1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PLLIN1_SERDESSTROBE1 : VitalDelayType01 := (100 ps, 100 ps);
     tperiod_PLLIN0_posedge : VitalDelayType := 0 ps;
     tperiod_PLLIN1_posedge : VitalDelayType := 0 ps
  );
  port (
     IOCLK0 : out std_ulogic;
     IOCLK1 : out std_ulogic;
     SERDESSTROBE0 : out std_ulogic;
     SERDESSTROBE1 : out std_ulogic;
     PLLIN0 : in std_ulogic;
     PLLIN1 : in std_ulogic
  );
end component;

----- component X_BUFR -----
component X_BUFR
  generic (
     BUFR_DIVIDE : string := "BYPASS";
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     SIM_DEVICE : string := "VIRTEX4";
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     thold_CE_I_negedge_negedge : VitalDelayType := 0 ps;
     thold_CE_I_negedge_posedge : VitalDelayType := 0 ps;
     thold_CE_I_posedge_negedge : VitalDelayType := 0 ps;
     thold_CE_I_posedge_posedge : VitalDelayType := 0 ps;
     ticd_I : VitalDelayType := 0.0 ps;
     tipd_CE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLR : VitalDelayType01 := (0 ps, 0 ps);
     tipd_I : VitalDelayType01 := (0 ps, 0 ps);
     tisd_CLR_I : VitalDelayType := 0.0 ps;
     tpd_CLR_O : VitalDelayType01 := (0 ps, 0 ps);
     tpd_I_O : VitalDelayType01 := (0 ps, 0 ps);
     tperiod_I_posedge : VitalDelayType := 0 ps;
     tpw_CLR_posedge : VitalDelayType := 0 ps;
     tpw_I_negedge : VitalDelayType := 0 ps;
     tpw_I_posedge : VitalDelayType := 0 ps;
     trecovery_CLR_I_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_CLR_I_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CE_I_negedge_negedge : VitalDelayType := 0 ps;
     tsetup_CE_I_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CE_I_posedge_negedge : VitalDelayType := 0 ps;
     tsetup_CE_I_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     O : out std_ulogic;
     CE : in std_ulogic;
     CLR : in std_ulogic;
     I : in std_ulogic
  );
end component;

----- component X_CAPTURE_VIRTEX6 -----
component X_CAPTURE_VIRTEX6
  generic (
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := FALSE;
     ONESHOT : boolean := TRUE;
     TimingChecksOn : boolean := TRUE;
     Xon : boolean := TRUE;
     thold_CAP_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CAP_CLK_posedge_posedge : VitalDelayType := 0 ps;
     ticd_CLK : VitalDelayType := 0 ps;
     tipd_CAP : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLK : VitalDelayType01 := (0 ps, 0 ps);
     tisd_CAP_CLK : VitalDelayType := 0 ps;
     tperiod_CLK_posedge : VitalDelayType := 0 ps;
     tsetup_CAP_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CAP_CLK_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     CAP : in std_ulogic := 'L';
     CLK : in std_ulogic
  );
end component;

----- component X_CARRY4 -----
component X_CARRY4
  generic (
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     tipd_CI : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CYINIT : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DI : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tipd_S : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_CI_CO : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tpd_CI_O : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tpd_CYINIT_CO : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tpd_CYINIT_O : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tpd_DI_CO : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
     tpd_DI_O : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
     tpd_S_CO : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
     tpd_S_O : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps))
  );
  port (
     CO : out std_logic_vector(3 downto 0);
     O : out std_logic_vector(3 downto 0);
     CI : in std_ulogic;
     CYINIT : in std_ulogic;
     DI : in std_logic_vector(3 downto 0);
     S : in std_logic_vector(3 downto 0)
  );
end component;

----- component X_CKBUF -----
component X_CKBUF
  generic (
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     PATHPULSE : time := 0 ps;
     Xon : boolean := true;
     tipd_I : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;

----- component X_CLKDLL -----
component X_CLKDLL
  generic (
     CLKDV_DIVIDE : real := 2.0;
     DLL_FREQUENCY_MODE : string := "LOW";
     DUTY_CYCLE_CORRECTION : boolean := true;
     FACTORY_JF : bit_vector := X"C080";
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MAXPERCLKIN : time := 40000 ps;
     MsgOn : boolean := false;
     SIM_CLKIN_CYCLE_JITTER : time := 300 ps;
     SIM_CLKIN_PERIOD_JITTER : time := 1000 ps;
     STARTUP_WAIT : boolean := false;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     tipd_CLKFB : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_CLKIN : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_RST : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_CLKIN_LOCKED : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tperiod_CLKIN_POSEDGE : VitalDelayType := 0.000 ns;
     tpw_CLKIN_negedge : VitalDelayType := 0.000 ns;
     tpw_CLKIN_posedge : VitalDelayType := 0.000 ns;
     tpw_RST_posedge : VitalDelayType := 0.000 ns
  );
  port (
     CLK0 : out std_ulogic := '0';
     CLK180 : out std_ulogic := '0';
     CLK270 : out std_ulogic := '0';
     CLK2X : out std_ulogic := '0';
     CLK90 : out std_ulogic := '0';
     CLKDV : out std_ulogic := '0';
     LOCKED : out std_ulogic := '0';
     CLKFB : in std_ulogic := '0';
     CLKIN : in std_ulogic := '0';
     RST : in std_ulogic := '0'
  );
end component;

----- component X_CLKDLLE -----
component X_CLKDLLE
  generic (
     CLKDV_DIVIDE : real := 2.0;
     DUTY_CYCLE_CORRECTION : boolean := true;
     FACTORY_JF : bit_vector := X"C080";
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MAXPERCLKIN : time := 40000 ps;
     MsgOn : boolean := false;
     SIM_CLKIN_CYCLE_JITTER : time := 300 ps;
     SIM_CLKIN_PERIOD_JITTER : time := 1000 ps;
     STARTUP_WAIT : boolean := false;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     tipd_CLKFB : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_CLKIN : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_RST : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_CLKIN_LOCKED : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tperiod_CLKIN_POSEDGE : VitalDelayType := 0.000 ns;
     tpw_CLKIN_negedge : VitalDelayType := 0.000 ns;
     tpw_CLKIN_posedge : VitalDelayType := 0.000 ns;
     tpw_RST_posedge : VitalDelayType := 0.000 ns
  );
  port (
     CLK0 : out std_ulogic := '0';
     CLK180 : out std_ulogic := '0';
     CLK270 : out std_ulogic := '0';
     CLK2X : out std_ulogic := '0';
     CLK2X180 : out std_ulogic := '0';
     CLK90 : out std_ulogic := '0';
     CLKDV : out std_ulogic := '0';
     LOCKED : out std_ulogic := '0';
     CLKFB : in std_ulogic := '0';
     CLKIN : in std_ulogic := '0';
     RST : in std_ulogic := '0'
  );
end component;

----- component X_CLK_DIV -----
component X_CLK_DIV
  generic (
     DIVIDER_DELAY : integer := 0;
     DIVIDE_BY : integer := 2;
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     tipd_CDRST : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_CLKIN : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tperiod_CLKIN_POSEDGE : VitalDelayType := 0.000 ns;
     tpw_CDRST_posedge : VitalDelayType := 0.000 ns;
     tpw_CLKIN_negedge : VitalDelayType := 0.000 ns;
     tpw_CLKIN_posedge : VitalDelayType := 0.000 ns
  );
  port (
     CLKDV : out std_ulogic := '0';
     CDRST : in std_ulogic := '0';
     CLKIN : in std_ulogic := '0'
  );
end component;

----- component X_CRC32 -----
component X_CRC32
  generic (
     CRC_INIT : bit_vector := X"FFFFFFFF";
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     thold_CRCDATAVALID_CRCCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_CRCDATAVALID_CRCCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_CRCDATAWIDTH_CRCCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0.0 ns);
     thold_CRCDATAWIDTH_CRCCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0.0 ns);
     thold_CRCIN_CRCCLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0.0 ns);
     thold_CRCIN_CRCCLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0.0 ns);
     thold_CRCRESET_CRCCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_CRCRESET_CRCCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     ticd_CRCCLK : VitalDelayType := 0.000 ns;
     tipd_CRCCLK : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_CRCDATAVALID : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_CRCDATAWIDTH : VitalDelayArrayType01 (2 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_CRCIN : VitalDelayArrayType01 (31 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_CRCRESET : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tisd_CRCDATAVALID_CRCCLK : VitalDelayType := 0.000 ns;
     tisd_CRCDATAWIDTH_CRCCLK : VitalDelayArrayType(2 downto 0) := (others => 0.000 ns);
     tisd_CRCIN_CRCCLK : VitalDelayArrayType(31 downto 0) := (others => 0.000 ns);
     tisd_CRCRESET_CRCCLK : VitalDelayType := 0.000 ns;
     tpd_CRCCLK_CRCOUT : VitalDelayArrayType01(31 downto 0) := (others => (0.100 ns, 0.100 ns));
     tperiod_CRCCLK_posedge : VitalDelayType := 0.0 ns;
     tpw_CRCCLK_negedge : VitalDelayType := 0 ps;
     tpw_CRCCLK_posedge : VitalDelayType := 0 ps;
     tsetup_CRCDATAVALID_CRCCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_CRCDATAVALID_CRCCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_CRCDATAWIDTH_CRCCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0.0 ns);
     tsetup_CRCDATAWIDTH_CRCCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0.0 ns);
     tsetup_CRCIN_CRCCLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0.0 ns);
     tsetup_CRCIN_CRCCLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0.0 ns);
     tsetup_CRCRESET_CRCCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_CRCRESET_CRCCLK_posedge_posedge : VitalDelayType := 0.0 ns
  );
  port (
     CRCOUT : out std_logic_vector(31 downto 0);
     CRCCLK : in std_ulogic;
     CRCDATAVALID : in std_ulogic;
     CRCDATAWIDTH : in std_logic_vector(2 downto 0);
     CRCIN : in std_logic_vector(31 downto 0);
     CRCRESET : in std_ulogic
  );
end component;

----- component X_CRC64 -----
component X_CRC64
  generic (
     CRC_INIT : bit_vector := X"FFFFFFFF";
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     thold_CRCDATAVALID_CRCCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_CRCDATAVALID_CRCCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_CRCDATAWIDTH_CRCCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0.0 ns);
     thold_CRCDATAWIDTH_CRCCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0.0 ns);
     thold_CRCIN_CRCCLK_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0.0 ns);
     thold_CRCIN_CRCCLK_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0.0 ns);
     thold_CRCRESET_CRCCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_CRCRESET_CRCCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     ticd_CRCCLK : VitalDelayType := 0.000 ns;
     tipd_CRCCLK : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_CRCDATAVALID : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_CRCDATAWIDTH : VitalDelayArrayType01 (2 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_CRCIN : VitalDelayArrayType01 (63 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_CRCRESET : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tisd_CRCDATAVALID_CRCCLK : VitalDelayType := 0.000 ns;
     tisd_CRCDATAWIDTH_CRCCLK : VitalDelayArrayType(2 downto 0) := (others => 0.000 ns);
     tisd_CRCIN_CRCCLK : VitalDelayArrayType(63 downto 0) := (others => 0.000 ns);
     tisd_CRCRESET_CRCCLK : VitalDelayType := 0.000 ns;
     tpd_CRCCLK_CRCOUT : VitalDelayArrayType01(31 downto 0) := (others => (0.100 ns, 0.100 ns));
     tperiod_CRCCLK_posedge : VitalDelayType := 0.0 ns;
     tpw_CRCCLK_negedge : VitalDelayType := 0 ps;
     tpw_CRCCLK_posedge : VitalDelayType := 0 ps;
     tsetup_CRCDATAVALID_CRCCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_CRCDATAVALID_CRCCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_CRCDATAWIDTH_CRCCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0.0 ns);
     tsetup_CRCDATAWIDTH_CRCCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0.0 ns);
     tsetup_CRCIN_CRCCLK_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0.0 ns);
     tsetup_CRCIN_CRCCLK_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0.0 ns);
     tsetup_CRCRESET_CRCCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_CRCRESET_CRCCLK_posedge_posedge : VitalDelayType := 0.0 ns
  );
  port (
     CRCOUT : out std_logic_vector(31 downto 0);
     CRCCLK : in std_ulogic;
     CRCDATAVALID : in std_ulogic;
     CRCDATAWIDTH : in std_logic_vector(2 downto 0);
     CRCIN : in std_logic_vector(63 downto 0);
     CRCRESET : in std_ulogic
  );
end component;

----- component X_DCM -----
component X_DCM
  generic (
     CLKDV_DIVIDE : real := 2.0;
     CLKFX_DIVIDE : integer := 1;
     CLKFX_MULTIPLY : integer := 4;
     CLKIN_DIVIDE_BY_2 : boolean := false;
     CLKIN_PERIOD : real := 10.0;
     CLKOUT_PHASE_SHIFT : string := "NONE";
     CLK_FEEDBACK : string := "1X";
     DESKEW_ADJUST : string := "SYSTEM_SYNCHRONOUS";
     DFS_FREQUENCY_MODE : string := "LOW";
     DLL_FREQUENCY_MODE : string := "LOW";
     DSS_MODE : string := "NONE";
     DUTY_CYCLE_CORRECTION : boolean := true;
     FACTORY_JF : bit_vector := X"C080";
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MAXPERCLKIN : time := 1000000 ps;
     MAXPERPSCLK : time := 100000000 ps;
     MsgOn : boolean := false;
     PHASE_SHIFT : integer := 0;
     SIM_CLKIN_CYCLE_JITTER : time := 300 ps;
     SIM_CLKIN_PERIOD_JITTER : time := 1000 ps;
     STARTUP_WAIT : boolean := false;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     thold_PSEN_PSCLK_negedge_posedge : VitalDelayType := 0.000 ns;
     thold_PSEN_PSCLK_posedge_posedge : VitalDelayType := 0.000 ns;
     thold_PSINCDEC_PSCLK_negedge_posedge : VitalDelayType := 0.000 ns;
     thold_PSINCDEC_PSCLK_posedge_posedge : VitalDelayType := 0.000 ns;
     ticd_PSCLK : VitalDelayType := 0.000 ns;
     tipd_CLKFB : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_CLKIN : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_DSSEN : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_PSCLK : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_PSEN : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_PSINCDEC : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_RST : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tisd_PSEN_PSCLK : VitalDelayType := 0.000 ns;
     tisd_PSINCDEC_PSCLK : VitalDelayType := 0.000 ns;
     tpd_CLKIN_LOCKED : VitalDelayType01 := (0.100 ns, 0.100 ns);
     tpd_PSCLK_PSDONE : VitalDelayType01 := (0.100 ns, 0.100 ns);
     tperiod_CLKIN_POSEDGE : VitalDelayType := 0.000 ns;
     tperiod_PSCLK_POSEDGE : VitalDelayType := 0.000 ns;
     tpw_CLKIN_negedge : VitalDelayType := 0.000 ns;
     tpw_CLKIN_posedge : VitalDelayType := 0.000 ns;
     tpw_PSCLK_negedge : VitalDelayType := 0.000 ns;
     tpw_PSCLK_posedge : VitalDelayType := 0.000 ns;
     tpw_RST_posedge : VitalDelayType := 0.000 ns;
     tsetup_PSEN_PSCLK_negedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_PSEN_PSCLK_posedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_PSINCDEC_PSCLK_negedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_PSINCDEC_PSCLK_posedge_posedge : VitalDelayType := 0.000 ns
  );
  port (
     CLK0 : out std_ulogic := '0';
     CLK180 : out std_ulogic := '0';
     CLK270 : out std_ulogic := '0';
     CLK2X : out std_ulogic := '0';
     CLK2X180 : out std_ulogic := '0';
     CLK90 : out std_ulogic := '0';
     CLKDV : out std_ulogic := '0';
     CLKFX : out std_ulogic := '0';
     CLKFX180 : out std_ulogic := '0';
     LOCKED : out std_ulogic := '0';
     PSDONE : out std_ulogic := '0';
     STATUS : out std_logic_vector(7 downto 0) := "00000000";
     CLKFB : in std_ulogic := '0';
     CLKIN : in std_ulogic := '0';
     DSSEN : in std_ulogic := '0';
     PSCLK : in std_ulogic := '0';
     PSEN : in std_ulogic := '0';
     PSINCDEC : in std_ulogic := '0';
     RST : in std_ulogic := '0'
  );
end component;

----- component X_DCM_ADV -----
component X_DCM_ADV
  generic (
     CLKDV_DIVIDE : real := 2.0;
     CLKFX_DIVIDE : integer := 1;
     CLKFX_MULTIPLY : integer := 4;
     CLKIN_DIVIDE_BY_2 : boolean := false;
     CLKIN_PERIOD : real := 10.0;
     CLKOUT_PHASE_SHIFT : string := "NONE";
     CLK_FEEDBACK : string := "1X";
     DCM_AUTOCALIBRATION : boolean := true;
     DCM_PERFORMANCE_MODE : string := "MAX_SPEED";
     DESKEW_ADJUST : string := "SYSTEM_SYNCHRONOUS";
     DFS_FREQUENCY_MODE : string := "LOW";
     DLL_FREQUENCY_MODE : string := "LOW";
     DUTY_CYCLE_CORRECTION : boolean := true;
     FACTORY_JF : bit_vector := X"F0F0";
     InstancePath : string := " ";
     LOC : string := "UNPLACED";
     MAXPERCLKIN : time := 1000000 ps;
     MAXPERPSCLK : time := 100000000 ps;
     MsgOn : boolean := false;
     PHASE_SHIFT : integer := 0;
     SIM_CLKIN_CYCLE_JITTER : time := 300 ps;
     SIM_CLKIN_PERIOD_JITTER : time := 1000 ps;
     SIM_DEVICE : string := "VIRTEX4";
     STARTUP_WAIT : boolean := false;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     thold_DADDR_DCLK_negedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0.00 ns);
     thold_DADDR_DCLK_posedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0.00 ns);
     thold_DEN_DCLK_negedge_posedge : VitalDelayType := 0.00 ns;
     thold_DEN_DCLK_posedge_posedge : VitalDelayType := 0.00 ns;
     thold_DI_DCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0.00 ns);
     thold_DI_DCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0.00 ns);
     thold_DWE_DCLK_negedge_posedge : VitalDelayType := 0.00 ns;
     thold_DWE_DCLK_posedge_posedge : VitalDelayType := 0.00 ns;
     thold_PSEN_PSCLK_negedge_posedge : VitalDelayType := 0.000 ns;
     thold_PSEN_PSCLK_posedge_posedge : VitalDelayType := 0.000 ns;
     thold_PSINCDEC_PSCLK_negedge_posedge : VitalDelayType := 0.000 ns;
     thold_PSINCDEC_PSCLK_posedge_posedge : VitalDelayType := 0.000 ns;
     ticd_DCLK : VitalDelayType := 0.000 ns;
     ticd_PSCLK : VitalDelayType := 0.000 ns;
     tipd_CLKFB : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_CLKIN : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_DADDR : VitalDelayArrayType01(6 downto 0) := (others => (0 ps, 0 ps));
     tipd_DCLK : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_DEN : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_DI : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
     tipd_DWE : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_PSCLK : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_PSEN : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_PSINCDEC : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_RST : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tisd_PSEN_PSCLK : VitalDelayType := 0.000 ns;
     tisd_PSINCDEC_PSCLK : VitalDelayType := 0.000 ns;
     tisd_daddr_dclk : VitalDelayArrayType(6 downto 0) := (others => 0.000 ns);
     tisd_den_dclk : VitalDelayType := 0.000 ns;
     tisd_di_dclk : VitalDelayArrayType(15 downto 0) := (others => 0.000 ns);
     tisd_dwe_dclk : VitalDelayType := 0.000 ns;
     tpd_CLKIN_LOCKED : VitalDelayType01 := (0.100 ns, 0.100 ns);
     tpd_DCLK_DO : VitalDelayArrayType01(15 downto 0) := (others => (0.100 ns, 0.100 ns));
     tpd_DCLK_DRDY : VitalDelayType01 := (0.100 ns, 0.100 ns);
     tpd_PSCLK_PSDONE : VitalDelayType01 := (0.100 ns, 0.100 ns);
     tperiod_CLKIN_POSEDGE : VitalDelayType := 0.000 ns;
     tperiod_PSCLK_POSEDGE : VitalDelayType := 0.000 ns;
     tpw_CLKIN_negedge : VitalDelayType := 0.000 ns;
     tpw_CLKIN_posedge : VitalDelayType := 0.000 ns;
     tpw_PSCLK_negedge : VitalDelayType := 0.000 ns;
     tpw_PSCLK_posedge : VitalDelayType := 0.000 ns;
     tpw_RST_posedge : VitalDelayType := 0.000 ns;
     tsetup_DADDR_DCLK_negedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0.00 ns);
     tsetup_DADDR_DCLK_posedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0.00 ns);
     tsetup_DEN_DCLK_negedge_posedge : VitalDelayType := 0.00 ns;
     tsetup_DEN_DCLK_posedge_posedge : VitalDelayType := 0.00 ns;
     tsetup_DI_DCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0.00 ns);
     tsetup_DI_DCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0.00 ns);
     tsetup_DWE_DCLK_negedge_posedge : VitalDelayType := 0.00 ns;
     tsetup_DWE_DCLK_posedge_posedge : VitalDelayType := 0.00 ns;
     tsetup_PSEN_PSCLK_negedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_PSEN_PSCLK_posedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_PSINCDEC_PSCLK_negedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_PSINCDEC_PSCLK_posedge_posedge : VitalDelayType := 0.000 ns
  );
  port (
     CLK0 : out std_ulogic := '0';
     CLK180 : out std_ulogic := '0';
     CLK270 : out std_ulogic := '0';
     CLK2X : out std_ulogic := '0';
     CLK2X180 : out std_ulogic := '0';
     CLK90 : out std_ulogic := '0';
     CLKDV : out std_ulogic := '0';
     CLKFX : out std_ulogic := '0';
     CLKFX180 : out std_ulogic := '0';
     DO : out std_logic_vector(15 downto 0) := "0000000000000000";
     DRDY : out std_ulogic := '0';
     LOCKED : out std_ulogic := '0';
     PSDONE : out std_ulogic := '0';
     CLKFB : in std_ulogic := '0';
     CLKIN : in std_ulogic := '0';
     DADDR : in std_logic_vector(6 downto 0) := "0000000";
     DCLK : in std_ulogic := '0';
     DEN : in std_ulogic := '0';
     DI : in std_logic_vector(15 downto 0) := "0000000000000000";
     DWE : in std_ulogic := '0';
     PSCLK : in std_ulogic := '0';
     PSEN : in std_ulogic := '0';
     PSINCDEC : in std_ulogic := '0';
     RST : in std_ulogic := '0'
  );
end component;

----- component X_DCM_CLKGEN -----
component X_DCM_CLKGEN
  generic (
     CLKFXDV_DIVIDE : integer := 2;
     CLKFX_DIVIDE : integer := 1;
     CLKFX_MD_MAX : real := 0.0;
     CLKFX_MULTIPLY : integer := 4;
     CLKIN_PERIOD : real := 10.0;
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := false;
     SPREAD_SPECTRUM : string := "NONE";
     STARTUP_WAIT : boolean := FALSE;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     thold_FREEZEDCM_CLKIN_negedge_posedge : VitalDelayType := 0 ps;
     thold_FREEZEDCM_CLKIN_posedge_posedge : VitalDelayType := 0 ps;
     thold_PROGDATA_PROGCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PROGDATA_PROGCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PROGEN_PROGCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PROGEN_PROGCLK_posedge_posedge : VitalDelayType := 0 ps;
     ticd_CLKIN : VitalDelayType := 0 ps;
     ticd_PROGCLK : VitalDelayType := 0 ps;
     tipd_CLKIN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_FREEZEDCM : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PROGCLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PROGDATA : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PROGEN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RST : VitalDelayType01 := (0 ps, 0 ps);
     tisd_FREEZEDCM_CLKIN : VitalDelayType := 0 ps;
     tisd_PROGDATA_PROGCLK : VitalDelayType := 0 ps;
     tisd_PROGEN_PROGCLK : VitalDelayType := 0 ps;
     tpd_CLKIN_LOCKED : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKIN_STATUS : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
     tpd_PROGCLK_PROGDONE : VitalDelayType01 := (100 ps, 100 ps);
     tperiod_CLKIN_POSEDGE : VitalDelayType := 0.000 ns;
     tperiod_PROGCLK_POSEDGE : VitalDelayType := 0.000 ns;
     tpw_CLKIN_negedge : VitalDelayType := 0.000 ns;
     tpw_CLKIN_posedge : VitalDelayType := 0.000 ns;
     tpw_PROGCLK_negedge : VitalDelayType := 0.000 ns;
     tpw_PROGCLK_posedge : VitalDelayType := 0.000 ns;
     tpw_RST_posedge : VitalDelayType := 0.000 ns;
     tsetup_FREEZEDCM_CLKIN_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_FREEZEDCM_CLKIN_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PROGDATA_PROGCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PROGDATA_PROGCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PROGEN_PROGCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PROGEN_PROGCLK_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     CLKFX : out std_ulogic := '0';
     CLKFX180 : out std_ulogic := '0';
     CLKFXDV : out std_ulogic := '0';
     LOCKED : out std_ulogic := '0';
     PROGDONE : out std_ulogic := '0';
     STATUS : out std_logic_vector(7 downto 0) := "00000000";
     CLKIN : in std_ulogic := 'L';
     FREEZEDCM : in std_ulogic := 'L';
     PROGCLK : in std_ulogic := 'L';
     PROGDATA : in std_ulogic := 'L';
     PROGEN : in std_ulogic := 'L';
     RST : in std_ulogic := 'L'
  );
end component;

----- component X_DCM_SP -----
component X_DCM_SP
  generic (
     CLKDV_DIVIDE : real := 2.0;
     CLKFX_DIVIDE : integer := 1;
     CLKFX_MULTIPLY : integer := 4;
     CLKIN_DIVIDE_BY_2 : boolean := false;
     CLKIN_PERIOD : real := 10.0;
     CLKOUT_PHASE_SHIFT : string := "NONE";
     CLK_FEEDBACK : string := "1X";
     DESKEW_ADJUST : string := "SYSTEM_SYNCHRONOUS";
     DFS_FREQUENCY_MODE : string := "LOW";
     DLL_FREQUENCY_MODE : string := "LOW";
     DSS_MODE : string := "NONE";
     DUTY_CYCLE_CORRECTION : boolean := true;
     FACTORY_JF : bit_vector := X"C080";
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MAXPERCLKIN : time := 5000000 ps;
     MAXPERPSCLK : time := 100000000 ps;
     MsgOn : boolean := false;
     PHASE_SHIFT : integer := 0;
     SIM_CLKIN_CYCLE_JITTER : time := 300 ps;
     SIM_CLKIN_PERIOD_JITTER : time := 1000 ps;
     STARTUP_WAIT : boolean := false;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     thold_PSEN_PSCLK_negedge_posedge : VitalDelayType := 0.000 ns;
     thold_PSEN_PSCLK_posedge_posedge : VitalDelayType := 0.000 ns;
     thold_PSINCDEC_PSCLK_negedge_posedge : VitalDelayType := 0.000 ns;
     thold_PSINCDEC_PSCLK_posedge_posedge : VitalDelayType := 0.000 ns;
     ticd_PSCLK : VitalDelayType := 0.000 ns;
     tipd_CLKFB : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_CLKIN : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_DSSEN : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_PSCLK : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_PSEN : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_PSINCDEC : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_RST : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tisd_PSEN_PSCLK : VitalDelayType := 0.000 ns;
     tisd_PSINCDEC_PSCLK : VitalDelayType := 0.000 ns;
     tpd_CLKIN_LOCKED : VitalDelayType01 := (0.100 ns, 0.100 ns);
     tpd_PSCLK_PSDONE : VitalDelayType01 := (0.100 ns, 0.100 ns);
     tperiod_CLKIN_POSEDGE : VitalDelayType := 0.000 ns;
     tperiod_PSCLK_POSEDGE : VitalDelayType := 0.000 ns;
     tpw_CLKIN_negedge : VitalDelayType := 0.000 ns;
     tpw_CLKIN_posedge : VitalDelayType := 0.000 ns;
     tpw_PSCLK_negedge : VitalDelayType := 0.000 ns;
     tpw_PSCLK_posedge : VitalDelayType := 0.000 ns;
     tpw_RST_posedge : VitalDelayType := 0.000 ns;
     tsetup_PSEN_PSCLK_negedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_PSEN_PSCLK_posedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_PSINCDEC_PSCLK_negedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_PSINCDEC_PSCLK_posedge_posedge : VitalDelayType := 0.000 ns
  );
  port (
     CLK0 : out std_ulogic := '0';
     CLK180 : out std_ulogic := '0';
     CLK270 : out std_ulogic := '0';
     CLK2X : out std_ulogic := '0';
     CLK2X180 : out std_ulogic := '0';
     CLK90 : out std_ulogic := '0';
     CLKDV : out std_ulogic := '0';
     CLKFX : out std_ulogic := '0';
     CLKFX180 : out std_ulogic := '0';
     LOCKED : out std_ulogic := '0';
     PSDONE : out std_ulogic := '0';
     STATUS : out std_logic_vector(7 downto 0) := "00000000";
     CLKFB : in std_ulogic := '0';
     CLKIN : in std_ulogic := '0';
     DSSEN : in std_ulogic := '0';
     PSCLK : in std_ulogic := '0';
     PSEN : in std_ulogic := '0';
     PSINCDEC : in std_ulogic := '0';
     RST : in std_ulogic := '0'
  );
end component;

----- component X_DNA_PORT -----
component X_DNA_PORT
  generic (
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     SIM_DNA_VALUE : bit_vector := X"000000000000000";
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     thold_DIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_DIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_READ_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_READ_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_SHIFT_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_SHIFT_CLK_posedge_posedge : VitalDelayType := 0 ps;
     ticd_CLK : VitalDelayType := 0 ps;
     tipd_CLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DIN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_READ : VitalDelayType01 := (0 ps, 0 ps);
     tipd_SHIFT : VitalDelayType01 := (0 ps, 0 ps);
     tisd_DIN_CLK : VitalDelayType := 0 ps;
     tisd_READ_CLK : VitalDelayType := 0 ps;
     tisd_SHIFT_CLK : VitalDelayType := 0 ps;
     tpd_CLK_DOUT : VitalDelayType01 := (100 ps, 100 ps);
     tperiod_CLK_posedge : VitalDelayType := 0 ps;
     tsetup_DIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_DIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_READ_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_READ_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_SHIFT_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_SHIFT_CLK_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     DOUT : out std_ulogic;
     CLK : in std_ulogic;
     DIN : in std_ulogic;
     READ : in std_ulogic;
     SHIFT : in std_ulogic
  );
end component;

----- component X_DSP48 -----
component X_DSP48
  generic (
     AREG : integer := 1;
     BREG : integer := 1;
     B_INPUT : string := "DIRECT";
     CARRYINREG : integer := 1;
     CARRYINSELREG : integer := 1;
     CREG : integer := 1;
     InstancePath : string := "*";
     LEGACY_MODE : string := "MULT18X18S";
     LOC : string := "UNPLACED";
     MREG : integer := 1;
     MsgOn : boolean := true;
     OPMODEREG : integer := 1;
     PREG : integer := 1;
     SUBTRACTREG : integer := 1;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     thold_A_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_A_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_BCIN_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_BCIN_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_B_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_B_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_CARRYINSEL_CLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_CARRYINSEL_CLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_CARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEA_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEA_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEB_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEB_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CECARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CECARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CECINSUB_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CECINSUB_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CECTRL_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CECTRL_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEC_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEC_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEM_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEM_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEP_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEP_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_C_CLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     thold_C_CLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     thold_OPMODE_CLK_negedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     thold_OPMODE_CLK_posedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     thold_PCIN_CLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     thold_PCIN_CLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     thold_RSTA_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTA_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTB_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTB_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTCARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTCARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTCTRL_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTCTRL_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTC_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTC_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTM_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTM_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTP_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTP_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_SUBTRACT_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_SUBTRACT_CLK_posedge_posedge : VitalDelayType := 0 ps;
     ticd_CLK : VitalDelayType := 0 ps;
     tipd_A : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tipd_B : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tipd_BCIN : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tipd_C : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tipd_CARRYIN : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CARRYINSEL : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_CEA : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CEB : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CEC : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CECARRYIN : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CECINSUB : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CECTRL : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CEM : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CEP : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CLK : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_OPMODE : VitalDelayArrayType01 (6 downto 0) := (others => (0 ps, 0 ps));
     tipd_PCIN : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tipd_RSTA : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTB : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTC : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTCARRYIN : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTCTRL : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTM : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTP : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_SUBTRACT : VitalDelayType01 := ( 0 ps, 0 ps);
     tisd_A_CLK : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tisd_BCIN_CLK : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tisd_B_CLK : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tisd_CARRYINSEL_CLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_CARRYIN_CLK : VitalDelayType := 0 ps;
     tisd_CEA_CLK : VitalDelayType := 0 ps;
     tisd_CEB_CLK : VitalDelayType := 0 ps;
     tisd_CECARRYIN_CLK : VitalDelayType := 0 ps;
     tisd_CECINSUB_CLK : VitalDelayType := 0 ps;
     tisd_CECTRL_CLK : VitalDelayType := 0 ps;
     tisd_CEC_CLK : VitalDelayType := 0 ps;
     tisd_CEM_CLK : VitalDelayType := 0 ps;
     tisd_CEP_CLK : VitalDelayType := 0 ps;
     tisd_C_CLK : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tisd_OPMODE_CLK : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     tisd_PCIN_CLK : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tisd_RSTA_CLK : VitalDelayType := 0 ps;
     tisd_RSTB_CLK : VitalDelayType := 0 ps;
     tisd_RSTCARRYIN_CLK : VitalDelayType := 0 ps;
     tisd_RSTCTRL_CLK : VitalDelayType := 0 ps;
     tisd_RSTC_CLK : VitalDelayType := 0 ps;
     tisd_RSTM_CLK : VitalDelayType := 0 ps;
     tisd_RSTP_CLK : VitalDelayType := 0 ps;
     tisd_SUBTRACT_CLK : VitalDelayType := 0 ps;
     tpd_A_P : VitalDelayArrayType01 (863 downto 0) := (others => (0 ps, 0 ps));
     tpd_A_PCOUT : VitalDelayArrayType01 (863 downto 0) := (others => (0 ps, 0 ps));
     tpd_BCIN_BCOUT : VitalDelayArrayType01 (323 downto 0) := (others => (0 ps, 0 ps));
     tpd_BCIN_P : VitalDelayArrayType01 (863 downto 0) := (others => (0 ps, 0 ps));
     tpd_BCIN_PCOUT : VitalDelayArrayType01 (863 downto 0) := (others => (0 ps, 0 ps));
     tpd_B_BCOUT : VitalDelayArrayType01 (323 downto 0) := (others => (0 ps, 0 ps));
     tpd_B_P : VitalDelayArrayType01 (863 downto 0) := (others => (0 ps, 0 ps));
     tpd_B_PCOUT : VitalDelayArrayType01 (863 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYINSEL_P : VitalDelayArrayType01 (95 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYINSEL_PCOUT : VitalDelayArrayType01 (95 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYIN_P : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYIN_PCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_CLK_BCOUT : VitalDelayArrayType01 (17 downto 0) := (others => (100 ps, 100 ps));
     tpd_CLK_P : VitalDelayArrayType01 (47 downto 0) := (others => (100 ps, 100 ps));
     tpd_CLK_PCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (100 ps, 100 ps));
     tpd_C_P : VitalDelayArrayType01 (2303 downto 0) := (others => (0 ps, 0 ps));
     tpd_C_PCOUT : VitalDelayArrayType01 (2303 downto 0) := (others => (0 ps, 0 ps));
     tpd_OPMODE_P : VitalDelayArrayType01 (335 downto 0) := (others => (0 ps, 0 ps));
     tpd_OPMODE_PCOUT : VitalDelayArrayType01 (335 downto 0) := (others => (0 ps, 0 ps));
     tpd_PCIN_P : VitalDelayArrayType01 (2303 downto 0) := (others => (0 ps, 0 ps));
     tpd_PCIN_PCOUT : VitalDelayArrayType01 (2303 downto 0) := (others => (0 ps, 0 ps));
     tpd_SUBTRACT_P : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_SUBTRACT_PCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tperiod_CLK_posedge : VitalDelayType := 0 ps;
     tpw_CLK_negedge : VitalDelayType := 0 ps;
     tpw_CLK_posedge : VitalDelayType := 0 ps;
     tsetup_A_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_A_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_BCIN_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_BCIN_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_B_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_B_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_CARRYINSEL_CLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_CARRYINSEL_CLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_CARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEA_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEA_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEB_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEB_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CECARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CECARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CECINSUB_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CECINSUB_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CECTRL_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CECTRL_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEC_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEC_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEM_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEM_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEP_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEP_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_C_CLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tsetup_C_CLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tsetup_OPMODE_CLK_negedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     tsetup_OPMODE_CLK_posedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     tsetup_PCIN_CLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tsetup_PCIN_CLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tsetup_RSTA_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTA_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTB_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTB_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTCARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTCARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTCTRL_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTCTRL_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTC_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTC_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTM_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTM_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTP_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTP_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_SUBTRACT_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_SUBTRACT_CLK_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     BCOUT : out std_logic_vector(17 downto 0);
     P : out std_logic_vector(47 downto 0);
     PCOUT : out std_logic_vector(47 downto 0);
     A : in std_logic_vector(17 downto 0);
     B : in std_logic_vector(17 downto 0);
     BCIN : in std_logic_vector(17 downto 0);
     C : in std_logic_vector(47 downto 0);
     CARRYIN : in std_ulogic;
     CARRYINSEL : in std_logic_vector(1 downto 0);
     CEA : in std_ulogic;
     CEB : in std_ulogic;
     CEC : in std_ulogic;
     CECARRYIN : in std_ulogic;
     CECINSUB : in std_ulogic;
     CECTRL : in std_ulogic;
     CEM : in std_ulogic;
     CEP : in std_ulogic;
     CLK : in std_ulogic;
     OPMODE : in std_logic_vector(6 downto 0);
     PCIN : in std_logic_vector(47 downto 0);
     RSTA : in std_ulogic;
     RSTB : in std_ulogic;
     RSTC : in std_ulogic;
     RSTCARRYIN : in std_ulogic;
     RSTCTRL : in std_ulogic;
     RSTM : in std_ulogic;
     RSTP : in std_ulogic;
     SUBTRACT : in std_ulogic
  );
end component;

----- component X_DSP48A -----
component X_DSP48A
  generic (
     A0REG : integer := 0;
     A1REG : integer := 1;
     B0REG : integer := 0;
     B1REG : integer := 1;
     B_INPUT : string := "DIRECT";
     CARRYINREG : integer := 1;
     CARRYINSEL : string := "CARRYIN";
     CREG : integer := 1;
     DREG : integer := 1;
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MREG : integer := 1;
     MsgOn : boolean := true;
     OPMODEREG : integer := 1;
     PREG : integer := 1;
     RSTTYPE : string := "SYNC";
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     thold_A_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_A_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_BCIN_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_BCIN_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_B_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_B_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_CARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEA_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEA_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEB_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEB_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CECARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CECARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEC_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEC_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CED_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CED_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEM_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEM_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEOPMODE_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEOPMODE_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEP_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEP_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_C_CLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     thold_C_CLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     thold_D_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_D_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_OPMODE_CLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_OPMODE_CLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_PCIN_CLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     thold_PCIN_CLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     thold_RSTA_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTA_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTB_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTB_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTCARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTCARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTC_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTC_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTD_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTD_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTM_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTM_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTOPMODE_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTOPMODE_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTP_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTP_CLK_posedge_posedge : VitalDelayType := 0 ps;
     ticd_CLK : VitalDelayType := 0 ps;
     tipd_A : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tipd_B : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tipd_BCIN : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tipd_C : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tipd_CARRYIN : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CEA : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CEB : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CEC : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CECARRYIN : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CED : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CEM : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CEOPMODE : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CEP : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CLK : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_D : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tipd_OPMODE : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
     tipd_PCIN : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tipd_RSTA : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTB : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTC : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTCARRYIN : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTD : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTM : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTOPMODE : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTP : VitalDelayType01 := ( 0 ps, 0 ps);
     tisd_A_CLK : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tisd_BCIN_CLK : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tisd_B_CLK : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tisd_CARRYIN_CLK : VitalDelayType := 0 ps;
     tisd_CEA_CLK : VitalDelayType := 0 ps;
     tisd_CEB_CLK : VitalDelayType := 0 ps;
     tisd_CECARRYIN_CLK : VitalDelayType := 0 ps;
     tisd_CEC_CLK : VitalDelayType := 0 ps;
     tisd_CED_CLK : VitalDelayType := 0 ps;
     tisd_CEM_CLK : VitalDelayType := 0 ps;
     tisd_CEOPMODE_CLK : VitalDelayType := 0 ps;
     tisd_CEP_CLK : VitalDelayType := 0 ps;
     tisd_C_CLK : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tisd_D_CLK : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tisd_OPMODE_CLK : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tisd_PCIN_CLK : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tisd_RSTA_CLK : VitalDelayType := 0 ps;
     tisd_RSTB_CLK : VitalDelayType := 0 ps;
     tisd_RSTCARRYIN_CLK : VitalDelayType := 0 ps;
     tisd_RSTC_CLK : VitalDelayType := 0 ps;
     tisd_RSTD_CLK : VitalDelayType := 0 ps;
     tisd_RSTM_CLK : VitalDelayType := 0 ps;
     tisd_RSTOPMODE_CLK : VitalDelayType := 0 ps;
     tisd_RSTP_CLK : VitalDelayType := 0 ps;
     tpd_A_CARRYOUT : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_A_P : VitalDelayArrayType01 (863 downto 0) := (others => (0 ps, 0 ps));
     tpd_A_PCOUT : VitalDelayArrayType01 (863 downto 0) := (others => (0 ps, 0 ps));
     tpd_BCIN_BCOUT : VitalDelayArrayType01 (323 downto 0) := (others => (0 ps, 0 ps));
     tpd_BCIN_CARRYOUT : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_BCIN_P : VitalDelayArrayType01 (863 downto 0) := (others => (0 ps, 0 ps));
     tpd_BCIN_PCOUT : VitalDelayArrayType01 (863 downto 0) := (others => (0 ps, 0 ps));
     tpd_B_BCOUT : VitalDelayArrayType01 (323 downto 0) := (others => (0 ps, 0 ps));
     tpd_B_CARRYOUT : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_B_P : VitalDelayArrayType01 (863 downto 0) := (others => (0 ps, 0 ps));
     tpd_B_PCOUT : VitalDelayArrayType01 (863 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYIN_CARRYOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CARRYIN_P : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYIN_PCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_CLK_BCOUT : VitalDelayArrayType01 (17 downto 0) := (others => (100 ps, 100 ps));
     tpd_CLK_CARRYOUT : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK_P : VitalDelayArrayType01 (47 downto 0) := (others => (100 ps, 100 ps));
     tpd_CLK_PCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (100 ps, 100 ps));
     tpd_C_CARRYOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_C_P : VitalDelayArrayType01 (2303 downto 0) := (others => (0 ps, 0 ps));
     tpd_C_PCOUT : VitalDelayArrayType01 (2303 downto 0) := (others => (0 ps, 0 ps));
     tpd_D_BCOUT : VitalDelayArrayType01 (323 downto 0) := (others => (0 ps, 0 ps));
     tpd_D_CARRYOUT : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_D_P : VitalDelayArrayType01 (863 downto 0) := (others => (0 ps, 0 ps));
     tpd_D_PCOUT : VitalDelayArrayType01 (863 downto 0) := (others => (0 ps, 0 ps));
     tpd_OPMODE_BCOUT : VitalDelayArrayType01 (143 downto 0) := (others => (0 ps, 0 ps));
     tpd_OPMODE_CARRYOUT : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
     tpd_OPMODE_P : VitalDelayArrayType01 (383 downto 0) := (others => (0 ps, 0 ps));
     tpd_OPMODE_PCOUT : VitalDelayArrayType01 (383 downto 0) := (others => (0 ps, 0 ps));
     tpd_PCIN_CARRYOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_PCIN_P : VitalDelayArrayType01 (2303 downto 0) := (others => (0 ps, 0 ps));
     tpd_PCIN_PCOUT : VitalDelayArrayType01 (2303 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTA_CARRYOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RSTA_P : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTA_PCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTB_BCOUT : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTB_CARRYOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RSTB_P : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTB_PCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTCARRYIN_CARRYOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RSTCARRYIN_P : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTCARRYIN_PCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTC_CARRYOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RSTC_P : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTC_PCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTD_BCOUT : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTD_CARRYOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RSTD_P : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTD_PCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTM_CARRYOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RSTM_P : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTM_PCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTOPMODE_BCOUT : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTOPMODE_CARRYOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RSTOPMODE_P : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTOPMODE_PCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTP_P : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTP_PCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tperiod_CLK_posedge : VitalDelayType := 0 ps;
     tpw_CLK_negedge : VitalDelayType := 0 ps;
     tpw_CLK_posedge : VitalDelayType := 0 ps;
     tsetup_A_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_A_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_BCIN_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_BCIN_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_B_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_B_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_CARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEA_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEA_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEB_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEB_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CECARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CECARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEC_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEC_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CED_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CED_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEM_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEM_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEOPMODE_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEOPMODE_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEP_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEP_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_C_CLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tsetup_C_CLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tsetup_D_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_D_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_OPMODE_CLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_OPMODE_CLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_PCIN_CLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tsetup_PCIN_CLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tsetup_RSTA_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTA_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTB_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTB_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTCARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTCARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTC_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTC_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTD_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTD_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTM_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTM_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTOPMODE_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTOPMODE_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTP_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTP_CLK_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     BCOUT : out std_logic_vector(17 downto 0);
     CARRYOUT : out std_ulogic;
     P : out std_logic_vector(47 downto 0);
     PCOUT : out std_logic_vector(47 downto 0);
     A : in std_logic_vector(17 downto 0);
     B : in std_logic_vector(17 downto 0);
     BCIN : in std_logic_vector(17 downto 0);
     C : in std_logic_vector(47 downto 0);
     CARRYIN : in std_ulogic;
     CEA : in std_ulogic;
     CEB : in std_ulogic;
     CEC : in std_ulogic;
     CECARRYIN : in std_ulogic;
     CED : in std_ulogic;
     CEM : in std_ulogic;
     CEOPMODE : in std_ulogic;
     CEP : in std_ulogic;
     CLK : in std_ulogic;
     D : in std_logic_vector(17 downto 0);
     OPMODE : in std_logic_vector(7 downto 0);
     PCIN : in std_logic_vector(47 downto 0);
     RSTA : in std_ulogic;
     RSTB : in std_ulogic;
     RSTC : in std_ulogic;
     RSTCARRYIN : in std_ulogic;
     RSTD : in std_ulogic;
     RSTM : in std_ulogic;
     RSTOPMODE : in std_ulogic;
     RSTP : in std_ulogic
  );
end component;

----- component X_DSP48A1 -----
component X_DSP48A1
  generic (
     A0REG : integer := 0;
     A1REG : integer := 1;
     B0REG : integer := 0;
     B1REG : integer := 1;
     B_INPUT : string := "DIRECT";
     CARRYINREG : integer := 1;
     CARRYINSEL : string := "OPMODE5";
     CARRYOUTREG : integer := 1;
     CREG : integer := 1;
     DREG : integer := 1;
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MREG : integer := 1;
     MsgOn : boolean := true;
     OPMODEREG : integer := 1;
     PREG : integer := 1;
     RSTTYPE : string := "SYNC";
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     thold_A_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_A_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_BCIN_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_BCIN_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_B_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_B_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_CARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEA_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEA_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEB_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEB_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CECARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CECARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEC_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEC_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CED_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CED_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEM_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEM_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEOPMODE_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEOPMODE_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEP_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEP_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_C_CLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     thold_C_CLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     thold_D_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_D_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_OPMODE_CLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_OPMODE_CLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_PCIN_CLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     thold_PCIN_CLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     thold_RSTA_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTA_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTB_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTB_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTCARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTCARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTC_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTC_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTD_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTD_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTM_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTM_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTOPMODE_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTOPMODE_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTP_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTP_CLK_posedge_posedge : VitalDelayType := 0 ps;
     ticd_CLK : VitalDelayType := 0 ps;
     tipd_A : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tipd_B : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tipd_BCIN : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tipd_C : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tipd_CARRYIN : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CEA : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CEB : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CEC : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CECARRYIN : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CED : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CEM : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CEOPMODE : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CEP : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CLK : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_D : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tipd_OPMODE : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
     tipd_PCIN : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tipd_RSTA : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTB : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTC : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTCARRYIN : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTD : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTM : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTOPMODE : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTP : VitalDelayType01 := ( 0 ps, 0 ps);
     tisd_A_CLK : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tisd_BCIN_CLK : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tisd_B_CLK : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tisd_CARRYIN_CLK : VitalDelayType := 0 ps;
     tisd_CEA_CLK : VitalDelayType := 0 ps;
     tisd_CEB_CLK : VitalDelayType := 0 ps;
     tisd_CECARRYIN_CLK : VitalDelayType := 0 ps;
     tisd_CEC_CLK : VitalDelayType := 0 ps;
     tisd_CED_CLK : VitalDelayType := 0 ps;
     tisd_CEM_CLK : VitalDelayType := 0 ps;
     tisd_CEOPMODE_CLK : VitalDelayType := 0 ps;
     tisd_CEP_CLK : VitalDelayType := 0 ps;
     tisd_C_CLK : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tisd_D_CLK : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tisd_OPMODE_CLK : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tisd_PCIN_CLK : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tisd_RSTA_CLK : VitalDelayType := 0 ps;
     tisd_RSTB_CLK : VitalDelayType := 0 ps;
     tisd_RSTCARRYIN_CLK : VitalDelayType := 0 ps;
     tisd_RSTC_CLK : VitalDelayType := 0 ps;
     tisd_RSTD_CLK : VitalDelayType := 0 ps;
     tisd_RSTM_CLK : VitalDelayType := 0 ps;
     tisd_RSTOPMODE_CLK : VitalDelayType := 0 ps;
     tisd_RSTP_CLK : VitalDelayType := 0 ps;
     tpd_A_CARRYOUT : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_A_CARRYOUTF : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_A_M : VitalDelayArrayType01 (647 downto 0) := (others => (0 ps, 0 ps));
     tpd_A_P : VitalDelayArrayType01 (863 downto 0) := (others => (0 ps, 0 ps));
     tpd_A_PCOUT : VitalDelayArrayType01 (863 downto 0) := (others => (0 ps, 0 ps));
     tpd_BCIN_BCOUT : VitalDelayArrayType01 (323 downto 0) := (others => (0 ps, 0 ps));
     tpd_BCIN_CARRYOUT : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_BCIN_CARRYOUTF : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_BCIN_M : VitalDelayArrayType01 (647 downto 0) := (others => (0 ps, 0 ps));
     tpd_BCIN_P : VitalDelayArrayType01 (863 downto 0) := (others => (0 ps, 0 ps));
     tpd_BCIN_PCOUT : VitalDelayArrayType01 (863 downto 0) := (others => (0 ps, 0 ps));
     tpd_B_BCOUT : VitalDelayArrayType01 (323 downto 0) := (others => (0 ps, 0 ps));
     tpd_B_CARRYOUT : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_B_CARRYOUTF : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_B_M : VitalDelayArrayType01 (647 downto 0) := (others => (0 ps, 0 ps));
     tpd_B_P : VitalDelayArrayType01 (863 downto 0) := (others => (0 ps, 0 ps));
     tpd_B_PCOUT : VitalDelayArrayType01 (863 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYIN_CARRYOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CARRYIN_CARRYOUTF : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CARRYIN_P : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYIN_PCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_CLK_BCOUT : VitalDelayArrayType01 (17 downto 0) := (others => (100 ps, 100 ps));
     tpd_CLK_CARRYOUT : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK_CARRYOUTF : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK_M : VitalDelayArrayType01 (35 downto 0) := (others => (100 ps, 100 ps));
     tpd_CLK_P : VitalDelayArrayType01 (47 downto 0) := (others => (100 ps, 100 ps));
     tpd_CLK_PCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (100 ps, 100 ps));
     tpd_C_CARRYOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_C_CARRYOUTF : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_C_P : VitalDelayArrayType01 (2303 downto 0) := (others => (0 ps, 0 ps));
     tpd_C_PCOUT : VitalDelayArrayType01 (2303 downto 0) := (others => (0 ps, 0 ps));
     tpd_D_BCOUT : VitalDelayArrayType01 (323 downto 0) := (others => (0 ps, 0 ps));
     tpd_D_CARRYOUT : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_D_CARRYOUTF : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_D_M : VitalDelayArrayType01 (647 downto 0) := (others => (0 ps, 0 ps));
     tpd_D_P : VitalDelayArrayType01 (863 downto 0) := (others => (0 ps, 0 ps));
     tpd_D_PCOUT : VitalDelayArrayType01 (863 downto 0) := (others => (0 ps, 0 ps));
     tpd_OPMODE_BCOUT : VitalDelayArrayType01 (143 downto 0) := (others => (0 ps, 0 ps));
     tpd_OPMODE_CARRYOUT : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
     tpd_OPMODE_CARRYOUTF : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
     tpd_OPMODE_M : VitalDelayArrayType01 (287 downto 0) := (others => (0 ps, 0 ps));
     tpd_OPMODE_P : VitalDelayArrayType01 (383 downto 0) := (others => (0 ps, 0 ps));
     tpd_OPMODE_PCOUT : VitalDelayArrayType01 (383 downto 0) := (others => (0 ps, 0 ps));
     tpd_PCIN_CARRYOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_PCIN_CARRYOUTF : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_PCIN_P : VitalDelayArrayType01 (2303 downto 0) := (others => (0 ps, 0 ps));
     tpd_PCIN_PCOUT : VitalDelayArrayType01 (2303 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTA_CARRYOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RSTA_CARRYOUTF : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RSTA_M : VitalDelayArrayType01 (35 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTA_P : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTA_PCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTB_BCOUT : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTB_CARRYOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RSTB_CARRYOUTF : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RSTB_M : VitalDelayArrayType01 (35 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTB_P : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTB_PCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTCARRYIN_CARRYOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RSTCARRYIN_CARRYOUTF : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RSTCARRYIN_P : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTCARRYIN_PCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTC_CARRYOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RSTC_CARRYOUTF : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RSTC_P : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTC_PCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTD_BCOUT : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTD_CARRYOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RSTD_CARRYOUTF : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RSTD_M : VitalDelayArrayType01 (35 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTD_P : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTD_PCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTM_CARRYOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RSTM_CARRYOUTF : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RSTM_M : VitalDelayArrayType01 (35 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTM_P : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTM_PCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTOPMODE_BCOUT : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTOPMODE_CARRYOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RSTOPMODE_CARRYOUTF : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RSTOPMODE_M : VitalDelayArrayType01 (35 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTOPMODE_P : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTOPMODE_PCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTP_P : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_RSTP_PCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tperiod_CLK_posedge : VitalDelayType := 0 ps;
     tpw_CLK_negedge : VitalDelayType := 0 ps;
     tpw_CLK_posedge : VitalDelayType := 0 ps;
     tsetup_A_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_A_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_BCIN_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_BCIN_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_B_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_B_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_CARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEA_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEA_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEB_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEB_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CECARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CECARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEC_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEC_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CED_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CED_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEM_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEM_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEOPMODE_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEOPMODE_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEP_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEP_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_C_CLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tsetup_C_CLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tsetup_D_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_D_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_OPMODE_CLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_OPMODE_CLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_PCIN_CLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tsetup_PCIN_CLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tsetup_RSTA_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTA_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTB_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTB_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTCARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTCARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTC_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTC_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTD_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTD_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTM_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTM_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTOPMODE_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTOPMODE_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTP_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTP_CLK_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     BCOUT : out std_logic_vector(17 downto 0);
     CARRYOUT : out std_ulogic;
     CARRYOUTF : out std_ulogic;
     M : out std_logic_vector(35 downto 0);
     P : out std_logic_vector(47 downto 0);
     PCOUT : out std_logic_vector(47 downto 0);
     A : in std_logic_vector(17 downto 0);
     B : in std_logic_vector(17 downto 0);
     BCIN : in std_logic_vector(17 downto 0) := (others => 'L');
     C : in std_logic_vector(47 downto 0);
     CARRYIN : in std_ulogic := 'L';
     CEA : in std_ulogic;
     CEB : in std_ulogic;
     CEC : in std_ulogic;
     CECARRYIN : in std_ulogic;
     CED : in std_ulogic;
     CEM : in std_ulogic;
     CEOPMODE : in std_ulogic;
     CEP : in std_ulogic;
     CLK : in std_ulogic;
     D : in std_logic_vector(17 downto 0);
     OPMODE : in std_logic_vector(7 downto 0);
     PCIN : in std_logic_vector(47 downto 0) := (others => 'L');
     RSTA : in std_ulogic;
     RSTB : in std_ulogic;
     RSTC : in std_ulogic;
     RSTCARRYIN : in std_ulogic;
     RSTD : in std_ulogic;
     RSTM : in std_ulogic;
     RSTOPMODE : in std_ulogic;
     RSTP : in std_ulogic
  );
end component;

----- component X_DSP48E -----
component X_DSP48E
  generic (
     ACASCREG : integer := 1;
     ALUMODEREG : integer := 1;
     AREG : integer := 1;
     AUTORESET_PATTERN_DETECT : boolean := FALSE;
     AUTORESET_PATTERN_DETECT_OPTINV : string := "MATCH";
     A_INPUT : string := "DIRECT";
     BCASCREG : integer := 1;
     BREG : integer := 1;
     B_INPUT : string := "DIRECT";
     CARRYINREG : integer := 1;
     CARRYINSELREG : integer := 1;
     CREG : integer := 1;
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MASK : bit_vector := X"3FFFFFFFFFFF";
     MREG : integer := 1;
     MULTCARRYINREG : integer := 1;
     MsgOn : boolean := true;
     OPMODEREG : integer := 1;
     PATTERN : bit_vector := X"000000000000";
     PREG : integer := 1;
     SEL_MASK : string := "MASK";
     SEL_PATTERN : string := "PATTERN";
     SEL_ROUNDING_MASK : string := "SEL_MASK";
     TimingChecksOn : boolean := true;
     USE_MULT : string := "MULT_S";
     USE_PATTERN_DETECT : string := "NO_PATDET";
     USE_SIMD : string := "ONE48";
     Xon : boolean := true;
     thold_ACIN_CLK_negedge_posedge : VitalDelayArrayType(29 downto 0) := (others => 0 ps);
     thold_ACIN_CLK_posedge_posedge : VitalDelayArrayType(29 downto 0) := (others => 0 ps);
     thold_ALUMODE_CLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_ALUMODE_CLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_A_CLK_negedge_posedge : VitalDelayArrayType(29 downto 0) := (others => 0 ps);
     thold_A_CLK_posedge_posedge : VitalDelayArrayType(29 downto 0) := (others => 0 ps);
     thold_BCIN_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_BCIN_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_B_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_B_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_CARRYCASCIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CARRYCASCIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CARRYINSEL_CLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_CARRYINSEL_CLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_CARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEA1_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEA1_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEA2_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEA2_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEALUMODE_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEALUMODE_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEB1_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEB1_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEB2_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEB2_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CECARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CECARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CECTRL_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CECTRL_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEC_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEC_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEMULTCARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEMULTCARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEM_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEM_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEP_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEP_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_C_CLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     thold_C_CLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     thold_MULTSIGNIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_MULTSIGNIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_OPMODE_CLK_negedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     thold_OPMODE_CLK_posedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     thold_PCIN_CLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     thold_PCIN_CLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     thold_RSTALLCARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTALLCARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTALUMODE_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTALUMODE_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTA_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTA_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTB_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTB_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTCTRL_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTCTRL_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTC_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTC_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTM_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTM_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTP_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTP_CLK_posedge_posedge : VitalDelayType := 0 ps;
     ticd_CLK : VitalDelayType := 0 ps;
     tipd_A : VitalDelayArrayType01 (29 downto 0) := (others => (0 ps, 0 ps));
     tipd_ACIN : VitalDelayArrayType01 (29 downto 0) := (others => (0 ps, 0 ps));
     tipd_ALUMODE : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_B : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tipd_BCIN : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tipd_C : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tipd_CARRYCASCIN : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CARRYIN : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CARRYINSEL : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_CEA1 : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CEA2 : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CEALUMODE : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CEB1 : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CEB2 : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CEC : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CECARRYIN : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CECTRL : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CEM : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CEMULTCARRYIN : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CEP : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CLK : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_MULTSIGNIN : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_OPMODE : VitalDelayArrayType01 (6 downto 0) := (others => (0 ps, 0 ps));
     tipd_PCIN : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tipd_RSTA : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTALLCARRYIN : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTALUMODE : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTB : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTC : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTCTRL : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTM : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTP : VitalDelayType01 := ( 0 ps, 0 ps);
     tisd_ACIN_CLK : VitalDelayArrayType(29 downto 0) := (others => 0 ps);
     tisd_ALUMODE_CLK : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_A_CLK : VitalDelayArrayType(29 downto 0) := (others => 0 ps);
     tisd_BCIN_CLK : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tisd_B_CLK : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tisd_CARRYCASCIN_CLK : VitalDelayType := 0 ps;
     tisd_CARRYINSEL_CLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_CARRYIN_CLK : VitalDelayType := 0 ps;
     tisd_CEA1_CLK : VitalDelayType := 0 ps;
     tisd_CEA2_CLK : VitalDelayType := 0 ps;
     tisd_CEALUMODE_CLK : VitalDelayType := 0 ps;
     tisd_CEB1_CLK : VitalDelayType := 0 ps;
     tisd_CEB2_CLK : VitalDelayType := 0 ps;
     tisd_CECARRYIN_CLK : VitalDelayType := 0 ps;
     tisd_CECTRL_CLK : VitalDelayType := 0 ps;
     tisd_CEC_CLK : VitalDelayType := 0 ps;
     tisd_CEMULTCARRYIN_CLK : VitalDelayType := 0 ps;
     tisd_CEM_CLK : VitalDelayType := 0 ps;
     tisd_CEP_CLK : VitalDelayType := 0 ps;
     tisd_C_CLK : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tisd_MULTSIGNIN_CLK : VitalDelayType := 0 ps;
     tisd_OPMODE_CLK : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     tisd_PCIN_CLK : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tisd_RSTALLCARRYIN_CLK : VitalDelayType := 0 ps;
     tisd_RSTALUMODE_CLK : VitalDelayType := 0 ps;
     tisd_RSTA_CLK : VitalDelayType := 0 ps;
     tisd_RSTB_CLK : VitalDelayType := 0 ps;
     tisd_RSTCTRL_CLK : VitalDelayType := 0 ps;
     tisd_RSTC_CLK : VitalDelayType := 0 ps;
     tisd_RSTM_CLK : VitalDelayType := 0 ps;
     tisd_RSTP_CLK : VitalDelayType := 0 ps;
     tpd_ACIN_ACOUT : VitalDelayArrayType01 (899 downto 0) := (others => (0 ps, 0 ps));
     tpd_ACIN_CARRYCASCOUT : VitalDelayArrayType01 (29 downto 0) := (others => (0 ps, 0 ps));
     tpd_ACIN_CARRYOUT : VitalDelayArrayType01 (119 downto 0) := (others => (0 ps, 0 ps));
     tpd_ACIN_MULTSIGNOUT : VitalDelayArrayType01 (29 downto 0) := (others => (0 ps, 0 ps));
     tpd_ACIN_OVERFLOW : VitalDelayArrayType01 (29 downto 0) := (others => (0 ps, 0 ps));
     tpd_ACIN_P : VitalDelayArrayType01 (1439 downto 0) := (others => (0 ps, 0 ps));
     tpd_ACIN_PATTERNBDETECT : VitalDelayArrayType01 (29 downto 0) := (others => (0 ps, 0 ps));
     tpd_ACIN_PATTERNDETECT : VitalDelayArrayType01 (29 downto 0) := (others => (0 ps, 0 ps));
     tpd_ACIN_PCOUT : VitalDelayArrayType01 (1439 downto 0) := (others => (0 ps, 0 ps));
     tpd_ACIN_UNDERFLOW : VitalDelayArrayType01 (29 downto 0) := (others => (0 ps, 0 ps));
     tpd_ALUMODE_ACOUT : VitalDelayArrayType01 (119 downto 0) := (others => (0 ps, 0 ps));
     tpd_ALUMODE_CARRYCASCOUT : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tpd_ALUMODE_CARRYOUT : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
     tpd_ALUMODE_MULTSIGNOUT : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tpd_ALUMODE_OVERFLOW : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tpd_ALUMODE_P : VitalDelayArrayType01 (191 downto 0) := (others => (0 ps, 0 ps));
     tpd_ALUMODE_PATTERNBDETECT : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tpd_ALUMODE_PATTERNDETECT : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tpd_ALUMODE_PCOUT : VitalDelayArrayType01 (191 downto 0) := (others => (0 ps, 0 ps));
     tpd_ALUMODE_UNDERFLOW : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tpd_A_ACOUT : VitalDelayArrayType01 (899 downto 0) := (others => (0 ps, 0 ps));
     tpd_A_CARRYCASCOUT : VitalDelayArrayType01 (29 downto 0) := (others => (0 ps, 0 ps));
     tpd_A_CARRYOUT : VitalDelayArrayType01 (119 downto 0) := (others => (0 ps, 0 ps));
     tpd_A_MULTSIGNOUT : VitalDelayArrayType01 (29 downto 0) := (others => (0 ps, 0 ps));
     tpd_A_OVERFLOW : VitalDelayArrayType01 (29 downto 0) := (others => (0 ps, 0 ps));
     tpd_A_P : VitalDelayArrayType01 (1439 downto 0) := (others => (0 ps, 0 ps));
     tpd_A_PATTERNBDETECT : VitalDelayArrayType01 (29 downto 0) := (others => (0 ps, 0 ps));
     tpd_A_PATTERNDETECT : VitalDelayArrayType01 (29 downto 0) := (others => (0 ps, 0 ps));
     tpd_A_PCOUT : VitalDelayArrayType01 (1439 downto 0) := (others => (0 ps, 0 ps));
     tpd_A_UNDERFLOW : VitalDelayArrayType01 (29 downto 0) := (others => (0 ps, 0 ps));
     tpd_BCIN_BCOUT : VitalDelayArrayType01 (323 downto 0) := (others => (0 ps, 0 ps));
     tpd_BCIN_CARRYCASCOUT : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_BCIN_CARRYOUT : VitalDelayArrayType01 (71 downto 0) := (others => (0 ps, 0 ps));
     tpd_BCIN_MULTSIGNOUT : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_BCIN_OVERFLOW : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_BCIN_P : VitalDelayArrayType01 (863 downto 0) := (others => (0 ps, 0 ps));
     tpd_BCIN_PATTERNBDETECT : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_BCIN_PATTERNDETECT : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_BCIN_PCOUT : VitalDelayArrayType01 (863 downto 0) := (others => (0 ps, 0 ps));
     tpd_BCIN_UNDERFLOW : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_B_BCOUT : VitalDelayArrayType01 (323 downto 0) := (others => (0 ps, 0 ps));
     tpd_B_CARRYCASCOUT : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_B_CARRYOUT : VitalDelayArrayType01 (71 downto 0) := (others => (0 ps, 0 ps));
     tpd_B_MULTSIGNOUT : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_B_OVERFLOW : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_B_P : VitalDelayArrayType01 (863 downto 0) := (others => (0 ps, 0 ps));
     tpd_B_PATTERNBDETECT : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_B_PATTERNDETECT : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_B_PCOUT : VitalDelayArrayType01 (863 downto 0) := (others => (0 ps, 0 ps));
     tpd_B_UNDERFLOW : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYCASCIN_CARRYCASCOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CARRYCASCIN_CARRYOUT : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYCASCIN_MULTSIGNOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CARRYCASCIN_OVERFLOW : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CARRYCASCIN_P : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYCASCIN_PATTERNBDETECT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CARRYCASCIN_PATTERNDETECT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CARRYCASCIN_PCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYCASCIN_UNDERFLOW : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CARRYINSEL_CARRYCASCOUT : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYINSEL_CARRYOUT : VitalDelayArrayType01 (11 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYINSEL_MULTSIGNOUT : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYINSEL_OVERFLOW : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYINSEL_P : VitalDelayArrayType01 (143 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYINSEL_PATTERNBDETECT : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYINSEL_PATTERNDETECT : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYINSEL_PCOUT : VitalDelayArrayType01 (143 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYINSEL_UNDERFLOW : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYIN_CARRYCASCOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CARRYIN_CARRYOUT : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYIN_MULTSIGNOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CARRYIN_OVERFLOW : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CARRYIN_P : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYIN_PATTERNBDETECT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CARRYIN_PATTERNDETECT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CARRYIN_PCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYIN_UNDERFLOW : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CLK_ACOUT : VitalDelayArrayType01 (29 downto 0) := (others => (100 ps, 100 ps));
     tpd_CLK_BCOUT : VitalDelayArrayType01 (17 downto 0) := (others => (100 ps, 100 ps));
     tpd_CLK_CARRYCASCOUT : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK_CARRYOUT : VitalDelayArrayType01 (3 downto 0) := (others => (100 ps, 100 ps));
     tpd_CLK_MULTSIGNOUT : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK_OVERFLOW : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK_P : VitalDelayArrayType01 (47 downto 0) := (others => (100 ps, 100 ps));
     tpd_CLK_PATTERNBDETECT : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK_PATTERNDETECT : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK_PCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (100 ps, 100 ps));
     tpd_CLK_UNDERFLOW : VitalDelayType01 := (100 ps, 100 ps);
     tpd_C_CARRYCASCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_C_CARRYOUT : VitalDelayArrayType01 (191 downto 0) := (others => (0 ps, 0 ps));
     tpd_C_MULTSIGNOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_C_OVERFLOW : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_C_P : VitalDelayArrayType01 (2303 downto 0) := (others => (0 ps, 0 ps));
     tpd_C_PATTERNBDETECT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_C_PATTERNDETECT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_C_PCOUT : VitalDelayArrayType01 (2303 downto 0) := (others => (0 ps, 0 ps));
     tpd_C_UNDERFLOW : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_MULTSIGNIN_CARRYCASCOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_MULTSIGNIN_CARRYOUT : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tpd_MULTSIGNIN_MULTSIGNOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_MULTSIGNIN_OVERFLOW : VitalDelayType01 := (0 ps, 0 ps);
     tpd_MULTSIGNIN_P : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_MULTSIGNIN_PATTERNBDETECT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_MULTSIGNIN_PATTERNDETECT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_MULTSIGNIN_PCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_MULTSIGNIN_UNDERFLOW : VitalDelayType01 := (0 ps, 0 ps);
     tpd_OPMODE_CARRYCASCOUT : VitalDelayArrayType01 (6 downto 0) := (others => (0 ps, 0 ps));
     tpd_OPMODE_CARRYOUT : VitalDelayArrayType01 (27 downto 0) := (others => (0 ps, 0 ps));
     tpd_OPMODE_MULTSIGNOUT : VitalDelayArrayType01 (6 downto 0) := (others => (0 ps, 0 ps));
     tpd_OPMODE_OVERFLOW : VitalDelayArrayType01 (6 downto 0) := (others => (0 ps, 0 ps));
     tpd_OPMODE_P : VitalDelayArrayType01 (335 downto 0) := (others => (0 ps, 0 ps));
     tpd_OPMODE_PATTERNBDETECT : VitalDelayArrayType01 (6 downto 0) := (others => (0 ps, 0 ps));
     tpd_OPMODE_PATTERNDETECT : VitalDelayArrayType01 (6 downto 0) := (others => (0 ps, 0 ps));
     tpd_OPMODE_PCOUT : VitalDelayArrayType01 (335 downto 0) := (others => (0 ps, 0 ps));
     tpd_OPMODE_UNDERFLOW : VitalDelayArrayType01 (6 downto 0) := (others => (0 ps, 0 ps));
     tpd_PCIN_CARRYCASCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_PCIN_CARRYOUT : VitalDelayArrayType01 (191 downto 0) := (others => (0 ps, 0 ps));
     tpd_PCIN_MULTSIGNOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_PCIN_OVERFLOW : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_PCIN_P : VitalDelayArrayType01 (2303 downto 0) := (others => (0 ps, 0 ps));
     tpd_PCIN_PATTERNBDETECT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_PCIN_PATTERNDETECT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_PCIN_PCOUT : VitalDelayArrayType01 (2303 downto 0) := (others => (0 ps, 0 ps));
     tpd_PCIN_UNDERFLOW : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tperiod_CLK_posedge : VitalDelayType := 0 ps;
     tpw_CLK_negedge : VitalDelayType := 0 ps;
     tpw_CLK_posedge : VitalDelayType := 0 ps;
     tsetup_ACIN_CLK_negedge_posedge : VitalDelayArrayType(29 downto 0) := (others => 0 ps);
     tsetup_ACIN_CLK_posedge_posedge : VitalDelayArrayType(29 downto 0) := (others => 0 ps);
     tsetup_ALUMODE_CLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_ALUMODE_CLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_A_CLK_negedge_posedge : VitalDelayArrayType(29 downto 0) := (others => 0 ps);
     tsetup_A_CLK_posedge_posedge : VitalDelayArrayType(29 downto 0) := (others => 0 ps);
     tsetup_BCIN_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_BCIN_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_B_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_B_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_CARRYCASCIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CARRYCASCIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CARRYINSEL_CLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_CARRYINSEL_CLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_CARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEA1_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEA1_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEA2_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEA2_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEALUMODE_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEALUMODE_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEB1_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEB1_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEB2_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEB2_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CECARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CECARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CECTRL_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CECTRL_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEC_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEC_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEMULTCARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEMULTCARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEM_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEM_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEP_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEP_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_C_CLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tsetup_C_CLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tsetup_MULTSIGNIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_MULTSIGNIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_OPMODE_CLK_negedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     tsetup_OPMODE_CLK_posedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     tsetup_PCIN_CLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tsetup_PCIN_CLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tsetup_RSTALLCARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTALLCARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTALUMODE_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTALUMODE_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTA_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTA_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTB_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTB_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTCTRL_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTCTRL_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTC_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTC_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTM_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTM_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTP_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTP_CLK_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     ACOUT : out std_logic_vector(29 downto 0);
     BCOUT : out std_logic_vector(17 downto 0);
     CARRYCASCOUT : out std_ulogic;
     CARRYOUT : out std_logic_vector(3 downto 0);
     MULTSIGNOUT : out std_ulogic;
     OVERFLOW : out std_ulogic;
     P : out std_logic_vector(47 downto 0);
     PATTERNBDETECT : out std_ulogic;
     PATTERNDETECT : out std_ulogic;
     PCOUT : out std_logic_vector(47 downto 0);
     UNDERFLOW : out std_ulogic;
     A : in std_logic_vector(29 downto 0);
     ACIN : in std_logic_vector(29 downto 0);
     ALUMODE : in std_logic_vector(3 downto 0);
     B : in std_logic_vector(17 downto 0);
     BCIN : in std_logic_vector(17 downto 0);
     C : in std_logic_vector(47 downto 0);
     CARRYCASCIN : in std_ulogic;
     CARRYIN : in std_ulogic;
     CARRYINSEL : in std_logic_vector(2 downto 0);
     CEA1 : in std_ulogic;
     CEA2 : in std_ulogic;
     CEALUMODE : in std_ulogic;
     CEB1 : in std_ulogic;
     CEB2 : in std_ulogic;
     CEC : in std_ulogic;
     CECARRYIN : in std_ulogic;
     CECTRL : in std_ulogic;
     CEM : in std_ulogic;
     CEMULTCARRYIN : in std_ulogic;
     CEP : in std_ulogic;
     CLK : in std_ulogic;
     MULTSIGNIN : in std_ulogic;
     OPMODE : in std_logic_vector(6 downto 0);
     PCIN : in std_logic_vector(47 downto 0);
     RSTA : in std_ulogic;
     RSTALLCARRYIN : in std_ulogic;
     RSTALUMODE : in std_ulogic;
     RSTB : in std_ulogic;
     RSTC : in std_ulogic;
     RSTCTRL : in std_ulogic;
     RSTM : in std_ulogic;
     RSTP : in std_ulogic
  );
end component;

----- component X_DSP48E1 -----
component X_DSP48E1
  generic (
     ACASCREG : integer := 1;
     ADREG : integer := 1;
     ALUMODEREG : integer := 1;
     AREG : integer := 1;
     AUTORESET_PATDET : string := "NO_RESET";
     A_INPUT : string := "DIRECT";
     BCASCREG : integer := 1;
     BREG : integer := 1;
     B_INPUT : string := "DIRECT";
     CARRYINREG : integer := 1;
     CARRYINSELREG : integer := 1;
     CREG : integer := 1;
     DREG : integer := 1;
     INMODEREG : integer := 1;
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MASK : bit_vector := X"3FFFFFFFFFFF";
     MREG : integer := 1;
     MsgOn : boolean := true;
     OPMODEREG : integer := 1;
     PATTERN : bit_vector := X"000000000000";
     PREG : integer := 1;
     SEL_MASK : string := "MASK";
     SEL_PATTERN : string := "PATTERN";
     TimingChecksOn : boolean := true;
     USE_DPORT : boolean := FALSE;
     USE_MULT : string := "MULTIPLY";
     USE_PATTERN_DETECT : string := "NO_PATDET";
     USE_SIMD : string := "ONE48";
     Xon : boolean := true;
     thold_ACIN_CLK_negedge_posedge : VitalDelayArrayType(29 downto 0) := (others => 0 ps);
     thold_ACIN_CLK_posedge_posedge : VitalDelayArrayType(29 downto 0) := (others => 0 ps);
     thold_ALUMODE_CLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_ALUMODE_CLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_A_CLK_negedge_posedge : VitalDelayArrayType(29 downto 0) := (others => 0 ps);
     thold_A_CLK_posedge_posedge : VitalDelayArrayType(29 downto 0) := (others => 0 ps);
     thold_BCIN_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_BCIN_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_B_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_B_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_CARRYCASCIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CARRYCASCIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CARRYINSEL_CLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_CARRYINSEL_CLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_CARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEA1_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEA1_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEA2_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEA2_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEAD_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEAD_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEALUMODE_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEALUMODE_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEB1_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEB1_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEB2_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEB2_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CECARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CECARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CECTRL_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CECTRL_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEC_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEC_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CED_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CED_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEINMODE_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEINMODE_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEM_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEM_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEP_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEP_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_C_CLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     thold_C_CLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     thold_D_CLK_negedge_posedge : VitalDelayArrayType(24 downto 0) := (others => 0 ps);
     thold_D_CLK_posedge_posedge : VitalDelayArrayType(24 downto 0) := (others => 0 ps);
     thold_INMODE_CLK_negedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     thold_INMODE_CLK_posedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     thold_MULTSIGNIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_MULTSIGNIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_OPMODE_CLK_negedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     thold_OPMODE_CLK_posedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     thold_PCIN_CLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     thold_PCIN_CLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     thold_RSTALLCARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTALLCARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTALUMODE_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTALUMODE_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTA_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTA_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTB_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTB_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTCTRL_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTCTRL_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTC_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTC_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTD_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTD_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTINMODE_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTINMODE_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTM_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTM_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTP_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTP_CLK_posedge_posedge : VitalDelayType := 0 ps;
     ticd_CLK : VitalDelayType := 0 ps;
     tipd_A : VitalDelayArrayType01 (29 downto 0) := (others => (0 ps, 0 ps));
     tipd_ACIN : VitalDelayArrayType01 (29 downto 0) := (others => (0 ps, 0 ps));
     tipd_ALUMODE : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_B : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tipd_BCIN : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tipd_C : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tipd_CARRYCASCIN : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CARRYIN : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CARRYINSEL : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_CEA1 : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CEA2 : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CEAD : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CEALUMODE : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CEB1 : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CEB2 : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CEC : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CECARRYIN : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CECTRL : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CED : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CEINMODE : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CEM : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CEP : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_CLK : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_D : VitalDelayArrayType01 (24 downto 0) := (others => (0 ps, 0 ps));
     tipd_INMODE : VitalDelayArrayType01 (4 downto 0) := (others => (0 ps, 0 ps));
     tipd_MULTSIGNIN : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_OPMODE : VitalDelayArrayType01 (6 downto 0) := (others => (0 ps, 0 ps));
     tipd_PCIN : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tipd_RSTA : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTALLCARRYIN : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTALUMODE : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTB : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTC : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTCTRL : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTD : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTINMODE : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTM : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RSTP : VitalDelayType01 := ( 0 ps, 0 ps);
     tisd_ACIN_CLK : VitalDelayArrayType(29 downto 0) := (others => 0 ps);
     tisd_ALUMODE_CLK : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_A_CLK : VitalDelayArrayType(29 downto 0) := (others => 0 ps);
     tisd_BCIN_CLK : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tisd_B_CLK : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tisd_CARRYCASCIN_CLK : VitalDelayType := 0 ps;
     tisd_CARRYINSEL_CLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_CARRYIN_CLK : VitalDelayType := 0 ps;
     tisd_CEA1_CLK : VitalDelayType := 0 ps;
     tisd_CEA2_CLK : VitalDelayType := 0 ps;
     tisd_CEAD_CLK : VitalDelayType := 0 ps;
     tisd_CEALUMODE_CLK : VitalDelayType := 0 ps;
     tisd_CEB1_CLK : VitalDelayType := 0 ps;
     tisd_CEB2_CLK : VitalDelayType := 0 ps;
     tisd_CECARRYIN_CLK : VitalDelayType := 0 ps;
     tisd_CECTRL_CLK : VitalDelayType := 0 ps;
     tisd_CEC_CLK : VitalDelayType := 0 ps;
     tisd_CED_CLK : VitalDelayType := 0 ps;
     tisd_CEINMODE_CLK : VitalDelayType := 0 ps;
     tisd_CEM_CLK : VitalDelayType := 0 ps;
     tisd_CEP_CLK : VitalDelayType := 0 ps;
     tisd_C_CLK : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tisd_D_CLK : VitalDelayArrayType(24 downto 0) := (others => 0 ps);
     tisd_INMODE_CLK : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tisd_MULTSIGNIN_CLK : VitalDelayType := 0 ps;
     tisd_OPMODE_CLK : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     tisd_PCIN_CLK : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tisd_RSTALLCARRYIN_CLK : VitalDelayType := 0 ps;
     tisd_RSTALUMODE_CLK : VitalDelayType := 0 ps;
     tisd_RSTA_CLK : VitalDelayType := 0 ps;
     tisd_RSTB_CLK : VitalDelayType := 0 ps;
     tisd_RSTCTRL_CLK : VitalDelayType := 0 ps;
     tisd_RSTC_CLK : VitalDelayType := 0 ps;
     tisd_RSTD_CLK : VitalDelayType := 0 ps;
     tisd_RSTINMODE_CLK : VitalDelayType := 0 ps;
     tisd_RSTM_CLK : VitalDelayType := 0 ps;
     tisd_RSTP_CLK : VitalDelayType := 0 ps;
     tpd_ACIN_ACOUT : VitalDelayArrayType01 (899 downto 0) := (others => (0 ps, 0 ps));
     tpd_ACIN_CARRYCASCOUT : VitalDelayArrayType01 (29 downto 0) := (others => (0 ps, 0 ps));
     tpd_ACIN_CARRYOUT : VitalDelayArrayType01 (119 downto 0) := (others => (0 ps, 0 ps));
     tpd_ACIN_MULTSIGNOUT : VitalDelayArrayType01 (29 downto 0) := (others => (0 ps, 0 ps));
     tpd_ACIN_OVERFLOW : VitalDelayArrayType01 (29 downto 0) := (others => (0 ps, 0 ps));
     tpd_ACIN_P : VitalDelayArrayType01 (1439 downto 0) := (others => (0 ps, 0 ps));
     tpd_ACIN_PATTERNBDETECT : VitalDelayArrayType01 (29 downto 0) := (others => (0 ps, 0 ps));
     tpd_ACIN_PATTERNDETECT : VitalDelayArrayType01 (29 downto 0) := (others => (0 ps, 0 ps));
     tpd_ACIN_PCOUT : VitalDelayArrayType01 (1439 downto 0) := (others => (0 ps, 0 ps));
     tpd_ACIN_UNDERFLOW : VitalDelayArrayType01 (29 downto 0) := (others => (0 ps, 0 ps));
     tpd_ALUMODE_ACOUT : VitalDelayArrayType01 (119 downto 0) := (others => (0 ps, 0 ps));
     tpd_ALUMODE_CARRYCASCOUT : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tpd_ALUMODE_CARRYOUT : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
     tpd_ALUMODE_MULTSIGNOUT : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tpd_ALUMODE_OVERFLOW : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tpd_ALUMODE_P : VitalDelayArrayType01 (191 downto 0) := (others => (0 ps, 0 ps));
     tpd_ALUMODE_PATTERNBDETECT : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tpd_ALUMODE_PATTERNDETECT : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tpd_ALUMODE_PCOUT : VitalDelayArrayType01 (191 downto 0) := (others => (0 ps, 0 ps));
     tpd_ALUMODE_UNDERFLOW : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tpd_A_ACOUT : VitalDelayArrayType01 (899 downto 0) := (others => (0 ps, 0 ps));
     tpd_A_CARRYCASCOUT : VitalDelayArrayType01 (29 downto 0) := (others => (0 ps, 0 ps));
     tpd_A_CARRYOUT : VitalDelayArrayType01 (119 downto 0) := (others => (0 ps, 0 ps));
     tpd_A_MULTSIGNOUT : VitalDelayArrayType01 (29 downto 0) := (others => (0 ps, 0 ps));
     tpd_A_OVERFLOW : VitalDelayArrayType01 (29 downto 0) := (others => (0 ps, 0 ps));
     tpd_A_P : VitalDelayArrayType01 (1439 downto 0) := (others => (0 ps, 0 ps));
     tpd_A_PATTERNBDETECT : VitalDelayArrayType01 (29 downto 0) := (others => (0 ps, 0 ps));
     tpd_A_PATTERNDETECT : VitalDelayArrayType01 (29 downto 0) := (others => (0 ps, 0 ps));
     tpd_A_PCOUT : VitalDelayArrayType01 (1439 downto 0) := (others => (0 ps, 0 ps));
     tpd_A_UNDERFLOW : VitalDelayArrayType01 (29 downto 0) := (others => (0 ps, 0 ps));
     tpd_BCIN_BCOUT : VitalDelayArrayType01 (323 downto 0) := (others => (0 ps, 0 ps));
     tpd_BCIN_CARRYCASCOUT : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_BCIN_CARRYOUT : VitalDelayArrayType01 (71 downto 0) := (others => (0 ps, 0 ps));
     tpd_BCIN_MULTSIGNOUT : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_BCIN_OVERFLOW : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_BCIN_P : VitalDelayArrayType01 (863 downto 0) := (others => (0 ps, 0 ps));
     tpd_BCIN_PATTERNBDETECT : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_BCIN_PATTERNDETECT : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_BCIN_PCOUT : VitalDelayArrayType01 (863 downto 0) := (others => (0 ps, 0 ps));
     tpd_BCIN_UNDERFLOW : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_B_BCOUT : VitalDelayArrayType01 (323 downto 0) := (others => (0 ps, 0 ps));
     tpd_B_CARRYCASCOUT : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_B_CARRYOUT : VitalDelayArrayType01 (71 downto 0) := (others => (0 ps, 0 ps));
     tpd_B_MULTSIGNOUT : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_B_OVERFLOW : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_B_P : VitalDelayArrayType01 (863 downto 0) := (others => (0 ps, 0 ps));
     tpd_B_PATTERNBDETECT : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_B_PATTERNDETECT : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_B_PCOUT : VitalDelayArrayType01 (863 downto 0) := (others => (0 ps, 0 ps));
     tpd_B_UNDERFLOW : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYCASCIN_CARRYCASCOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CARRYCASCIN_CARRYOUT : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYCASCIN_MULTSIGNOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CARRYCASCIN_OVERFLOW : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CARRYCASCIN_P : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYCASCIN_PATTERNBDETECT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CARRYCASCIN_PATTERNDETECT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CARRYCASCIN_PCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYCASCIN_UNDERFLOW : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CARRYINSEL_CARRYCASCOUT : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYINSEL_CARRYOUT : VitalDelayArrayType01 (11 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYINSEL_MULTSIGNOUT : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYINSEL_OVERFLOW : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYINSEL_P : VitalDelayArrayType01 (143 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYINSEL_PATTERNBDETECT : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYINSEL_PATTERNDETECT : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYINSEL_PCOUT : VitalDelayArrayType01 (143 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYINSEL_UNDERFLOW : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYIN_CARRYCASCOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CARRYIN_CARRYOUT : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYIN_MULTSIGNOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CARRYIN_OVERFLOW : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CARRYIN_P : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYIN_PATTERNBDETECT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CARRYIN_PATTERNDETECT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CARRYIN_PCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_CARRYIN_UNDERFLOW : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CLK_ACOUT : VitalDelayArrayType01 (29 downto 0) := (others => (100 ps, 100 ps));
     tpd_CLK_BCOUT : VitalDelayArrayType01 (17 downto 0) := (others => (100 ps, 100 ps));
     tpd_CLK_CARRYCASCOUT : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK_CARRYOUT : VitalDelayArrayType01 (3 downto 0) := (others => (100 ps, 100 ps));
     tpd_CLK_MULTSIGNOUT : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK_OVERFLOW : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK_P : VitalDelayArrayType01 (47 downto 0) := (others => (100 ps, 100 ps));
     tpd_CLK_PATTERNBDETECT : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK_PATTERNDETECT : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK_PCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (100 ps, 100 ps));
     tpd_CLK_UNDERFLOW : VitalDelayType01 := (100 ps, 100 ps);
     tpd_C_CARRYCASCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_C_CARRYOUT : VitalDelayArrayType01 (191 downto 0) := (others => (0 ps, 0 ps));
     tpd_C_MULTSIGNOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_C_OVERFLOW : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_C_P : VitalDelayArrayType01 (2303 downto 0) := (others => (0 ps, 0 ps));
     tpd_C_PATTERNBDETECT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_C_PATTERNDETECT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_C_PCOUT : VitalDelayArrayType01 (2303 downto 0) := (others => (0 ps, 0 ps));
     tpd_C_UNDERFLOW : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_D_CARRYCASCOUT : VitalDelayArrayType01 (24 downto 0) := (others => (0 ps, 0 ps));
     tpd_D_CARRYOUT : VitalDelayArrayType01 (99 downto 0) := (others => (0 ps, 0 ps));
     tpd_D_MULTSIGNOUT : VitalDelayArrayType01 (24 downto 0) := (others => (0 ps, 0 ps));
     tpd_D_OVERFLOW : VitalDelayArrayType01 (24 downto 0) := (others => (0 ps, 0 ps));
     tpd_D_P : VitalDelayArrayType01 (1199 downto 0) := (others => (0 ps, 0 ps));
     tpd_D_PATTERNBDETECT : VitalDelayArrayType01 (24 downto 0) := (others => (0 ps, 0 ps));
     tpd_D_PATTERNDETECT : VitalDelayArrayType01 (24 downto 0) := (others => (0 ps, 0 ps));
     tpd_D_PCOUT : VitalDelayArrayType01 (1199 downto 0) := (others => (0 ps, 0 ps));
     tpd_D_UNDERFLOW : VitalDelayArrayType01 (24 downto 0) := (others => (0 ps, 0 ps));
     tpd_INMODE_CARRYCASCOUT : VitalDelayArrayType01 (4 downto 0) := (others => (0 ps, 0 ps));
     tpd_INMODE_CARRYOUT : VitalDelayArrayType01 (19 downto 0) := (others => (0 ps, 0 ps));
     tpd_INMODE_MULTSIGNOUT : VitalDelayArrayType01 (4 downto 0) := (others => (0 ps, 0 ps));
     tpd_INMODE_OVERFLOW : VitalDelayArrayType01 (4 downto 0) := (others => (0 ps, 0 ps));
     tpd_INMODE_P : VitalDelayArrayType01 (239 downto 0) := (others => (0 ps, 0 ps));
     tpd_INMODE_PATTERNBDETECT : VitalDelayArrayType01 (4 downto 0) := (others => (0 ps, 0 ps));
     tpd_INMODE_PATTERNDETECT : VitalDelayArrayType01 (4 downto 0) := (others => (0 ps, 0 ps));
     tpd_INMODE_PCOUT : VitalDelayArrayType01 (239 downto 0) := (others => (0 ps, 0 ps));
     tpd_INMODE_UNDERFLOW : VitalDelayArrayType01 (4 downto 0) := (others => (0 ps, 0 ps));
     tpd_MULTSIGNIN_CARRYCASCOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_MULTSIGNIN_CARRYOUT : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tpd_MULTSIGNIN_MULTSIGNOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_MULTSIGNIN_OVERFLOW : VitalDelayType01 := (0 ps, 0 ps);
     tpd_MULTSIGNIN_P : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_MULTSIGNIN_PATTERNBDETECT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_MULTSIGNIN_PATTERNDETECT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_MULTSIGNIN_PCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_MULTSIGNIN_UNDERFLOW : VitalDelayType01 := (0 ps, 0 ps);
     tpd_OPMODE_CARRYCASCOUT : VitalDelayArrayType01 (6 downto 0) := (others => (0 ps, 0 ps));
     tpd_OPMODE_CARRYOUT : VitalDelayArrayType01 (27 downto 0) := (others => (0 ps, 0 ps));
     tpd_OPMODE_MULTSIGNOUT : VitalDelayArrayType01 (6 downto 0) := (others => (0 ps, 0 ps));
     tpd_OPMODE_OVERFLOW : VitalDelayArrayType01 (6 downto 0) := (others => (0 ps, 0 ps));
     tpd_OPMODE_P : VitalDelayArrayType01 (335 downto 0) := (others => (0 ps, 0 ps));
     tpd_OPMODE_PATTERNBDETECT : VitalDelayArrayType01 (6 downto 0) := (others => (0 ps, 0 ps));
     tpd_OPMODE_PATTERNDETECT : VitalDelayArrayType01 (6 downto 0) := (others => (0 ps, 0 ps));
     tpd_OPMODE_PCOUT : VitalDelayArrayType01 (335 downto 0) := (others => (0 ps, 0 ps));
     tpd_OPMODE_UNDERFLOW : VitalDelayArrayType01 (6 downto 0) := (others => (0 ps, 0 ps));
     tpd_PCIN_CARRYCASCOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_PCIN_CARRYOUT : VitalDelayArrayType01 (191 downto 0) := (others => (0 ps, 0 ps));
     tpd_PCIN_MULTSIGNOUT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_PCIN_OVERFLOW : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_PCIN_P : VitalDelayArrayType01 (2303 downto 0) := (others => (0 ps, 0 ps));
     tpd_PCIN_PATTERNBDETECT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_PCIN_PATTERNDETECT : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tpd_PCIN_PCOUT : VitalDelayArrayType01 (2303 downto 0) := (others => (0 ps, 0 ps));
     tpd_PCIN_UNDERFLOW : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tperiod_CLK_posedge : VitalDelayType := 0 ps;
     tpw_CLK_negedge : VitalDelayType := 0 ps;
     tpw_CLK_posedge : VitalDelayType := 0 ps;
     tsetup_ACIN_CLK_negedge_posedge : VitalDelayArrayType(29 downto 0) := (others => 0 ps);
     tsetup_ACIN_CLK_posedge_posedge : VitalDelayArrayType(29 downto 0) := (others => 0 ps);
     tsetup_ALUMODE_CLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_ALUMODE_CLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_A_CLK_negedge_posedge : VitalDelayArrayType(29 downto 0) := (others => 0 ps);
     tsetup_A_CLK_posedge_posedge : VitalDelayArrayType(29 downto 0) := (others => 0 ps);
     tsetup_BCIN_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_BCIN_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_B_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_B_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_CARRYCASCIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CARRYCASCIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CARRYINSEL_CLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_CARRYINSEL_CLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_CARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEA1_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEA1_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEA2_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEA2_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEAD_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEAD_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEALUMODE_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEALUMODE_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEB1_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEB1_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEB2_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEB2_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CECARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CECARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CECTRL_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CECTRL_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEC_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEC_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CED_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CED_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEINMODE_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEINMODE_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEM_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEM_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEP_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEP_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_C_CLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tsetup_C_CLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tsetup_D_CLK_negedge_posedge : VitalDelayArrayType(24 downto 0) := (others => 0 ps);
     tsetup_D_CLK_posedge_posedge : VitalDelayArrayType(24 downto 0) := (others => 0 ps);
     tsetup_INMODE_CLK_negedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tsetup_INMODE_CLK_posedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tsetup_MULTSIGNIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_MULTSIGNIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_OPMODE_CLK_negedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     tsetup_OPMODE_CLK_posedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     tsetup_PCIN_CLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tsetup_PCIN_CLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tsetup_RSTALLCARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTALLCARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTALUMODE_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTALUMODE_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTA_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTA_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTB_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTB_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTCTRL_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTCTRL_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTC_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTC_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTD_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTD_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTINMODE_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTINMODE_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTM_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTM_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTP_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTP_CLK_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     ACOUT : out std_logic_vector(29 downto 0);
     BCOUT : out std_logic_vector(17 downto 0);
     CARRYCASCOUT : out std_ulogic;
     CARRYOUT : out std_logic_vector(3 downto 0);
     MULTSIGNOUT : out std_ulogic;
     OVERFLOW : out std_ulogic;
     P : out std_logic_vector(47 downto 0);
     PATTERNBDETECT : out std_ulogic;
     PATTERNDETECT : out std_ulogic;
     PCOUT : out std_logic_vector(47 downto 0);
     UNDERFLOW : out std_ulogic;
     A : in std_logic_vector(29 downto 0);
     ACIN : in std_logic_vector(29 downto 0);
     ALUMODE : in std_logic_vector(3 downto 0);
     B : in std_logic_vector(17 downto 0);
     BCIN : in std_logic_vector(17 downto 0);
     C : in std_logic_vector(47 downto 0);
     CARRYCASCIN : in std_ulogic;
     CARRYIN : in std_ulogic;
     CARRYINSEL : in std_logic_vector(2 downto 0);
     CEA1 : in std_ulogic;
     CEA2 : in std_ulogic;
     CEAD : in std_ulogic;
     CEALUMODE : in std_ulogic;
     CEB1 : in std_ulogic;
     CEB2 : in std_ulogic;
     CEC : in std_ulogic;
     CECARRYIN : in std_ulogic;
     CECTRL : in std_ulogic;
     CED : in std_ulogic;
     CEINMODE : in std_ulogic;
     CEM : in std_ulogic;
     CEP : in std_ulogic;
     CLK : in std_ulogic;
     D : in std_logic_vector(24 downto 0);
     INMODE : in std_logic_vector(4 downto 0);
     MULTSIGNIN : in std_ulogic;
     OPMODE : in std_logic_vector(6 downto 0);
     PCIN : in std_logic_vector(47 downto 0);
     RSTA : in std_ulogic;
     RSTALLCARRYIN : in std_ulogic;
     RSTALUMODE : in std_ulogic;
     RSTB : in std_ulogic;
     RSTC : in std_ulogic;
     RSTCTRL : in std_ulogic;
     RSTD : in std_ulogic;
     RSTINMODE : in std_ulogic;
     RSTM : in std_ulogic;
     RSTP : in std_ulogic
  );
end component;

----- component X_EFUSE_USR -----
component X_EFUSE_USR
  generic (
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := FALSE;
     SIM_EFUSE_VALUE : bit_vector := X"00000000";
     TimingChecksOn : boolean := TRUE;
     Xon : boolean := TRUE
  );
  port (
     EFUSEUSR : out std_logic_vector(31 downto 0)
  );
end component;

----- component X_EMAC -----
component X_EMAC
  generic (
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := FALSE;
     TimingChecksOn : boolean := TRUE;
     Xon : boolean := TRUE;
     thold_CLIENTEMAC0DCMLOCKED_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_CLIENTEMAC0DCMLOCKED_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_CLIENTEMAC0PAUSEREQ_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_CLIENTEMAC0PAUSEREQ_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0.0 ns);
     thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0.0 ns);
     thold_CLIENTEMAC0TXDVLDMSW_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_CLIENTEMAC0TXDVLDMSW_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_CLIENTEMAC0TXDVLD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_CLIENTEMAC0TXDVLD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0.0 ns);
     thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0.0 ns);
     thold_CLIENTEMAC0TXFIRSTBYTE_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_CLIENTEMAC0TXFIRSTBYTE_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     thold_CLIENTEMAC0TXUNDERRUN_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_CLIENTEMAC0TXUNDERRUN_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_CLIENTEMAC1DCMLOCKED_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_CLIENTEMAC1DCMLOCKED_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_CLIENTEMAC1PAUSEREQ_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_CLIENTEMAC1PAUSEREQ_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0.0 ns);
     thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0.0 ns);
     thold_CLIENTEMAC1TXDVLDMSW_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_CLIENTEMAC1TXDVLDMSW_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_CLIENTEMAC1TXDVLD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_CLIENTEMAC1TXDVLD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0.0 ns);
     thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0.0 ns);
     thold_CLIENTEMAC1TXFIRSTBYTE_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_CLIENTEMAC1TXFIRSTBYTE_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     thold_CLIENTEMAC1TXUNDERRUN_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_CLIENTEMAC1TXUNDERRUN_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_HOSTADDR_HOSTCLK_negedge_posedge : VitalDelayArrayType(9 downto 0) := (others => 0.0 ns);
     thold_HOSTADDR_HOSTCLK_posedge_posedge : VitalDelayArrayType(9 downto 0) := (others => 0.0 ns);
     thold_HOSTEMAC1SEL_HOSTCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_HOSTEMAC1SEL_HOSTCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_HOSTMIIMSEL_HOSTCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_HOSTMIIMSEL_HOSTCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_HOSTOPCODE_HOSTCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0.0 ns);
     thold_HOSTOPCODE_HOSTCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0.0 ns);
     thold_HOSTREQ_HOSTCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_HOSTREQ_HOSTCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_HOSTWRDATA_HOSTCLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0.0 ns);
     thold_HOSTWRDATA_HOSTCLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0.0 ns);
     thold_PHYEMAC0COL_PHYEMAC0RXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC0COL_PHYEMAC0RXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC0CRS_PHYEMAC0RXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC0CRS_PHYEMAC0RXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC0MDIN_HOSTCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC0MDIN_HOSTCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC0MDIN_PHYEMAC0MCLKIN_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC0MDIN_PHYEMAC0MCLKIN_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC0RXBUFERR_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC0RXBUFERR_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC0RXBUFSTATUS_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0.0 ns);
     thold_PHYEMAC0RXBUFSTATUS_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0.0 ns);
     thold_PHYEMAC0RXCHARISCOMMA_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC0RXCHARISCOMMA_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC0RXCHARISK_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC0RXCHARISK_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC0RXCHECKINGCRC_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC0RXCHECKINGCRC_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC0RXCLKCORCNT_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0.0 ns);
     thold_PHYEMAC0RXCLKCORCNT_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0.0 ns);
     thold_PHYEMAC0RXCOMMADET_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC0RXCOMMADET_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC0RXDISPERR_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC0RXDISPERR_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC0RXDV_PHYEMAC0RXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC0RXDV_PHYEMAC0RXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     thold_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     thold_PHYEMAC0RXER_PHYEMAC0RXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC0RXER_PHYEMAC0RXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0.0 ns);
     thold_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0.0 ns);
     thold_PHYEMAC0RXNOTINTABLE_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC0RXNOTINTABLE_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC0RXRUNDISP_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC0RXRUNDISP_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC0TXBUFERR_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC0TXBUFERR_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC1COL_PHYEMAC1RXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC1COL_PHYEMAC1RXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC1CRS_PHYEMAC1RXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC1CRS_PHYEMAC1RXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC1MDIN_HOSTCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC1MDIN_HOSTCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC1MDIN_PHYEMAC1MCLKIN_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC1MDIN_PHYEMAC1MCLKIN_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC1RXBUFERR_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC1RXBUFERR_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC1RXBUFSTATUS_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0.0 ns);
     thold_PHYEMAC1RXBUFSTATUS_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0.0 ns);
     thold_PHYEMAC1RXCHARISCOMMA_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC1RXCHARISCOMMA_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC1RXCHARISK_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC1RXCHARISK_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC1RXCHECKINGCRC_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC1RXCHECKINGCRC_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC1RXCLKCORCNT_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0.0 ns);
     thold_PHYEMAC1RXCLKCORCNT_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0.0 ns);
     thold_PHYEMAC1RXCOMMADET_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC1RXCOMMADET_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC1RXDISPERR_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC1RXDISPERR_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC1RXDV_PHYEMAC1RXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC1RXDV_PHYEMAC1RXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     thold_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     thold_PHYEMAC1RXER_PHYEMAC1RXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC1RXER_PHYEMAC1RXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0.0 ns);
     thold_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0.0 ns);
     thold_PHYEMAC1RXNOTINTABLE_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC1RXNOTINTABLE_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC1RXRUNDISP_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC1RXRUNDISP_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC1TXBUFERR_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_PHYEMAC1TXBUFERR_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_TIEEMAC0CONFIGVEC_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayArrayType(79 downto 0) := (others => 0.0 ns);
     thold_TIEEMAC0CONFIGVEC_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayArrayType(79 downto 0) := (others => 0.0 ns);
     thold_TIEEMAC1CONFIGVEC_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayArrayType(79 downto 0) := (others => 0.0 ns);
     thold_TIEEMAC1CONFIGVEC_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayArrayType(79 downto 0) := (others => 0.0 ns);
     ticd_CLIENTEMAC0TXCLIENTCLKIN : VitalDelayType := 0.000 ns;
     ticd_CLIENTEMAC1TXCLIENTCLKIN : VitalDelayType := 0.000 ns;
     ticd_HOSTCLK : VitalDelayType := 0.000 ns;
     ticd_PHYEMAC0GTXCLK : VitalDelayType := 0.000 ns;
     ticd_PHYEMAC0MCLKIN : VitalDelayType := 0.000 ns;
     ticd_PHYEMAC0RXCLK : VitalDelayType := 0.000 ns;
     ticd_PHYEMAC1GTXCLK : VitalDelayType := 0.000 ns;
     ticd_PHYEMAC1MCLKIN : VitalDelayType := 0.000 ns;
     ticd_PHYEMAC1RXCLK : VitalDelayType := 0.000 ns;
     tipd_CLIENTEMAC0DCMLOCKED : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_CLIENTEMAC0PAUSEREQ : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_CLIENTEMAC0PAUSEVAL : VitalDelayArrayType01 (15 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_CLIENTEMAC0RXCLIENTCLKIN : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_CLIENTEMAC0TXCLIENTCLKIN : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_CLIENTEMAC0TXD : VitalDelayArrayType01 (15 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_CLIENTEMAC0TXDVLD : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_CLIENTEMAC0TXDVLDMSW : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_CLIENTEMAC0TXFIRSTBYTE : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_CLIENTEMAC0TXGMIIMIICLKIN : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_CLIENTEMAC0TXIFGDELAY : VitalDelayArrayType01 (7 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_CLIENTEMAC0TXUNDERRUN : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_CLIENTEMAC1DCMLOCKED : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_CLIENTEMAC1PAUSEREQ : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_CLIENTEMAC1PAUSEVAL : VitalDelayArrayType01 (15 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_CLIENTEMAC1RXCLIENTCLKIN : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_CLIENTEMAC1TXCLIENTCLKIN : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_CLIENTEMAC1TXD : VitalDelayArrayType01 (15 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_CLIENTEMAC1TXDVLD : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_CLIENTEMAC1TXDVLDMSW : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_CLIENTEMAC1TXFIRSTBYTE : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_CLIENTEMAC1TXGMIIMIICLKIN : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_CLIENTEMAC1TXIFGDELAY : VitalDelayArrayType01 (7 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_CLIENTEMAC1TXUNDERRUN : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_DCREMACABUS : VitalDelayArrayType01 (8 to 9) := (others => (0.0 ns, 0.0 ns));
     tipd_DCREMACCLK : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_DCREMACDBUS : VitalDelayArrayType01 (0 to 31) := (others => (0.0 ns, 0.0 ns));
     tipd_DCREMACENABLE : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_DCREMACREAD : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_DCREMACWRITE : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_GSR : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_HOSTADDR : VitalDelayArrayType01 (9 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_HOSTCLK : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_HOSTEMAC1SEL : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_HOSTMIIMSEL : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_HOSTOPCODE : VitalDelayArrayType01 (1 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_HOSTREQ : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_HOSTWRDATA : VitalDelayArrayType01 (31 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_PHYEMAC0COL : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC0CRS : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC0GTXCLK : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC0MCLKIN : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC0MDIN : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC0MIITXCLK : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC0PHYAD : VitalDelayArrayType01 (4 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_PHYEMAC0RXBUFERR : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC0RXBUFSTATUS : VitalDelayArrayType01 (1 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_PHYEMAC0RXCHARISCOMMA : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC0RXCHARISK : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC0RXCHECKINGCRC : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC0RXCLK : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC0RXCLKCORCNT : VitalDelayArrayType01 (2 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_PHYEMAC0RXCOMMADET : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC0RXD : VitalDelayArrayType01 (7 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_PHYEMAC0RXDISPERR : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC0RXDV : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC0RXER : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC0RXLOSSOFSYNC : VitalDelayArrayType01 (1 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_PHYEMAC0RXNOTINTABLE : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC0RXRUNDISP : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC0SIGNALDET : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC0TXBUFERR : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC1COL : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC1CRS : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC1GTXCLK : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC1MCLKIN : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC1MDIN : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC1MIITXCLK : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC1PHYAD : VitalDelayArrayType01 (4 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_PHYEMAC1RXBUFERR : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC1RXBUFSTATUS : VitalDelayArrayType01 (1 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_PHYEMAC1RXCHARISCOMMA : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC1RXCHARISK : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC1RXCHECKINGCRC : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC1RXCLK : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC1RXCLKCORCNT : VitalDelayArrayType01 (2 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_PHYEMAC1RXCOMMADET : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC1RXD : VitalDelayArrayType01 (7 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_PHYEMAC1RXDISPERR : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC1RXDV : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC1RXER : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC1RXLOSSOFSYNC : VitalDelayArrayType01 (1 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_PHYEMAC1RXNOTINTABLE : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC1RXRUNDISP : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC1SIGNALDET : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_PHYEMAC1TXBUFERR : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_RESET : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_TIEEMAC0CONFIGVEC : VitalDelayArrayType01 (79 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_TIEEMAC0UNICASTADDR : VitalDelayArrayType01 (47 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_TIEEMAC1CONFIGVEC : VitalDelayArrayType01 (79 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_TIEEMAC1UNICASTADDR : VitalDelayArrayType01 (47 downto 0) := (others => (0.0 ns, 0.0 ns));
     tisd_CLIENTEMAC0DCMLOCKED : VitalDelayType := 0.000 ns;
     tisd_CLIENTEMAC0PAUSEREQ : VitalDelayType := 0.000 ns;
     tisd_CLIENTEMAC0PAUSEVAL : VitalDelayArrayType(15 downto 0) := (others => 0.000 ns);
     tisd_CLIENTEMAC0TXD : VitalDelayArrayType(15 downto 0) := (others => 0.000 ns);
     tisd_CLIENTEMAC0TXDVLD : VitalDelayType := 0.000 ns;
     tisd_CLIENTEMAC0TXDVLDMSW : VitalDelayType := 0.000 ns;
     tisd_CLIENTEMAC0TXFIRSTBYTE : VitalDelayType := 0.000 ns;
     tisd_CLIENTEMAC0TXIFGDELAY : VitalDelayArrayType(7 downto 0) := (others => 0.000 ns);
     tisd_CLIENTEMAC0TXUNDERRUN : VitalDelayType := 0.000 ns;
     tisd_CLIENTEMAC1DCMLOCKED : VitalDelayType := 0.000 ns;
     tisd_CLIENTEMAC1PAUSEREQ : VitalDelayType := 0.000 ns;
     tisd_CLIENTEMAC1PAUSEVAL : VitalDelayArrayType(15 downto 0) := (others => 0.000 ns);
     tisd_CLIENTEMAC1TXD : VitalDelayArrayType(15 downto 0) := (others => 0.000 ns);
     tisd_CLIENTEMAC1TXDVLD : VitalDelayType := 0.000 ns;
     tisd_CLIENTEMAC1TXDVLDMSW : VitalDelayType := 0.000 ns;
     tisd_CLIENTEMAC1TXFIRSTBYTE : VitalDelayType := 0.000 ns;
     tisd_CLIENTEMAC1TXIFGDELAY : VitalDelayArrayType(7 downto 0) := (others => 0.000 ns);
     tisd_CLIENTEMAC1TXUNDERRUN : VitalDelayType := 0.000 ns;
     tisd_HOSTADDR : VitalDelayArrayType(9 downto 0) := (others => 0.000 ns);
     tisd_HOSTEMAC1SEL : VitalDelayType := 0.000 ns;
     tisd_HOSTMIIMSEL : VitalDelayType := 0.000 ns;
     tisd_HOSTOPCODE : VitalDelayArrayType(1 downto 0) := (others => 0.000 ns);
     tisd_HOSTREQ : VitalDelayType := 0.000 ns;
     tisd_HOSTWRDATA : VitalDelayArrayType(31 downto 0) := (others => 0.000 ns);
     tisd_PHYEMAC0COL : VitalDelayType := 0.000 ns;
     tisd_PHYEMAC0CRS : VitalDelayType := 0.000 ns;
     tisd_PHYEMAC0MDIN : VitalDelayType := 0.000 ns;
     tisd_PHYEMAC0RXBUFERR : VitalDelayType := 0.000 ns;
     tisd_PHYEMAC0RXBUFSTATUS : VitalDelayArrayType(1 downto 0) := (others => 0.000 ns);
     tisd_PHYEMAC0RXCHARISCOMMA : VitalDelayType := 0.000 ns;
     tisd_PHYEMAC0RXCHARISK : VitalDelayType := 0.000 ns;
     tisd_PHYEMAC0RXCHECKINGCRC : VitalDelayType := 0.000 ns;
     tisd_PHYEMAC0RXCLKCORCNT : VitalDelayArrayType(2 downto 0) := (others => 0.000 ns);
     tisd_PHYEMAC0RXCOMMADET : VitalDelayType := 0.000 ns;
     tisd_PHYEMAC0RXD : VitalDelayArrayType(7 downto 0) := (others => 0.000 ns);
     tisd_PHYEMAC0RXDISPERR : VitalDelayType := 0.000 ns;
     tisd_PHYEMAC0RXDV : VitalDelayType := 0.000 ns;
     tisd_PHYEMAC0RXER : VitalDelayType := 0.000 ns;
     tisd_PHYEMAC0RXLOSSOFSYNC : VitalDelayArrayType(1 downto 0) := (others => 0.000 ns);
     tisd_PHYEMAC0RXNOTINTABLE : VitalDelayType := 0.000 ns;
     tisd_PHYEMAC0RXRUNDISP : VitalDelayType := 0.000 ns;
     tisd_PHYEMAC0TXBUFERR : VitalDelayType := 0.000 ns;
     tisd_PHYEMAC1COL : VitalDelayType := 0.000 ns;
     tisd_PHYEMAC1CRS : VitalDelayType := 0.000 ns;
     tisd_PHYEMAC1MDIN : VitalDelayType := 0.000 ns;
     tisd_PHYEMAC1RXBUFERR : VitalDelayType := 0.000 ns;
     tisd_PHYEMAC1RXBUFSTATUS : VitalDelayArrayType(1 downto 0) := (others => 0.000 ns);
     tisd_PHYEMAC1RXCHARISCOMMA : VitalDelayType := 0.000 ns;
     tisd_PHYEMAC1RXCHARISK : VitalDelayType := 0.000 ns;
     tisd_PHYEMAC1RXCHECKINGCRC : VitalDelayType := 0.000 ns;
     tisd_PHYEMAC1RXCLKCORCNT : VitalDelayArrayType(2 downto 0) := (others => 0.000 ns);
     tisd_PHYEMAC1RXCOMMADET : VitalDelayType := 0.000 ns;
     tisd_PHYEMAC1RXD : VitalDelayArrayType(7 downto 0) := (others => 0.000 ns);
     tisd_PHYEMAC1RXDISPERR : VitalDelayType := 0.000 ns;
     tisd_PHYEMAC1RXDV : VitalDelayType := 0.000 ns;
     tisd_PHYEMAC1RXER : VitalDelayType := 0.000 ns;
     tisd_PHYEMAC1RXLOSSOFSYNC : VitalDelayArrayType(1 downto 0) := (others => 0.000 ns);
     tisd_PHYEMAC1RXNOTINTABLE : VitalDelayType := 0.000 ns;
     tisd_PHYEMAC1RXRUNDISP : VitalDelayType := 0.000 ns;
     tisd_PHYEMAC1TXBUFERR : VitalDelayType := 0.000 ns;
     tisd_TIEEMAC0CONFIGVEC : VitalDelayArrayType(79 downto 0) := (others => 0.000 ns);
     tisd_TIEEMAC1CONFIGVEC : VitalDelayArrayType(79 downto 0) := (others => 0.000 ns);
     tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXBADFRAME : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXD : VitalDelayArrayType01(15 downto 0) := (others => (0.1 ns, 0.1 ns));
     tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXDVLD : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXDVLDMSW : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXDVREG6 : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXFRAMEDROP : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXGOODFRAME : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXSTATS : VitalDelayArrayType01(6 downto 0) := (others => (0.1 ns, 0.1 ns));
     tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXSTATSBYTEVLD : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXSTATSVLD : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_CLIENTEMAC0TXCLIENTCLKIN_EMAC0CLIENTTXACK : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_CLIENTEMAC0TXCLIENTCLKIN_EMAC0CLIENTTXCOLLISION : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_CLIENTEMAC0TXCLIENTCLKIN_EMAC0CLIENTTXRETRANSMIT : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_CLIENTEMAC0TXCLIENTCLKIN_EMAC0CLIENTTXSTATS : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_CLIENTEMAC0TXCLIENTCLKIN_EMAC0CLIENTTXSTATSBYTEVLD : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_CLIENTEMAC0TXCLIENTCLKIN_EMAC0CLIENTTXSTATSVLD : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_CLIENTEMAC0TXGMIIMIICLKIN_EMAC0PHYTXD : VitalDelayArrayType01(7 downto 0) := (others => (0.1 ns, 0.1 ns));
     tpd_CLIENTEMAC0TXGMIIMIICLKIN_EMAC0PHYTXEN : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_CLIENTEMAC0TXGMIIMIICLKIN_EMAC0PHYTXER : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXBADFRAME : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXD : VitalDelayArrayType01(15 downto 0) := (others => (0.1 ns, 0.1 ns));
     tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXDVLD : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXDVLDMSW : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXDVREG6 : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXFRAMEDROP : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXGOODFRAME : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXSTATS : VitalDelayArrayType01(6 downto 0) := (others => (0.1 ns, 0.1 ns));
     tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXSTATSBYTEVLD : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXSTATSVLD : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_CLIENTEMAC1TXCLIENTCLKIN_EMAC1CLIENTTXACK : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_CLIENTEMAC1TXCLIENTCLKIN_EMAC1CLIENTTXCOLLISION : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_CLIENTEMAC1TXCLIENTCLKIN_EMAC1CLIENTTXRETRANSMIT : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_CLIENTEMAC1TXCLIENTCLKIN_EMAC1CLIENTTXSTATS : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_CLIENTEMAC1TXCLIENTCLKIN_EMAC1CLIENTTXSTATSBYTEVLD : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_CLIENTEMAC1TXCLIENTCLKIN_EMAC1CLIENTTXSTATSVLD : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_CLIENTEMAC1TXGMIIMIICLKIN_EMAC1PHYTXD : VitalDelayArrayType01(7 downto 0) := (others => (0.1 ns, 0.1 ns));
     tpd_CLIENTEMAC1TXGMIIMIICLKIN_EMAC1PHYTXEN : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_CLIENTEMAC1TXGMIIMIICLKIN_EMAC1PHYTXER : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_HOSTCLK_EMAC0PHYMCLKOUT : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_HOSTCLK_EMAC0PHYMDOUT : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_HOSTCLK_EMAC0PHYMDTRI : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_HOSTCLK_EMAC1PHYMCLKOUT : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_HOSTCLK_EMAC1PHYMDOUT : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_HOSTCLK_EMAC1PHYMDTRI : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_HOSTCLK_HOSTMIIMRDY : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_HOSTCLK_HOSTRDDATA : VitalDelayArrayType01(31 downto 0) := (others => (0.1 ns, 0.1 ns));
     tpd_PHYEMAC0GTXCLK_EMAC0CLIENTANINTERRUPT : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC0GTXCLK_EMAC0CLIENTRXCLIENTCLKOUT : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC0GTXCLK_EMAC0CLIENTTXCLIENTCLKOUT : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC0GTXCLK_EMAC0CLIENTTXGMIIMIICLKOUT : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC0GTXCLK_EMAC0PHYENCOMMAALIGN : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC0GTXCLK_EMAC0PHYLOOPBACKMSB : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC0GTXCLK_EMAC0PHYMGTRXRESET : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC0GTXCLK_EMAC0PHYMGTTXRESET : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC0GTXCLK_EMAC0PHYPOWERDOWN : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC0GTXCLK_EMAC0PHYSYNCACQSTATUS : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC0GTXCLK_EMAC0PHYTXCHARDISPMODE : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC0GTXCLK_EMAC0PHYTXCHARDISPVAL : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC0GTXCLK_EMAC0PHYTXCHARISK : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC0GTXCLK_EMAC0PHYTXCLK : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC0MCLKIN_EMAC0PHYMCLKOUT : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC0MCLKIN_EMAC0PHYMDOUT : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC0MCLKIN_EMAC0PHYMDTRI : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC0MIITXCLK_EMAC0CLIENTTXCLIENTCLKOUT : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC0MIITXCLK_EMAC0CLIENTTXGMIIMIICLKOUT : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXCLIENTCLKOUT : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC1GTXCLK_EMAC1CLIENTANINTERRUPT : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC1GTXCLK_EMAC1CLIENTRXCLIENTCLKOUT : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC1GTXCLK_EMAC1CLIENTTXCLIENTCLKOUT : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC1GTXCLK_EMAC1CLIENTTXGMIIMIICLKOUT : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC1GTXCLK_EMAC1PHYENCOMMAALIGN : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC1GTXCLK_EMAC1PHYLOOPBACKMSB : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC1GTXCLK_EMAC1PHYMGTRXRESET : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC1GTXCLK_EMAC1PHYMGTTXRESET : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC1GTXCLK_EMAC1PHYPOWERDOWN : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC1GTXCLK_EMAC1PHYSYNCACQSTATUS : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC1GTXCLK_EMAC1PHYTXCHARDISPMODE : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC1GTXCLK_EMAC1PHYTXCHARDISPVAL : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC1GTXCLK_EMAC1PHYTXCHARISK : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC1GTXCLK_EMAC1PHYTXCLK : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC1MCLKIN_EMAC1PHYMCLKOUT : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC1MCLKIN_EMAC1PHYMDOUT : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC1MCLKIN_EMAC1PHYMDTRI : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC1MIITXCLK_EMAC1CLIENTTXCLIENTCLKOUT : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC1MIITXCLK_EMAC1CLIENTTXGMIIMIICLKOUT : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXCLIENTCLKOUT : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tsetup_CLIENTEMAC0DCMLOCKED_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_CLIENTEMAC0DCMLOCKED_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_CLIENTEMAC0PAUSEREQ_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_CLIENTEMAC0PAUSEREQ_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0.0 ns);
     tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0.0 ns);
     tsetup_CLIENTEMAC0TXDVLDMSW_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_CLIENTEMAC0TXDVLDMSW_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_CLIENTEMAC0TXDVLD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_CLIENTEMAC0TXDVLD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0.0 ns);
     tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0.0 ns);
     tsetup_CLIENTEMAC0TXFIRSTBYTE_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_CLIENTEMAC0TXFIRSTBYTE_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     tsetup_CLIENTEMAC0TXUNDERRUN_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_CLIENTEMAC0TXUNDERRUN_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_CLIENTEMAC1DCMLOCKED_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_CLIENTEMAC1DCMLOCKED_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_CLIENTEMAC1PAUSEREQ_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_CLIENTEMAC1PAUSEREQ_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0.0 ns);
     tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0.0 ns);
     tsetup_CLIENTEMAC1TXDVLDMSW_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_CLIENTEMAC1TXDVLDMSW_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_CLIENTEMAC1TXDVLD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_CLIENTEMAC1TXDVLD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0.0 ns);
     tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0.0 ns);
     tsetup_CLIENTEMAC1TXFIRSTBYTE_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_CLIENTEMAC1TXFIRSTBYTE_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     tsetup_CLIENTEMAC1TXUNDERRUN_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_CLIENTEMAC1TXUNDERRUN_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_HOSTADDR_HOSTCLK_negedge_posedge : VitalDelayArrayType(9 downto 0) := (others => 0.0 ns);
     tsetup_HOSTADDR_HOSTCLK_posedge_posedge : VitalDelayArrayType(9 downto 0) := (others => 0.0 ns);
     tsetup_HOSTEMAC1SEL_HOSTCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_HOSTEMAC1SEL_HOSTCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_HOSTMIIMSEL_HOSTCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_HOSTMIIMSEL_HOSTCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_HOSTOPCODE_HOSTCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0.0 ns);
     tsetup_HOSTOPCODE_HOSTCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0.0 ns);
     tsetup_HOSTREQ_HOSTCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_HOSTREQ_HOSTCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_HOSTWRDATA_HOSTCLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0.0 ns);
     tsetup_HOSTWRDATA_HOSTCLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0.0 ns);
     tsetup_PHYEMAC0COL_PHYEMAC0RXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC0COL_PHYEMAC0RXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC0CRS_PHYEMAC0RXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC0CRS_PHYEMAC0RXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC0MDIN_HOSTCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC0MDIN_HOSTCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC0MDIN_PHYEMAC0MCLKIN_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC0MDIN_PHYEMAC0MCLKIN_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC0RXBUFERR_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC0RXBUFERR_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC0RXBUFSTATUS_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0.0 ns);
     tsetup_PHYEMAC0RXBUFSTATUS_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0.0 ns);
     tsetup_PHYEMAC0RXCHARISCOMMA_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC0RXCHARISCOMMA_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC0RXCHARISK_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC0RXCHARISK_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC0RXCHECKINGCRC_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC0RXCHECKINGCRC_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC0RXCLKCORCNT_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0.0 ns);
     tsetup_PHYEMAC0RXCLKCORCNT_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0.0 ns);
     tsetup_PHYEMAC0RXCOMMADET_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC0RXCOMMADET_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC0RXDISPERR_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC0RXDISPERR_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC0RXDV_PHYEMAC0RXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC0RXDV_PHYEMAC0RXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     tsetup_PHYEMAC0RXER_PHYEMAC0RXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC0RXER_PHYEMAC0RXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0.0 ns);
     tsetup_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0.0 ns);
     tsetup_PHYEMAC0RXNOTINTABLE_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC0RXNOTINTABLE_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC0RXRUNDISP_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC0RXRUNDISP_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC0TXBUFERR_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC0TXBUFERR_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC1COL_PHYEMAC1RXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC1COL_PHYEMAC1RXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC1CRS_PHYEMAC1RXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC1CRS_PHYEMAC1RXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC1MDIN_HOSTCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC1MDIN_HOSTCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC1MDIN_PHYEMAC1MCLKIN_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC1MDIN_PHYEMAC1MCLKIN_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC1RXBUFERR_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC1RXBUFERR_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC1RXBUFSTATUS_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0.0 ns);
     tsetup_PHYEMAC1RXBUFSTATUS_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0.0 ns);
     tsetup_PHYEMAC1RXCHARISCOMMA_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC1RXCHARISCOMMA_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC1RXCHARISK_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC1RXCHARISK_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC1RXCHECKINGCRC_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC1RXCHECKINGCRC_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC1RXCLKCORCNT_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0.0 ns);
     tsetup_PHYEMAC1RXCLKCORCNT_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0.0 ns);
     tsetup_PHYEMAC1RXCOMMADET_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC1RXCOMMADET_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC1RXDISPERR_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC1RXDISPERR_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC1RXDV_PHYEMAC1RXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC1RXDV_PHYEMAC1RXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     tsetup_PHYEMAC1RXER_PHYEMAC1RXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC1RXER_PHYEMAC1RXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0.0 ns);
     tsetup_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0.0 ns);
     tsetup_PHYEMAC1RXNOTINTABLE_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC1RXNOTINTABLE_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC1RXRUNDISP_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC1RXRUNDISP_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC1TXBUFERR_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_PHYEMAC1TXBUFERR_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_TIEEMAC0CONFIGVEC_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayArrayType(79 downto 0) := (others => 0.0 ns);
     tsetup_TIEEMAC0CONFIGVEC_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayArrayType(79 downto 0) := (others => 0.0 ns);
     tsetup_TIEEMAC1CONFIGVEC_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayArrayType(79 downto 0) := (others => 0.0 ns);
     tsetup_TIEEMAC1CONFIGVEC_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayArrayType(79 downto 0) := (others => 0.0 ns)
  );
  port (
     DCRHOSTDONEIR : out std_ulogic;
     EMAC0CLIENTANINTERRUPT : out std_ulogic;
     EMAC0CLIENTRXBADFRAME : out std_ulogic;
     EMAC0CLIENTRXCLIENTCLKOUT : out std_ulogic;
     EMAC0CLIENTRXD : out std_logic_vector(15 downto 0);
     EMAC0CLIENTRXDVLD : out std_ulogic;
     EMAC0CLIENTRXDVLDMSW : out std_ulogic;
     EMAC0CLIENTRXDVREG6 : out std_ulogic;
     EMAC0CLIENTRXFRAMEDROP : out std_ulogic;
     EMAC0CLIENTRXGOODFRAME : out std_ulogic;
     EMAC0CLIENTRXSTATS : out std_logic_vector(6 downto 0);
     EMAC0CLIENTRXSTATSBYTEVLD : out std_ulogic;
     EMAC0CLIENTRXSTATSVLD : out std_ulogic;
     EMAC0CLIENTTXACK : out std_ulogic;
     EMAC0CLIENTTXCLIENTCLKOUT : out std_ulogic;
     EMAC0CLIENTTXCOLLISION : out std_ulogic;
     EMAC0CLIENTTXGMIIMIICLKOUT : out std_ulogic;
     EMAC0CLIENTTXRETRANSMIT : out std_ulogic;
     EMAC0CLIENTTXSTATS : out std_ulogic;
     EMAC0CLIENTTXSTATSBYTEVLD : out std_ulogic;
     EMAC0CLIENTTXSTATSVLD : out std_ulogic;
     EMAC0PHYENCOMMAALIGN : out std_ulogic;
     EMAC0PHYLOOPBACKMSB : out std_ulogic;
     EMAC0PHYMCLKOUT : out std_ulogic;
     EMAC0PHYMDOUT : out std_ulogic;
     EMAC0PHYMDTRI : out std_ulogic;
     EMAC0PHYMGTRXRESET : out std_ulogic;
     EMAC0PHYMGTTXRESET : out std_ulogic;
     EMAC0PHYPOWERDOWN : out std_ulogic;
     EMAC0PHYSYNCACQSTATUS : out std_ulogic;
     EMAC0PHYTXCHARDISPMODE : out std_ulogic;
     EMAC0PHYTXCHARDISPVAL : out std_ulogic;
     EMAC0PHYTXCHARISK : out std_ulogic;
     EMAC0PHYTXCLK : out std_ulogic;
     EMAC0PHYTXD : out std_logic_vector(7 downto 0);
     EMAC0PHYTXEN : out std_ulogic;
     EMAC0PHYTXER : out std_ulogic;
     EMAC1CLIENTANINTERRUPT : out std_ulogic;
     EMAC1CLIENTRXBADFRAME : out std_ulogic;
     EMAC1CLIENTRXCLIENTCLKOUT : out std_ulogic;
     EMAC1CLIENTRXD : out std_logic_vector(15 downto 0);
     EMAC1CLIENTRXDVLD : out std_ulogic;
     EMAC1CLIENTRXDVLDMSW : out std_ulogic;
     EMAC1CLIENTRXDVREG6 : out std_ulogic;
     EMAC1CLIENTRXFRAMEDROP : out std_ulogic;
     EMAC1CLIENTRXGOODFRAME : out std_ulogic;
     EMAC1CLIENTRXSTATS : out std_logic_vector(6 downto 0);
     EMAC1CLIENTRXSTATSBYTEVLD : out std_ulogic;
     EMAC1CLIENTRXSTATSVLD : out std_ulogic;
     EMAC1CLIENTTXACK : out std_ulogic;
     EMAC1CLIENTTXCLIENTCLKOUT : out std_ulogic;
     EMAC1CLIENTTXCOLLISION : out std_ulogic;
     EMAC1CLIENTTXGMIIMIICLKOUT : out std_ulogic;
     EMAC1CLIENTTXRETRANSMIT : out std_ulogic;
     EMAC1CLIENTTXSTATS : out std_ulogic;
     EMAC1CLIENTTXSTATSBYTEVLD : out std_ulogic;
     EMAC1CLIENTTXSTATSVLD : out std_ulogic;
     EMAC1PHYENCOMMAALIGN : out std_ulogic;
     EMAC1PHYLOOPBACKMSB : out std_ulogic;
     EMAC1PHYMCLKOUT : out std_ulogic;
     EMAC1PHYMDOUT : out std_ulogic;
     EMAC1PHYMDTRI : out std_ulogic;
     EMAC1PHYMGTRXRESET : out std_ulogic;
     EMAC1PHYMGTTXRESET : out std_ulogic;
     EMAC1PHYPOWERDOWN : out std_ulogic;
     EMAC1PHYSYNCACQSTATUS : out std_ulogic;
     EMAC1PHYTXCHARDISPMODE : out std_ulogic;
     EMAC1PHYTXCHARDISPVAL : out std_ulogic;
     EMAC1PHYTXCHARISK : out std_ulogic;
     EMAC1PHYTXCLK : out std_ulogic;
     EMAC1PHYTXD : out std_logic_vector(7 downto 0);
     EMAC1PHYTXEN : out std_ulogic;
     EMAC1PHYTXER : out std_ulogic;
     EMACDCRACK : out std_ulogic;
     EMACDCRDBUS : out std_logic_vector(0 to 31);
     HOSTMIIMRDY : out std_ulogic;
     HOSTRDDATA : out std_logic_vector(31 downto 0);
     CLIENTEMAC0DCMLOCKED : in std_ulogic;
     CLIENTEMAC0PAUSEREQ : in std_ulogic;
     CLIENTEMAC0PAUSEVAL : in std_logic_vector(15 downto 0);
     CLIENTEMAC0RXCLIENTCLKIN : in std_ulogic;
     CLIENTEMAC0TXCLIENTCLKIN : in std_ulogic;
     CLIENTEMAC0TXD : in std_logic_vector(15 downto 0);
     CLIENTEMAC0TXDVLD : in std_ulogic;
     CLIENTEMAC0TXDVLDMSW : in std_ulogic;
     CLIENTEMAC0TXFIRSTBYTE : in std_ulogic;
     CLIENTEMAC0TXGMIIMIICLKIN : in std_ulogic;
     CLIENTEMAC0TXIFGDELAY : in std_logic_vector(7 downto 0);
     CLIENTEMAC0TXUNDERRUN : in std_ulogic;
     CLIENTEMAC1DCMLOCKED : in std_ulogic;
     CLIENTEMAC1PAUSEREQ : in std_ulogic;
     CLIENTEMAC1PAUSEVAL : in std_logic_vector(15 downto 0);
     CLIENTEMAC1RXCLIENTCLKIN : in std_ulogic;
     CLIENTEMAC1TXCLIENTCLKIN : in std_ulogic;
     CLIENTEMAC1TXD : in std_logic_vector(15 downto 0);
     CLIENTEMAC1TXDVLD : in std_ulogic;
     CLIENTEMAC1TXDVLDMSW : in std_ulogic;
     CLIENTEMAC1TXFIRSTBYTE : in std_ulogic;
     CLIENTEMAC1TXGMIIMIICLKIN : in std_ulogic;
     CLIENTEMAC1TXIFGDELAY : in std_logic_vector(7 downto 0);
     CLIENTEMAC1TXUNDERRUN : in std_ulogic;
     DCREMACABUS : in std_logic_vector(8 to 9);
     DCREMACCLK : in std_ulogic;
     DCREMACDBUS : in std_logic_vector(0 to 31);
     DCREMACENABLE : in std_ulogic;
     DCREMACREAD : in std_ulogic;
     DCREMACWRITE : in std_ulogic;
     HOSTADDR : in std_logic_vector(9 downto 0);
     HOSTCLK : in std_ulogic;
     HOSTEMAC1SEL : in std_ulogic;
     HOSTMIIMSEL : in std_ulogic;
     HOSTOPCODE : in std_logic_vector(1 downto 0);
     HOSTREQ : in std_ulogic;
     HOSTWRDATA : in std_logic_vector(31 downto 0);
     PHYEMAC0COL : in std_ulogic;
     PHYEMAC0CRS : in std_ulogic;
     PHYEMAC0GTXCLK : in std_ulogic;
     PHYEMAC0MCLKIN : in std_ulogic;
     PHYEMAC0MDIN : in std_ulogic;
     PHYEMAC0MIITXCLK : in std_ulogic;
     PHYEMAC0PHYAD : in std_logic_vector(4 downto 0);
     PHYEMAC0RXBUFERR : in std_ulogic;
     PHYEMAC0RXBUFSTATUS : in std_logic_vector(1 downto 0);
     PHYEMAC0RXCHARISCOMMA : in std_ulogic;
     PHYEMAC0RXCHARISK : in std_ulogic;
     PHYEMAC0RXCHECKINGCRC : in std_ulogic;
     PHYEMAC0RXCLK : in std_ulogic;
     PHYEMAC0RXCLKCORCNT : in std_logic_vector(2 downto 0);
     PHYEMAC0RXCOMMADET : in std_ulogic;
     PHYEMAC0RXD : in std_logic_vector(7 downto 0);
     PHYEMAC0RXDISPERR : in std_ulogic;
     PHYEMAC0RXDV : in std_ulogic;
     PHYEMAC0RXER : in std_ulogic;
     PHYEMAC0RXLOSSOFSYNC : in std_logic_vector(1 downto 0);
     PHYEMAC0RXNOTINTABLE : in std_ulogic;
     PHYEMAC0RXRUNDISP : in std_ulogic;
     PHYEMAC0SIGNALDET : in std_ulogic;
     PHYEMAC0TXBUFERR : in std_ulogic;
     PHYEMAC1COL : in std_ulogic;
     PHYEMAC1CRS : in std_ulogic;
     PHYEMAC1GTXCLK : in std_ulogic;
     PHYEMAC1MCLKIN : in std_ulogic;
     PHYEMAC1MDIN : in std_ulogic;
     PHYEMAC1MIITXCLK : in std_ulogic;
     PHYEMAC1PHYAD : in std_logic_vector(4 downto 0);
     PHYEMAC1RXBUFERR : in std_ulogic;
     PHYEMAC1RXBUFSTATUS : in std_logic_vector(1 downto 0);
     PHYEMAC1RXCHARISCOMMA : in std_ulogic;
     PHYEMAC1RXCHARISK : in std_ulogic;
     PHYEMAC1RXCHECKINGCRC : in std_ulogic;
     PHYEMAC1RXCLK : in std_ulogic;
     PHYEMAC1RXCLKCORCNT : in std_logic_vector(2 downto 0);
     PHYEMAC1RXCOMMADET : in std_ulogic;
     PHYEMAC1RXD : in std_logic_vector(7 downto 0);
     PHYEMAC1RXDISPERR : in std_ulogic;
     PHYEMAC1RXDV : in std_ulogic;
     PHYEMAC1RXER : in std_ulogic;
     PHYEMAC1RXLOSSOFSYNC : in std_logic_vector(1 downto 0);
     PHYEMAC1RXNOTINTABLE : in std_ulogic;
     PHYEMAC1RXRUNDISP : in std_ulogic;
     PHYEMAC1SIGNALDET : in std_ulogic;
     PHYEMAC1TXBUFERR : in std_ulogic;
     RESET : in std_ulogic;
     TIEEMAC0CONFIGVEC : in std_logic_vector(79 downto 0);
     TIEEMAC0UNICASTADDR : in std_logic_vector(47 downto 0);
     TIEEMAC1CONFIGVEC : in std_logic_vector(79 downto 0);
     TIEEMAC1UNICASTADDR : in std_logic_vector(47 downto 0)
  );
end component;

----- component X_FDD -----
component X_FDD
  generic (
     INIT : bit := '0';
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     thold_CE_CLK_negedge_posedge : VitalDelayType := 0.000 ns;
     thold_CE_CLK_posedge_posedge : VitalDelayType := 0.000 ns;
     thold_I_CLK_negedge_posedge : VitalDelayType := 0.000 ns;
     thold_I_CLK_posedge_posedge : VitalDelayType := 0.000 ns;
     thold_RST_CLK_negedge_posedge : VitalDelayType := 0.000 ns;
     thold_SET_CLK_negedge_posedge : VitalDelayType := 0.000 ns;
     tipd_CE : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_CLK : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_RST : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_SET : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_CLK_O : VitalDelayType01 := (0.100 ns, 0.100 ns);
     tpd_RST_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_SET_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpw_CLK_negedge : VitalDelayType := 0.000 ns;
     tpw_CLK_posedge : VitalDelayType := 0.000 ns;
     tpw_RST_posedge : VitalDelayType := 0.000 ns;
     tpw_SET_posedge : VitalDelayType := 0.000 ns;
     trecovery_RST_CLK_negedge_posedge : VitalDelayType := 0.000 ns;
     trecovery_SET_CLK_negedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_CE_CLK_negedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_CE_CLK_posedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_I_CLK_negedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_I_CLK_posedge_posedge : VitalDelayType := 0.000 ns
  );
  port (
     O : out std_ulogic;
     CE : in std_ulogic;
     CLK : in std_ulogic;
     I : in std_ulogic;
     RST : in std_ulogic;
     SET : in std_ulogic
  );
end component;

----- component X_FDDRCPE -----
component X_FDDRCPE
  generic (
     INIT : bit := '0';
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     tbpd_CLR_Q_C0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tbpd_PRE_Q_C0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     thold_CE_C0_negedge_posedge : VitalDelayType := 0.000 ns;
     thold_CE_C0_posedge_posedge : VitalDelayType := 0.000 ns;
     thold_CE_C1_negedge_posedge : VitalDelayType := 0.000 ns;
     thold_CE_C1_posedge_posedge : VitalDelayType := 0.000 ns;
     thold_D0_C0_negedge_posedge : VitalDelayType := 0.000 ns;
     thold_D0_C0_posedge_posedge : VitalDelayType := 0.000 ns;
     thold_D1_C1_negedge_posedge : VitalDelayType := 0.000 ns;
     thold_D1_C1_posedge_posedge : VitalDelayType := 0.000 ns;
     ticd_C0 : VitalDelayType := 0.000 ns;
     ticd_C1 : VitalDelayType := 0.000 ns;
     tipd_C0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_C1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_CE : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_CLR : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_D0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_D1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_PRE : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tisd_CE_C0 : VitalDelayType := 0.000 ns;
     tisd_CE_C1 : VitalDelayType := 0.000 ns;
     tisd_CLR_C0 : VitalDelayType := 0.000 ns;
     tisd_CLR_C1 : VitalDelayType := 0.000 ns;
     tisd_D0_C0 : VitalDelayType := 0.000 ns;
     tisd_D1_C1 : VitalDelayType := 0.000 ns;
     tisd_PRE_C0 : VitalDelayType := 0.000 ns;
     tisd_PRE_C1 : VitalDelayType := 0.000 ns;
     tpd_C0_Q : VitalDelayType01 := (0.100 ns, 0.100 ns);
     tpd_C1_Q : VitalDelayType01 := (0.100 ns, 0.100 ns);
     tpd_CLR_Q : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_PRE_Q : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpw_C0_negedge : VitalDelayType := 0.000 ns;
     tpw_C0_posedge : VitalDelayType := 0.000 ns;
     tpw_C1_negedge : VitalDelayType := 0.000 ns;
     tpw_C1_posedge : VitalDelayType := 0.000 ns;
     tpw_CLR_posedge : VitalDelayType := 0.000 ns;
     tpw_PRE_posedge : VitalDelayType := 0.000 ns;
     trecovery_CLR_C0_negedge_posedge : VitalDelayType := 0.000 ns;
     trecovery_CLR_C1_negedge_posedge : VitalDelayType := 0.000 ns;
     trecovery_PRE_C0_negedge_posedge : VitalDelayType := 0.000 ns;
     trecovery_PRE_C1_negedge_posedge : VitalDelayType := 0.000 ns;
     tremoval_CLR_C0_negedge_posedge : VitalDelayType := 0.000 ns;
     tremoval_CLR_C1_negedge_posedge : VitalDelayType := 0.000 ns;
     tremoval_PRE_C0_negedge_posedge : VitalDelayType := 0.000 ns;
     tremoval_PRE_C1_negedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_CE_C0_negedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_CE_C0_posedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_CE_C1_negedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_CE_C1_posedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_D0_C0_negedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_D0_C0_posedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_D1_C1_negedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_D1_C1_posedge_posedge : VitalDelayType := 0.000 ns
  );
  port (
     Q : out std_ulogic;
     C0 : in std_ulogic;
     C1 : in std_ulogic;
     CE : in std_ulogic;
     CLR : in std_ulogic;
     D0 : in std_ulogic;
     D1 : in std_ulogic;
     PRE : in std_ulogic
  );
end component;

----- component X_FDDRRSE -----
component X_FDDRRSE
  generic (
     INIT : bit := '0';
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     thold_CE_C0_negedge_posedge : VitalDelayType := 0.000 ns;
     thold_CE_C0_posedge_posedge : VitalDelayType := 0.000 ns;
     thold_CE_C1_negedge_posedge : VitalDelayType := 0.000 ns;
     thold_CE_C1_posedge_posedge : VitalDelayType := 0.000 ns;
     thold_D0_C0_negedge_posedge : VitalDelayType := 0.000 ns;
     thold_D0_C0_posedge_posedge : VitalDelayType := 0.000 ns;
     thold_D1_C1_negedge_posedge : VitalDelayType := 0.000 ns;
     thold_D1_C1_posedge_posedge : VitalDelayType := 0.000 ns;
     thold_R_C0_negedge_posedge : VitalDelayType := 0.000 ns;
     thold_R_C0_posedge_posedge : VitalDelayType := 0.000 ns;
     thold_R_C1_negedge_posedge : VitalDelayType := 0.000 ns;
     thold_R_C1_posedge_posedge : VitalDelayType := 0.000 ns;
     thold_S_C0_negedge_posedge : VitalDelayType := 0.000 ns;
     thold_S_C0_posedge_posedge : VitalDelayType := 0.000 ns;
     thold_S_C1_negedge_posedge : VitalDelayType := 0.000 ns;
     thold_S_C1_posedge_posedge : VitalDelayType := 0.000 ns;
     ticd_C0 : VitalDelayType := 0.000 ns;
     ticd_C1 : VitalDelayType := 0.000 ns;
     tipd_C0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_C1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_D0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_D1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_R : VitalDelayType01 := (0 ps, 0 ps);
     tipd_S : VitalDelayType01 := (0 ps, 0 ps);
     tisd_CE_C0 : VitalDelayType := 0.000 ns;
     tisd_CE_C1 : VitalDelayType := 0.000 ns;
     tisd_D0_C0 : VitalDelayType := 0.000 ns;
     tisd_D1_C1 : VitalDelayType := 0.000 ns;
     tisd_R_C0 : VitalDelayType := 0.000 ns;
     tisd_R_C1 : VitalDelayType := 0.000 ns;
     tisd_S_C0 : VitalDelayType := 0.000 ns;
     tisd_S_C1 : VitalDelayType := 0.000 ns;
     tpd_C0_Q : VitalDelayType01 := (100 ps, 100 ps);
     tpd_C1_Q : VitalDelayType01 := (100 ps, 100 ps);
     tpw_C0_negedge : VitalDelayType := 0.000 ns;
     tpw_C0_posedge : VitalDelayType := 0.000 ns;
     tpw_C1_negedge : VitalDelayType := 0.000 ns;
     tpw_C1_posedge : VitalDelayType := 0.000 ns;
     tpw_R_posedge : VitalDelayType := 0.000 ns;
     tpw_S_posedge : VitalDelayType := 0.000 ns;
     tsetup_CE_C0_negedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_CE_C0_posedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_CE_C1_negedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_CE_C1_posedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_D0_C0_negedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_D0_C0_posedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_D1_C1_negedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_D1_C1_posedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_R_C0_negedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_R_C0_posedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_R_C1_negedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_R_C1_posedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_S_C0_negedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_S_C0_posedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_S_C1_negedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_S_C1_posedge_posedge : VitalDelayType := 0.000 ns
  );
  port (
     Q : out std_ulogic;
     C0 : in std_ulogic;
     C1 : in std_ulogic;
     CE : in std_ulogic;
     D0 : in std_ulogic;
     D1 : in std_ulogic;
     R : in std_ulogic;
     S : in std_ulogic
  );
end component;

----- component X_FF -----
component X_FF
  generic (
     INIT : bit := '0';
     LOC : string := "UNPLACED";
     MSGON : boolean := true;
     TimingChecksOn : boolean := true;
     XON : boolean := true;
     thold_CE_CLK_negedge_posedge : VitalDelayType := 0.000 ns;
     thold_CE_CLK_posedge_posedge : VitalDelayType := 0.000 ns;
     thold_I_CLK_negedge_posedge : VitalDelayType := 0.000 ns;
     thold_I_CLK_posedge_posedge : VitalDelayType := 0.000 ns;
     thold_RST_CLK_negedge_posedge : VitalDelayType := 0.000 ns;
     thold_SET_CLK_negedge_posedge : VitalDelayType := 0.000 ns;
     ticd_CLK : VitalDelayType := 0.000 ns;
     tipd_CE : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_CLK : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_RST : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_SET : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tisd_CE_CLK : VitalDelayType := 0.000 ns;
     tisd_I_CLK : VitalDelayType := 0.000 ns;
     tisd_RST_CLK : VitalDelayType := 0.000 ns;
     tisd_SET_CLK : VitalDelayType := 0.000 ns;
     tpd_CLK_O : VitalDelayType01 := (0.100 ns, 0.100 ns);
     tpd_RST_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_SET_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tperiod_CLK_posedge : VitalDelayType := 0.000 ns;
     tpw_CLK_negedge : VitalDelayType := 0.000 ns;
     tpw_CLK_posedge : VitalDelayType := 0.000 ns;
     tpw_RST_posedge : VitalDelayType := 0.000 ns;
     tpw_SET_posedge : VitalDelayType := 0.000 ns;
     trecovery_RST_CLK_negedge_posedge : VitalDelayType := 0.000 ns;
     trecovery_SET_CLK_negedge_posedge : VitalDelayType := 0.000 ns;
     tremoval_RST_CLK_negedge_posedge : VitalDelayType := 0.000 ns;
     tremoval_SET_CLK_negedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_CE_CLK_negedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_CE_CLK_posedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_I_CLK_negedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_I_CLK_posedge_posedge : VitalDelayType := 0.000 ns
  );
  port (
     O : out std_ulogic;
     CE : in std_ulogic;
     CLK : in std_ulogic;
     I : in std_ulogic;
     RST : in std_ulogic;
     SET : in std_ulogic
  );
end component;

----- component X_FF18_INTERNAL_VHDL -----
component X_FF18_INTERNAL_VHDL
  generic (
     ALMOST_EMPTY_OFFSET : bit_vector := X"0080";
     ALMOST_FULL_OFFSET : bit_vector := X"0080";
     DATA_WIDTH : integer := 4;
     DO_REG : integer := 1;
     EN_ECC_READ : boolean := FALSE;
     EN_ECC_WRITE : boolean := FALSE;
     EN_SYN : boolean := FALSE;
     FIFO_MODE : string := "FIFO36";
     FIFO_SIZE : integer := 36;
     FIRST_WORD_FALL_THROUGH : boolean := FALSE;
     INIT : bit_vector := X"000000000000000000";
     SRVAL : bit_vector := X"000000000000000000"
  );
  port (
     ALMOSTEMPTY : out std_ulogic;
     ALMOSTFULL : out std_ulogic;
     DBITERR : out std_ulogic;
     DO : out std_logic_vector (63 downto 0);
     DOP : out std_logic_vector (7 downto 0);
     ECCPARITY : out std_logic_vector (7 downto 0);
     EMPTY : out std_ulogic;
     FULL : out std_ulogic;
     RDCOUNT : out std_logic_vector (12 downto 0);
     RDERR : out std_ulogic;
     SBITERR : out std_ulogic;
     WRCOUNT : out std_logic_vector (12 downto 0);
     WRERR : out std_ulogic;
     DI : in std_logic_vector (63 downto 0);
     DIP : in std_logic_vector (7 downto 0);
     INJECTDBITERR : in std_ulogic;
     INJECTSBITERR : in std_ulogic;
     RDCLK : in std_ulogic;
     RDEN : in std_ulogic;
     REGCE : in std_ulogic;
     RST : in std_ulogic;
     RSTREG : in std_ulogic;
     WRCLK : in std_ulogic;
     WREN : in std_ulogic
  );
end component;

----- component X_FF36_INTERNAL_VHDL -----
component X_FF36_INTERNAL_VHDL
  generic (
     ALMOST_EMPTY_OFFSET : bit_vector := X"0080";
     ALMOST_FULL_OFFSET : bit_vector := X"0080";
     DATA_WIDTH : integer := 4;
     DO_REG : integer := 1;
     EN_ECC_READ : boolean := FALSE;
     EN_ECC_WRITE : boolean := FALSE;
     EN_SYN : boolean := FALSE;
     FIFO_MODE : string := "FIFO36";
     FIFO_SIZE : integer := 36;
     FIRST_WORD_FALL_THROUGH : boolean := FALSE;
     INIT : bit_vector := X"000000000000000000";
     SRVAL : bit_vector := X"000000000000000000"
  );
  port (
     ALMOSTEMPTY : out std_ulogic;
     ALMOSTFULL : out std_ulogic;
     DBITERR : out std_ulogic;
     DO : out std_logic_vector (63 downto 0);
     DOP : out std_logic_vector (7 downto 0);
     ECCPARITY : out std_logic_vector (7 downto 0);
     EMPTY : out std_ulogic;
     FULL : out std_ulogic;
     RDCOUNT : out std_logic_vector (12 downto 0);
     RDERR : out std_ulogic;
     SBITERR : out std_ulogic;
     WRCOUNT : out std_logic_vector (12 downto 0);
     WRERR : out std_ulogic;
     DI : in std_logic_vector (63 downto 0);
     DIP : in std_logic_vector (7 downto 0);
     INJECTDBITERR : in std_ulogic;
     INJECTSBITERR : in std_ulogic;
     RDCLK : in std_ulogic;
     RDEN : in std_ulogic;
     REGCE : in std_ulogic;
     RST : in std_ulogic;
     RSTREG : in std_ulogic;
     WRCLK : in std_ulogic;
     WREN : in std_ulogic
  );
end component;

----- component X_FF_CPLD -----
component X_FF_CPLD
  generic (
     INIT : bit := '0';
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     thold_CE_CLK_negedge_posedge : VitalDelayType := 0.000 ns;
     thold_CE_CLK_posedge_posedge : VitalDelayType := 0.000 ns;
     thold_I_CLK_negedge_posedge : VitalDelayType := 0.000 ns;
     thold_I_CLK_posedge_posedge : VitalDelayType := 0.000 ns;
     thold_RST_CLK_negedge_posedge : VitalDelayType := 0.000 ns;
     thold_SET_CLK_negedge_posedge : VitalDelayType := 0.000 ns;
     ticd_CLK : VitalDelayType := 0.000 ns;
     tipd_CE : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_CLK : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_RST : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_SET : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tisd_CE_CLK : VitalDelayType := 0.000 ns;
     tisd_I_CLK : VitalDelayType := 0.000 ns;
     tisd_RST_CLK : VitalDelayType := 0.000 ns;
     tisd_SET_CLK : VitalDelayType := 0.000 ns;
     tpd_CLK_O : VitalDelayType01 := (0.100 ns, 0.100 ns);
     tpd_RST_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_SET_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tperiod_CLK_posedge : VitalDelayType := 0.000 ns;
     tpw_RST_posedge : VitalDelayType := 0.000 ns;
     tpw_SET_posedge : VitalDelayType := 0.000 ns;
     trecovery_RST_CLK_negedge_posedge : VitalDelayType := 0.000 ns;
     trecovery_SET_CLK_negedge_posedge : VitalDelayType := 0.000 ns;
     tremoval_RST_CLK_negedge_posedge : VitalDelayType := 0.000 ns;
     tremoval_SET_CLK_negedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_CE_CLK_negedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_CE_CLK_posedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_I_CLK_negedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_I_CLK_posedge_posedge : VitalDelayType := 0.000 ns
  );
  port (
     O : out std_ulogic;
     CE : in std_ulogic;
     CLK : in std_ulogic;
     I : in std_ulogic;
     RST : in std_ulogic;
     SET : in std_ulogic
  );
end component;

----- component X_FIFO16 -----
component X_FIFO16
  generic (
     ALMOST_EMPTY_OFFSET : bit_vector := X"080";
     ALMOST_FULL_OFFSET : bit_vector := X"080";
     DATA_WIDTH : integer := 36;
     FIRST_WORD_FALL_THROUGH : boolean := false;
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     thold_DIP_WRCLK_negedge_posedge : VitalDelayArrayType (3 downto 0) := (others => 0 ps);
     thold_DIP_WRCLK_posedge_posedge : VitalDelayArrayType (3 downto 0) := (others => 0 ps);
     thold_DI_WRCLK_negedge_posedge : VitalDelayArrayType (31 downto 0) := (others => 0 ps);
     thold_DI_WRCLK_posedge_posedge : VitalDelayArrayType (31 downto 0) := (others => 0 ps);
     thold_RDEN_RDCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RDEN_RDCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_WREN_WRCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_WREN_WRCLK_posedge_posedge : VitalDelayType := 0 ps;
     ticd_RDCLK : VitalDelayType := 0 ps;
     ticd_WRCLK : VitalDelayType := 0 ps;
     tipd_DI : VitalDelayArrayType01(31 downto 0) := (others => (0 ps, 0 ps));
     tipd_DIP : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tipd_RDCLK : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RDEN : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RST : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_WRCLK : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_WREN : VitalDelayType01 := ( 0 ps, 0 ps);
     tisd_DIP_WRCLK : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_DI_WRCLK : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tisd_RDEN_RDCLK : VitalDelayType := 0 ps;
     tisd_RST_WRCLK : VitalDelayType := 0 ps;
     tisd_WREN_WRCLK : VitalDelayType := 0 ps;
     tpd_RDCLK_ALMOSTEMPTY : VitalDelayType01 := ( 100 ps, 100 ps);
     tpd_RDCLK_DO : VitalDelayArrayType01 (31 downto 0) := (others => (100 ps, 100 ps));
     tpd_RDCLK_DOP : VitalDelayArrayType01 (3 downto 0) := (others => (100 ps, 100 ps));
     tpd_RDCLK_EMPTY : VitalDelayType01 := ( 100 ps, 100 ps);
     tpd_RDCLK_RDCOUNT : VitalDelayArrayType01 (11 downto 0) := (others => (100 ps, 100 ps));
     tpd_RDCLK_RDERR : VitalDelayType01 := ( 100 ps, 100 ps);
     tpd_RST_ALMOSTEMPTY : VitalDelayType01 := ( 0 ps, 0 ps);
     tpd_RST_ALMOSTFULL : VitalDelayType01 := ( 0 ps, 0 ps);
     tpd_RST_EMPTY : VitalDelayType01 := ( 0 ps, 0 ps);
     tpd_RST_FULL : VitalDelayType01 := ( 0 ps, 0 ps);
     tpd_RST_RDCOUNT : VitalDelayArrayType01 (11 downto 0) := (others => (0 ps, 0 ps));
     tpd_RST_RDERR : VitalDelayType01 := ( 0 ps, 0 ps);
     tpd_RST_WRCOUNT : VitalDelayArrayType01 (11 downto 0) := (others => (0 ps, 0 ps));
     tpd_RST_WRERR : VitalDelayType01 := ( 0 ps, 0 ps);
     tpd_WRCLK_ALMOSTFULL : VitalDelayType01 := ( 100 ps, 100 ps);
     tpd_WRCLK_FULL : VitalDelayType01 := ( 100 ps, 100 ps);
     tpd_WRCLK_WRCOUNT : VitalDelayArrayType01 (11 downto 0) := (others => (100 ps, 100 ps));
     tpd_WRCLK_WRERR : VitalDelayType01 := ( 100 ps, 100 ps);
     tperiod_RDCLK_posedge : VitalDelayType := 0 ps;
     tperiod_WRCLK_posedge : VitalDelayType := 0 ps;
     tpw_RDCLK_negedge : VitalDelayType := 0 ps;
     tpw_RDCLK_posedge : VitalDelayType := 0 ps;
     tpw_RST_negedge : VitalDelayType := 0 ps;
     tpw_RST_posedge : VitalDelayType := 0 ps;
     tpw_WRCLK_negedge : VitalDelayType := 0 ps;
     tpw_WRCLK_posedge : VitalDelayType := 0 ps;
     trecovery_RST_RDCLK_negedge_posedge : VitalDelayType := 0 ps;
     trecovery_RST_WRCLK_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_RST_RDCLK_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_RST_WRCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_DIP_WRCLK_negedge_posedge : VitalDelayArrayType (3 downto 0) := (others => 0 ps);
     tsetup_DIP_WRCLK_posedge_posedge : VitalDelayArrayType (3 downto 0) := (others => 0 ps);
     tsetup_DI_WRCLK_negedge_posedge : VitalDelayArrayType (31 downto 0) := (others => 0 ps);
     tsetup_DI_WRCLK_posedge_posedge : VitalDelayArrayType (31 downto 0) := (others => 0 ps);
     tsetup_RDEN_RDCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RDEN_RDCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_WREN_WRCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_WREN_WRCLK_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     ALMOSTEMPTY : out std_ulogic;
     ALMOSTFULL : out std_ulogic;
     DO : out std_logic_vector (31 downto 0);
     DOP : out std_logic_vector (3 downto 0);
     EMPTY : out std_ulogic;
     FULL : out std_ulogic;
     RDCOUNT : out std_logic_vector (11 downto 0);
     RDERR : out std_ulogic;
     WRCOUNT : out std_logic_vector (11 downto 0);
     WRERR : out std_ulogic;
     DI : in std_logic_vector (31 downto 0);
     DIP : in std_logic_vector (3 downto 0);
     RDCLK : in std_ulogic;
     RDEN : in std_ulogic;
     RST : in std_ulogic;
     WRCLK : in std_ulogic;
     WREN : in std_ulogic
  );
end component;

----- component X_FIFO18 -----
component X_FIFO18
  generic (
     ALMOST_EMPTY_OFFSET : bit_vector := X"080";
     ALMOST_FULL_OFFSET : bit_vector := X"080";
     DATA_WIDTH : integer := 4;
     DO_REG : integer := 1;
     EN_SYN : boolean := FALSE;
     FIRST_WORD_FALL_THROUGH : boolean := FALSE;
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     tbpd_RST_ALMOSTEMPTY_RDCLK : VitalDelayType01 := ( 0 ps, 0 ps);
     tbpd_RST_ALMOSTFULL_WRCLK : VitalDelayType01 := ( 0 ps, 0 ps);
     tbpd_RST_EMPTY_RDCLK : VitalDelayType01 := ( 0 ps, 0 ps);
     tbpd_RST_FULL_WRCLK : VitalDelayType01 := ( 0 ps, 0 ps);
     tbpd_RST_RDCOUNT_RDCLK : VitalDelayArrayType01 (11 downto 0) := (others => (0 ps, 0 ps));
     tbpd_RST_RDERR_RDCLK : VitalDelayType01 := ( 0 ps, 0 ps);
     tbpd_RST_WRCOUNT_WRCLK : VitalDelayArrayType01 (11 downto 0) := (others => (0 ps, 0 ps));
     tbpd_RST_WRERR_WRCLK : VitalDelayType01 := ( 0 ps, 0 ps);
     thold_DIP_WRCLK_negedge_posedge : VitalDelayArrayType (1 downto 0) := (others => 0 ps);
     thold_DIP_WRCLK_posedge_posedge : VitalDelayArrayType (1 downto 0) := (others => 0 ps);
     thold_DI_WRCLK_negedge_posedge : VitalDelayArrayType (15 downto 0) := (others => 0 ps);
     thold_DI_WRCLK_posedge_posedge : VitalDelayArrayType (15 downto 0) := (others => 0 ps);
     thold_RDEN_RDCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RDEN_RDCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_WREN_WRCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_WREN_WRCLK_posedge_posedge : VitalDelayType := 0 ps;
     ticd_RDCLK : VitalDelayType := 0 ps;
     ticd_WRCLK : VitalDelayType := 0 ps;
     tipd_DI : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
     tipd_DIP : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tipd_RDCLK : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RDEN : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RST : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_WRCLK : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_WREN : VitalDelayType01 := ( 0 ps, 0 ps);
     tisd_DIP_WRCLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_DI_WRCLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tisd_RDEN_RDCLK : VitalDelayType := 0 ps;
     tisd_RST_RDCLK : VitalDelayType := 0 ps;
     tisd_RST_WRCLK : VitalDelayType := 0 ps;
     tisd_WREN_WRCLK : VitalDelayType := 0 ps;
     tpd_RDCLK_ALMOSTEMPTY : VitalDelayType01 := ( 100 ps, 100 ps);
     tpd_RDCLK_DO : VitalDelayArrayType01 (15 downto 0) := (others => (100 ps, 100 ps));
     tpd_RDCLK_DOP : VitalDelayArrayType01 (1 downto 0) := (others => (100 ps, 100 ps));
     tpd_RDCLK_EMPTY : VitalDelayType01 := ( 100 ps, 100 ps);
     tpd_RDCLK_RDCOUNT : VitalDelayArrayType01 (11 downto 0) := (others => (100 ps, 100 ps));
     tpd_RDCLK_RDERR : VitalDelayType01 := ( 100 ps, 100 ps);
     tpd_RST_ALMOSTEMPTY : VitalDelayType01 := ( 0 ps, 0 ps);
     tpd_RST_ALMOSTFULL : VitalDelayType01 := ( 0 ps, 0 ps);
     tpd_RST_EMPTY : VitalDelayType01 := ( 0 ps, 0 ps);
     tpd_RST_FULL : VitalDelayType01 := ( 0 ps, 0 ps);
     tpd_RST_RDCOUNT : VitalDelayArrayType01 (11 downto 0) := (others => (0 ps, 0 ps));
     tpd_RST_RDERR : VitalDelayType01 := ( 0 ps, 0 ps);
     tpd_RST_WRCOUNT : VitalDelayArrayType01 (11 downto 0) := (others => (0 ps, 0 ps));
     tpd_RST_WRERR : VitalDelayType01 := ( 0 ps, 0 ps);
     tpd_WRCLK_ALMOSTFULL : VitalDelayType01 := ( 100 ps, 100 ps);
     tpd_WRCLK_FULL : VitalDelayType01 := ( 100 ps, 100 ps);
     tpd_WRCLK_WRCOUNT : VitalDelayArrayType01 (11 downto 0) := (others => (100 ps, 100 ps));
     tpd_WRCLK_WRERR : VitalDelayType01 := ( 100 ps, 100 ps);
     tperiod_RDCLK_posedge : VitalDelayType := 0 ps;
     tperiod_WRCLK_posedge : VitalDelayType := 0 ps;
     tpw_RDCLK_negedge : VitalDelayType := 0 ps;
     tpw_RDCLK_posedge : VitalDelayType := 0 ps;
     tpw_RST_negedge : VitalDelayType := 0 ps;
     tpw_RST_posedge : VitalDelayType := 0 ps;
     tpw_WRCLK_negedge : VitalDelayType := 0 ps;
     tpw_WRCLK_posedge : VitalDelayType := 0 ps;
     trecovery_RST_RDCLK_negedge_posedge : VitalDelayType := 0 ps;
     trecovery_RST_WRCLK_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_RST_RDCLK_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_RST_WRCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_DIP_WRCLK_negedge_posedge : VitalDelayArrayType (1 downto 0) := (others => 0 ps);
     tsetup_DIP_WRCLK_posedge_posedge : VitalDelayArrayType (1 downto 0) := (others => 0 ps);
     tsetup_DI_WRCLK_negedge_posedge : VitalDelayArrayType (15 downto 0) := (others => 0 ps);
     tsetup_DI_WRCLK_posedge_posedge : VitalDelayArrayType (15 downto 0) := (others => 0 ps);
     tsetup_RDEN_RDCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RDEN_RDCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_WREN_WRCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_WREN_WRCLK_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     ALMOSTEMPTY : out std_ulogic;
     ALMOSTFULL : out std_ulogic;
     DO : out std_logic_vector (15 downto 0);
     DOP : out std_logic_vector (1 downto 0);
     EMPTY : out std_ulogic;
     FULL : out std_ulogic;
     RDCOUNT : out std_logic_vector (11 downto 0);
     RDERR : out std_ulogic;
     WRCOUNT : out std_logic_vector (11 downto 0);
     WRERR : out std_ulogic;
     DI : in std_logic_vector (15 downto 0);
     DIP : in std_logic_vector (1 downto 0);
     RDCLK : in std_ulogic;
     RDEN : in std_ulogic;
     RST : in std_ulogic;
     WRCLK : in std_ulogic;
     WREN : in std_ulogic
  );
end component;

----- component X_FIFO18E1 -----
component X_FIFO18E1
  generic (
     ALMOST_EMPTY_OFFSET : bit_vector := X"0080";
     ALMOST_FULL_OFFSET : bit_vector := X"0080";
     DATA_WIDTH : integer := 4;
     DO_REG : integer := 1;
     EN_SYN : boolean := FALSE;
     FIFO_MODE : string := "FIFO18";
     FIRST_WORD_FALL_THROUGH : boolean := FALSE;
     INIT : bit_vector := X"000000000";
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     SRVAL : bit_vector := X"000000000";
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     thold_DIP_WRCLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_DIP_WRCLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_DI_WRCLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     thold_DI_WRCLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     thold_RDEN_RDCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RDEN_RDCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_REGCE_RDCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_REGCE_RDCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTREG_RDCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTREG_RDCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_WREN_WRCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_WREN_WRCLK_posedge_posedge : VitalDelayType := 0 ps;
     ticd_RDCLK : VitalDelayType := 0 ps;
     ticd_WRCLK : VitalDelayType := 0 ps;
     tipd_DI : VitalDelayArrayType01 (31 downto 0) := (others => (0 ps, 0 ps));
     tipd_DIP : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_RDCLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RDEN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_REGCE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RST : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RSTREG : VitalDelayType01 := (0 ps, 0 ps);
     tipd_WRCLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_WREN : VitalDelayType01 := (0 ps, 0 ps);
     tisd_DIP_WRCLK : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_DI_WRCLK : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tisd_RDEN_RDCLK : VitalDelayType := 0 ps;
     tisd_REGCE_RDCLK : VitalDelayType := 0 ps;
     tisd_RSTREG_RDCLK : VitalDelayType := 0 ps;
     tisd_RST_RDCLK : VitalDelayType := 0 ps;
     tisd_RST_WRCLK : VitalDelayType := 0 ps;
     tisd_WREN_WRCLK : VitalDelayType := 0 ps;
     tpd_RDCLK_ALMOSTEMPTY : VitalDelayType01 := (100 ps, 100 ps);
     tpd_RDCLK_DO : VitalDelayArrayType01(31 downto 0) := (others => (100 ps, 100 ps));
     tpd_RDCLK_DOP : VitalDelayArrayType01(3 downto 0) := (others => (100 ps, 100 ps));
     tpd_RDCLK_EMPTY : VitalDelayType01 := (100 ps, 100 ps);
     tpd_RDCLK_RDCOUNT : VitalDelayArrayType01(11 downto 0) := (others => (100 ps, 100 ps));
     tpd_RDCLK_RDERR : VitalDelayType01 := (100 ps, 100 ps);
     tpd_RST_ALMOSTEMPTY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RST_ALMOSTFULL : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RST_EMPTY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RST_FULL : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RST_RDCOUNT : VitalDelayArrayType01(11 downto 0) := (others => (0 ps, 0 ps));
     tpd_RST_RDERR : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RST_WRCOUNT : VitalDelayArrayType01(11 downto 0) := (others => (0 ps, 0 ps));
     tpd_RST_WRERR : VitalDelayType01 := (0 ps, 0 ps);
     tpd_WRCLK_ALMOSTFULL : VitalDelayType01 := (100 ps, 100 ps);
     tpd_WRCLK_FULL : VitalDelayType01 := (100 ps, 100 ps);
     tpd_WRCLK_WRCOUNT : VitalDelayArrayType01(11 downto 0) := (others => (100 ps, 100 ps));
     tpd_WRCLK_WRERR : VitalDelayType01 := (100 ps, 100 ps);
     tperiod_RDCLK_posedge : VitalDelayType := 0 ps;
     tperiod_WRCLK_posedge : VitalDelayType := 0 ps;
     tpw_RDCLK_negedge : VitalDelayType := 0 ps;
     tpw_RDCLK_posedge : VitalDelayType := 0 ps;
     tpw_RST_negedge : VitalDelayType := 0 ps;
     tpw_RST_posedge : VitalDelayType := 0 ps;
     tpw_WRCLK_negedge : VitalDelayType := 0 ps;
     tpw_WRCLK_posedge : VitalDelayType := 0 ps;
     trecovery_RST_RDCLK_negedge_posedge : VitalDelayType := 0 ps;
     trecovery_RST_WRCLK_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_RST_RDCLK_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_RST_WRCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_DIP_WRCLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_DIP_WRCLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_DI_WRCLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tsetup_DI_WRCLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tsetup_RDEN_RDCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RDEN_RDCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_REGCE_RDCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_REGCE_RDCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTREG_RDCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTREG_RDCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_WREN_WRCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_WREN_WRCLK_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     ALMOSTEMPTY : out std_ulogic;
     ALMOSTFULL : out std_ulogic;
     DO : out std_logic_vector (31 downto 0);
     DOP : out std_logic_vector (3 downto 0);
     EMPTY : out std_ulogic;
     FULL : out std_ulogic;
     RDCOUNT : out std_logic_vector (11 downto 0);
     RDERR : out std_ulogic;
     WRCOUNT : out std_logic_vector (11 downto 0);
     WRERR : out std_ulogic;
     DI : in std_logic_vector (31 downto 0);
     DIP : in std_logic_vector (3 downto 0);
     RDCLK : in std_ulogic;
     RDEN : in std_ulogic;
     REGCE : in std_ulogic;
     RST : in std_ulogic;
     RSTREG : in std_ulogic;
     WRCLK : in std_ulogic;
     WREN : in std_ulogic
  );
end component;

----- component X_FIFO18_36 -----
component X_FIFO18_36
  generic (
     ALMOST_EMPTY_OFFSET : bit_vector := X"080";
     ALMOST_FULL_OFFSET : bit_vector := X"080";
     DO_REG : integer := 1;
     EN_SYN : boolean := FALSE;
     FIRST_WORD_FALL_THROUGH : boolean := FALSE;
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     tbpd_RST_ALMOSTEMPTY_RDCLK : VitalDelayType01 := ( 0 ps, 0 ps);
     tbpd_RST_ALMOSTFULL_WRCLK : VitalDelayType01 := ( 0 ps, 0 ps);
     tbpd_RST_EMPTY_RDCLK : VitalDelayType01 := ( 0 ps, 0 ps);
     tbpd_RST_FULL_WRCLK : VitalDelayType01 := ( 0 ps, 0 ps);
     tbpd_RST_RDCOUNT_RDCLK : VitalDelayArrayType01 (8 downto 0) := (others => (0 ps, 0 ps));
     tbpd_RST_RDERR_RDCLK : VitalDelayType01 := ( 0 ps, 0 ps);
     tbpd_RST_WRCOUNT_WRCLK : VitalDelayArrayType01 (8 downto 0) := (others => (0 ps, 0 ps));
     tbpd_RST_WRERR_WRCLK : VitalDelayType01 := ( 0 ps, 0 ps);
     thold_DIP_WRCLK_negedge_posedge : VitalDelayArrayType (3 downto 0) := (others => 0 ps);
     thold_DIP_WRCLK_posedge_posedge : VitalDelayArrayType (3 downto 0) := (others => 0 ps);
     thold_DI_WRCLK_negedge_posedge : VitalDelayArrayType (31 downto 0) := (others => 0 ps);
     thold_DI_WRCLK_posedge_posedge : VitalDelayArrayType (31 downto 0) := (others => 0 ps);
     thold_RDEN_RDCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RDEN_RDCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_WREN_WRCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_WREN_WRCLK_posedge_posedge : VitalDelayType := 0 ps;
     ticd_RDCLK : VitalDelayType := 0 ps;
     ticd_WRCLK : VitalDelayType := 0 ps;
     tipd_DI : VitalDelayArrayType01(31 downto 0) := (others => (0 ps, 0 ps));
     tipd_DIP : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tipd_RDCLK : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RDEN : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RST : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_WRCLK : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_WREN : VitalDelayType01 := ( 0 ps, 0 ps);
     tisd_DIP_WRCLK : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_DI_WRCLK : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tisd_RDEN_RDCLK : VitalDelayType := 0 ps;
     tisd_RST_RDCLK : VitalDelayType := 0 ps;
     tisd_RST_WRCLK : VitalDelayType := 0 ps;
     tisd_WREN_WRCLK : VitalDelayType := 0 ps;
     tpd_RDCLK_ALMOSTEMPTY : VitalDelayType01 := ( 100 ps, 100 ps);
     tpd_RDCLK_DO : VitalDelayArrayType01 (31 downto 0) := (others => (100 ps, 100 ps));
     tpd_RDCLK_DOP : VitalDelayArrayType01 (3 downto 0) := (others => (100 ps, 100 ps));
     tpd_RDCLK_EMPTY : VitalDelayType01 := ( 100 ps, 100 ps);
     tpd_RDCLK_RDCOUNT : VitalDelayArrayType01 (8 downto 0) := (others => (100 ps, 100 ps));
     tpd_RDCLK_RDERR : VitalDelayType01 := ( 100 ps, 100 ps);
     tpd_RST_ALMOSTEMPTY : VitalDelayType01 := ( 0 ps, 0 ps);
     tpd_RST_ALMOSTFULL : VitalDelayType01 := ( 0 ps, 0 ps);
     tpd_RST_EMPTY : VitalDelayType01 := ( 0 ps, 0 ps);
     tpd_RST_FULL : VitalDelayType01 := ( 0 ps, 0 ps);
     tpd_RST_RDCOUNT : VitalDelayArrayType01 (8 downto 0) := (others => (0 ps, 0 ps));
     tpd_RST_RDERR : VitalDelayType01 := ( 0 ps, 0 ps);
     tpd_RST_WRCOUNT : VitalDelayArrayType01 (8 downto 0) := (others => (0 ps, 0 ps));
     tpd_RST_WRERR : VitalDelayType01 := ( 0 ps, 0 ps);
     tpd_WRCLK_ALMOSTFULL : VitalDelayType01 := ( 100 ps, 100 ps);
     tpd_WRCLK_FULL : VitalDelayType01 := ( 100 ps, 100 ps);
     tpd_WRCLK_WRCOUNT : VitalDelayArrayType01 (8 downto 0) := (others => (100 ps, 100 ps));
     tpd_WRCLK_WRERR : VitalDelayType01 := ( 100 ps, 100 ps);
     tperiod_RDCLK_posedge : VitalDelayType := 0 ps;
     tperiod_WRCLK_posedge : VitalDelayType := 0 ps;
     tpw_RDCLK_negedge : VitalDelayType := 0 ps;
     tpw_RDCLK_posedge : VitalDelayType := 0 ps;
     tpw_RST_negedge : VitalDelayType := 0 ps;
     tpw_RST_posedge : VitalDelayType := 0 ps;
     tpw_WRCLK_negedge : VitalDelayType := 0 ps;
     tpw_WRCLK_posedge : VitalDelayType := 0 ps;
     trecovery_RST_RDCLK_negedge_posedge : VitalDelayType := 0 ps;
     trecovery_RST_WRCLK_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_RST_RDCLK_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_RST_WRCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_DIP_WRCLK_negedge_posedge : VitalDelayArrayType (3 downto 0) := (others => 0 ps);
     tsetup_DIP_WRCLK_posedge_posedge : VitalDelayArrayType (3 downto 0) := (others => 0 ps);
     tsetup_DI_WRCLK_negedge_posedge : VitalDelayArrayType (31 downto 0) := (others => 0 ps);
     tsetup_DI_WRCLK_posedge_posedge : VitalDelayArrayType (31 downto 0) := (others => 0 ps);
     tsetup_RDEN_RDCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RDEN_RDCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_WREN_WRCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_WREN_WRCLK_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     ALMOSTEMPTY : out std_ulogic;
     ALMOSTFULL : out std_ulogic;
     DO : out std_logic_vector (31 downto 0);
     DOP : out std_logic_vector (3 downto 0);
     EMPTY : out std_ulogic;
     FULL : out std_ulogic;
     RDCOUNT : out std_logic_vector (8 downto 0);
     RDERR : out std_ulogic;
     WRCOUNT : out std_logic_vector (8 downto 0);
     WRERR : out std_ulogic;
     DI : in std_logic_vector (31 downto 0);
     DIP : in std_logic_vector (3 downto 0);
     RDCLK : in std_ulogic;
     RDEN : in std_ulogic;
     RST : in std_ulogic;
     WRCLK : in std_ulogic;
     WREN : in std_ulogic
  );
end component;

----- component X_FIFO36E1 -----
component X_FIFO36E1
  generic (
     ALMOST_EMPTY_OFFSET : bit_vector := X"0080";
     ALMOST_FULL_OFFSET : bit_vector := X"0080";
     DATA_WIDTH : integer := 4;
     DO_REG : integer := 1;
     EN_ECC_READ : boolean := FALSE;
     EN_ECC_WRITE : boolean := FALSE;
     EN_SYN : boolean := FALSE;
     FIFO_MODE : string := "FIFO36";
     FIRST_WORD_FALL_THROUGH : boolean := FALSE;
     INIT : bit_vector := X"000000000000000000";
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     SRVAL : bit_vector := X"000000000000000000";
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     thold_DIP_WRCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_DIP_WRCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_DI_WRCLK_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     thold_DI_WRCLK_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     thold_INJECTDBITERR_WRCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_INJECTDBITERR_WRCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_INJECTSBITERR_WRCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_INJECTSBITERR_WRCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RDEN_RDCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RDEN_RDCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_REGCE_RDCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_REGCE_RDCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTREG_RDCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTREG_RDCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_WREN_WRCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_WREN_WRCLK_posedge_posedge : VitalDelayType := 0 ps;
     ticd_RDCLK : VitalDelayType := 0 ps;
     ticd_WRCLK : VitalDelayType := 0 ps;
     tipd_DI : VitalDelayArrayType01 (63 downto 0) := (others => (0 ps, 0 ps));
     tipd_DIP : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
     tipd_INJECTDBITERR : VitalDelayType01 := (0 ps, 0 ps);
     tipd_INJECTSBITERR : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RDCLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RDEN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_REGCE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RST : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RSTREG : VitalDelayType01 := (0 ps, 0 ps);
     tipd_WRCLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_WREN : VitalDelayType01 := (0 ps, 0 ps);
     tisd_DIP_WRCLK : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tisd_DI_WRCLK : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     tisd_INJECTDBITERR_WRCLK : VitalDelayType := 0 ps;
     tisd_INJECTSBITERR_WRCLK : VitalDelayType := 0 ps;
     tisd_RDEN_RDCLK : VitalDelayType := 0 ps;
     tisd_REGCE_RDCLK : VitalDelayType := 0 ps;
     tisd_RSTREG_RDCLK : VitalDelayType := 0 ps;
     tisd_RST_RDCLK : VitalDelayType := 0 ps;
     tisd_RST_WRCLK : VitalDelayType := 0 ps;
     tisd_WREN_WRCLK : VitalDelayType := 0 ps;
     tpd_RDCLK_ALMOSTEMPTY : VitalDelayType01 := (100 ps, 100 ps);
     tpd_RDCLK_DBITERR : VitalDelayType01 := (100 ps, 100 ps);
     tpd_RDCLK_DO : VitalDelayArrayType01(63 downto 0) := (others => (100 ps, 100 ps));
     tpd_RDCLK_DOP : VitalDelayArrayType01(7 downto 0) := (others => (100 ps, 100 ps));
     tpd_RDCLK_EMPTY : VitalDelayType01 := (100 ps, 100 ps);
     tpd_RDCLK_RDCOUNT : VitalDelayArrayType01(12 downto 0) := (others => (100 ps, 100 ps));
     tpd_RDCLK_RDERR : VitalDelayType01 := (100 ps, 100 ps);
     tpd_RDCLK_SBITERR : VitalDelayType01 := (100 ps, 100 ps);
     tpd_RST_ALMOSTEMPTY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RST_ALMOSTFULL : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RST_EMPTY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RST_FULL : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RST_RDCOUNT : VitalDelayArrayType01(12 downto 0) := (others => (0 ps, 0 ps));
     tpd_RST_RDERR : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RST_WRCOUNT : VitalDelayArrayType01(12 downto 0) := (others => (0 ps, 0 ps));
     tpd_RST_WRERR : VitalDelayType01 := (0 ps, 0 ps);
     tpd_WRCLK_ALMOSTFULL : VitalDelayType01 := (100 ps, 100 ps);
     tpd_WRCLK_ECCPARITY : VitalDelayArrayType01(7 downto 0) := (others => (100 ps, 100 ps));
     tpd_WRCLK_FULL : VitalDelayType01 := (100 ps, 100 ps);
     tpd_WRCLK_WRCOUNT : VitalDelayArrayType01(12 downto 0) := (others => (100 ps, 100 ps));
     tpd_WRCLK_WRERR : VitalDelayType01 := (100 ps, 100 ps);
     tperiod_RDCLK_posedge : VitalDelayType := 0 ps;
     tperiod_WRCLK_posedge : VitalDelayType := 0 ps;
     tpw_RDCLK_negedge : VitalDelayType := 0 ps;
     tpw_RDCLK_posedge : VitalDelayType := 0 ps;
     tpw_RST_negedge : VitalDelayType := 0 ps;
     tpw_RST_posedge : VitalDelayType := 0 ps;
     tpw_WRCLK_negedge : VitalDelayType := 0 ps;
     tpw_WRCLK_posedge : VitalDelayType := 0 ps;
     trecovery_RST_RDCLK_negedge_posedge : VitalDelayType := 0 ps;
     trecovery_RST_WRCLK_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_RST_RDCLK_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_RST_WRCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_DIP_WRCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_DIP_WRCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_DI_WRCLK_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     tsetup_DI_WRCLK_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     tsetup_INJECTDBITERR_WRCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_INJECTDBITERR_WRCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_INJECTSBITERR_WRCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_INJECTSBITERR_WRCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RDEN_RDCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RDEN_RDCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_REGCE_RDCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_REGCE_RDCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTREG_RDCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTREG_RDCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_WREN_WRCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_WREN_WRCLK_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     ALMOSTEMPTY : out std_ulogic;
     ALMOSTFULL : out std_ulogic;
     DBITERR : out std_ulogic;
     DO : out std_logic_vector (63 downto 0);
     DOP : out std_logic_vector (7 downto 0);
     ECCPARITY : out std_logic_vector (7 downto 0);
     EMPTY : out std_ulogic;
     FULL : out std_ulogic;
     RDCOUNT : out std_logic_vector (12 downto 0);
     RDERR : out std_ulogic;
     SBITERR : out std_ulogic;
     WRCOUNT : out std_logic_vector (12 downto 0);
     WRERR : out std_ulogic;
     DI : in std_logic_vector (63 downto 0);
     DIP : in std_logic_vector (7 downto 0);
     INJECTDBITERR : in std_ulogic;
     INJECTSBITERR : in std_ulogic;
     RDCLK : in std_ulogic;
     RDEN : in std_ulogic;
     REGCE : in std_ulogic;
     RST : in std_ulogic;
     RSTREG : in std_ulogic;
     WRCLK : in std_ulogic;
     WREN : in std_ulogic
  );
end component;

----- component X_FIFO36_72_EXP -----
component X_FIFO36_72_EXP
  generic (
     ALMOST_EMPTY_OFFSET : bit_vector := X"080";
     ALMOST_FULL_OFFSET : bit_vector := X"080";
     DO_REG : integer := 1;
     EN_ECC_READ : boolean := FALSE;
     EN_ECC_WRITE : boolean := FALSE;
     EN_SYN : boolean := FALSE;
     FIRST_WORD_FALL_THROUGH : boolean := FALSE;
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     tbpd_RST_ALMOSTEMPTY_RDCLKL : VitalDelayType01 := ( 0 ps, 0 ps);
     tbpd_RST_ALMOSTFULL_WRCLKL : VitalDelayType01 := ( 0 ps, 0 ps);
     tbpd_RST_EMPTY_RDCLKL : VitalDelayType01 := ( 0 ps, 0 ps);
     tbpd_RST_FULL_WRCLKL : VitalDelayType01 := ( 0 ps, 0 ps);
     tbpd_RST_RDCOUNT_RDCLKL : VitalDelayArrayType01 (12 downto 0) := (others => (0 ps, 0 ps));
     tbpd_RST_RDERR_RDCLKL : VitalDelayType01 := ( 0 ps, 0 ps);
     tbpd_RST_WRCOUNT_WRCLKL : VitalDelayArrayType01 (12 downto 0) := (others => (0 ps, 0 ps));
     tbpd_RST_WRERR_WRCLKL : VitalDelayType01 := ( 0 ps, 0 ps);
     thold_DIP_WRCLKL_negedge_posedge : VitalDelayArrayType (7 downto 0) := (others => 0 ps);
     thold_DIP_WRCLKL_posedge_posedge : VitalDelayArrayType (7 downto 0) := (others => 0 ps);
     thold_DI_WRCLKL_negedge_posedge : VitalDelayArrayType (63 downto 0) := (others => 0 ps);
     thold_DI_WRCLKL_posedge_posedge : VitalDelayArrayType (63 downto 0) := (others => 0 ps);
     thold_RDEN_RDCLKL_negedge_posedge : VitalDelayType := 0 ps;
     thold_RDEN_RDCLKL_posedge_posedge : VitalDelayType := 0 ps;
     thold_RDEN_RDRCLKL_negedge_posedge : VitalDelayType := 0 ps;
     thold_RDEN_RDRCLKL_posedge_posedge : VitalDelayType := 0 ps;
     thold_WREN_WRCLKL_negedge_posedge : VitalDelayType := 0 ps;
     thold_WREN_WRCLKL_posedge_posedge : VitalDelayType := 0 ps;
     ticd_RDCLKL : VitalDelayType := 0 ps;
     ticd_RDRCLKL : VitalDelayType := 0 ps;
     ticd_WRCLKL : VitalDelayType := 0 ps;
     tipd_DI : VitalDelayArrayType01(63 downto 0) := (others => (0 ps, 0 ps));
     tipd_DIP : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
     tipd_RDCLKL : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RDEN : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RDRCLKL : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RST : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_WRCLKL : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_WREN : VitalDelayType01 := ( 0 ps, 0 ps);
     tisd_DIP_WRCLKL : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tisd_DI_WRCLKL : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     tisd_RDEN_RDCLKL : VitalDelayType := 0 ps;
     tisd_RDEN_RDRCLKL : VitalDelayType := 0 ps;
     tisd_RST_RDCLKL : VitalDelayType := 0 ps;
     tisd_RST_RDRCLKL : VitalDelayType := 0 ps;
     tisd_RST_WRCLKL : VitalDelayType := 0 ps;
     tisd_WREN_WRCLKL : VitalDelayType := 0 ps;
     tpd_RDCLKL_ALMOSTEMPTY : VitalDelayType01 := ( 100 ps, 100 ps);
     tpd_RDCLKL_DBITERR : VitalDelayType01 := (100 ps, 100 ps);
     tpd_RDCLKL_DO : VitalDelayArrayType01 (63 downto 0) := (others => (100 ps, 100 ps));
     tpd_RDCLKL_DOP : VitalDelayArrayType01 (7 downto 0) := (others => (100 ps, 100 ps));
     tpd_RDCLKL_EMPTY : VitalDelayType01 := ( 100 ps, 100 ps);
     tpd_RDCLKL_RDCOUNT : VitalDelayArrayType01 (12 downto 0) := (others => (100 ps, 100 ps));
     tpd_RDCLKL_RDERR : VitalDelayType01 := ( 100 ps, 100 ps);
     tpd_RDCLKL_SBITERR : VitalDelayType01 := (100 ps, 100 ps);
     tpd_RDRCLKL_ALMOSTEMPTY : VitalDelayType01 := ( 100 ps, 100 ps);
     tpd_RDRCLKL_DBITERR : VitalDelayType01 := (100 ps, 100 ps);
     tpd_RDRCLKL_DO : VitalDelayArrayType01 (63 downto 0) := (others => (100 ps, 100 ps));
     tpd_RDRCLKL_DOP : VitalDelayArrayType01 (7 downto 0) := (others => (100 ps, 100 ps));
     tpd_RDRCLKL_EMPTY : VitalDelayType01 := ( 100 ps, 100 ps);
     tpd_RDRCLKL_RDCOUNT : VitalDelayArrayType01 (12 downto 0) := (others => (100 ps, 100 ps));
     tpd_RDRCLKL_RDERR : VitalDelayType01 := ( 100 ps, 100 ps);
     tpd_RDRCLKL_SBITERR : VitalDelayType01 := (100 ps, 100 ps);
     tpd_RST_ALMOSTEMPTY : VitalDelayType01 := ( 0 ps, 0 ps);
     tpd_RST_ALMOSTFULL : VitalDelayType01 := ( 0 ps, 0 ps);
     tpd_RST_EMPTY : VitalDelayType01 := ( 0 ps, 0 ps);
     tpd_RST_FULL : VitalDelayType01 := ( 0 ps, 0 ps);
     tpd_RST_RDCOUNT : VitalDelayArrayType01 (12 downto 0) := (others => (0 ps, 0 ps));
     tpd_RST_RDERR : VitalDelayType01 := ( 0 ps, 0 ps);
     tpd_RST_WRCOUNT : VitalDelayArrayType01 (12 downto 0) := (others => (0 ps, 0 ps));
     tpd_RST_WRERR : VitalDelayType01 := ( 0 ps, 0 ps);
     tpd_WRCLKL_ALMOSTFULL : VitalDelayType01 := ( 100 ps, 100 ps);
     tpd_WRCLKL_ECCPARITY : VitalDelayArrayType01(7 downto 0) := (others => (100 ps, 100 ps));
     tpd_WRCLKL_FULL : VitalDelayType01 := ( 100 ps, 100 ps);
     tpd_WRCLKL_WRCOUNT : VitalDelayArrayType01 (12 downto 0) := (others => (100 ps, 100 ps));
     tpd_WRCLKL_WRERR : VitalDelayType01 := ( 100 ps, 100 ps);
     tperiod_RDCLKL_posedge : VitalDelayType := 0 ps;
     tperiod_RDRCLKL_posedge : VitalDelayType := 0 ps;
     tperiod_WRCLKL_posedge : VitalDelayType := 0 ps;
     tpw_RDCLKL_negedge : VitalDelayType := 0 ps;
     tpw_RDCLKL_posedge : VitalDelayType := 0 ps;
     tpw_RDRCLKL_negedge : VitalDelayType := 0 ps;
     tpw_RDRCLKL_posedge : VitalDelayType := 0 ps;
     tpw_RST_negedge : VitalDelayType := 0 ps;
     tpw_RST_posedge : VitalDelayType := 0 ps;
     tpw_WRCLKL_negedge : VitalDelayType := 0 ps;
     tpw_WRCLKL_posedge : VitalDelayType := 0 ps;
     trecovery_RST_RDCLKL_negedge_posedge : VitalDelayType := 0 ps;
     trecovery_RST_RDRCLKL_negedge_posedge : VitalDelayType := 0 ps;
     trecovery_RST_WRCLKL_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_RST_RDCLKL_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_RST_RDRCLKL_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_RST_WRCLKL_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_DIP_WRCLKL_negedge_posedge : VitalDelayArrayType (7 downto 0) := (others => 0 ps);
     tsetup_DIP_WRCLKL_posedge_posedge : VitalDelayArrayType (7 downto 0) := (others => 0 ps);
     tsetup_DI_WRCLKL_negedge_posedge : VitalDelayArrayType (63 downto 0) := (others => 0 ps);
     tsetup_DI_WRCLKL_posedge_posedge : VitalDelayArrayType (63 downto 0) := (others => 0 ps);
     tsetup_RDEN_RDCLKL_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RDEN_RDCLKL_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RDEN_RDRCLKL_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RDEN_RDRCLKL_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_WREN_WRCLKL_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_WREN_WRCLKL_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     ALMOSTEMPTY : out std_ulogic;
     ALMOSTFULL : out std_ulogic;
     DBITERR : out std_ulogic;
     DO : out std_logic_vector (63 downto 0);
     DOP : out std_logic_vector (7 downto 0);
     ECCPARITY : out std_logic_vector (7 downto 0);
     EMPTY : out std_ulogic;
     FULL : out std_ulogic;
     RDCOUNT : out std_logic_vector (12 downto 0);
     RDERR : out std_ulogic;
     SBITERR : out std_ulogic;
     WRCOUNT : out std_logic_vector (12 downto 0);
     WRERR : out std_ulogic;
     DI : in std_logic_vector (63 downto 0);
     DIP : in std_logic_vector (7 downto 0);
     RDCLKL : in std_ulogic;
     RDCLKU : in std_ulogic;
     RDEN : in std_ulogic;
     RDRCLKL : in std_ulogic;
     RDRCLKU : in std_ulogic;
     RST : in std_ulogic;
     WRCLKL : in std_ulogic;
     WRCLKU : in std_ulogic;
     WREN : in std_ulogic
  );
end component;

----- component X_FIFO36_EXP -----
component X_FIFO36_EXP
  generic (
     ALMOST_EMPTY_OFFSET : bit_vector := X"0080";
     ALMOST_FULL_OFFSET : bit_vector := X"0080";
     DATA_WIDTH : integer := 4;
     DO_REG : integer := 1;
     EN_SYN : boolean := FALSE;
     FIRST_WORD_FALL_THROUGH : boolean := FALSE;
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     tbpd_RST_ALMOSTEMPTY_RDCLKL : VitalDelayType01 := ( 0 ps, 0 ps);
     tbpd_RST_ALMOSTFULL_WRCLKL : VitalDelayType01 := ( 0 ps, 0 ps);
     tbpd_RST_EMPTY_RDCLKL : VitalDelayType01 := ( 0 ps, 0 ps);
     tbpd_RST_FULL_WRCLKL : VitalDelayType01 := ( 0 ps, 0 ps);
     tbpd_RST_RDCOUNT_RDCLKL : VitalDelayArrayType01 (12 downto 0) := (others => (0 ps, 0 ps));
     tbpd_RST_RDERR_RDCLKL : VitalDelayType01 := ( 0 ps, 0 ps);
     tbpd_RST_WRCOUNT_WRCLKL : VitalDelayArrayType01 (12 downto 0) := (others => (0 ps, 0 ps));
     tbpd_RST_WRERR_WRCLKL : VitalDelayType01 := ( 0 ps, 0 ps);
     thold_DIP_WRCLKL_negedge_posedge : VitalDelayArrayType (3 downto 0) := (others => 0 ps);
     thold_DIP_WRCLKL_posedge_posedge : VitalDelayArrayType (3 downto 0) := (others => 0 ps);
     thold_DI_WRCLKL_negedge_posedge : VitalDelayArrayType (31 downto 0) := (others => 0 ps);
     thold_DI_WRCLKL_posedge_posedge : VitalDelayArrayType (31 downto 0) := (others => 0 ps);
     thold_RDEN_RDCLKL_negedge_posedge : VitalDelayType := 0 ps;
     thold_RDEN_RDCLKL_posedge_posedge : VitalDelayType := 0 ps;
     thold_RDEN_RDRCLKL_negedge_posedge : VitalDelayType := 0 ps;
     thold_RDEN_RDRCLKL_posedge_posedge : VitalDelayType := 0 ps;
     thold_WREN_WRCLKL_negedge_posedge : VitalDelayType := 0 ps;
     thold_WREN_WRCLKL_posedge_posedge : VitalDelayType := 0 ps;
     ticd_RDCLKL : VitalDelayType := 0 ps;
     ticd_RDRCLKL : VitalDelayType := 0 ps;
     ticd_WRCLKL : VitalDelayType := 0 ps;
     tipd_DI : VitalDelayArrayType01(31 downto 0) := (others => (0 ps, 0 ps));
     tipd_DIP : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tipd_RDCLKL : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RDEN : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RDRCLKL : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_RST : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_WRCLKL : VitalDelayType01 := ( 0 ps, 0 ps);
     tipd_WREN : VitalDelayType01 := ( 0 ps, 0 ps);
     tisd_DIP_WRCLKL : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_DI_WRCLKL : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tisd_RDEN_RDCLKL : VitalDelayType := 0 ps;
     tisd_RDEN_RDRCLKL : VitalDelayType := 0 ps;
     tisd_RST_RDCLKL : VitalDelayType := 0 ps;
     tisd_RST_RDRCLKL : VitalDelayType := 0 ps;
     tisd_RST_WRCLKL : VitalDelayType := 0 ps;
     tisd_WREN_WRCLKL : VitalDelayType := 0 ps;
     tpd_RDCLKL_ALMOSTEMPTY : VitalDelayType01 := ( 100 ps, 100 ps);
     tpd_RDCLKL_DO : VitalDelayArrayType01 (31 downto 0) := (others => (100 ps, 100 ps));
     tpd_RDCLKL_DOP : VitalDelayArrayType01 (3 downto 0) := (others => (100 ps, 100 ps));
     tpd_RDCLKL_EMPTY : VitalDelayType01 := ( 100 ps, 100 ps);
     tpd_RDCLKL_RDCOUNT : VitalDelayArrayType01 (12 downto 0) := (others => (100 ps, 100 ps));
     tpd_RDCLKL_RDERR : VitalDelayType01 := ( 100 ps, 100 ps);
     tpd_RDRCLKL_ALMOSTEMPTY : VitalDelayType01 := ( 100 ps, 100 ps);
     tpd_RDRCLKL_DO : VitalDelayArrayType01 (31 downto 0) := (others => (100 ps, 100 ps));
     tpd_RDRCLKL_DOP : VitalDelayArrayType01 (3 downto 0) := (others => (100 ps, 100 ps));
     tpd_RDRCLKL_EMPTY : VitalDelayType01 := ( 100 ps, 100 ps);
     tpd_RDRCLKL_RDCOUNT : VitalDelayArrayType01 (12 downto 0) := (others => (100 ps, 100 ps));
     tpd_RDRCLKL_RDERR : VitalDelayType01 := ( 100 ps, 100 ps);
     tpd_RST_ALMOSTEMPTY : VitalDelayType01 := ( 0 ps, 0 ps);
     tpd_RST_ALMOSTFULL : VitalDelayType01 := ( 0 ps, 0 ps);
     tpd_RST_EMPTY : VitalDelayType01 := ( 0 ps, 0 ps);
     tpd_RST_FULL : VitalDelayType01 := ( 0 ps, 0 ps);
     tpd_RST_RDCOUNT : VitalDelayArrayType01 (12 downto 0) := (others => (0 ps, 0 ps));
     tpd_RST_RDERR : VitalDelayType01 := ( 0 ps, 0 ps);
     tpd_RST_WRCOUNT : VitalDelayArrayType01 (12 downto 0) := (others => (0 ps, 0 ps));
     tpd_RST_WRERR : VitalDelayType01 := ( 0 ps, 0 ps);
     tpd_WRCLKL_ALMOSTFULL : VitalDelayType01 := ( 100 ps, 100 ps);
     tpd_WRCLKL_FULL : VitalDelayType01 := ( 100 ps, 100 ps);
     tpd_WRCLKL_WRCOUNT : VitalDelayArrayType01 (12 downto 0) := (others => (100 ps, 100 ps));
     tpd_WRCLKL_WRERR : VitalDelayType01 := ( 100 ps, 100 ps);
     tperiod_RDCLKL_posedge : VitalDelayType := 0 ps;
     tperiod_RDRCLKL_posedge : VitalDelayType := 0 ps;
     tperiod_WRCLKL_posedge : VitalDelayType := 0 ps;
     tpw_RDCLKL_negedge : VitalDelayType := 0 ps;
     tpw_RDCLKL_posedge : VitalDelayType := 0 ps;
     tpw_RDRCLKL_negedge : VitalDelayType := 0 ps;
     tpw_RDRCLKL_posedge : VitalDelayType := 0 ps;
     tpw_RST_negedge : VitalDelayType := 0 ps;
     tpw_RST_posedge : VitalDelayType := 0 ps;
     tpw_WRCLKL_negedge : VitalDelayType := 0 ps;
     tpw_WRCLKL_posedge : VitalDelayType := 0 ps;
     trecovery_RST_RDCLKL_negedge_posedge : VitalDelayType := 0 ps;
     trecovery_RST_RDRCLKL_negedge_posedge : VitalDelayType := 0 ps;
     trecovery_RST_WRCLKL_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_RST_RDCLKL_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_RST_RDRCLKL_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_RST_WRCLKL_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_DIP_WRCLKL_negedge_posedge : VitalDelayArrayType (3 downto 0) := (others => 0 ps);
     tsetup_DIP_WRCLKL_posedge_posedge : VitalDelayArrayType (3 downto 0) := (others => 0 ps);
     tsetup_DI_WRCLKL_negedge_posedge : VitalDelayArrayType (31 downto 0) := (others => 0 ps);
     tsetup_DI_WRCLKL_posedge_posedge : VitalDelayArrayType (31 downto 0) := (others => 0 ps);
     tsetup_RDEN_RDCLKL_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RDEN_RDCLKL_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RDEN_RDRCLKL_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RDEN_RDRCLKL_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_WREN_WRCLKL_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_WREN_WRCLKL_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     ALMOSTEMPTY : out std_ulogic;
     ALMOSTFULL : out std_ulogic;
     DO : out std_logic_vector (31 downto 0);
     DOP : out std_logic_vector (3 downto 0);
     EMPTY : out std_ulogic;
     FULL : out std_ulogic;
     RDCOUNT : out std_logic_vector (12 downto 0);
     RDERR : out std_ulogic;
     WRCOUNT : out std_logic_vector (12 downto 0);
     WRERR : out std_ulogic;
     DI : in std_logic_vector (31 downto 0);
     DIP : in std_logic_vector (3 downto 0);
     RDCLKL : in std_ulogic;
     RDCLKU : in std_ulogic;
     RDEN : in std_ulogic;
     RDRCLKL : in std_ulogic;
     RDRCLKU : in std_ulogic;
     RST : in std_ulogic;
     WRCLKL : in std_ulogic;
     WRCLKU : in std_ulogic;
     WREN : in std_ulogic
  );
end component;

----- component X_FRAME_ECC_VIRTEX6 -----
component X_FRAME_ECC_VIRTEX6
  generic (
     FARSRC : string:= "EFAR";
     FRAME_RBT_IN_FILENAME : string := "frame_rbt_v6.txt";
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := FALSE;
     TimingChecksOn : boolean := TRUE;
     Xon : boolean := TRUE
  );
  port (
     CRCERROR : out std_ulogic;
     ECCERROR : out std_ulogic;
     ECCERRORSINGLE : out std_ulogic;
     FAR : out std_logic_vector(23 downto 0);
     SYNBIT : out std_logic_vector(4 downto 0);
     SYNDROME : out std_logic_vector(12 downto 0);
     SYNDROMEVALID : out std_ulogic;
     SYNWORD : out std_logic_vector(6 downto 0)
  );
end component;

----- component X_GT11 -----
component X_GT11
  generic (
     ALIGN_COMMA_WORD : integer := 4;
     BANDGAPSEL : boolean := FALSE;
     BIASRESSEL : boolean := FALSE;
     CCCB_ARBITRATOR_DISABLE : boolean := FALSE;
     CHAN_BOND_LIMIT : integer := 16;
     CHAN_BOND_MODE : string := "NONE";
     CHAN_BOND_ONE_SHOT : boolean := FALSE;
     CHAN_BOND_SEQ_1_1 : bit_vector := "00000000000";
     CHAN_BOND_SEQ_1_2 : bit_vector := "00000000000";
     CHAN_BOND_SEQ_1_3 : bit_vector := "00000000000";
     CHAN_BOND_SEQ_1_4 : bit_vector := "00000000000";
     CHAN_BOND_SEQ_1_MASK : bit_vector := "1110";
     CHAN_BOND_SEQ_2_1 : bit_vector := "00000000000";
     CHAN_BOND_SEQ_2_2 : bit_vector := "00000000000";
     CHAN_BOND_SEQ_2_3 : bit_vector := "00000000000";
     CHAN_BOND_SEQ_2_4 : bit_vector := "00000000000";
     CHAN_BOND_SEQ_2_MASK : bit_vector := "1110";
     CHAN_BOND_SEQ_2_USE : boolean := FALSE;
     CHAN_BOND_SEQ_LEN : integer := 1;
     CLK_CORRECT_USE : boolean := FALSE;
     CLK_COR_8B10B_DE : boolean := FALSE;
     CLK_COR_MAX_LAT : integer := 48;
     CLK_COR_MIN_LAT : integer := 36;
     CLK_COR_SEQ_1_1 : bit_vector := "00000000000";
     CLK_COR_SEQ_1_2 : bit_vector := "00000000000";
     CLK_COR_SEQ_1_3 : bit_vector := "00000000000";
     CLK_COR_SEQ_1_4 : bit_vector := "00000000000";
     CLK_COR_SEQ_1_MASK : bit_vector := "1110";
     CLK_COR_SEQ_2_1 : bit_vector := "00000000000";
     CLK_COR_SEQ_2_2 : bit_vector := "00000000000";
     CLK_COR_SEQ_2_3 : bit_vector := "00000000000";
     CLK_COR_SEQ_2_4 : bit_vector := "00000000000";
     CLK_COR_SEQ_2_MASK : bit_vector := "1110";
     CLK_COR_SEQ_2_USE : boolean := FALSE;
     CLK_COR_SEQ_DROP : boolean := FALSE;
     CLK_COR_SEQ_LEN : integer := 1;
     COMMA32 : boolean := FALSE;
     COMMA_10B_MASK : bit_vector := X"3FF";
     CYCLE_LIMIT_SEL : bit_vector := "00";
     DCDR_FILTER : bit_vector := "010";
     DEC_MCOMMA_DETECT : boolean := TRUE;
     DEC_PCOMMA_DETECT : boolean := TRUE;
     DEC_VALID_COMMA_ONLY : boolean := TRUE;
     DIGRX_FWDCLK : bit_vector := "00";
     DIGRX_SYNC_MODE : boolean := FALSE;
     ENABLE_DCDR : boolean := FALSE;
     FDET_HYS_CAL : bit_vector := "010";
     FDET_HYS_SEL : bit_vector := "100";
     FDET_LCK_CAL : bit_vector := "100";
     FDET_LCK_SEL : bit_vector := "001";
     GT11_MODE : string := "DONT_CARE";
     IN_DELAY : time := 0 ps;
     IREFBIASMODE : bit_vector := "11";
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     LOOPCAL_WAIT : bit_vector := "00";
     MCOMMA_32B_VALUE : bit_vector := X"00000000";
     MCOMMA_DETECT : boolean := TRUE;
     MsgOn : boolean := TRUE;
     OPPOSITE_SELECT : boolean := FALSE;
     OUT_DELAY : VitalDelayType01 := (0 ps, 0 ps);
     PCOMMA_32B_VALUE : bit_vector := X"00000000";
     PCOMMA_DETECT : boolean := TRUE;
     PCS_BIT_SLIP : boolean := FALSE;
     PMACLKENABLE : boolean := TRUE;
     PMACOREPWRENABLE : boolean := TRUE;
     PMAIREFTRIM : bit_vector := "0111";
     PMAVBGCTRL : bit_vector := "00000";
     PMAVREFTRIM : bit_vector := "0111";
     PMA_BIT_SLIP : boolean := FALSE;
     POWER_ENABLE : boolean := TRUE;
     REPEATER : boolean := FALSE;
     RXACTST : boolean := FALSE;
     RXAFEEQ : bit_vector := "000000000";
     RXAFEPD : boolean := FALSE;
     RXAFETST : boolean := FALSE;
     RXAPD : boolean := FALSE;
     RXAREGCTRL : bit_vector := "00000";
     RXASYNCDIVIDE : bit_vector := "11";
     RXBY_32 : boolean := FALSE;
     RXCDRLOS : bit_vector := "000000";
     RXCLK0_FORCE_PMACLK : boolean := FALSE;
     RXCLKMODE : bit_vector := "110001";
     RXCLMODE : bit_vector := "00";
     RXCMADJ : bit_vector := "01";
     RXCPSEL : boolean := TRUE;
     RXCPTST : boolean := FALSE;
     RXCRCCLOCKDOUBLE : boolean := FALSE;
     RXCRCENABLE : boolean := FALSE;
     RXCRCINITVAL : bit_vector := X"00000000";
     RXCRCINVERTGEN : boolean := FALSE;
     RXCRCSAMECLOCK : boolean := FALSE;
     RXCTRL1 : bit_vector := X"200";
     RXCYCLE_LIMIT_SEL : bit_vector := "00";
     RXDATA_SEL : bit_vector := "00";
     RXDCCOUPLE : boolean := FALSE;
     RXDIGRESET : boolean := FALSE;
     RXDIGRX : boolean := FALSE;
     RXEQ : bit_vector := X"4000000000000000";
     RXFDCAL_CLOCK_DIVIDE : string := "NONE";
     RXFDET_HYS_CAL : bit_vector := "010";
     RXFDET_HYS_SEL : bit_vector := "100";
     RXFDET_LCK_CAL : bit_vector := "100";
     RXFDET_LCK_SEL : bit_vector := "001";
     RXFECONTROL1 : bit_vector := "00";
     RXFECONTROL2 : bit_vector := "000";
     RXFETUNE : bit_vector := "01";
     RXLB : boolean := FALSE;
     RXLKADJ : bit_vector := "00000";
     RXLKAPD : boolean := FALSE;
     RXLOOPCAL_WAIT : bit_vector := "00";
     RXLOOPFILT : bit_vector := "0111";
     RXMODE : bit_vector := "000000";
     RXOUTDIV2SEL : integer := 1;
     RXPD : boolean := FALSE;
     RXPDDTST : boolean := TRUE;
     RXPLLNDIVSEL : integer := 8;
     RXPMACLKSEL : string := "REFCLK1";
     RXRCPADJ : bit_vector := "011";
     RXRCPPD : boolean := FALSE;
     RXRECCLK1_USE_SYNC : boolean := FALSE;
     RXRIBADJ : bit_vector := "11";
     RXRPDPD : boolean := FALSE;
     RXRSDPD : boolean := FALSE;
     RXSLOWDOWN_CAL : bit_vector := "00";
     RXTUNE : bit_vector := X"0000";
     RXUSRDIVISOR : integer := 1;
     RXVCODAC_INIT : bit_vector := "1010000000";
     RXVCO_CTRL_ENABLE : boolean := FALSE;
     RX_BUFFER_USE : boolean := TRUE;
     RX_CLOCK_DIVIDER : bit_vector := "00";
     SAMPLE_8X : boolean := FALSE;
     SH_CNT_MAX : integer := 64;
     SH_INVALID_CNT_MAX : integer := 16;
     SLOWDOWN_CAL : bit_vector := "00";
     TXABPMACLKSEL : string := "REFCLK1";
     TXAPD : boolean := FALSE;
     TXAREFBIASSEL : boolean := TRUE;
     TXASYNCDIVIDE : bit_vector := "11";
     TXCLK0_FORCE_PMACLK : boolean := FALSE;
     TXCLKMODE : bit_vector := "1001";
     TXCLMODE : bit_vector := "00";
     TXCPSEL : boolean := TRUE;
     TXCRCCLOCKDOUBLE : boolean := FALSE;
     TXCRCENABLE : boolean := FALSE;
     TXCRCINITVAL : bit_vector := X"00000000";
     TXCRCINVERTGEN : boolean := FALSE;
     TXCRCSAMECLOCK : boolean := FALSE;
     TXCTRL1 : bit_vector := X"200";
     TXDATA_SEL : bit_vector := "00";
     TXDAT_PRDRV_DAC : bit_vector := "111";
     TXDAT_TAP_DAC : bit_vector := "10110";
     TXDIGPD : boolean := FALSE;
     TXFDCAL_CLOCK_DIVIDE : string := "NONE";
     TXHIGHSIGNALEN : boolean := TRUE;
     TXLOOPFILT : bit_vector := "0111";
     TXLVLSHFTPD : boolean := FALSE;
     TXOUTCLK1_USE_SYNC : boolean := FALSE;
     TXOUTDIV2SEL : integer := 1;
     TXPD : boolean := FALSE;
     TXPHASESEL : boolean := FALSE;
     TXPLLNDIVSEL : integer := 8;
     TXPOST_PRDRV_DAC : bit_vector := "111";
     TXPOST_TAP_DAC : bit_vector := "01110";
     TXPOST_TAP_PD : boolean := TRUE;
     TXPRE_PRDRV_DAC : bit_vector := "111";
     TXPRE_TAP_DAC : bit_vector := "00000";
     TXPRE_TAP_PD : boolean := TRUE;
     TXSLEWRATE : boolean := FALSE;
     TXTERMTRIM : bit_vector := "1100";
     TXTUNE : bit_vector := X"0000";
     TX_BUFFER_USE : boolean := TRUE;
     TX_CLOCK_DIVIDER : bit_vector := "00";
     TimingChecksOn : boolean := TRUE;
     VCODAC_INIT : bit_vector := "1010000000";
     VCO_CTRL_ENABLE : boolean := FALSE;
     VREFBIASMODE : bit_vector := "11";
     Xon : boolean := TRUE;
     thold_CHBONDI_RXUSRCLK_negedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0.0 ns);
     thold_CHBONDI_RXUSRCLK_posedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0.0 ns);
     thold_DADDR_DCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     thold_DADDR_DCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     thold_DEN_DCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_DEN_DCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_DI_DCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0.0 ns);
     thold_DI_DCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0.0 ns);
     thold_DWE_DCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_DWE_DCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_ENCHANSYNC_RXUSRCLK2_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_ENCHANSYNC_RXUSRCLK2_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_ENMCOMMAALIGN_RXUSRCLK2_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_ENMCOMMAALIGN_RXUSRCLK2_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_ENPCOMMAALIGN_RXUSRCLK2_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_ENPCOMMAALIGN_RXUSRCLK2_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_RXCLKSTABLE_RXUSRCLK2_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_RXCLKSTABLE_RXUSRCLK2_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_RXCOMMADETUSE_RXUSRCLK2_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_RXCOMMADETUSE_RXUSRCLK2_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_RXCRCDATAVALID_RXCRCINTCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_RXCRCDATAVALID_RXCRCINTCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_RXCRCDATAWIDTH_RXCRCINTCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0.0 ns);
     thold_RXCRCDATAWIDTH_RXCRCINTCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0.0 ns);
     thold_RXCRCINIT_RXCRCINTCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_RXCRCINIT_RXCRCINTCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_RXCRCIN_RXCRCINTCLK_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0.0 ns);
     thold_RXCRCIN_RXCRCINTCLK_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0.0 ns);
     thold_RXCRCRESET_RXCRCINTCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_RXCRCRESET_RXCRCINTCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_RXIGNOREBTF_RXUSRCLK2_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_RXIGNOREBTF_RXUSRCLK2_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_RXPMARESET_RXUSRCLK2_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_RXPMARESET_RXUSRCLK2_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_RXRESET_RXUSRCLK2_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_RXRESET_RXUSRCLK2_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_RXSLIDE_RXUSRCLK2_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_RXSLIDE_RXUSRCLK2_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_RXSYNC_RXUSRCLK2_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_RXSYNC_RXUSRCLK2_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_TXBYPASS8B10B_TXUSRCLK2_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     thold_TXBYPASS8B10B_TXUSRCLK2_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     thold_TXCHARDISPMODE_TXUSRCLK2_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     thold_TXCHARDISPMODE_TXUSRCLK2_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     thold_TXCHARDISPVAL_TXUSRCLK2_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     thold_TXCHARDISPVAL_TXUSRCLK2_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     thold_TXCHARISK_TXUSRCLK2_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     thold_TXCHARISK_TXUSRCLK2_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     thold_TXCLKSTABLE_TXUSRCLK2_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_TXCLKSTABLE_TXUSRCLK2_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_TXCRCDATAVALID_TXCRCINTCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_TXCRCDATAVALID_TXCRCINTCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_TXCRCDATAWIDTH_TXCRCINTCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0.0 ns);
     thold_TXCRCDATAWIDTH_TXCRCINTCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0.0 ns);
     thold_TXCRCINIT_TXCRCINTCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_TXCRCINIT_TXCRCINTCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_TXCRCIN_TXCRCINTCLK_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0.0 ns);
     thold_TXCRCIN_TXCRCINTCLK_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0.0 ns);
     thold_TXCRCRESET_TXCRCINTCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_TXCRCRESET_TXCRCINTCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_TXDATA_TXUSRCLK2_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0.0 ns);
     thold_TXDATA_TXUSRCLK2_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0.0 ns);
     thold_TXENOOB_TXUSRCLK2_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_TXENOOB_TXUSRCLK2_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_TXPMARESET_TXUSRCLK2_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_TXPMARESET_TXUSRCLK2_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_TXRESET_TXUSRCLK2_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_TXRESET_TXUSRCLK2_posedge_posedge : VitalDelayType := 0.0 ns;
     thold_TXSYNC_TXUSRCLK2_negedge_posedge : VitalDelayType := 0.0 ns;
     thold_TXSYNC_TXUSRCLK2_posedge_posedge : VitalDelayType := 0.0 ns;
     ticd_DCLK : VitalDelayType := 0.000 ns;
     ticd_RXCRCINTCLK : VitalDelayType := 0.000 ns;
     ticd_RXUSRCLK : VitalDelayType := 0.000 ns;
     ticd_RXUSRCLK2 : VitalDelayType := 0.000 ns;
     ticd_TXCRCINTCLK : VitalDelayType := 0.000 ns;
     ticd_TXUSRCLK2 : VitalDelayType := 0.000 ns;
     tipd_CHBONDI : VitalDelayArrayType01 (4 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_COMBUSIN : VitalDelayArrayType(15 downto 0) := (others => 0.000 ns);
     tipd_DADDR : VitalDelayArrayType01 (7 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_DCLK : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_DEN : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_DI : VitalDelayArrayType01 (15 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_DWE : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_ENCHANSYNC : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_ENMCOMMAALIGN : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_ENPCOMMAALIGN : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_GREFCLK : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_GSR : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_LOOPBACK : VitalDelayArrayType01 (1 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_POWERDOWN : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_REFCLK1 : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_REFCLK2 : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_RX1N : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_RX1P : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_RXBLOCKSYNC64B66BUSE : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_RXCLKSTABLE : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_RXCOMMADETUSE : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_RXCRCCLK : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_RXCRCDATAVALID : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_RXCRCDATAWIDTH : VitalDelayArrayType01 (2 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_RXCRCIN : VitalDelayArrayType01 (63 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_RXCRCINIT : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_RXCRCINTCLK : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_RXCRCPD : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_RXCRCRESET : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_RXDATAWIDTH : VitalDelayArrayType01 (1 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_RXDEC64B66BUSE : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_RXDEC8B10BUSE : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_RXDESCRAM64B66BUSE : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_RXIGNOREBTF : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_RXINTDATAWIDTH : VitalDelayArrayType01 (1 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_RXPMARESET : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_RXPOLARITY : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_RXRESET : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_RXSLIDE : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_RXSYNC : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_RXUSRCLK : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_RXUSRCLK2 : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_TXBYPASS8B10B : VitalDelayArrayType01 (7 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_TXCHARDISPMODE : VitalDelayArrayType01 (7 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_TXCHARDISPVAL : VitalDelayArrayType01 (7 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_TXCHARISK : VitalDelayArrayType01 (7 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_TXCLKSTABLE : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_TXCRCCLK : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_TXCRCDATAVALID : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_TXCRCDATAWIDTH : VitalDelayArrayType01 (2 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_TXCRCIN : VitalDelayArrayType01 (63 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_TXCRCINIT : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_TXCRCINTCLK : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_TXCRCPD : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_TXCRCRESET : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_TXDATA : VitalDelayArrayType01 (63 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_TXDATAWIDTH : VitalDelayArrayType01 (1 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_TXENC64B66BUSE : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_TXENC8B10BUSE : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_TXENOOB : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_TXGEARBOX64B66BUSE : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_TXINHIBIT : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_TXINTDATAWIDTH : VitalDelayArrayType01 (1 downto 0) := (others => (0.0 ns, 0.0 ns));
     tipd_TXPMARESET : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_TXPOLARITY : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_TXRESET : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_TXSCRAM64B66BUSE : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_TXSYNC : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_TXUSRCLK : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_TXUSRCLK2 : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tisd_CHBONDI : VitalDelayArrayType(4 downto 0) := (others => 0.000 ns);
     tisd_DADDR : VitalDelayArrayType(7 downto 0) := (others => 0.000 ns);
     tisd_DEN : VitalDelayType := 0.000 ns;
     tisd_DI : VitalDelayArrayType(15 downto 0) := (others => 0.000 ns);
     tisd_DWE : VitalDelayType := 0.000 ns;
     tisd_ENCHANSYNC : VitalDelayType := 0.000 ns;
     tisd_ENMCOMMAALIGN : VitalDelayType := 0.000 ns;
     tisd_ENPCOMMAALIGN : VitalDelayType := 0.000 ns;
     tisd_RXCLKSTABLE : VitalDelayType := 0.000 ns;
     tisd_RXCOMMADETUSE : VitalDelayType := 0.000 ns;
     tisd_RXCRCDATAVALID : VitalDelayType := 0.000 ns;
     tisd_RXCRCDATAWIDTH : VitalDelayArrayType(2 downto 0) := (others => 0.000 ns);
     tisd_RXCRCIN : VitalDelayArrayType(63 downto 0) := (others => 0.000 ns);
     tisd_RXCRCINIT : VitalDelayType := 0.000 ns;
     tisd_RXCRCRESET : VitalDelayType := 0.000 ns;
     tisd_RXIGNOREBTF : VitalDelayType := 0.000 ns;
     tisd_RXPMARESET : VitalDelayType := 0.000 ns;
     tisd_RXRESET : VitalDelayType := 0.000 ns;
     tisd_RXSLIDE : VitalDelayType := 0.000 ns;
     tisd_RXSYNC : VitalDelayType := 0.000 ns;
     tisd_TXBYPASS8B10B : VitalDelayArrayType(7 downto 0) := (others => 0.000 ns);
     tisd_TXCHARDISPMODE : VitalDelayArrayType(7 downto 0) := (others => 0.000 ns);
     tisd_TXCHARDISPVAL : VitalDelayArrayType(7 downto 0) := (others => 0.000 ns);
     tisd_TXCHARISK : VitalDelayArrayType(7 downto 0) := (others => 0.000 ns);
     tisd_TXCLKSTABLE : VitalDelayType := 0.000 ns;
     tisd_TXCRCDATAVALID : VitalDelayType := 0.000 ns;
     tisd_TXCRCDATAWIDTH : VitalDelayArrayType(2 downto 0) := (others => 0.000 ns);
     tisd_TXCRCIN : VitalDelayArrayType(63 downto 0) := (others => 0.000 ns);
     tisd_TXCRCINIT : VitalDelayType := 0.000 ns;
     tisd_TXCRCRESET : VitalDelayType := 0.000 ns;
     tisd_TXDATA : VitalDelayArrayType(63 downto 0) := (others => 0.000 ns);
     tisd_TXENOOB : VitalDelayType := 0.000 ns;
     tisd_TXPMARESET : VitalDelayType := 0.000 ns;
     tisd_TXRESET : VitalDelayType := 0.000 ns;
     tisd_TXSYNC : VitalDelayType := 0.000 ns;
     tpd_DCLK_DO : VitalDelayArrayType01(15 downto 0) := (others => (0.1 ns, 0.1 ns));
     tpd_DCLK_DRDY : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_RXCRCINTCLK_RXCRCOUT : VitalDelayArrayType01(31 downto 0) := (others => (0.1 ns, 0.1 ns));
     tpd_RXUSRCLK2_RXBUFERR : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_RXUSRCLK2_RXCHARISCOMMA : VitalDelayArrayType01(7 downto 0) := (others => (0.1 ns, 0.1 ns));
     tpd_RXUSRCLK2_RXCHARISK : VitalDelayArrayType01(7 downto 0) := (others => (0.1 ns, 0.1 ns));
     tpd_RXUSRCLK2_RXCOMMADET : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_RXUSRCLK2_RXCYCLELIMIT : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_RXUSRCLK2_RXDATA : VitalDelayArrayType01(63 downto 0) := (others => (0.1 ns, 0.1 ns));
     tpd_RXUSRCLK2_RXDISPERR : VitalDelayArrayType01(7 downto 0) := (others => (0.1 ns, 0.1 ns));
     tpd_RXUSRCLK2_RXLOCK : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_RXUSRCLK2_RXLOSSOFSYNC : VitalDelayArrayType01(1 downto 0) := (others => (0.1 ns, 0.1 ns));
     tpd_RXUSRCLK2_RXNOTINTABLE : VitalDelayArrayType01(7 downto 0) := (others => (0.1 ns, 0.1 ns));
     tpd_RXUSRCLK2_RXREALIGN : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_RXUSRCLK2_RXRUNDISP : VitalDelayArrayType01(7 downto 0) := (others => (0.1 ns, 0.1 ns));
     tpd_RXUSRCLK2_RXSIGDET : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_RXUSRCLK2_RXSTATUS : VitalDelayArrayType01(5 downto 0) := (others => (0.1 ns, 0.1 ns));
     tpd_RXUSRCLK_CHBONDO : VitalDelayArrayType01(4 downto 0) := (others => (0.1 ns, 0.1 ns));
     tpd_TXCRCINTCLK_TXCRCOUT : VitalDelayArrayType01(31 downto 0) := (others => (0.1 ns, 0.1 ns));
     tpd_TXUSRCLK2_RXCALFAIL : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_TXUSRCLK2_TXBUFERR : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_TXUSRCLK2_TXCALFAIL : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_TXUSRCLK2_TXCYCLELIMIT : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_TXUSRCLK2_TXKERR : VitalDelayArrayType01(7 downto 0) := (others => (0.1 ns, 0.1 ns));
     tpd_TXUSRCLK2_TXLOCK : VitalDelayType01 := (0.1 ns, 0.1 ns);
     tpd_TXUSRCLK2_TXRUNDISP : VitalDelayArrayType01(7 downto 0) := (others => (0.1 ns, 0.1 ns));
     tperiod_DCLK_posedge : VitalDelayType := 0.0 ns;
     tperiod_RXCRCCLK_posedge : VitalDelayType := 0.0 ns;
     tperiod_RXCRCINTCLK_posedge : VitalDelayType := 0.0 ns;
     tperiod_RXUSRCLK2_posedge : VitalDelayType := 0.0 ns;
     tperiod_RXUSRCLK_posedge : VitalDelayType := 0.0 ns;
     tperiod_TXCRCCLK_posedge : VitalDelayType := 0.0 ns;
     tperiod_TXCRCINTCLK_posedge : VitalDelayType := 0.0 ns;
     tperiod_TXUSRCLK2_posedge : VitalDelayType := 0.0 ns;
     tperiod_TXUSRCLK_posedge : VitalDelayType := 0.0 ns;
     tsetup_CHBONDI_RXUSRCLK_negedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0.0 ns);
     tsetup_CHBONDI_RXUSRCLK_posedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0.0 ns);
     tsetup_DADDR_DCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     tsetup_DADDR_DCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     tsetup_DEN_DCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_DEN_DCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_DI_DCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0.0 ns);
     tsetup_DI_DCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0.0 ns);
     tsetup_DWE_DCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_DWE_DCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_ENCHANSYNC_RXUSRCLK2_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_ENCHANSYNC_RXUSRCLK2_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_ENMCOMMAALIGN_RXUSRCLK2_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_ENMCOMMAALIGN_RXUSRCLK2_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_ENPCOMMAALIGN_RXUSRCLK2_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_ENPCOMMAALIGN_RXUSRCLK2_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_RXCLKSTABLE_RXUSRCLK2_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_RXCLKSTABLE_RXUSRCLK2_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_RXCOMMADETUSE_RXUSRCLK2_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_RXCOMMADETUSE_RXUSRCLK2_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_RXCRCDATAVALID_RXCRCINTCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_RXCRCDATAVALID_RXCRCINTCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_RXCRCDATAWIDTH_RXCRCINTCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0.0 ns);
     tsetup_RXCRCDATAWIDTH_RXCRCINTCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0.0 ns);
     tsetup_RXCRCINIT_RXCRCINTCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_RXCRCINIT_RXCRCINTCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_RXCRCIN_RXCRCINTCLK_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0.0 ns);
     tsetup_RXCRCIN_RXCRCINTCLK_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0.0 ns);
     tsetup_RXCRCRESET_RXCRCINTCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_RXCRCRESET_RXCRCINTCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_RXIGNOREBTF_RXUSRCLK2_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_RXIGNOREBTF_RXUSRCLK2_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_RXPMARESET_RXUSRCLK2_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_RXPMARESET_RXUSRCLK2_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_RXRESET_RXUSRCLK2_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_RXRESET_RXUSRCLK2_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_RXSLIDE_RXUSRCLK2_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_RXSLIDE_RXUSRCLK2_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_RXSYNC_RXUSRCLK2_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_RXSYNC_RXUSRCLK2_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_TXBYPASS8B10B_TXUSRCLK2_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     tsetup_TXBYPASS8B10B_TXUSRCLK2_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     tsetup_TXCHARDISPMODE_TXUSRCLK2_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     tsetup_TXCHARDISPMODE_TXUSRCLK2_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     tsetup_TXCHARDISPVAL_TXUSRCLK2_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     tsetup_TXCHARDISPVAL_TXUSRCLK2_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     tsetup_TXCHARISK_TXUSRCLK2_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     tsetup_TXCHARISK_TXUSRCLK2_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0.0 ns);
     tsetup_TXCLKSTABLE_TXUSRCLK2_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_TXCLKSTABLE_TXUSRCLK2_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_TXCRCDATAVALID_TXCRCINTCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_TXCRCDATAVALID_TXCRCINTCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_TXCRCDATAWIDTH_TXCRCINTCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0.0 ns);
     tsetup_TXCRCDATAWIDTH_TXCRCINTCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0.0 ns);
     tsetup_TXCRCINIT_TXCRCINTCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_TXCRCINIT_TXCRCINTCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_TXCRCIN_TXCRCINTCLK_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0.0 ns);
     tsetup_TXCRCIN_TXCRCINTCLK_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0.0 ns);
     tsetup_TXCRCRESET_TXCRCINTCLK_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_TXCRCRESET_TXCRCINTCLK_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_TXDATA_TXUSRCLK2_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0.0 ns);
     tsetup_TXDATA_TXUSRCLK2_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0.0 ns);
     tsetup_TXENOOB_TXUSRCLK2_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_TXENOOB_TXUSRCLK2_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_TXPMARESET_TXUSRCLK2_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_TXPMARESET_TXUSRCLK2_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_TXRESET_TXUSRCLK2_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_TXRESET_TXUSRCLK2_posedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_TXSYNC_TXUSRCLK2_negedge_posedge : VitalDelayType := 0.0 ns;
     tsetup_TXSYNC_TXUSRCLK2_posedge_posedge : VitalDelayType := 0.0 ns
  );
  port (
     CHBONDO : out std_logic_vector(4 downto 0);
     COMBUSOUT : out std_logic_vector(15 downto 0);
     DO : out std_logic_vector(15 downto 0);
     DRDY : out std_ulogic;
     RXBUFERR : out std_ulogic;
     RXCALFAIL : out std_ulogic;
     RXCHARISCOMMA : out std_logic_vector(7 downto 0);
     RXCHARISK : out std_logic_vector(7 downto 0);
     RXCOMMADET : out std_ulogic;
     RXCRCOUT : out std_logic_vector(31 downto 0);
     RXCYCLELIMIT : out std_ulogic;
     RXDATA : out std_logic_vector(63 downto 0);
     RXDISPERR : out std_logic_vector(7 downto 0);
     RXLOCK : out std_ulogic;
     RXLOSSOFSYNC : out std_logic_vector(1 downto 0);
     RXMCLK : out std_ulogic;
     RXNOTINTABLE : out std_logic_vector(7 downto 0);
     RXPCSHCLKOUT : out std_ulogic;
     RXREALIGN : out std_ulogic;
     RXRECCLK1 : out std_ulogic;
     RXRECCLK2 : out std_ulogic;
     RXRUNDISP : out std_logic_vector(7 downto 0);
     RXSIGDET : out std_ulogic;
     RXSTATUS : out std_logic_vector(5 downto 0);
     TX1N : out std_ulogic;
     TX1P : out std_ulogic;
     TXBUFERR : out std_ulogic;
     TXCALFAIL : out std_ulogic;
     TXCRCOUT : out std_logic_vector(31 downto 0);
     TXCYCLELIMIT : out std_ulogic;
     TXKERR : out std_logic_vector(7 downto 0);
     TXLOCK : out std_ulogic;
     TXOUTCLK1 : out std_ulogic;
     TXOUTCLK2 : out std_ulogic;
     TXPCSHCLKOUT : out std_ulogic;
     TXRUNDISP : out std_logic_vector(7 downto 0);
     CHBONDI : in std_logic_vector(4 downto 0);
     COMBUSIN : in std_logic_vector(15 downto 0);
     DADDR : in std_logic_vector(7 downto 0);
     DCLK : in std_ulogic;
     DEN : in std_ulogic;
     DI : in std_logic_vector(15 downto 0);
     DWE : in std_ulogic;
     ENCHANSYNC : in std_ulogic;
     ENMCOMMAALIGN : in std_ulogic;
     ENPCOMMAALIGN : in std_ulogic;
     GREFCLK : in std_ulogic;
     LOOPBACK : in std_logic_vector(1 downto 0);
     POWERDOWN : in std_ulogic;
     REFCLK1 : in std_ulogic;
     REFCLK2 : in std_ulogic;
     RX1N : in std_ulogic;
     RX1P : in std_ulogic;
     RXBLOCKSYNC64B66BUSE : in std_ulogic;
     RXCLKSTABLE : in std_ulogic;
     RXCOMMADETUSE : in std_ulogic;
     RXCRCCLK : in std_ulogic;
     RXCRCDATAVALID : in std_ulogic;
     RXCRCDATAWIDTH : in std_logic_vector(2 downto 0);
     RXCRCIN : in std_logic_vector(63 downto 0);
     RXCRCINIT : in std_ulogic;
     RXCRCINTCLK : in std_ulogic;
     RXCRCPD : in std_ulogic;
     RXCRCRESET : in std_ulogic;
     RXDATAWIDTH : in std_logic_vector(1 downto 0);
     RXDEC64B66BUSE : in std_ulogic;
     RXDEC8B10BUSE : in std_ulogic;
     RXDESCRAM64B66BUSE : in std_ulogic;
     RXIGNOREBTF : in std_ulogic;
     RXINTDATAWIDTH : in std_logic_vector(1 downto 0);
     RXPMARESET : in std_ulogic;
     RXPOLARITY : in std_ulogic;
     RXRESET : in std_ulogic;
     RXSLIDE : in std_ulogic;
     RXSYNC : in std_ulogic;
     RXUSRCLK : in std_ulogic;
     RXUSRCLK2 : in std_ulogic;
     TXBYPASS8B10B : in std_logic_vector(7 downto 0);
     TXCHARDISPMODE : in std_logic_vector(7 downto 0);
     TXCHARDISPVAL : in std_logic_vector(7 downto 0);
     TXCHARISK : in std_logic_vector(7 downto 0);
     TXCLKSTABLE : in std_ulogic;
     TXCRCCLK : in std_ulogic;
     TXCRCDATAVALID : in std_ulogic;
     TXCRCDATAWIDTH : in std_logic_vector(2 downto 0);
     TXCRCIN : in std_logic_vector(63 downto 0);
     TXCRCINIT : in std_ulogic;
     TXCRCINTCLK : in std_ulogic;
     TXCRCPD : in std_ulogic;
     TXCRCRESET : in std_ulogic;
     TXDATA : in std_logic_vector(63 downto 0);
     TXDATAWIDTH : in std_logic_vector(1 downto 0);
     TXENC64B66BUSE : in std_ulogic;
     TXENC8B10BUSE : in std_ulogic;
     TXENOOB : in std_ulogic;
     TXGEARBOX64B66BUSE : in std_ulogic;
     TXINHIBIT : in std_ulogic;
     TXINTDATAWIDTH : in std_logic_vector(1 downto 0);
     TXPMARESET : in std_ulogic;
     TXPOLARITY : in std_ulogic;
     TXRESET : in std_ulogic;
     TXSCRAM64B66BUSE : in std_ulogic;
     TXSYNC : in std_ulogic;
     TXUSRCLK : in std_ulogic;
     TXUSRCLK2 : in std_ulogic
  );
end component;

----- component X_GT11CLK -----
component X_GT11CLK
  generic (
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := FALSE;
     REFCLKSEL : string := "MGTCLK";
     SYNCLK1OUTEN : string := "ENABLE";
     SYNCLK2OUTEN : string := "DISABLE";
     TimingChecksOn : boolean := TRUE;
     Xon : boolean := TRUE;
     tipd_MGTCLKN : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_MGTCLKP : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_REFCLK : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_RXBCLK : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_SYNCLK1IN : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tipd_SYNCLK2IN : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tpd_MGTCLKP_SYNCLK1OUT : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tpd_MGTCLKP_SYNCLK2OUT : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tpd_REFCLK_SYNCLK1OUT : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tpd_REFCLK_SYNCLK2OUT : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tpd_RXBCLK_SYNCLK1OUT : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tpd_RXBCLK_SYNCLK2OUT : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tpd_SYNCLK1IN_SYNCLK1OUT : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tpd_SYNCLK1IN_SYNCLK2OUT : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tpd_SYNCLK2IN_SYNCLK1OUT : VitalDelayType01 := (0.0 ns, 0.0 ns);
     tpd_SYNCLK2IN_SYNCLK2OUT : VitalDelayType01 := (0.0 ns, 0.0 ns)
  );
  port (
     SYNCLK1OUT : out std_ulogic;
     SYNCLK2OUT : out std_ulogic;
     MGTCLKN : in std_ulogic;
     MGTCLKP : in std_ulogic;
     REFCLK : in std_ulogic;
     RXBCLK : in std_ulogic;
     SYNCLK1IN : in std_ulogic;
     SYNCLK2IN : in std_ulogic
  );
end component;

----- component X_GTHE1_QUAD -----
component X_GTHE1_QUAD
  generic (
     BER_CONST_PTRN0 : bit_vector := X"0000";
     BER_CONST_PTRN1 : bit_vector := X"0000";
     BUFFER_CONFIG_LANE0 : bit_vector := X"4004";
     BUFFER_CONFIG_LANE1 : bit_vector := X"4004";
     BUFFER_CONFIG_LANE2 : bit_vector := X"4004";
     BUFFER_CONFIG_LANE3 : bit_vector := X"4004";
     DFE_TRAIN_CTRL_LANE0 : bit_vector := X"0000";
     DFE_TRAIN_CTRL_LANE1 : bit_vector := X"0000";
     DFE_TRAIN_CTRL_LANE2 : bit_vector := X"0000";
     DFE_TRAIN_CTRL_LANE3 : bit_vector := X"0000";
     DLL_CFG0 : bit_vector := X"4201";
     DLL_CFG1 : bit_vector := X"0000";
     E10GBASEKR_LD_COEFF_UPD_LANE0 : bit_vector := X"0000";
     E10GBASEKR_LD_COEFF_UPD_LANE1 : bit_vector := X"0000";
     E10GBASEKR_LD_COEFF_UPD_LANE2 : bit_vector := X"0000";
     E10GBASEKR_LD_COEFF_UPD_LANE3 : bit_vector := X"0000";
     E10GBASEKR_LP_COEFF_UPD_LANE0 : bit_vector := X"0000";
     E10GBASEKR_LP_COEFF_UPD_LANE1 : bit_vector := X"0000";
     E10GBASEKR_LP_COEFF_UPD_LANE2 : bit_vector := X"0000";
     E10GBASEKR_LP_COEFF_UPD_LANE3 : bit_vector := X"0000";
     E10GBASEKR_PMA_CTRL_LANE0 : bit_vector := X"0002";
     E10GBASEKR_PMA_CTRL_LANE1 : bit_vector := X"0002";
     E10GBASEKR_PMA_CTRL_LANE2 : bit_vector := X"0002";
     E10GBASEKR_PMA_CTRL_LANE3 : bit_vector := X"0002";
     E10GBASEKX_CTRL_LANE0 : bit_vector := X"0000";
     E10GBASEKX_CTRL_LANE1 : bit_vector := X"0000";
     E10GBASEKX_CTRL_LANE2 : bit_vector := X"0000";
     E10GBASEKX_CTRL_LANE3 : bit_vector := X"0000";
     E10GBASER_PCS_CFG_LANE0 : bit_vector := X"070C";
     E10GBASER_PCS_CFG_LANE1 : bit_vector := X"070C";
     E10GBASER_PCS_CFG_LANE2 : bit_vector := X"070C";
     E10GBASER_PCS_CFG_LANE3 : bit_vector := X"070C";
     E10GBASER_PCS_SEEDA0_LANE0 : bit_vector := X"0001";
     E10GBASER_PCS_SEEDA0_LANE1 : bit_vector := X"0001";
     E10GBASER_PCS_SEEDA0_LANE2 : bit_vector := X"0001";
     E10GBASER_PCS_SEEDA0_LANE3 : bit_vector := X"0001";
     E10GBASER_PCS_SEEDA1_LANE0 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDA1_LANE1 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDA1_LANE2 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDA1_LANE3 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDA2_LANE0 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDA2_LANE1 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDA2_LANE2 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDA2_LANE3 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDA3_LANE0 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDA3_LANE1 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDA3_LANE2 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDA3_LANE3 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDB0_LANE0 : bit_vector := X"0001";
     E10GBASER_PCS_SEEDB0_LANE1 : bit_vector := X"0001";
     E10GBASER_PCS_SEEDB0_LANE2 : bit_vector := X"0001";
     E10GBASER_PCS_SEEDB0_LANE3 : bit_vector := X"0001";
     E10GBASER_PCS_SEEDB1_LANE0 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDB1_LANE1 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDB1_LANE2 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDB1_LANE3 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDB2_LANE0 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDB2_LANE1 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDB2_LANE2 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDB2_LANE3 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDB3_LANE0 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDB3_LANE1 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDB3_LANE2 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDB3_LANE3 : bit_vector := X"0000";
     E10GBASER_PCS_TEST_CTRL_LANE0 : bit_vector := X"0000";
     E10GBASER_PCS_TEST_CTRL_LANE1 : bit_vector := X"0000";
     E10GBASER_PCS_TEST_CTRL_LANE2 : bit_vector := X"0000";
     E10GBASER_PCS_TEST_CTRL_LANE3 : bit_vector := X"0000";
     E10GBASEX_PCS_TSTCTRL_LANE0 : bit_vector := X"0000";
     E10GBASEX_PCS_TSTCTRL_LANE1 : bit_vector := X"0000";
     E10GBASEX_PCS_TSTCTRL_LANE2 : bit_vector := X"0000";
     E10GBASEX_PCS_TSTCTRL_LANE3 : bit_vector := X"0000";
     GLBL0_NOISE_CTRL : bit_vector := X"F0B8";
     GLBL_AMON_SEL : bit_vector := X"0000";
     GLBL_DMON_SEL : bit_vector := X"0200";
     GLBL_PWR_CTRL : bit_vector := X"0000";
     GTH_CFG_PWRUP_LANE0 : bit := '1';
     GTH_CFG_PWRUP_LANE1 : bit := '1';
     GTH_CFG_PWRUP_LANE2 : bit := '1';
     GTH_CFG_PWRUP_LANE3 : bit := '1';
     InstancePath : string := "*";
     LANE_AMON_SEL : bit_vector := X"00F0";
     LANE_DMON_SEL : bit_vector := X"0000";
     LANE_LNK_CFGOVRD : bit_vector := X"0000";
     LANE_PWR_CTRL_LANE0 : bit_vector := X"0400";
     LANE_PWR_CTRL_LANE1 : bit_vector := X"0400";
     LANE_PWR_CTRL_LANE2 : bit_vector := X"0400";
     LANE_PWR_CTRL_LANE3 : bit_vector := X"0400";
     LNK_TRN_CFG_LANE0 : bit_vector := X"0000";
     LNK_TRN_CFG_LANE1 : bit_vector := X"0000";
     LNK_TRN_CFG_LANE2 : bit_vector := X"0000";
     LNK_TRN_CFG_LANE3 : bit_vector := X"0000";
     LNK_TRN_COEFF_REQ_LANE0 : bit_vector := X"0000";
     LNK_TRN_COEFF_REQ_LANE1 : bit_vector := X"0000";
     LNK_TRN_COEFF_REQ_LANE2 : bit_vector := X"0000";
     LNK_TRN_COEFF_REQ_LANE3 : bit_vector := X"0000";
     LOC : string := "UNPLACED";
     MISC_CFG : bit_vector := X"0004";
     MODE_CFG1 : bit_vector := X"0000";
     MODE_CFG2 : bit_vector := X"0000";
     MODE_CFG3 : bit_vector := X"0000";
     MODE_CFG4 : bit_vector := X"0000";
     MODE_CFG5 : bit_vector := X"0000";
     MODE_CFG6 : bit_vector := X"0000";
     MODE_CFG7 : bit_vector := X"0000";
     MsgOn : boolean := FALSE;
     PCS_ABILITY_LANE0 : bit_vector := X"0010";
     PCS_ABILITY_LANE1 : bit_vector := X"0010";
     PCS_ABILITY_LANE2 : bit_vector := X"0010";
     PCS_ABILITY_LANE3 : bit_vector := X"0010";
     PCS_CTRL1_LANE0 : bit_vector := X"2040";
     PCS_CTRL1_LANE1 : bit_vector := X"2040";
     PCS_CTRL1_LANE2 : bit_vector := X"2040";
     PCS_CTRL1_LANE3 : bit_vector := X"2040";
     PCS_CTRL2_LANE0 : bit_vector := X"0000";
     PCS_CTRL2_LANE1 : bit_vector := X"0000";
     PCS_CTRL2_LANE2 : bit_vector := X"0000";
     PCS_CTRL2_LANE3 : bit_vector := X"0000";
     PCS_MISC_CFG_0_LANE0 : bit_vector := X"1117";
     PCS_MISC_CFG_0_LANE1 : bit_vector := X"1117";
     PCS_MISC_CFG_0_LANE2 : bit_vector := X"1117";
     PCS_MISC_CFG_0_LANE3 : bit_vector := X"1117";
     PCS_MISC_CFG_1_LANE0 : bit_vector := X"0000";
     PCS_MISC_CFG_1_LANE1 : bit_vector := X"0000";
     PCS_MISC_CFG_1_LANE2 : bit_vector := X"0000";
     PCS_MISC_CFG_1_LANE3 : bit_vector := X"0000";
     PCS_MODE_LANE0 : bit_vector := X"0000";
     PCS_MODE_LANE1 : bit_vector := X"0000";
     PCS_MODE_LANE2 : bit_vector := X"0000";
     PCS_MODE_LANE3 : bit_vector := X"0000";
     PCS_RESET_1_LANE0 : bit_vector := X"0002";
     PCS_RESET_1_LANE1 : bit_vector := X"0002";
     PCS_RESET_1_LANE2 : bit_vector := X"0002";
     PCS_RESET_1_LANE3 : bit_vector := X"0002";
     PCS_RESET_LANE0 : bit_vector := X"0000";
     PCS_RESET_LANE1 : bit_vector := X"0000";
     PCS_RESET_LANE2 : bit_vector := X"0000";
     PCS_RESET_LANE3 : bit_vector := X"0000";
     PCS_TYPE_LANE0 : bit_vector := X"002C";
     PCS_TYPE_LANE1 : bit_vector := X"002C";
     PCS_TYPE_LANE2 : bit_vector := X"002C";
     PCS_TYPE_LANE3 : bit_vector := X"002C";
     PLL_CFG0 : bit_vector := X"58C0";
     PLL_CFG1 : bit_vector := X"8440";
     PLL_CFG2 : bit_vector := X"0424";
     PMA_CTRL1_LANE0 : bit_vector := X"0000";
     PMA_CTRL1_LANE1 : bit_vector := X"0000";
     PMA_CTRL1_LANE2 : bit_vector := X"0000";
     PMA_CTRL1_LANE3 : bit_vector := X"0000";
     PMA_CTRL2_LANE0 : bit_vector := X"000B";
     PMA_CTRL2_LANE1 : bit_vector := X"000B";
     PMA_CTRL2_LANE2 : bit_vector := X"000B";
     PMA_CTRL2_LANE3 : bit_vector := X"000B";
     PMA_LPBK_CTRL_LANE0 : bit_vector := X"0004";
     PMA_LPBK_CTRL_LANE1 : bit_vector := X"0004";
     PMA_LPBK_CTRL_LANE2 : bit_vector := X"0004";
     PMA_LPBK_CTRL_LANE3 : bit_vector := X"0004";
     PRBS_BER_CFG0_LANE0 : bit_vector := X"0000";
     PRBS_BER_CFG0_LANE1 : bit_vector := X"0000";
     PRBS_BER_CFG0_LANE2 : bit_vector := X"0000";
     PRBS_BER_CFG0_LANE3 : bit_vector := X"0000";
     PRBS_BER_CFG1_LANE0 : bit_vector := X"0000";
     PRBS_BER_CFG1_LANE1 : bit_vector := X"0000";
     PRBS_BER_CFG1_LANE2 : bit_vector := X"0000";
     PRBS_BER_CFG1_LANE3 : bit_vector := X"0000";
     PRBS_CFG_LANE0 : bit_vector := X"000A";
     PRBS_CFG_LANE1 : bit_vector := X"000A";
     PRBS_CFG_LANE2 : bit_vector := X"000A";
     PRBS_CFG_LANE3 : bit_vector := X"000A";
     PTRN_CFG0_LSB : bit_vector := X"5555";
     PTRN_CFG0_MSB : bit_vector := X"5555";
     PTRN_LEN_CFG : bit_vector := X"001F";
     PWRUP_DLY : bit_vector := X"0000";
     RX_AEQ_VAL0_LANE0 : bit_vector := X"0100";
     RX_AEQ_VAL0_LANE1 : bit_vector := X"0100";
     RX_AEQ_VAL0_LANE2 : bit_vector := X"0100";
     RX_AEQ_VAL0_LANE3 : bit_vector := X"0100";
     RX_AEQ_VAL1_LANE0 : bit_vector := X"0000";
     RX_AEQ_VAL1_LANE1 : bit_vector := X"0000";
     RX_AEQ_VAL1_LANE2 : bit_vector := X"0000";
     RX_AEQ_VAL1_LANE3 : bit_vector := X"0000";
     RX_AGC_CTRL_LANE0 : bit_vector := X"0000";
     RX_AGC_CTRL_LANE1 : bit_vector := X"0000";
     RX_AGC_CTRL_LANE2 : bit_vector := X"0000";
     RX_AGC_CTRL_LANE3 : bit_vector := X"0000";
     RX_CDR_CTRL0_LANE0 : bit_vector := X"0005";
     RX_CDR_CTRL0_LANE1 : bit_vector := X"0005";
     RX_CDR_CTRL0_LANE2 : bit_vector := X"0005";
     RX_CDR_CTRL0_LANE3 : bit_vector := X"0005";
     RX_CDR_CTRL1_LANE0 : bit_vector := X"4300";
     RX_CDR_CTRL1_LANE1 : bit_vector := X"4300";
     RX_CDR_CTRL1_LANE2 : bit_vector := X"4300";
     RX_CDR_CTRL1_LANE3 : bit_vector := X"4300";
     RX_CDR_CTRL2_LANE0 : bit_vector := X"2000";
     RX_CDR_CTRL2_LANE1 : bit_vector := X"2000";
     RX_CDR_CTRL2_LANE2 : bit_vector := X"2000";
     RX_CDR_CTRL2_LANE3 : bit_vector := X"2000";
     RX_CFG0_LANE0 : bit_vector := X"0B06";
     RX_CFG0_LANE1 : bit_vector := X"0B06";
     RX_CFG0_LANE2 : bit_vector := X"0B06";
     RX_CFG0_LANE3 : bit_vector := X"0B06";
     RX_CFG1_LANE0 : bit_vector := X"817F";
     RX_CFG1_LANE1 : bit_vector := X"817F";
     RX_CFG1_LANE2 : bit_vector := X"817F";
     RX_CFG1_LANE3 : bit_vector := X"817F";
     RX_CFG2_LANE0 : bit_vector := X"1000";
     RX_CFG2_LANE1 : bit_vector := X"1000";
     RX_CFG2_LANE2 : bit_vector := X"1000";
     RX_CFG2_LANE3 : bit_vector := X"1000";
     RX_CTLE_CTRL_LANE0 : bit_vector := X"007F";
     RX_CTLE_CTRL_LANE1 : bit_vector := X"007F";
     RX_CTLE_CTRL_LANE2 : bit_vector := X"007F";
     RX_CTLE_CTRL_LANE3 : bit_vector := X"007F";
     RX_CTRL_OVRD_LANE0 : bit_vector := X"000C";
     RX_CTRL_OVRD_LANE1 : bit_vector := X"000C";
     RX_CTRL_OVRD_LANE2 : bit_vector := X"000C";
     RX_CTRL_OVRD_LANE3 : bit_vector := X"000C";
     RX_FABRIC_WIDTH0 : integer := 6466;
     RX_FABRIC_WIDTH1 : integer := 6466;
     RX_FABRIC_WIDTH2 : integer := 6466;
     RX_FABRIC_WIDTH3 : integer := 6466;
     RX_LOOP_CTRL_LANE0 : bit_vector := X"0070";
     RX_LOOP_CTRL_LANE1 : bit_vector := X"0070";
     RX_LOOP_CTRL_LANE2 : bit_vector := X"0070";
     RX_LOOP_CTRL_LANE3 : bit_vector := X"0070";
     RX_MVAL0_LANE0 : bit_vector := X"0000";
     RX_MVAL0_LANE1 : bit_vector := X"0000";
     RX_MVAL0_LANE2 : bit_vector := X"0000";
     RX_MVAL0_LANE3 : bit_vector := X"0000";
     RX_MVAL1_LANE0 : bit_vector := X"0000";
     RX_MVAL1_LANE1 : bit_vector := X"0000";
     RX_MVAL1_LANE2 : bit_vector := X"0000";
     RX_MVAL1_LANE3 : bit_vector := X"0000";
     RX_P0S_CTRL : bit_vector := X"1206";
     RX_P0_CTRL : bit_vector := X"11F0";
     RX_P1_CTRL : bit_vector := X"120F";
     RX_P2_CTRL : bit_vector := X"0E0F";
     RX_PI_CTRL0 : bit_vector := X"B2F2";
     RX_PI_CTRL1 : bit_vector := X"0080";
     SIM_GTHRESET_SPEEDUP : integer := 1;
     SIM_VERSION : string := "1.0";
     SLICE_CFG : bit_vector := X"0000";
     SLICE_NOISE_CTRL_0_LANE01 : bit_vector := X"0000";
     SLICE_NOISE_CTRL_0_LANE23 : bit_vector := X"0000";
     SLICE_NOISE_CTRL_1_LANE01 : bit_vector := X"0000";
     SLICE_NOISE_CTRL_1_LANE23 : bit_vector := X"0000";
     SLICE_NOISE_CTRL_2_LANE01 : bit_vector := X"EFFF";
     SLICE_NOISE_CTRL_2_LANE23 : bit_vector := X"EFFF";
     SLICE_TX_RESET_LANE01 : bit_vector := X"0000";
     SLICE_TX_RESET_LANE23 : bit_vector := X"0000";
     TERM_CTRL_LANE0 : bit_vector := X"0000";
     TERM_CTRL_LANE1 : bit_vector := X"0000";
     TERM_CTRL_LANE2 : bit_vector := X"0000";
     TERM_CTRL_LANE3 : bit_vector := X"0000";
     TX_CFG0_LANE0 : bit_vector := X"203D";
     TX_CFG0_LANE1 : bit_vector := X"203D";
     TX_CFG0_LANE2 : bit_vector := X"203D";
     TX_CFG0_LANE3 : bit_vector := X"203D";
     TX_CFG1_LANE0 : bit_vector := X"0C83";
     TX_CFG1_LANE1 : bit_vector := X"0C83";
     TX_CFG1_LANE2 : bit_vector := X"0C83";
     TX_CFG1_LANE3 : bit_vector := X"0C83";
     TX_CFG2_LANE0 : bit_vector := X"0001";
     TX_CFG2_LANE1 : bit_vector := X"0001";
     TX_CFG2_LANE2 : bit_vector := X"0001";
     TX_CFG2_LANE3 : bit_vector := X"0001";
     TX_CLK_SEL0_LANE0 : bit_vector := X"2F2F";
     TX_CLK_SEL0_LANE1 : bit_vector := X"2F2F";
     TX_CLK_SEL0_LANE2 : bit_vector := X"2F2F";
     TX_CLK_SEL0_LANE3 : bit_vector := X"2F2F";
     TX_CLK_SEL1_LANE0 : bit_vector := X"2F2F";
     TX_CLK_SEL1_LANE1 : bit_vector := X"2F2F";
     TX_CLK_SEL1_LANE2 : bit_vector := X"2F2F";
     TX_CLK_SEL1_LANE3 : bit_vector := X"2F2F";
     TX_DISABLE_LANE0 : bit_vector := X"0000";
     TX_DISABLE_LANE1 : bit_vector := X"0000";
     TX_DISABLE_LANE2 : bit_vector := X"0000";
     TX_DISABLE_LANE3 : bit_vector := X"0000";
     TX_FABRIC_WIDTH0 : integer := 6466;
     TX_FABRIC_WIDTH1 : integer := 6466;
     TX_FABRIC_WIDTH2 : integer := 6466;
     TX_FABRIC_WIDTH3 : integer := 6466;
     TX_P0P0S_CTRL : bit_vector := X"060C";
     TX_P1P2_CTRL : bit_vector := X"0C39";
     TX_PREEMPH_LANE0 : bit_vector := X"A0F0";
     TX_PREEMPH_LANE1 : bit_vector := X"A0F0";
     TX_PREEMPH_LANE2 : bit_vector := X"A0F0";
     TX_PREEMPH_LANE3 : bit_vector := X"A0F0";
     TX_PWR_RATE_OVRD_LANE0 : bit_vector := X"0060";
     TX_PWR_RATE_OVRD_LANE1 : bit_vector := X"0060";
     TX_PWR_RATE_OVRD_LANE2 : bit_vector := X"0060";
     TX_PWR_RATE_OVRD_LANE3 : bit_vector := X"0060";
     TimingChecksOn : boolean := TRUE;
     Xon : boolean := TRUE;
     thold_DADDR_DCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_DADDR_DCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_DEN_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_DEN_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_DFETRAINCTRL0_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_DFETRAINCTRL0_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_DFETRAINCTRL1_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_DFETRAINCTRL1_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_DFETRAINCTRL2_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_DFETRAINCTRL2_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_DFETRAINCTRL3_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_DFETRAINCTRL3_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_DISABLEDRP_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_DISABLEDRP_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_DI_DCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_DI_DCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_DWE_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_DWE_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_GTHINIT_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_GTHINIT_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_MGMTPCSLANESEL_DCLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_MGMTPCSLANESEL_DCLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_MGMTPCSMMDADDR_DCLK_negedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     thold_MGMTPCSMMDADDR_DCLK_posedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     thold_MGMTPCSREGADDR_DCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_MGMTPCSREGADDR_DCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_MGMTPCSREGRD_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_MGMTPCSREGRD_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_MGMTPCSREGWR_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_MGMTPCSREGWR_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_MGMTPCSWRDATA_DCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_MGMTPCSWRDATA_DCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_PLLPCSCLKDIV_DCLK_negedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     thold_PLLPCSCLKDIV_DCLK_posedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     thold_RXBUFRESET0_RXUSERCLKIN0_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXBUFRESET0_RXUSERCLKIN0_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXBUFRESET1_RXUSERCLKIN1_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXBUFRESET1_RXUSERCLKIN1_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXBUFRESET2_RXUSERCLKIN2_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXBUFRESET2_RXUSERCLKIN2_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXBUFRESET3_RXUSERCLKIN3_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXBUFRESET3_RXUSERCLKIN3_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXENCOMMADET0_RXUSERCLKIN0_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXENCOMMADET0_RXUSERCLKIN0_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXENCOMMADET1_RXUSERCLKIN1_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXENCOMMADET1_RXUSERCLKIN1_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXENCOMMADET2_RXUSERCLKIN2_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXENCOMMADET2_RXUSERCLKIN2_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXENCOMMADET3_RXUSERCLKIN3_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXENCOMMADET3_RXUSERCLKIN3_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXPOLARITY0_RXUSERCLKIN0_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXPOLARITY0_RXUSERCLKIN0_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXPOLARITY1_RXUSERCLKIN1_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXPOLARITY1_RXUSERCLKIN1_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXPOLARITY2_RXUSERCLKIN2_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXPOLARITY2_RXUSERCLKIN2_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXPOLARITY3_RXUSERCLKIN3_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXPOLARITY3_RXUSERCLKIN3_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXPOWERDOWN0_TXUSERCLKIN0_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_RXPOWERDOWN0_TXUSERCLKIN0_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_RXPOWERDOWN1_TXUSERCLKIN1_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_RXPOWERDOWN1_TXUSERCLKIN1_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_RXPOWERDOWN2_TXUSERCLKIN2_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_RXPOWERDOWN2_TXUSERCLKIN2_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_RXPOWERDOWN3_TXUSERCLKIN3_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_RXPOWERDOWN3_TXUSERCLKIN3_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_RXRATE0_TXUSERCLKIN0_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_RXRATE0_TXUSERCLKIN0_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_RXRATE1_TXUSERCLKIN1_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_RXRATE1_TXUSERCLKIN1_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_RXRATE2_TXUSERCLKIN2_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_RXRATE2_TXUSERCLKIN2_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_RXRATE3_TXUSERCLKIN3_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_RXRATE3_TXUSERCLKIN3_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_SAMPLERATE0_TXUSERCLKIN0_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_SAMPLERATE0_TXUSERCLKIN0_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_SAMPLERATE1_TXUSERCLKIN1_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_SAMPLERATE1_TXUSERCLKIN1_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_SAMPLERATE2_TXUSERCLKIN2_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_SAMPLERATE2_TXUSERCLKIN2_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_SAMPLERATE3_TXUSERCLKIN3_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_SAMPLERATE3_TXUSERCLKIN3_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_TXBUFRESET0_TXUSERCLKIN0_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXBUFRESET0_TXUSERCLKIN0_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXBUFRESET1_TXUSERCLKIN1_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXBUFRESET1_TXUSERCLKIN1_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXBUFRESET2_TXUSERCLKIN2_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXBUFRESET2_TXUSERCLKIN2_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXBUFRESET3_TXUSERCLKIN3_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXBUFRESET3_TXUSERCLKIN3_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXCTRL0_TXUSERCLKIN0_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_TXCTRL0_TXUSERCLKIN0_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_TXCTRL1_TXUSERCLKIN1_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_TXCTRL1_TXUSERCLKIN1_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_TXCTRL2_TXUSERCLKIN2_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_TXCTRL2_TXUSERCLKIN2_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_TXCTRL3_TXUSERCLKIN3_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_TXCTRL3_TXUSERCLKIN3_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_TXDATA0_TXUSERCLKIN0_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     thold_TXDATA0_TXUSERCLKIN0_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     thold_TXDATA1_TXUSERCLKIN1_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     thold_TXDATA1_TXUSERCLKIN1_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     thold_TXDATA2_TXUSERCLKIN2_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     thold_TXDATA2_TXUSERCLKIN2_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     thold_TXDATA3_TXUSERCLKIN3_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     thold_TXDATA3_TXUSERCLKIN3_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     thold_TXDATAMSB0_TXUSERCLKIN0_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_TXDATAMSB0_TXUSERCLKIN0_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_TXDATAMSB1_TXUSERCLKIN1_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_TXDATAMSB1_TXUSERCLKIN1_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_TXDATAMSB2_TXUSERCLKIN2_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_TXDATAMSB2_TXUSERCLKIN2_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_TXDATAMSB3_TXUSERCLKIN3_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_TXDATAMSB3_TXUSERCLKIN3_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_TXDEEMPH0_TXUSERCLKIN0_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXDEEMPH0_TXUSERCLKIN0_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXDEEMPH1_TXUSERCLKIN1_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXDEEMPH1_TXUSERCLKIN1_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXDEEMPH2_TXUSERCLKIN2_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXDEEMPH2_TXUSERCLKIN2_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXDEEMPH3_TXUSERCLKIN3_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXDEEMPH3_TXUSERCLKIN3_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXMARGIN0_TXUSERCLKIN0_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_TXMARGIN0_TXUSERCLKIN0_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_TXMARGIN1_TXUSERCLKIN1_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_TXMARGIN1_TXUSERCLKIN1_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_TXMARGIN2_TXUSERCLKIN2_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_TXMARGIN2_TXUSERCLKIN2_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_TXMARGIN3_TXUSERCLKIN3_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_TXMARGIN3_TXUSERCLKIN3_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_TXPOWERDOWN0_TXUSERCLKIN0_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXPOWERDOWN0_TXUSERCLKIN0_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXPOWERDOWN1_TXUSERCLKIN1_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXPOWERDOWN1_TXUSERCLKIN1_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXPOWERDOWN2_TXUSERCLKIN2_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXPOWERDOWN2_TXUSERCLKIN2_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXPOWERDOWN3_TXUSERCLKIN3_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXPOWERDOWN3_TXUSERCLKIN3_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXRATE0_TXUSERCLKIN0_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXRATE0_TXUSERCLKIN0_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXRATE1_TXUSERCLKIN1_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXRATE1_TXUSERCLKIN1_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXRATE2_TXUSERCLKIN2_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXRATE2_TXUSERCLKIN2_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXRATE3_TXUSERCLKIN3_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXRATE3_TXUSERCLKIN3_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     ticd_DCLK : VitalDelayType := 0 ps;
     ticd_REFCLK : VitalDelayType := 0 ps;
     ticd_RXUSERCLKIN0 : VitalDelayType := 0 ps;
     ticd_RXUSERCLKIN1 : VitalDelayType := 0 ps;
     ticd_RXUSERCLKIN2 : VitalDelayType := 0 ps;
     ticd_RXUSERCLKIN3 : VitalDelayType := 0 ps;
     ticd_TXUSERCLKIN0 : VitalDelayType := 0 ps;
     ticd_TXUSERCLKIN1 : VitalDelayType := 0 ps;
     ticd_TXUSERCLKIN2 : VitalDelayType := 0 ps;
     ticd_TXUSERCLKIN3 : VitalDelayType := 0 ps;
     tipd_DADDR : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
     tipd_DCLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DEN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DFETRAINCTRL0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DFETRAINCTRL1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DFETRAINCTRL2 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DFETRAINCTRL3 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DI : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
     tipd_DISABLEDRP : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DWE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_GTHINIT : VitalDelayType01 := (0 ps, 0 ps);
     tipd_GTHRESET : VitalDelayType01 := (0 ps, 0 ps);
     tipd_GTHX2LANE01 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_GTHX2LANE23 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_GTHX4LANE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_MGMTPCSLANESEL : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_MGMTPCSMMDADDR : VitalDelayArrayType01 (4 downto 0) := (others => (0 ps, 0 ps));
     tipd_MGMTPCSREGADDR : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
     tipd_MGMTPCSREGRD : VitalDelayType01 := (0 ps, 0 ps);
     tipd_MGMTPCSREGWR : VitalDelayType01 := (0 ps, 0 ps);
     tipd_MGMTPCSWRDATA : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
     tipd_PLLPCSCLKDIV : VitalDelayArrayType01 (5 downto 0) := (others => (0 ps, 0 ps));
     tipd_PLLREFCLKSEL : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_POWERDOWN0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_POWERDOWN1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_POWERDOWN2 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_POWERDOWN3 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_REFCLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXBUFRESET0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXBUFRESET1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXBUFRESET2 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXBUFRESET3 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENCOMMADET0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENCOMMADET1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENCOMMADET2 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENCOMMADET3 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXN0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXN1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXN2 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXN3 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXP0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXP1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXP2 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXP3 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXPOLARITY0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXPOLARITY1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXPOLARITY2 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXPOLARITY3 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXPOWERDOWN0 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXPOWERDOWN1 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXPOWERDOWN2 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXPOWERDOWN3 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXRATE0 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXRATE1 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXRATE2 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXRATE3 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXSLIP0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXSLIP1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXSLIP2 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXSLIP3 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXUSERCLKIN0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXUSERCLKIN1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXUSERCLKIN2 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXUSERCLKIN3 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_SAMPLERATE0 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_SAMPLERATE1 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_SAMPLERATE2 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_SAMPLERATE3 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXBUFRESET0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXBUFRESET1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXBUFRESET2 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXBUFRESET3 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXCTRL0 : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXCTRL1 : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXCTRL2 : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXCTRL3 : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXDATA0 : VitalDelayArrayType01 (63 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXDATA1 : VitalDelayArrayType01 (63 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXDATA2 : VitalDelayArrayType01 (63 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXDATA3 : VitalDelayArrayType01 (63 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXDATAMSB0 : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXDATAMSB1 : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXDATAMSB2 : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXDATAMSB3 : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXDEEMPH0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXDEEMPH1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXDEEMPH2 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXDEEMPH3 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXMARGIN0 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXMARGIN1 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXMARGIN2 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXMARGIN3 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXPOWERDOWN0 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXPOWERDOWN1 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXPOWERDOWN2 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXPOWERDOWN3 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXRATE0 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXRATE1 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXRATE2 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXRATE3 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXUSERCLKIN0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXUSERCLKIN1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXUSERCLKIN2 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXUSERCLKIN3 : VitalDelayType01 := (0 ps, 0 ps);
     tisd_DADDR_DCLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tisd_DEN_DCLK : VitalDelayType := 0 ps;
     tisd_DFETRAINCTRL0_DCLK : VitalDelayType := 0 ps;
     tisd_DFETRAINCTRL1_DCLK : VitalDelayType := 0 ps;
     tisd_DFETRAINCTRL2_DCLK : VitalDelayType := 0 ps;
     tisd_DFETRAINCTRL3_DCLK : VitalDelayType := 0 ps;
     tisd_DISABLEDRP_DCLK : VitalDelayType := 0 ps;
     tisd_DI_DCLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tisd_DWE_DCLK : VitalDelayType := 0 ps;
     tisd_GTHINIT_DCLK : VitalDelayType := 0 ps;
     tisd_MGMTPCSLANESEL_DCLK : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_MGMTPCSMMDADDR_DCLK : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tisd_MGMTPCSREGADDR_DCLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tisd_MGMTPCSREGRD_DCLK : VitalDelayType := 0 ps;
     tisd_MGMTPCSREGWR_DCLK : VitalDelayType := 0 ps;
     tisd_MGMTPCSWRDATA_DCLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tisd_PLLPCSCLKDIV_DCLK : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     tisd_RXBUFRESET0_RXUSERCLKIN0 : VitalDelayType := 0 ps;
     tisd_RXBUFRESET1_RXUSERCLKIN1 : VitalDelayType := 0 ps;
     tisd_RXBUFRESET2_RXUSERCLKIN2 : VitalDelayType := 0 ps;
     tisd_RXBUFRESET3_RXUSERCLKIN3 : VitalDelayType := 0 ps;
     tisd_RXENCOMMADET0_RXUSERCLKIN0 : VitalDelayType := 0 ps;
     tisd_RXENCOMMADET1_RXUSERCLKIN1 : VitalDelayType := 0 ps;
     tisd_RXENCOMMADET2_RXUSERCLKIN2 : VitalDelayType := 0 ps;
     tisd_RXENCOMMADET3_RXUSERCLKIN3 : VitalDelayType := 0 ps;
     tisd_RXPOLARITY0_RXUSERCLKIN0 : VitalDelayType := 0 ps;
     tisd_RXPOLARITY1_RXUSERCLKIN1 : VitalDelayType := 0 ps;
     tisd_RXPOLARITY2_RXUSERCLKIN2 : VitalDelayType := 0 ps;
     tisd_RXPOLARITY3_RXUSERCLKIN3 : VitalDelayType := 0 ps;
     tisd_RXPOWERDOWN0_TXUSERCLKIN0 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_RXPOWERDOWN1_TXUSERCLKIN1 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_RXPOWERDOWN2_TXUSERCLKIN2 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_RXPOWERDOWN3_TXUSERCLKIN3 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_RXRATE0_TXUSERCLKIN0 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_RXRATE1_TXUSERCLKIN1 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_RXRATE2_TXUSERCLKIN2 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_RXRATE3_TXUSERCLKIN3 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_SAMPLERATE0_TXUSERCLKIN0 : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_SAMPLERATE1_TXUSERCLKIN1 : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_SAMPLERATE2_TXUSERCLKIN2 : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_SAMPLERATE3_TXUSERCLKIN3 : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_TXBUFRESET0_TXUSERCLKIN0 : VitalDelayType := 0 ps;
     tisd_TXBUFRESET1_TXUSERCLKIN1 : VitalDelayType := 0 ps;
     tisd_TXBUFRESET2_TXUSERCLKIN2 : VitalDelayType := 0 ps;
     tisd_TXBUFRESET3_TXUSERCLKIN3 : VitalDelayType := 0 ps;
     tisd_TXCTRL0_TXUSERCLKIN0 : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tisd_TXCTRL1_TXUSERCLKIN1 : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tisd_TXCTRL2_TXUSERCLKIN2 : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tisd_TXCTRL3_TXUSERCLKIN3 : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tisd_TXDATA0_TXUSERCLKIN0 : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     tisd_TXDATA1_TXUSERCLKIN1 : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     tisd_TXDATA2_TXUSERCLKIN2 : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     tisd_TXDATA3_TXUSERCLKIN3 : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     tisd_TXDATAMSB0_TXUSERCLKIN0 : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tisd_TXDATAMSB1_TXUSERCLKIN1 : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tisd_TXDATAMSB2_TXUSERCLKIN2 : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tisd_TXDATAMSB3_TXUSERCLKIN3 : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tisd_TXDEEMPH0_TXUSERCLKIN0 : VitalDelayType := 0 ps;
     tisd_TXDEEMPH1_TXUSERCLKIN1 : VitalDelayType := 0 ps;
     tisd_TXDEEMPH2_TXUSERCLKIN2 : VitalDelayType := 0 ps;
     tisd_TXDEEMPH3_TXUSERCLKIN3 : VitalDelayType := 0 ps;
     tisd_TXMARGIN0_TXUSERCLKIN0 : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_TXMARGIN1_TXUSERCLKIN1 : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_TXMARGIN2_TXUSERCLKIN2 : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_TXMARGIN3_TXUSERCLKIN3 : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_TXPOWERDOWN0_TXUSERCLKIN0 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_TXPOWERDOWN1_TXUSERCLKIN1 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_TXPOWERDOWN2_TXUSERCLKIN2 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_TXPOWERDOWN3_TXUSERCLKIN3 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_TXRATE0_TXUSERCLKIN0 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_TXRATE1_TXUSERCLKIN1 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_TXRATE2_TXUSERCLKIN2 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_TXRATE3_TXUSERCLKIN3 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tpd_DCLK_DRDY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_DCLK_DRPDO : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
     tpd_DCLK_GTHINITDONE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_DCLK_MGMTPCSRDACK : VitalDelayType01 := (0 ps, 0 ps);
     tpd_DCLK_MGMTPCSRDDATA : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
     tpd_REFCLK_TSTREFCLKFAB : VitalDelayType01 := (0 ps, 0 ps);
     tpd_REFCLK_TSTREFCLKOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSERCLKIN0_RXCODEERR0 : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSERCLKIN0_RXCTRL0 : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSERCLKIN0_RXDATA0 : VitalDelayArrayType01(63 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSERCLKIN0_RXDISPERR0 : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSERCLKIN0_RXVALID0 : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSERCLKIN1_RXCODEERR1 : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSERCLKIN1_RXCTRL1 : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSERCLKIN1_RXDATA1 : VitalDelayArrayType01(63 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSERCLKIN1_RXDISPERR1 : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSERCLKIN1_RXVALID1 : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSERCLKIN2_RXCODEERR2 : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSERCLKIN2_RXCTRL2 : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSERCLKIN2_RXDATA2 : VitalDelayArrayType01(63 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSERCLKIN2_RXDISPERR2 : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSERCLKIN2_RXVALID2 : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSERCLKIN3_RXCODEERR3 : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSERCLKIN3_RXCTRL3 : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSERCLKIN3_RXDATA3 : VitalDelayArrayType01(63 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSERCLKIN3_RXDISPERR3 : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSERCLKIN3_RXVALID3 : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
     tpd_TXUSERCLKIN0_RXCTRLACK0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_TXUSERCLKIN0_TXCTRLACK0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_TXUSERCLKIN1_RXCTRLACK1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_TXUSERCLKIN1_TXCTRLACK1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_TXUSERCLKIN2_RXCTRLACK2 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_TXUSERCLKIN2_TXCTRLACK2 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_TXUSERCLKIN3_RXCTRLACK3 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_TXUSERCLKIN3_TXCTRLACK3 : VitalDelayType01 := (0 ps, 0 ps);
     tperiod_DCLK_posedge : VitalDelayType := 0 ps;
     tperiod_REFCLK_posedge : VitalDelayType := 0 ps;
     tperiod_RXUSERCLKIN0_posedge : VitalDelayType := 0 ps;
     tperiod_RXUSERCLKIN1_posedge : VitalDelayType := 0 ps;
     tperiod_RXUSERCLKIN2_posedge : VitalDelayType := 0 ps;
     tperiod_RXUSERCLKIN3_posedge : VitalDelayType := 0 ps;
     tperiod_TXUSERCLKIN0_posedge : VitalDelayType := 0 ps;
     tperiod_TXUSERCLKIN1_posedge : VitalDelayType := 0 ps;
     tperiod_TXUSERCLKIN2_posedge : VitalDelayType := 0 ps;
     tperiod_TXUSERCLKIN3_posedge : VitalDelayType := 0 ps;
     tsetup_DADDR_DCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_DADDR_DCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_DEN_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_DEN_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_DFETRAINCTRL0_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_DFETRAINCTRL0_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_DFETRAINCTRL1_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_DFETRAINCTRL1_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_DFETRAINCTRL2_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_DFETRAINCTRL2_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_DFETRAINCTRL3_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_DFETRAINCTRL3_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_DISABLEDRP_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_DISABLEDRP_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_DI_DCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_DI_DCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_DWE_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_DWE_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_GTHINIT_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_GTHINIT_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_MGMTPCSLANESEL_DCLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_MGMTPCSLANESEL_DCLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_MGMTPCSMMDADDR_DCLK_negedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tsetup_MGMTPCSMMDADDR_DCLK_posedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tsetup_MGMTPCSREGADDR_DCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_MGMTPCSREGADDR_DCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_MGMTPCSREGRD_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_MGMTPCSREGRD_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_MGMTPCSREGWR_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_MGMTPCSREGWR_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_MGMTPCSWRDATA_DCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_MGMTPCSWRDATA_DCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_PLLPCSCLKDIV_DCLK_negedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     tsetup_PLLPCSCLKDIV_DCLK_posedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     tsetup_RXBUFRESET0_RXUSERCLKIN0_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXBUFRESET0_RXUSERCLKIN0_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXBUFRESET1_RXUSERCLKIN1_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXBUFRESET1_RXUSERCLKIN1_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXBUFRESET2_RXUSERCLKIN2_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXBUFRESET2_RXUSERCLKIN2_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXBUFRESET3_RXUSERCLKIN3_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXBUFRESET3_RXUSERCLKIN3_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENCOMMADET0_RXUSERCLKIN0_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENCOMMADET0_RXUSERCLKIN0_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENCOMMADET1_RXUSERCLKIN1_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENCOMMADET1_RXUSERCLKIN1_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENCOMMADET2_RXUSERCLKIN2_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENCOMMADET2_RXUSERCLKIN2_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENCOMMADET3_RXUSERCLKIN3_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENCOMMADET3_RXUSERCLKIN3_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXPOLARITY0_RXUSERCLKIN0_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXPOLARITY0_RXUSERCLKIN0_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXPOLARITY1_RXUSERCLKIN1_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXPOLARITY1_RXUSERCLKIN1_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXPOLARITY2_RXUSERCLKIN2_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXPOLARITY2_RXUSERCLKIN2_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXPOLARITY3_RXUSERCLKIN3_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXPOLARITY3_RXUSERCLKIN3_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXPOWERDOWN0_TXUSERCLKIN0_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_RXPOWERDOWN0_TXUSERCLKIN0_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_RXPOWERDOWN1_TXUSERCLKIN1_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_RXPOWERDOWN1_TXUSERCLKIN1_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_RXPOWERDOWN2_TXUSERCLKIN2_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_RXPOWERDOWN2_TXUSERCLKIN2_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_RXPOWERDOWN3_TXUSERCLKIN3_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_RXPOWERDOWN3_TXUSERCLKIN3_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_RXRATE0_TXUSERCLKIN0_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_RXRATE0_TXUSERCLKIN0_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_RXRATE1_TXUSERCLKIN1_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_RXRATE1_TXUSERCLKIN1_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_RXRATE2_TXUSERCLKIN2_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_RXRATE2_TXUSERCLKIN2_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_RXRATE3_TXUSERCLKIN3_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_RXRATE3_TXUSERCLKIN3_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_SAMPLERATE0_TXUSERCLKIN0_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_SAMPLERATE0_TXUSERCLKIN0_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_SAMPLERATE1_TXUSERCLKIN1_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_SAMPLERATE1_TXUSERCLKIN1_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_SAMPLERATE2_TXUSERCLKIN2_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_SAMPLERATE2_TXUSERCLKIN2_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_SAMPLERATE3_TXUSERCLKIN3_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_SAMPLERATE3_TXUSERCLKIN3_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_TXBUFRESET0_TXUSERCLKIN0_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXBUFRESET0_TXUSERCLKIN0_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXBUFRESET1_TXUSERCLKIN1_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXBUFRESET1_TXUSERCLKIN1_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXBUFRESET2_TXUSERCLKIN2_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXBUFRESET2_TXUSERCLKIN2_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXBUFRESET3_TXUSERCLKIN3_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXBUFRESET3_TXUSERCLKIN3_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXCTRL0_TXUSERCLKIN0_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_TXCTRL0_TXUSERCLKIN0_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_TXCTRL1_TXUSERCLKIN1_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_TXCTRL1_TXUSERCLKIN1_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_TXCTRL2_TXUSERCLKIN2_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_TXCTRL2_TXUSERCLKIN2_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_TXCTRL3_TXUSERCLKIN3_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_TXCTRL3_TXUSERCLKIN3_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_TXDATA0_TXUSERCLKIN0_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     tsetup_TXDATA0_TXUSERCLKIN0_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     tsetup_TXDATA1_TXUSERCLKIN1_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     tsetup_TXDATA1_TXUSERCLKIN1_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     tsetup_TXDATA2_TXUSERCLKIN2_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     tsetup_TXDATA2_TXUSERCLKIN2_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     tsetup_TXDATA3_TXUSERCLKIN3_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     tsetup_TXDATA3_TXUSERCLKIN3_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     tsetup_TXDATAMSB0_TXUSERCLKIN0_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_TXDATAMSB0_TXUSERCLKIN0_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_TXDATAMSB1_TXUSERCLKIN1_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_TXDATAMSB1_TXUSERCLKIN1_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_TXDATAMSB2_TXUSERCLKIN2_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_TXDATAMSB2_TXUSERCLKIN2_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_TXDATAMSB3_TXUSERCLKIN3_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_TXDATAMSB3_TXUSERCLKIN3_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_TXDEEMPH0_TXUSERCLKIN0_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXDEEMPH0_TXUSERCLKIN0_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXDEEMPH1_TXUSERCLKIN1_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXDEEMPH1_TXUSERCLKIN1_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXDEEMPH2_TXUSERCLKIN2_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXDEEMPH2_TXUSERCLKIN2_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXDEEMPH3_TXUSERCLKIN3_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXDEEMPH3_TXUSERCLKIN3_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXMARGIN0_TXUSERCLKIN0_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_TXMARGIN0_TXUSERCLKIN0_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_TXMARGIN1_TXUSERCLKIN1_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_TXMARGIN1_TXUSERCLKIN1_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_TXMARGIN2_TXUSERCLKIN2_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_TXMARGIN2_TXUSERCLKIN2_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_TXMARGIN3_TXUSERCLKIN3_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_TXMARGIN3_TXUSERCLKIN3_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_TXPOWERDOWN0_TXUSERCLKIN0_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXPOWERDOWN0_TXUSERCLKIN0_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXPOWERDOWN1_TXUSERCLKIN1_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXPOWERDOWN1_TXUSERCLKIN1_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXPOWERDOWN2_TXUSERCLKIN2_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXPOWERDOWN2_TXUSERCLKIN2_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXPOWERDOWN3_TXUSERCLKIN3_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXPOWERDOWN3_TXUSERCLKIN3_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXRATE0_TXUSERCLKIN0_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXRATE0_TXUSERCLKIN0_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXRATE1_TXUSERCLKIN1_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXRATE1_TXUSERCLKIN1_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXRATE2_TXUSERCLKIN2_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXRATE2_TXUSERCLKIN2_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXRATE3_TXUSERCLKIN3_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXRATE3_TXUSERCLKIN3_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps)
  );
  port (
     DRDY : out std_ulogic;
     DRPDO : out std_logic_vector(15 downto 0);
     GTHINITDONE : out std_ulogic;
     MGMTPCSRDACK : out std_ulogic;
     MGMTPCSRDDATA : out std_logic_vector(15 downto 0);
     RXCODEERR0 : out std_logic_vector(7 downto 0);
     RXCODEERR1 : out std_logic_vector(7 downto 0);
     RXCODEERR2 : out std_logic_vector(7 downto 0);
     RXCODEERR3 : out std_logic_vector(7 downto 0);
     RXCTRL0 : out std_logic_vector(7 downto 0);
     RXCTRL1 : out std_logic_vector(7 downto 0);
     RXCTRL2 : out std_logic_vector(7 downto 0);
     RXCTRL3 : out std_logic_vector(7 downto 0);
     RXCTRLACK0 : out std_ulogic;
     RXCTRLACK1 : out std_ulogic;
     RXCTRLACK2 : out std_ulogic;
     RXCTRLACK3 : out std_ulogic;
     RXDATA0 : out std_logic_vector(63 downto 0);
     RXDATA1 : out std_logic_vector(63 downto 0);
     RXDATA2 : out std_logic_vector(63 downto 0);
     RXDATA3 : out std_logic_vector(63 downto 0);
     RXDATATAP0 : out std_ulogic;
     RXDATATAP1 : out std_ulogic;
     RXDATATAP2 : out std_ulogic;
     RXDATATAP3 : out std_ulogic;
     RXDISPERR0 : out std_logic_vector(7 downto 0);
     RXDISPERR1 : out std_logic_vector(7 downto 0);
     RXDISPERR2 : out std_logic_vector(7 downto 0);
     RXDISPERR3 : out std_logic_vector(7 downto 0);
     RXPCSCLKSMPL0 : out std_ulogic;
     RXPCSCLKSMPL1 : out std_ulogic;
     RXPCSCLKSMPL2 : out std_ulogic;
     RXPCSCLKSMPL3 : out std_ulogic;
     RXUSERCLKOUT0 : out std_ulogic;
     RXUSERCLKOUT1 : out std_ulogic;
     RXUSERCLKOUT2 : out std_ulogic;
     RXUSERCLKOUT3 : out std_ulogic;
     RXVALID0 : out std_logic_vector(7 downto 0);
     RXVALID1 : out std_logic_vector(7 downto 0);
     RXVALID2 : out std_logic_vector(7 downto 0);
     RXVALID3 : out std_logic_vector(7 downto 0);
     TSTPATH : out std_ulogic;
     TSTREFCLKFAB : out std_ulogic;
     TSTREFCLKOUT : out std_ulogic;
     TXCTRLACK0 : out std_ulogic;
     TXCTRLACK1 : out std_ulogic;
     TXCTRLACK2 : out std_ulogic;
     TXCTRLACK3 : out std_ulogic;
     TXDATATAP10 : out std_ulogic;
     TXDATATAP11 : out std_ulogic;
     TXDATATAP12 : out std_ulogic;
     TXDATATAP13 : out std_ulogic;
     TXDATATAP20 : out std_ulogic;
     TXDATATAP21 : out std_ulogic;
     TXDATATAP22 : out std_ulogic;
     TXDATATAP23 : out std_ulogic;
     TXN0 : out std_ulogic;
     TXN1 : out std_ulogic;
     TXN2 : out std_ulogic;
     TXN3 : out std_ulogic;
     TXP0 : out std_ulogic;
     TXP1 : out std_ulogic;
     TXP2 : out std_ulogic;
     TXP3 : out std_ulogic;
     TXPCSCLKSMPL0 : out std_ulogic;
     TXPCSCLKSMPL1 : out std_ulogic;
     TXPCSCLKSMPL2 : out std_ulogic;
     TXPCSCLKSMPL3 : out std_ulogic;
     TXUSERCLKOUT0 : out std_ulogic;
     TXUSERCLKOUT1 : out std_ulogic;
     TXUSERCLKOUT2 : out std_ulogic;
     TXUSERCLKOUT3 : out std_ulogic;
     DADDR : in std_logic_vector(15 downto 0);
     DCLK : in std_ulogic;
     DEN : in std_ulogic;
     DFETRAINCTRL0 : in std_ulogic;
     DFETRAINCTRL1 : in std_ulogic;
     DFETRAINCTRL2 : in std_ulogic;
     DFETRAINCTRL3 : in std_ulogic;
     DI : in std_logic_vector(15 downto 0);
     DISABLEDRP : in std_ulogic;
     DWE : in std_ulogic;
     GTHINIT : in std_ulogic;
     GTHRESET : in std_ulogic;
     GTHX2LANE01 : in std_ulogic;
     GTHX2LANE23 : in std_ulogic;
     GTHX4LANE : in std_ulogic;
     MGMTPCSLANESEL : in std_logic_vector(3 downto 0);
     MGMTPCSMMDADDR : in std_logic_vector(4 downto 0);
     MGMTPCSREGADDR : in std_logic_vector(15 downto 0);
     MGMTPCSREGRD : in std_ulogic;
     MGMTPCSREGWR : in std_ulogic;
     MGMTPCSWRDATA : in std_logic_vector(15 downto 0);
     PLLPCSCLKDIV : in std_logic_vector(5 downto 0);
     PLLREFCLKSEL : in std_logic_vector(2 downto 0);
     POWERDOWN0 : in std_ulogic;
     POWERDOWN1 : in std_ulogic;
     POWERDOWN2 : in std_ulogic;
     POWERDOWN3 : in std_ulogic;
     REFCLK : in std_ulogic;
     RXBUFRESET0 : in std_ulogic;
     RXBUFRESET1 : in std_ulogic;
     RXBUFRESET2 : in std_ulogic;
     RXBUFRESET3 : in std_ulogic;
     RXENCOMMADET0 : in std_ulogic;
     RXENCOMMADET1 : in std_ulogic;
     RXENCOMMADET2 : in std_ulogic;
     RXENCOMMADET3 : in std_ulogic;
     RXN0 : in std_ulogic;
     RXN1 : in std_ulogic;
     RXN2 : in std_ulogic;
     RXN3 : in std_ulogic;
     RXP0 : in std_ulogic;
     RXP1 : in std_ulogic;
     RXP2 : in std_ulogic;
     RXP3 : in std_ulogic;
     RXPOLARITY0 : in std_ulogic;
     RXPOLARITY1 : in std_ulogic;
     RXPOLARITY2 : in std_ulogic;
     RXPOLARITY3 : in std_ulogic;
     RXPOWERDOWN0 : in std_logic_vector(1 downto 0);
     RXPOWERDOWN1 : in std_logic_vector(1 downto 0);
     RXPOWERDOWN2 : in std_logic_vector(1 downto 0);
     RXPOWERDOWN3 : in std_logic_vector(1 downto 0);
     RXRATE0 : in std_logic_vector(1 downto 0);
     RXRATE1 : in std_logic_vector(1 downto 0);
     RXRATE2 : in std_logic_vector(1 downto 0);
     RXRATE3 : in std_logic_vector(1 downto 0);
     RXSLIP0 : in std_ulogic;
     RXSLIP1 : in std_ulogic;
     RXSLIP2 : in std_ulogic;
     RXSLIP3 : in std_ulogic;
     RXUSERCLKIN0 : in std_ulogic;
     RXUSERCLKIN1 : in std_ulogic;
     RXUSERCLKIN2 : in std_ulogic;
     RXUSERCLKIN3 : in std_ulogic;
     SAMPLERATE0 : in std_logic_vector(2 downto 0);
     SAMPLERATE1 : in std_logic_vector(2 downto 0);
     SAMPLERATE2 : in std_logic_vector(2 downto 0);
     SAMPLERATE3 : in std_logic_vector(2 downto 0);
     TXBUFRESET0 : in std_ulogic;
     TXBUFRESET1 : in std_ulogic;
     TXBUFRESET2 : in std_ulogic;
     TXBUFRESET3 : in std_ulogic;
     TXCTRL0 : in std_logic_vector(7 downto 0);
     TXCTRL1 : in std_logic_vector(7 downto 0);
     TXCTRL2 : in std_logic_vector(7 downto 0);
     TXCTRL3 : in std_logic_vector(7 downto 0);
     TXDATA0 : in std_logic_vector(63 downto 0);
     TXDATA1 : in std_logic_vector(63 downto 0);
     TXDATA2 : in std_logic_vector(63 downto 0);
     TXDATA3 : in std_logic_vector(63 downto 0);
     TXDATAMSB0 : in std_logic_vector(7 downto 0);
     TXDATAMSB1 : in std_logic_vector(7 downto 0);
     TXDATAMSB2 : in std_logic_vector(7 downto 0);
     TXDATAMSB3 : in std_logic_vector(7 downto 0);
     TXDEEMPH0 : in std_ulogic;
     TXDEEMPH1 : in std_ulogic;
     TXDEEMPH2 : in std_ulogic;
     TXDEEMPH3 : in std_ulogic;
     TXMARGIN0 : in std_logic_vector(2 downto 0);
     TXMARGIN1 : in std_logic_vector(2 downto 0);
     TXMARGIN2 : in std_logic_vector(2 downto 0);
     TXMARGIN3 : in std_logic_vector(2 downto 0);
     TXPOWERDOWN0 : in std_logic_vector(1 downto 0);
     TXPOWERDOWN1 : in std_logic_vector(1 downto 0);
     TXPOWERDOWN2 : in std_logic_vector(1 downto 0);
     TXPOWERDOWN3 : in std_logic_vector(1 downto 0);
     TXRATE0 : in std_logic_vector(1 downto 0);
     TXRATE1 : in std_logic_vector(1 downto 0);
     TXRATE2 : in std_logic_vector(1 downto 0);
     TXRATE3 : in std_logic_vector(1 downto 0);
     TXUSERCLKIN0 : in std_ulogic;
     TXUSERCLKIN1 : in std_ulogic;
     TXUSERCLKIN2 : in std_ulogic;
     TXUSERCLKIN3 : in std_ulogic
  );
end component;

----- component X_GTPA1_DUAL -----
component X_GTPA1_DUAL
  generic (
     AC_CAP_DIS_0 : boolean := TRUE;
     AC_CAP_DIS_1 : boolean := TRUE;
     ALIGN_COMMA_WORD_0 : integer := 1;
     ALIGN_COMMA_WORD_1 : integer := 1;
     CB2_INH_CC_PERIOD_0 : integer := 8;
     CB2_INH_CC_PERIOD_1 : integer := 8;
     CDR_PH_ADJ_TIME_0 : bit_vector := "01010";
     CDR_PH_ADJ_TIME_1 : bit_vector := "01010";
     CHAN_BOND_1_MAX_SKEW_0 : integer := 7;
     CHAN_BOND_1_MAX_SKEW_1 : integer := 7;
     CHAN_BOND_2_MAX_SKEW_0 : integer := 1;
     CHAN_BOND_2_MAX_SKEW_1 : integer := 1;
     CHAN_BOND_KEEP_ALIGN_0 : boolean := FALSE;
     CHAN_BOND_KEEP_ALIGN_1 : boolean := FALSE;
     CHAN_BOND_SEQ_1_1_0 : bit_vector := "0101111100";
     CHAN_BOND_SEQ_1_1_1 : bit_vector := "0101111100";
     CHAN_BOND_SEQ_1_2_0 : bit_vector := "0001001010";
     CHAN_BOND_SEQ_1_2_1 : bit_vector := "0001001010";
     CHAN_BOND_SEQ_1_3_0 : bit_vector := "0001001010";
     CHAN_BOND_SEQ_1_3_1 : bit_vector := "0001001010";
     CHAN_BOND_SEQ_1_4_0 : bit_vector := "0110111100";
     CHAN_BOND_SEQ_1_4_1 : bit_vector := "0110111100";
     CHAN_BOND_SEQ_1_ENABLE_0 : bit_vector := "1111";
     CHAN_BOND_SEQ_1_ENABLE_1 : bit_vector := "1111";
     CHAN_BOND_SEQ_2_1_0 : bit_vector := "0110111100";
     CHAN_BOND_SEQ_2_1_1 : bit_vector := "0110111100";
     CHAN_BOND_SEQ_2_2_0 : bit_vector := "0100111100";
     CHAN_BOND_SEQ_2_2_1 : bit_vector := "0100111100";
     CHAN_BOND_SEQ_2_3_0 : bit_vector := "0100111100";
     CHAN_BOND_SEQ_2_3_1 : bit_vector := "0100111100";
     CHAN_BOND_SEQ_2_4_0 : bit_vector := "0100111100";
     CHAN_BOND_SEQ_2_4_1 : bit_vector := "0100111100";
     CHAN_BOND_SEQ_2_ENABLE_0 : bit_vector := "1111";
     CHAN_BOND_SEQ_2_ENABLE_1 : bit_vector := "1111";
     CHAN_BOND_SEQ_2_USE_0 : boolean := FALSE;
     CHAN_BOND_SEQ_2_USE_1 : boolean := FALSE;
     CHAN_BOND_SEQ_LEN_0 : integer := 1;
     CHAN_BOND_SEQ_LEN_1 : integer := 1;
     CLK25_DIVIDER_0 : integer := 4;
     CLK25_DIVIDER_1 : integer := 4;
     CLKINDC_B_0 : boolean := TRUE;
     CLKINDC_B_1 : boolean := TRUE;
     CLKRCV_TRST_0 : boolean := TRUE;
     CLKRCV_TRST_1 : boolean := TRUE;
     CLK_CORRECT_USE_0 : boolean := TRUE;
     CLK_CORRECT_USE_1 : boolean := TRUE;
     CLK_COR_ADJ_LEN_0 : integer := 1;
     CLK_COR_ADJ_LEN_1 : integer := 1;
     CLK_COR_DET_LEN_0 : integer := 1;
     CLK_COR_DET_LEN_1 : integer := 1;
     CLK_COR_INSERT_IDLE_FLAG_0 : boolean := FALSE;
     CLK_COR_INSERT_IDLE_FLAG_1 : boolean := FALSE;
     CLK_COR_KEEP_IDLE_0 : boolean := FALSE;
     CLK_COR_KEEP_IDLE_1 : boolean := FALSE;
     CLK_COR_MAX_LAT_0 : integer := 20;
     CLK_COR_MAX_LAT_1 : integer := 20;
     CLK_COR_MIN_LAT_0 : integer := 18;
     CLK_COR_MIN_LAT_1 : integer := 18;
     CLK_COR_PRECEDENCE_0 : boolean := TRUE;
     CLK_COR_PRECEDENCE_1 : boolean := TRUE;
     CLK_COR_REPEAT_WAIT_0 : integer := 0;
     CLK_COR_REPEAT_WAIT_1 : integer := 0;
     CLK_COR_SEQ_1_1_0 : bit_vector := "0100011100";
     CLK_COR_SEQ_1_1_1 : bit_vector := "0100011100";
     CLK_COR_SEQ_1_2_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_2_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_3_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_3_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_4_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_4_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_ENABLE_0 : bit_vector := "1111";
     CLK_COR_SEQ_1_ENABLE_1 : bit_vector := "1111";
     CLK_COR_SEQ_2_1_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_1_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_2_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_2_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_3_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_3_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_4_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_4_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_ENABLE_0 : bit_vector := "1111";
     CLK_COR_SEQ_2_ENABLE_1 : bit_vector := "1111";
     CLK_COR_SEQ_2_USE_0 : boolean := FALSE;
     CLK_COR_SEQ_2_USE_1 : boolean := FALSE;
     CLK_OUT_GTP_SEL_0 : string := "REFCLKPLL0";
     CLK_OUT_GTP_SEL_1 : string := "REFCLKPLL1";
     CM_TRIM_0 : bit_vector := "00";
     CM_TRIM_1 : bit_vector := "00";
     COMMA_10B_ENABLE_0 : bit_vector := "1111111111";
     COMMA_10B_ENABLE_1 : bit_vector := "1111111111";
     COM_BURST_VAL_0 : bit_vector := "1111";
     COM_BURST_VAL_1 : bit_vector := "1111";
     DEC_MCOMMA_DETECT_0 : boolean := TRUE;
     DEC_MCOMMA_DETECT_1 : boolean := TRUE;
     DEC_PCOMMA_DETECT_0 : boolean := TRUE;
     DEC_PCOMMA_DETECT_1 : boolean := TRUE;
     DEC_VALID_COMMA_ONLY_0 : boolean := TRUE;
     DEC_VALID_COMMA_ONLY_1 : boolean := TRUE;
     GTP_CFG_PWRUP_0 : boolean := TRUE;
     GTP_CFG_PWRUP_1 : boolean := TRUE;
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MCOMMA_10B_VALUE_0 : bit_vector := "1010000011";
     MCOMMA_10B_VALUE_1 : bit_vector := "1010000011";
     MCOMMA_DETECT_0 : boolean := TRUE;
     MCOMMA_DETECT_1 : boolean := TRUE;
     MsgOn : boolean := FALSE;
     OOBDETECT_THRESHOLD_0 : bit_vector := "110";
     OOBDETECT_THRESHOLD_1 : bit_vector := "110";
     OOB_CLK_DIVIDER_0 : integer := 4;
     OOB_CLK_DIVIDER_1 : integer := 4;
     PCI_EXPRESS_MODE_0 : boolean := FALSE;
     PCI_EXPRESS_MODE_1 : boolean := FALSE;
     PCOMMA_10B_VALUE_0 : bit_vector := "0101111100";
     PCOMMA_10B_VALUE_1 : bit_vector := "0101111100";
     PCOMMA_DETECT_0 : boolean := TRUE;
     PCOMMA_DETECT_1 : boolean := TRUE;
     PLLLKDET_CFG_0 : bit_vector := "101";
     PLLLKDET_CFG_1 : bit_vector := "101";
     PLL_COM_CFG_0 : bit_vector := X"21680A";
     PLL_COM_CFG_1 : bit_vector := X"21680A";
     PLL_CP_CFG_0 : bit_vector := X"00";
     PLL_CP_CFG_1 : bit_vector := X"00";
     PLL_DIVSEL_FB_0 : integer := 5;
     PLL_DIVSEL_FB_1 : integer := 5;
     PLL_DIVSEL_REF_0 : integer := 2;
     PLL_DIVSEL_REF_1 : integer := 2;
     PLL_RXDIVSEL_OUT_0 : integer := 1;
     PLL_RXDIVSEL_OUT_1 : integer := 1;
     PLL_SATA_0 : boolean := FALSE;
     PLL_SATA_1 : boolean := FALSE;
     PLL_SOURCE_0 : string := "PLL0";
     PLL_SOURCE_1 : string := "PLL0";
     PLL_TXDIVSEL_OUT_0 : integer := 1;
     PLL_TXDIVSEL_OUT_1 : integer := 1;
     PMA_CDR_SCAN_0 : bit_vector := X"6404040";
     PMA_CDR_SCAN_1 : bit_vector := X"6404040";
     PMA_COM_CFG_EAST : bit_vector := X"000008000";
     PMA_COM_CFG_WEST : bit_vector := X"000008000";
     PMA_RXSYNC_CFG_0 : bit_vector := X"00";
     PMA_RXSYNC_CFG_1 : bit_vector := X"00";
     PMA_RX_CFG_0 : bit_vector := X"05CE048";
     PMA_RX_CFG_1 : bit_vector := X"05CE048";
     PMA_TX_CFG_0 : bit_vector := X"00082";
     PMA_TX_CFG_1 : bit_vector := X"00082";
     RCV_TERM_GND_0 : boolean := FALSE;
     RCV_TERM_GND_1 : boolean := FALSE;
     RCV_TERM_VTTRX_0 : boolean := TRUE;
     RCV_TERM_VTTRX_1 : boolean := TRUE;
     RXEQ_CFG_0 : bit_vector := "01111011";
     RXEQ_CFG_1 : bit_vector := "01111011";
     RXPRBSERR_LOOPBACK_0 : bit := '0';
     RXPRBSERR_LOOPBACK_1 : bit := '0';
     RX_BUFFER_USE_0 : boolean := TRUE;
     RX_BUFFER_USE_1 : boolean := TRUE;
     RX_DECODE_SEQ_MATCH_0 : boolean := TRUE;
     RX_DECODE_SEQ_MATCH_1 : boolean := TRUE;
     RX_EN_IDLE_HOLD_CDR_0 : boolean := FALSE;
     RX_EN_IDLE_HOLD_CDR_1 : boolean := FALSE;
     RX_EN_IDLE_RESET_BUF_0 : boolean := TRUE;
     RX_EN_IDLE_RESET_BUF_1 : boolean := TRUE;
     RX_EN_IDLE_RESET_FR_0 : boolean := TRUE;
     RX_EN_IDLE_RESET_FR_1 : boolean := TRUE;
     RX_EN_IDLE_RESET_PH_0 : boolean := TRUE;
     RX_EN_IDLE_RESET_PH_1 : boolean := TRUE;
     RX_EN_MODE_RESET_BUF_0 : boolean := TRUE;
     RX_EN_MODE_RESET_BUF_1 : boolean := TRUE;
     RX_IDLE_HI_CNT_0 : bit_vector := "1000";
     RX_IDLE_HI_CNT_1 : bit_vector := "1000";
     RX_IDLE_LO_CNT_0 : bit_vector := "0000";
     RX_IDLE_LO_CNT_1 : bit_vector := "0000";
     RX_LOSS_OF_SYNC_FSM_0 : boolean := FALSE;
     RX_LOSS_OF_SYNC_FSM_1 : boolean := FALSE;
     RX_LOS_INVALID_INCR_0 : integer := 1;
     RX_LOS_INVALID_INCR_1 : integer := 1;
     RX_LOS_THRESHOLD_0 : integer := 4;
     RX_LOS_THRESHOLD_1 : integer := 4;
     RX_SLIDE_MODE_0 : string := "PCS";
     RX_SLIDE_MODE_1 : string := "PCS";
     RX_STATUS_FMT_0 : string := "PCIE";
     RX_STATUS_FMT_1 : string := "PCIE";
     RX_XCLK_SEL_0 : string := "RXREC";
     RX_XCLK_SEL_1 : string := "RXREC";
     SATA_BURST_VAL_0 : bit_vector := "100";
     SATA_BURST_VAL_1 : bit_vector := "100";
     SATA_IDLE_VAL_0 : bit_vector := "011";
     SATA_IDLE_VAL_1 : bit_vector := "011";
     SATA_MAX_BURST_0 : integer := 7;
     SATA_MAX_BURST_1 : integer := 7;
     SATA_MAX_INIT_0 : integer := 22;
     SATA_MAX_INIT_1 : integer := 22;
     SATA_MAX_WAKE_0 : integer := 7;
     SATA_MAX_WAKE_1 : integer := 7;
     SATA_MIN_BURST_0 : integer := 4;
     SATA_MIN_BURST_1 : integer := 4;
     SATA_MIN_INIT_0 : integer := 12;
     SATA_MIN_INIT_1 : integer := 12;
     SATA_MIN_WAKE_0 : integer := 4;
     SATA_MIN_WAKE_1 : integer := 4;
     SIM_GTPRESET_SPEEDUP : integer := 1;
     SIM_RECEIVER_DETECT_PASS : boolean := TRUE;
     SIM_REFCLK0_SOURCE : bit_vector := "000";
     SIM_REFCLK1_SOURCE : bit_vector := "000";
     SIM_TX_ELEC_IDLE_LEVEL : string := "X";
     SIM_VERSION : string := "2.0";
     TERMINATION_CTRL_0 : bit_vector := "10100";
     TERMINATION_CTRL_1 : bit_vector := "10100";
     TERMINATION_OVRD_0 : boolean := FALSE;
     TERMINATION_OVRD_1 : boolean := FALSE;
     TRANS_TIME_FROM_P2_0 : bit_vector := X"03C";
     TRANS_TIME_FROM_P2_1 : bit_vector := X"03C";
     TRANS_TIME_NON_P2_0 : bit_vector := X"19";
     TRANS_TIME_NON_P2_1 : bit_vector := X"19";
     TRANS_TIME_TO_P2_0 : bit_vector := X"064";
     TRANS_TIME_TO_P2_1 : bit_vector := X"064";
     TST_ATTR_0 : bit_vector := X"00000000";
     TST_ATTR_1 : bit_vector := X"00000000";
     TXRX_INVERT_0 : bit_vector := "011";
     TXRX_INVERT_1 : bit_vector := "011";
     TX_BUFFER_USE_0 : boolean := FALSE;
     TX_BUFFER_USE_1 : boolean := FALSE;
     TX_DETECT_RX_CFG_0 : bit_vector := X"1832";
     TX_DETECT_RX_CFG_1 : bit_vector := X"1832";
     TX_IDLE_DELAY_0 : bit_vector := "011";
     TX_IDLE_DELAY_1 : bit_vector := "011";
     TX_TDCC_CFG_0 : bit_vector := "00";
     TX_TDCC_CFG_1 : bit_vector := "00";
     TX_XCLK_SEL_0 : string := "TXUSR";
     TX_XCLK_SEL_1 : string := "TXUSR";
     TimingChecksOn : boolean := TRUE;
     Xon : boolean := TRUE;
     thold_DADDR_DCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_DADDR_DCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_DEN_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_DEN_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_DI_DCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_DI_DCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_DWE_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_DWE_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PRBSCNTRESET0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_PRBSCNTRESET0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_PRBSCNTRESET1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_PRBSCNTRESET1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXCHBONDI_RXUSRCLK0_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_RXCHBONDI_RXUSRCLK0_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_RXCHBONDI_RXUSRCLK1_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_RXCHBONDI_RXUSRCLK1_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_RXCHBONDMASTER0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXCHBONDMASTER0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXCHBONDMASTER1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXCHBONDMASTER1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXCHBONDSLAVE0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXCHBONDSLAVE0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXCHBONDSLAVE1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXCHBONDSLAVE1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXCOMMADETUSE0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXCOMMADETUSE0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXCOMMADETUSE1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXCOMMADETUSE1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXDEC8B10BUSE0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXDEC8B10BUSE0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXDEC8B10BUSE1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXDEC8B10BUSE1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXENCHANSYNC0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXENCHANSYNC0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXENCHANSYNC1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXENCHANSYNC1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXENMCOMMAALIGN0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXENMCOMMAALIGN0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXENMCOMMAALIGN1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXENMCOMMAALIGN1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXENPCOMMAALIGN0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXENPCOMMAALIGN0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXENPCOMMAALIGN1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXENPCOMMAALIGN1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXENPRBSTST0_RXUSRCLK20_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_RXENPRBSTST0_RXUSRCLK20_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_RXENPRBSTST1_RXUSRCLK21_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_RXENPRBSTST1_RXUSRCLK21_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_RXPOLARITY0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXPOLARITY0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXPOLARITY1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXPOLARITY1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXSLIDE0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXSLIDE0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXSLIDE1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXSLIDE1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXBYPASS8B10B0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXBYPASS8B10B0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXBYPASS8B10B1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXBYPASS8B10B1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXCHARDISPMODE0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXCHARDISPMODE0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXCHARDISPMODE1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXCHARDISPMODE1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXCHARDISPVAL0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXCHARDISPVAL0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXCHARDISPVAL1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXCHARDISPVAL1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXCHARISK0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXCHARISK0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXCHARISK1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXCHARISK1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXCOMSTART0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXCOMSTART0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXCOMSTART1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXCOMSTART1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXCOMTYPE0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXCOMTYPE0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXCOMTYPE1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXCOMTYPE1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXDATA0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     thold_TXDATA0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     thold_TXDATA1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     thold_TXDATA1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     thold_TXDETECTRX0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXDETECTRX0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXDETECTRX1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXDETECTRX1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXELECIDLE0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXELECIDLE0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXELECIDLE1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXELECIDLE1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXENC8B10BUSE0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXENC8B10BUSE0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXENC8B10BUSE1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXENC8B10BUSE1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXENPRBSTST0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_TXENPRBSTST0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_TXENPRBSTST1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_TXENPRBSTST1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_TXINHIBIT0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXINHIBIT0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXINHIBIT1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXINHIBIT1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXPOLARITY0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXPOLARITY0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXPOLARITY1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXPOLARITY1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXPOWERDOWN0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXPOWERDOWN0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXPOWERDOWN1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXPOWERDOWN1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXPRBSFORCEERR0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXPRBSFORCEERR0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXPRBSFORCEERR1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXPRBSFORCEERR1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_USRCODEERR0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_USRCODEERR0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_USRCODEERR1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_USRCODEERR1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     ticd_CLK00 : VitalDelayType := 0 ps;
     ticd_CLK01 : VitalDelayType := 0 ps;
     ticd_CLK10 : VitalDelayType := 0 ps;
     ticd_CLK11 : VitalDelayType := 0 ps;
     ticd_CLKINEAST0 : VitalDelayType := 0 ps;
     ticd_CLKINEAST1 : VitalDelayType := 0 ps;
     ticd_CLKINWEST0 : VitalDelayType := 0 ps;
     ticd_CLKINWEST1 : VitalDelayType := 0 ps;
     ticd_DCLK : VitalDelayType := 0 ps;
     ticd_GCLK00 : VitalDelayType := 0 ps;
     ticd_GCLK01 : VitalDelayType := 0 ps;
     ticd_GCLK10 : VitalDelayType := 0 ps;
     ticd_GCLK11 : VitalDelayType := 0 ps;
     ticd_PLLCLK00 : VitalDelayType := 0 ps;
     ticd_PLLCLK01 : VitalDelayType := 0 ps;
     ticd_PLLCLK10 : VitalDelayType := 0 ps;
     ticd_PLLCLK11 : VitalDelayType := 0 ps;
     ticd_RXUSRCLK0 : VitalDelayType := 0 ps;
     ticd_RXUSRCLK1 : VitalDelayType := 0 ps;
     ticd_RXUSRCLK20 : VitalDelayType := 0 ps;
     ticd_RXUSRCLK21 : VitalDelayType := 0 ps;
     ticd_TXUSRCLK20 : VitalDelayType := 0 ps;
     ticd_TXUSRCLK21 : VitalDelayType := 0 ps;
     tipd_CLK00 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLK01 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLK10 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLK11 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLKINEAST0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLKINEAST1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLKINWEST0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLKINWEST1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DADDR : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
     tipd_DCLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DEN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DI : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
     tipd_DWE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_GATERXELECIDLE0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_GATERXELECIDLE1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_GCLK00 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_GCLK01 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_GCLK10 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_GCLK11 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_GTPCLKFBSEL0EAST : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_GTPCLKFBSEL0WEST : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_GTPCLKFBSEL1EAST : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_GTPCLKFBSEL1WEST : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_GTPRESET0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_GTPRESET1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_GTPTEST0 : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
     tipd_GTPTEST1 : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
     tipd_IGNORESIGDET0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_IGNORESIGDET1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_INTDATAWIDTH0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_INTDATAWIDTH1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_LOOPBACK0 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_LOOPBACK1 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_PLLCLK00 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PLLCLK01 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PLLCLK10 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PLLCLK11 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PLLLKDETEN0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PLLLKDETEN1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PLLPOWERDOWN0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PLLPOWERDOWN1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PRBSCNTRESET0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PRBSCNTRESET1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RCALINEAST : VitalDelayArrayType01 (4 downto 0) := (others => (0 ps, 0 ps));
     tipd_RCALINWEST : VitalDelayArrayType01 (4 downto 0) := (others => (0 ps, 0 ps));
     tipd_REFCLKPWRDNB0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_REFCLKPWRDNB1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_REFSELDYPLL0 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_REFSELDYPLL1 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXBUFRESET0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXBUFRESET1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXCDRRESET0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXCDRRESET1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXCHBONDI : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXCHBONDMASTER0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXCHBONDMASTER1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXCHBONDSLAVE0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXCHBONDSLAVE1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXCOMMADETUSE0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXCOMMADETUSE1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXDATAWIDTH0 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXDATAWIDTH1 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXDEC8B10BUSE0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXDEC8B10BUSE1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENCHANSYNC0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENCHANSYNC1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENMCOMMAALIGN0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENMCOMMAALIGN1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENPCOMMAALIGN0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENPCOMMAALIGN1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENPMAPHASEALIGN0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENPMAPHASEALIGN1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENPRBSTST0 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXENPRBSTST1 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXEQMIX0 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXEQMIX1 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXN0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXN1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXP0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXP1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXPMASETPHASE0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXPMASETPHASE1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXPOLARITY0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXPOLARITY1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXPOWERDOWN0 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXPOWERDOWN1 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXRESET0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXRESET1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXSLIDE0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXSLIDE1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXUSRCLK0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXUSRCLK1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXUSRCLK20 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXUSRCLK21 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TSTCLK0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TSTCLK1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TSTIN0 : VitalDelayArrayType01 (11 downto 0) := (others => (0 ps, 0 ps));
     tipd_TSTIN1 : VitalDelayArrayType01 (11 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXBUFDIFFCTRL0 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXBUFDIFFCTRL1 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXBYPASS8B10B0 : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXBYPASS8B10B1 : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXCHARDISPMODE0 : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXCHARDISPMODE1 : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXCHARDISPVAL0 : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXCHARDISPVAL1 : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXCHARISK0 : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXCHARISK1 : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXCOMSTART0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXCOMSTART1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXCOMTYPE0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXCOMTYPE1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXDATA0 : VitalDelayArrayType01 (31 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXDATA1 : VitalDelayArrayType01 (31 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXDATAWIDTH0 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXDATAWIDTH1 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXDETECTRX0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXDETECTRX1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXDIFFCTRL0 : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXDIFFCTRL1 : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXELECIDLE0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXELECIDLE1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXENC8B10BUSE0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXENC8B10BUSE1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXENPMAPHASEALIGN0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXENPMAPHASEALIGN1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXENPRBSTST0 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXENPRBSTST1 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXINHIBIT0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXINHIBIT1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXPDOWNASYNCH0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXPDOWNASYNCH1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXPMASETPHASE0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXPMASETPHASE1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXPOLARITY0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXPOLARITY1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXPOWERDOWN0 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXPOWERDOWN1 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXPRBSFORCEERR0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXPRBSFORCEERR1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXPREEMPHASIS0 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXPREEMPHASIS1 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXRESET0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXRESET1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXUSRCLK0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXUSRCLK1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXUSRCLK20 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXUSRCLK21 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_USRCODEERR0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_USRCODEERR1 : VitalDelayType01 := (0 ps, 0 ps);
     tisd_DADDR_DCLK : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tisd_DEN_DCLK : VitalDelayType := 0 ps;
     tisd_DI_DCLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tisd_DWE_DCLK : VitalDelayType := 0 ps;
     tisd_PRBSCNTRESET0_RXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_PRBSCNTRESET1_RXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_RXCHBONDI_RXUSRCLK0 : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_RXCHBONDI_RXUSRCLK1 : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_RXCHBONDMASTER0_RXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_RXCHBONDMASTER1_RXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_RXCHBONDSLAVE0_RXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_RXCHBONDSLAVE1_RXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_RXCOMMADETUSE0_RXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_RXCOMMADETUSE1_RXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_RXDEC8B10BUSE0_RXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_RXDEC8B10BUSE1_RXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_RXENCHANSYNC0_RXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_RXENCHANSYNC1_RXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_RXENMCOMMAALIGN0_RXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_RXENMCOMMAALIGN1_RXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_RXENPCOMMAALIGN0_RXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_RXENPCOMMAALIGN1_RXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_RXENPRBSTST0_RXUSRCLK20 : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_RXENPRBSTST1_RXUSRCLK21 : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_RXPOLARITY0_RXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_RXPOLARITY1_RXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_RXSLIDE0_RXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_RXSLIDE1_RXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_TXBYPASS8B10B0_TXUSRCLK20 : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_TXBYPASS8B10B1_TXUSRCLK21 : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_TXCHARDISPMODE0_TXUSRCLK20 : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_TXCHARDISPMODE1_TXUSRCLK21 : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_TXCHARDISPVAL0_TXUSRCLK20 : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_TXCHARDISPVAL1_TXUSRCLK21 : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_TXCHARISK0_TXUSRCLK20 : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_TXCHARISK1_TXUSRCLK21 : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_TXCOMSTART0_TXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_TXCOMSTART1_TXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_TXCOMTYPE0_TXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_TXCOMTYPE1_TXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_TXDATA0_TXUSRCLK20 : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tisd_TXDATA1_TXUSRCLK21 : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tisd_TXDETECTRX0_TXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_TXDETECTRX1_TXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_TXELECIDLE0_TXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_TXELECIDLE1_TXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_TXENC8B10BUSE0_TXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_TXENC8B10BUSE1_TXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_TXENPRBSTST0_TXUSRCLK20 : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_TXENPRBSTST1_TXUSRCLK21 : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_TXINHIBIT0_TXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_TXINHIBIT1_TXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_TXPOLARITY0_TXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_TXPOLARITY1_TXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_TXPOWERDOWN0_TXUSRCLK20 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_TXPOWERDOWN1_TXUSRCLK21 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_TXPRBSFORCEERR0_TXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_TXPRBSFORCEERR1_TXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_USRCODEERR0_RXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_USRCODEERR1_RXUSRCLK21 : VitalDelayType := 0 ps;
     tpd_CLK00_REFCLKPLL0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CLK01_REFCLKPLL1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CLK10_REFCLKPLL0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CLK11_REFCLKPLL1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CLKINEAST0_REFCLKPLL0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CLKINEAST1_REFCLKPLL1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CLKINWEST0_REFCLKPLL0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CLKINWEST1_REFCLKPLL1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_DCLK_DRDY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_DCLK_DRPDO : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
     tpd_GCLK00_REFCLKPLL0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_GCLK01_REFCLKPLL1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_GCLK10_REFCLKPLL0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_GCLK11_REFCLKPLL1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PLLCLK00_REFCLKPLL0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PLLCLK01_REFCLKPLL1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PLLCLK10_REFCLKPLL0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PLLCLK11_REFCLKPLL1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK0_RXCHBONDO : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK1_RXCHBONDO : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_PHYSTATUS0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK20_RXBUFSTATUS0 : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_RXBYTEISALIGNED0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK20_RXBYTEREALIGN0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK20_RXCHANBONDSEQ0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK20_RXCHANISALIGNED0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK20_RXCHANREALIGN0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK20_RXCHARISCOMMA0 : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_RXCHARISK0 : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_RXCLKCORCNT0 : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_RXCOMMADET0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK20_RXDATA0 : VitalDelayArrayType01(31 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_RXDISPERR0 : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_RXLOSSOFSYNC0 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_RXNOTINTABLE0 : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_RXPRBSERR0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK20_RXRUNDISP0 : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_RXSTATUS0 : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_RXVALID0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK21_PHYSTATUS1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK21_RXBUFSTATUS1 : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_RXBYTEISALIGNED1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK21_RXBYTEREALIGN1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK21_RXCHANBONDSEQ1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK21_RXCHANISALIGNED1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK21_RXCHANREALIGN1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK21_RXCHARISCOMMA1 : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_RXCHARISK1 : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_RXCLKCORCNT1 : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_RXCOMMADET1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK21_RXDATA1 : VitalDelayArrayType01(31 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_RXDISPERR1 : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_RXLOSSOFSYNC1 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_RXNOTINTABLE1 : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_RXPRBSERR1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK21_RXRUNDISP1 : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_RXSTATUS1 : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_RXVALID1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_TXUSRCLK20_TXBUFSTATUS0 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_TXUSRCLK20_TXKERR0 : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_TXUSRCLK20_TXRUNDISP0 : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_TXUSRCLK21_TXBUFSTATUS1 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_TXUSRCLK21_TXKERR1 : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_TXUSRCLK21_TXRUNDISP1 : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tperiod_CLK00_posedge : VitalDelayType := 0 ps;
     tperiod_CLK01_posedge : VitalDelayType := 0 ps;
     tperiod_CLK10_posedge : VitalDelayType := 0 ps;
     tperiod_CLK11_posedge : VitalDelayType := 0 ps;
     tperiod_CLKINEAST0_posedge : VitalDelayType := 0 ps;
     tperiod_CLKINEAST1_posedge : VitalDelayType := 0 ps;
     tperiod_CLKINWEST0_posedge : VitalDelayType := 0 ps;
     tperiod_CLKINWEST1_posedge : VitalDelayType := 0 ps;
     tperiod_DCLK_posedge : VitalDelayType := 0 ps;
     tperiod_GCLK00_posedge : VitalDelayType := 0 ps;
     tperiod_GCLK01_posedge : VitalDelayType := 0 ps;
     tperiod_GCLK10_posedge : VitalDelayType := 0 ps;
     tperiod_GCLK11_posedge : VitalDelayType := 0 ps;
     tperiod_PLLCLK00_posedge : VitalDelayType := 0 ps;
     tperiod_PLLCLK01_posedge : VitalDelayType := 0 ps;
     tperiod_PLLCLK10_posedge : VitalDelayType := 0 ps;
     tperiod_PLLCLK11_posedge : VitalDelayType := 0 ps;
     tperiod_RXUSRCLK0_posedge : VitalDelayType := 0 ps;
     tperiod_RXUSRCLK1_posedge : VitalDelayType := 0 ps;
     tperiod_RXUSRCLK20_posedge : VitalDelayType := 0 ps;
     tperiod_RXUSRCLK21_posedge : VitalDelayType := 0 ps;
     tperiod_TSTCLK0_posedge : VitalDelayType := 0 ps;
     tperiod_TSTCLK1_posedge : VitalDelayType := 0 ps;
     tperiod_TXUSRCLK0_posedge : VitalDelayType := 0 ps;
     tperiod_TXUSRCLK1_posedge : VitalDelayType := 0 ps;
     tperiod_TXUSRCLK20_posedge : VitalDelayType := 0 ps;
     tperiod_TXUSRCLK21_posedge : VitalDelayType := 0 ps;
     tsetup_DADDR_DCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_DADDR_DCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_DEN_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_DEN_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_DI_DCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_DI_DCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_DWE_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_DWE_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PRBSCNTRESET0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PRBSCNTRESET0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PRBSCNTRESET1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PRBSCNTRESET1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXCHBONDI_RXUSRCLK0_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_RXCHBONDI_RXUSRCLK0_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_RXCHBONDI_RXUSRCLK1_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_RXCHBONDI_RXUSRCLK1_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_RXCHBONDMASTER0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXCHBONDMASTER0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXCHBONDMASTER1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXCHBONDMASTER1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXCHBONDSLAVE0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXCHBONDSLAVE0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXCHBONDSLAVE1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXCHBONDSLAVE1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXCOMMADETUSE0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXCOMMADETUSE0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXCOMMADETUSE1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXCOMMADETUSE1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXDEC8B10BUSE0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXDEC8B10BUSE0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXDEC8B10BUSE1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXDEC8B10BUSE1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENCHANSYNC0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENCHANSYNC0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENCHANSYNC1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENCHANSYNC1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENMCOMMAALIGN0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENMCOMMAALIGN0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENMCOMMAALIGN1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENMCOMMAALIGN1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENPCOMMAALIGN0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENPCOMMAALIGN0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENPCOMMAALIGN1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENPCOMMAALIGN1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENPRBSTST0_RXUSRCLK20_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_RXENPRBSTST0_RXUSRCLK20_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_RXENPRBSTST1_RXUSRCLK21_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_RXENPRBSTST1_RXUSRCLK21_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_RXPOLARITY0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXPOLARITY0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXPOLARITY1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXPOLARITY1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXSLIDE0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXSLIDE0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXSLIDE1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXSLIDE1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXBYPASS8B10B0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXBYPASS8B10B0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXBYPASS8B10B1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXBYPASS8B10B1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXCHARDISPMODE0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXCHARDISPMODE0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXCHARDISPMODE1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXCHARDISPMODE1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXCHARDISPVAL0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXCHARDISPVAL0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXCHARDISPVAL1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXCHARDISPVAL1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXCHARISK0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXCHARISK0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXCHARISK1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXCHARISK1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXCOMSTART0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXCOMSTART0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXCOMSTART1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXCOMSTART1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXCOMTYPE0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXCOMTYPE0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXCOMTYPE1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXCOMTYPE1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXDATA0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tsetup_TXDATA0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tsetup_TXDATA1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tsetup_TXDATA1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tsetup_TXDETECTRX0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXDETECTRX0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXDETECTRX1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXDETECTRX1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXELECIDLE0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXELECIDLE0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXELECIDLE1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXELECIDLE1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXENC8B10BUSE0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXENC8B10BUSE0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXENC8B10BUSE1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXENC8B10BUSE1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXENPRBSTST0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_TXENPRBSTST0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_TXENPRBSTST1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_TXENPRBSTST1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_TXINHIBIT0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXINHIBIT0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXINHIBIT1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXINHIBIT1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXPOLARITY0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXPOLARITY0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXPOLARITY1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXPOLARITY1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXPOWERDOWN0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXPOWERDOWN0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXPOWERDOWN1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXPOWERDOWN1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXPRBSFORCEERR0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXPRBSFORCEERR0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXPRBSFORCEERR1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXPRBSFORCEERR1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_USRCODEERR0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_USRCODEERR0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_USRCODEERR1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_USRCODEERR1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     DRDY : out std_ulogic;
     DRPDO : out std_logic_vector(15 downto 0);
     GTPCLKFBEAST : out std_logic_vector(1 downto 0);
     GTPCLKFBWEST : out std_logic_vector(1 downto 0);
     GTPCLKOUT0 : out std_logic_vector(1 downto 0);
     GTPCLKOUT1 : out std_logic_vector(1 downto 0);
     PHYSTATUS0 : out std_ulogic;
     PHYSTATUS1 : out std_ulogic;
     PLLLKDET0 : out std_ulogic;
     PLLLKDET1 : out std_ulogic;
     RCALOUTEAST : out std_logic_vector(4 downto 0);
     RCALOUTWEST : out std_logic_vector(4 downto 0);
     REFCLKOUT0 : out std_ulogic;
     REFCLKOUT1 : out std_ulogic;
     REFCLKPLL0 : out std_ulogic;
     REFCLKPLL1 : out std_ulogic;
     RESETDONE0 : out std_ulogic;
     RESETDONE1 : out std_ulogic;
     RXBUFSTATUS0 : out std_logic_vector(2 downto 0);
     RXBUFSTATUS1 : out std_logic_vector(2 downto 0);
     RXBYTEISALIGNED0 : out std_ulogic;
     RXBYTEISALIGNED1 : out std_ulogic;
     RXBYTEREALIGN0 : out std_ulogic;
     RXBYTEREALIGN1 : out std_ulogic;
     RXCHANBONDSEQ0 : out std_ulogic;
     RXCHANBONDSEQ1 : out std_ulogic;
     RXCHANISALIGNED0 : out std_ulogic;
     RXCHANISALIGNED1 : out std_ulogic;
     RXCHANREALIGN0 : out std_ulogic;
     RXCHANREALIGN1 : out std_ulogic;
     RXCHARISCOMMA0 : out std_logic_vector(3 downto 0);
     RXCHARISCOMMA1 : out std_logic_vector(3 downto 0);
     RXCHARISK0 : out std_logic_vector(3 downto 0);
     RXCHARISK1 : out std_logic_vector(3 downto 0);
     RXCHBONDO : out std_logic_vector(2 downto 0);
     RXCLKCORCNT0 : out std_logic_vector(2 downto 0);
     RXCLKCORCNT1 : out std_logic_vector(2 downto 0);
     RXCOMMADET0 : out std_ulogic;
     RXCOMMADET1 : out std_ulogic;
     RXDATA0 : out std_logic_vector(31 downto 0);
     RXDATA1 : out std_logic_vector(31 downto 0);
     RXDISPERR0 : out std_logic_vector(3 downto 0);
     RXDISPERR1 : out std_logic_vector(3 downto 0);
     RXELECIDLE0 : out std_ulogic;
     RXELECIDLE1 : out std_ulogic;
     RXLOSSOFSYNC0 : out std_logic_vector(1 downto 0);
     RXLOSSOFSYNC1 : out std_logic_vector(1 downto 0);
     RXNOTINTABLE0 : out std_logic_vector(3 downto 0);
     RXNOTINTABLE1 : out std_logic_vector(3 downto 0);
     RXPRBSERR0 : out std_ulogic;
     RXPRBSERR1 : out std_ulogic;
     RXRECCLK0 : out std_ulogic;
     RXRECCLK1 : out std_ulogic;
     RXRUNDISP0 : out std_logic_vector(3 downto 0);
     RXRUNDISP1 : out std_logic_vector(3 downto 0);
     RXSTATUS0 : out std_logic_vector(2 downto 0);
     RXSTATUS1 : out std_logic_vector(2 downto 0);
     RXVALID0 : out std_ulogic;
     RXVALID1 : out std_ulogic;
     TSTOUT0 : out std_logic_vector(4 downto 0);
     TSTOUT1 : out std_logic_vector(4 downto 0);
     TXBUFSTATUS0 : out std_logic_vector(1 downto 0);
     TXBUFSTATUS1 : out std_logic_vector(1 downto 0);
     TXKERR0 : out std_logic_vector(3 downto 0);
     TXKERR1 : out std_logic_vector(3 downto 0);
     TXN0 : out std_ulogic;
     TXN1 : out std_ulogic;
     TXOUTCLK0 : out std_ulogic;
     TXOUTCLK1 : out std_ulogic;
     TXP0 : out std_ulogic;
     TXP1 : out std_ulogic;
     TXRUNDISP0 : out std_logic_vector(3 downto 0);
     TXRUNDISP1 : out std_logic_vector(3 downto 0);
     CLK00 : in std_ulogic;
     CLK01 : in std_ulogic;
     CLK10 : in std_ulogic;
     CLK11 : in std_ulogic;
     CLKINEAST0 : in std_ulogic;
     CLKINEAST1 : in std_ulogic;
     CLKINWEST0 : in std_ulogic;
     CLKINWEST1 : in std_ulogic;
     DADDR : in std_logic_vector(7 downto 0);
     DCLK : in std_ulogic := 'L';
     DEN : in std_ulogic := 'L';
     DI : in std_logic_vector(15 downto 0);
     DWE : in std_ulogic := 'L';
     GATERXELECIDLE0 : in std_ulogic := 'L';
     GATERXELECIDLE1 : in std_ulogic := 'L';
     GCLK00 : in std_ulogic;
     GCLK01 : in std_ulogic;
     GCLK10 : in std_ulogic;
     GCLK11 : in std_ulogic;
     GTPCLKFBSEL0EAST : in std_logic_vector(1 downto 0);
     GTPCLKFBSEL0WEST : in std_logic_vector(1 downto 0);
     GTPCLKFBSEL1EAST : in std_logic_vector(1 downto 0);
     GTPCLKFBSEL1WEST : in std_logic_vector(1 downto 0);
     GTPRESET0 : in std_ulogic := 'L';
     GTPRESET1 : in std_ulogic := 'L';
     GTPTEST0 : in std_logic_vector(7 downto 0);
     GTPTEST1 : in std_logic_vector(7 downto 0);
     IGNORESIGDET0 : in std_ulogic := 'L';
     IGNORESIGDET1 : in std_ulogic := 'L';
     INTDATAWIDTH0 : in std_ulogic := 'L';
     INTDATAWIDTH1 : in std_ulogic := 'L';
     LOOPBACK0 : in std_logic_vector(2 downto 0);
     LOOPBACK1 : in std_logic_vector(2 downto 0);
     PLLCLK00 : in std_ulogic;
     PLLCLK01 : in std_ulogic;
     PLLCLK10 : in std_ulogic;
     PLLCLK11 : in std_ulogic;
     PLLLKDETEN0 : in std_ulogic := 'L';
     PLLLKDETEN1 : in std_ulogic := 'L';
     PLLPOWERDOWN0 : in std_ulogic := 'L';
     PLLPOWERDOWN1 : in std_ulogic := 'L';
     PRBSCNTRESET0 : in std_ulogic := 'L';
     PRBSCNTRESET1 : in std_ulogic := 'L';
     RCALINEAST : in std_logic_vector(4 downto 0);
     RCALINWEST : in std_logic_vector(4 downto 0);
     REFCLKPWRDNB0 : in std_ulogic := 'H';
     REFCLKPWRDNB1 : in std_ulogic := 'H';
     REFSELDYPLL0 : in std_logic_vector(2 downto 0);
     REFSELDYPLL1 : in std_logic_vector(2 downto 0);
     RXBUFRESET0 : in std_ulogic := 'L';
     RXBUFRESET1 : in std_ulogic := 'L';
     RXCDRRESET0 : in std_ulogic := 'L';
     RXCDRRESET1 : in std_ulogic := 'L';
     RXCHBONDI : in std_logic_vector(2 downto 0);
     RXCHBONDMASTER0 : in std_ulogic := 'L';
     RXCHBONDMASTER1 : in std_ulogic := 'L';
     RXCHBONDSLAVE0 : in std_ulogic := 'L';
     RXCHBONDSLAVE1 : in std_ulogic := 'L';
     RXCOMMADETUSE0 : in std_ulogic := 'L';
     RXCOMMADETUSE1 : in std_ulogic := 'L';
     RXDATAWIDTH0 : in std_logic_vector(1 downto 0);
     RXDATAWIDTH1 : in std_logic_vector(1 downto 0);
     RXDEC8B10BUSE0 : in std_ulogic := 'L';
     RXDEC8B10BUSE1 : in std_ulogic := 'L';
     RXENCHANSYNC0 : in std_ulogic := 'L';
     RXENCHANSYNC1 : in std_ulogic := 'L';
     RXENMCOMMAALIGN0 : in std_ulogic := 'L';
     RXENMCOMMAALIGN1 : in std_ulogic := 'L';
     RXENPCOMMAALIGN0 : in std_ulogic := 'L';
     RXENPCOMMAALIGN1 : in std_ulogic := 'L';
     RXENPMAPHASEALIGN0 : in std_ulogic := 'L';
     RXENPMAPHASEALIGN1 : in std_ulogic := 'L';
     RXENPRBSTST0 : in std_logic_vector(2 downto 0);
     RXENPRBSTST1 : in std_logic_vector(2 downto 0);
     RXEQMIX0 : in std_logic_vector(1 downto 0);
     RXEQMIX1 : in std_logic_vector(1 downto 0);
     RXN0 : in std_ulogic;
     RXN1 : in std_ulogic;
     RXP0 : in std_ulogic;
     RXP1 : in std_ulogic;
     RXPMASETPHASE0 : in std_ulogic := 'L';
     RXPMASETPHASE1 : in std_ulogic := 'L';
     RXPOLARITY0 : in std_ulogic := 'L';
     RXPOLARITY1 : in std_ulogic := 'L';
     RXPOWERDOWN0 : in std_logic_vector(1 downto 0);
     RXPOWERDOWN1 : in std_logic_vector(1 downto 0);
     RXRESET0 : in std_ulogic := 'L';
     RXRESET1 : in std_ulogic := 'L';
     RXSLIDE0 : in std_ulogic := 'L';
     RXSLIDE1 : in std_ulogic := 'L';
     RXUSRCLK0 : in std_ulogic := 'L';
     RXUSRCLK1 : in std_ulogic := 'L';
     RXUSRCLK20 : in std_ulogic := 'L';
     RXUSRCLK21 : in std_ulogic := 'L';
     TSTCLK0 : in std_ulogic := 'L';
     TSTCLK1 : in std_ulogic := 'L';
     TSTIN0 : in std_logic_vector(11 downto 0);
     TSTIN1 : in std_logic_vector(11 downto 0);
     TXBUFDIFFCTRL0 : in std_logic_vector(2 downto 0);
     TXBUFDIFFCTRL1 : in std_logic_vector(2 downto 0);
     TXBYPASS8B10B0 : in std_logic_vector(3 downto 0);
     TXBYPASS8B10B1 : in std_logic_vector(3 downto 0);
     TXCHARDISPMODE0 : in std_logic_vector(3 downto 0);
     TXCHARDISPMODE1 : in std_logic_vector(3 downto 0);
     TXCHARDISPVAL0 : in std_logic_vector(3 downto 0);
     TXCHARDISPVAL1 : in std_logic_vector(3 downto 0);
     TXCHARISK0 : in std_logic_vector(3 downto 0);
     TXCHARISK1 : in std_logic_vector(3 downto 0);
     TXCOMSTART0 : in std_ulogic := 'L';
     TXCOMSTART1 : in std_ulogic := 'L';
     TXCOMTYPE0 : in std_ulogic := 'L';
     TXCOMTYPE1 : in std_ulogic := 'L';
     TXDATA0 : in std_logic_vector(31 downto 0);
     TXDATA1 : in std_logic_vector(31 downto 0);
     TXDATAWIDTH0 : in std_logic_vector(1 downto 0);
     TXDATAWIDTH1 : in std_logic_vector(1 downto 0);
     TXDETECTRX0 : in std_ulogic := 'L';
     TXDETECTRX1 : in std_ulogic := 'L';
     TXDIFFCTRL0 : in std_logic_vector(3 downto 0);
     TXDIFFCTRL1 : in std_logic_vector(3 downto 0);
     TXELECIDLE0 : in std_ulogic := 'L';
     TXELECIDLE1 : in std_ulogic := 'L';
     TXENC8B10BUSE0 : in std_ulogic := 'L';
     TXENC8B10BUSE1 : in std_ulogic := 'L';
     TXENPMAPHASEALIGN0 : in std_ulogic := 'L';
     TXENPMAPHASEALIGN1 : in std_ulogic := 'L';
     TXENPRBSTST0 : in std_logic_vector(2 downto 0);
     TXENPRBSTST1 : in std_logic_vector(2 downto 0);
     TXINHIBIT0 : in std_ulogic := 'L';
     TXINHIBIT1 : in std_ulogic := 'L';
     TXPDOWNASYNCH0 : in std_ulogic := 'L';
     TXPDOWNASYNCH1 : in std_ulogic := 'L';
     TXPMASETPHASE0 : in std_ulogic := 'L';
     TXPMASETPHASE1 : in std_ulogic := 'L';
     TXPOLARITY0 : in std_ulogic := 'L';
     TXPOLARITY1 : in std_ulogic := 'L';
     TXPOWERDOWN0 : in std_logic_vector(1 downto 0);
     TXPOWERDOWN1 : in std_logic_vector(1 downto 0);
     TXPRBSFORCEERR0 : in std_ulogic := 'L';
     TXPRBSFORCEERR1 : in std_ulogic := 'L';
     TXPREEMPHASIS0 : in std_logic_vector(2 downto 0);
     TXPREEMPHASIS1 : in std_logic_vector(2 downto 0);
     TXRESET0 : in std_ulogic := 'L';
     TXRESET1 : in std_ulogic := 'L';
     TXUSRCLK0 : in std_ulogic := 'L';
     TXUSRCLK1 : in std_ulogic := 'L';
     TXUSRCLK20 : in std_ulogic := 'L';
     TXUSRCLK21 : in std_ulogic := 'L';
     USRCODEERR0 : in std_ulogic := 'L';
     USRCODEERR1 : in std_ulogic := 'L'
  );
end component;

----- component X_GTP_DUAL -----
component X_GTP_DUAL
  generic (
     AC_CAP_DIS_0 : boolean := TRUE;
     AC_CAP_DIS_1 : boolean := TRUE;
     ALIGN_COMMA_WORD_0 : integer := 1;
     ALIGN_COMMA_WORD_1 : integer := 1;
     CHAN_BOND_1_MAX_SKEW_0 : integer := 7;
     CHAN_BOND_1_MAX_SKEW_1 : integer := 7;
     CHAN_BOND_2_MAX_SKEW_0 : integer := 1;
     CHAN_BOND_2_MAX_SKEW_1 : integer := 1;
     CHAN_BOND_LEVEL_0 : integer := 0;
     CHAN_BOND_LEVEL_1 : integer := 0;
     CHAN_BOND_MODE_0 : string := "OFF";
     CHAN_BOND_MODE_1 : string := "OFF";
     CHAN_BOND_SEQ_1_1_0 : bit_vector := "0001001010";
     CHAN_BOND_SEQ_1_1_1 : bit_vector := "0001001010";
     CHAN_BOND_SEQ_1_2_0 : bit_vector := "0001001010";
     CHAN_BOND_SEQ_1_2_1 : bit_vector := "0001001010";
     CHAN_BOND_SEQ_1_3_0 : bit_vector := "0001001010";
     CHAN_BOND_SEQ_1_3_1 : bit_vector := "0001001010";
     CHAN_BOND_SEQ_1_4_0 : bit_vector := "0110111100";
     CHAN_BOND_SEQ_1_4_1 : bit_vector := "0110111100";
     CHAN_BOND_SEQ_1_ENABLE_0 : bit_vector := "1111";
     CHAN_BOND_SEQ_1_ENABLE_1 : bit_vector := "1111";
     CHAN_BOND_SEQ_2_1_0 : bit_vector := "0110111100";
     CHAN_BOND_SEQ_2_1_1 : bit_vector := "0110111100";
     CHAN_BOND_SEQ_2_2_0 : bit_vector := "0100111100";
     CHAN_BOND_SEQ_2_2_1 : bit_vector := "0100111100";
     CHAN_BOND_SEQ_2_3_0 : bit_vector := "0100111100";
     CHAN_BOND_SEQ_2_3_1 : bit_vector := "0100111100";
     CHAN_BOND_SEQ_2_4_0 : bit_vector := "0100111100";
     CHAN_BOND_SEQ_2_4_1 : bit_vector := "0100111100";
     CHAN_BOND_SEQ_2_ENABLE_0 : bit_vector := "1111";
     CHAN_BOND_SEQ_2_ENABLE_1 : bit_vector := "1111";
     CHAN_BOND_SEQ_2_USE_0 : boolean := TRUE;
     CHAN_BOND_SEQ_2_USE_1 : boolean := TRUE;
     CHAN_BOND_SEQ_LEN_0 : integer := 4;
     CHAN_BOND_SEQ_LEN_1 : integer := 4;
     CLK25_DIVIDER : integer := 4;
     CLKINDC_B : boolean := TRUE;
     CLK_CORRECT_USE_0 : boolean := TRUE;
     CLK_CORRECT_USE_1 : boolean := TRUE;
     CLK_COR_ADJ_LEN_0 : integer := 1;
     CLK_COR_ADJ_LEN_1 : integer := 1;
     CLK_COR_DET_LEN_0 : integer := 1;
     CLK_COR_DET_LEN_1 : integer := 1;
     CLK_COR_INSERT_IDLE_FLAG_0 : boolean := FALSE;
     CLK_COR_INSERT_IDLE_FLAG_1 : boolean := FALSE;
     CLK_COR_KEEP_IDLE_0 : boolean := FALSE;
     CLK_COR_KEEP_IDLE_1 : boolean := FALSE;
     CLK_COR_MAX_LAT_0 : integer := 18;
     CLK_COR_MAX_LAT_1 : integer := 18;
     CLK_COR_MIN_LAT_0 : integer := 16;
     CLK_COR_MIN_LAT_1 : integer := 16;
     CLK_COR_PRECEDENCE_0 : boolean := TRUE;
     CLK_COR_PRECEDENCE_1 : boolean := TRUE;
     CLK_COR_REPEAT_WAIT_0 : integer := 5;
     CLK_COR_REPEAT_WAIT_1 : integer := 5;
     CLK_COR_SEQ_1_1_0 : bit_vector := "0100011100";
     CLK_COR_SEQ_1_1_1 : bit_vector := "0100011100";
     CLK_COR_SEQ_1_2_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_2_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_3_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_3_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_4_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_4_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_ENABLE_0 : bit_vector := "1111";
     CLK_COR_SEQ_1_ENABLE_1 : bit_vector := "1111";
     CLK_COR_SEQ_2_1_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_1_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_2_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_2_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_3_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_3_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_4_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_4_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_ENABLE_0 : bit_vector := "1111";
     CLK_COR_SEQ_2_ENABLE_1 : bit_vector := "1111";
     CLK_COR_SEQ_2_USE_0 : boolean := FALSE;
     CLK_COR_SEQ_2_USE_1 : boolean := FALSE;
     COMMA_10B_ENABLE_0 : bit_vector := "1111111111";
     COMMA_10B_ENABLE_1 : bit_vector := "1111111111";
     COMMA_DOUBLE_0 : boolean := FALSE;
     COMMA_DOUBLE_1 : boolean := FALSE;
     COM_BURST_VAL_0 : bit_vector := "1111";
     COM_BURST_VAL_1 : bit_vector := "1111";
     DEC_MCOMMA_DETECT_0 : boolean := TRUE;
     DEC_MCOMMA_DETECT_1 : boolean := TRUE;
     DEC_PCOMMA_DETECT_0 : boolean := TRUE;
     DEC_PCOMMA_DETECT_1 : boolean := TRUE;
     DEC_VALID_COMMA_ONLY_0 : boolean := TRUE;
     DEC_VALID_COMMA_ONLY_1 : boolean := TRUE;
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MCOMMA_10B_VALUE_0 : bit_vector := "1010000011";
     MCOMMA_10B_VALUE_1 : bit_vector := "1010000011";
     MCOMMA_DETECT_0 : boolean := TRUE;
     MCOMMA_DETECT_1 : boolean := TRUE;
     MsgOn : boolean := FALSE;
     OOBDETECT_THRESHOLD_0 : bit_vector := "001";
     OOBDETECT_THRESHOLD_1 : bit_vector := "001";
     OOB_CLK_DIVIDER : integer := 4;
     OVERSAMPLE_MODE : boolean := FALSE;
     PCI_EXPRESS_MODE_0 : boolean := TRUE;
     PCI_EXPRESS_MODE_1 : boolean := TRUE;
     PCOMMA_10B_VALUE_0 : bit_vector := "0101111100";
     PCOMMA_10B_VALUE_1 : bit_vector := "0101111100";
     PCOMMA_DETECT_0 : boolean := TRUE;
     PCOMMA_DETECT_1 : boolean := TRUE;
     PCS_COM_CFG : bit_vector := X"1680a0e";
     PLL_DIVSEL_FB : integer := 5;
     PLL_DIVSEL_REF : integer := 2;
     PLL_RXDIVSEL_OUT_0 : integer := 1;
     PLL_RXDIVSEL_OUT_1 : integer := 1;
     PLL_SATA_0 : boolean := FALSE;
     PLL_SATA_1 : boolean := FALSE;
     PLL_TXDIVSEL_COMM_OUT : integer := 1;
     PLL_TXDIVSEL_OUT_0 : integer := 1;
     PLL_TXDIVSEL_OUT_1 : integer := 1;
     PMA_CDR_SCAN_0 : bit_vector := X"6c07640";
     PMA_CDR_SCAN_1 : bit_vector := X"6c07640";
     PMA_RX_CFG_0 : bit_vector := X"09f0089";
     PMA_RX_CFG_1 : bit_vector := X"09f0089";
     PRBS_ERR_THRESHOLD_0 : bit_vector := X"00000001";
     PRBS_ERR_THRESHOLD_1 : bit_vector := X"00000001";
     RCV_TERM_GND_0 : boolean := TRUE;
     RCV_TERM_GND_1 : boolean := TRUE;
     RCV_TERM_MID_0 : boolean := FALSE;
     RCV_TERM_MID_1 : boolean := FALSE;
     RCV_TERM_VTTRX_0 : boolean := FALSE;
     RCV_TERM_VTTRX_1 : boolean := FALSE;
     RX_BUFFER_USE_0 : boolean := TRUE;
     RX_BUFFER_USE_1 : boolean := TRUE;
     RX_DECODE_SEQ_MATCH_0 : boolean := TRUE;
     RX_DECODE_SEQ_MATCH_1 : boolean := TRUE;
     RX_LOSS_OF_SYNC_FSM_0 : boolean := FALSE;
     RX_LOSS_OF_SYNC_FSM_1 : boolean := FALSE;
     RX_LOS_INVALID_INCR_0 : integer := 8;
     RX_LOS_INVALID_INCR_1 : integer := 8;
     RX_LOS_THRESHOLD_0 : integer := 128;
     RX_LOS_THRESHOLD_1 : integer := 128;
     RX_SLIDE_MODE_0 : string := "PCS";
     RX_SLIDE_MODE_1 : string := "PCS";
     RX_STATUS_FMT_0 : string := "PCIE";
     RX_STATUS_FMT_1 : string := "PCIE";
     RX_XCLK_SEL_0 : string := "RXREC";
     RX_XCLK_SEL_1 : string := "RXREC";
     SATA_BURST_VAL_0 : bit_vector := "100";
     SATA_BURST_VAL_1 : bit_vector := "100";
     SATA_IDLE_VAL_0 : bit_vector := "011";
     SATA_IDLE_VAL_1 : bit_vector := "011";
     SATA_MAX_BURST_0 : integer := 7;
     SATA_MAX_BURST_1 : integer := 7;
     SATA_MAX_INIT_0 : integer := 22;
     SATA_MAX_INIT_1 : integer := 22;
     SATA_MAX_WAKE_0 : integer := 7;
     SATA_MAX_WAKE_1 : integer := 7;
     SATA_MIN_BURST_0 : integer := 4;
     SATA_MIN_BURST_1 : integer := 4;
     SATA_MIN_INIT_0 : integer := 12;
     SATA_MIN_INIT_1 : integer := 12;
     SATA_MIN_WAKE_0 : integer := 4;
     SATA_MIN_WAKE_1 : integer := 4;
     SIM_GTPRESET_SPEEDUP : integer := 0;
     SIM_MODE : string := "FAST";
     SIM_PLL_PERDIV2 : bit_vector := X"190";
     SIM_RECEIVER_DETECT_PASS0 : boolean := FALSE;
     SIM_RECEIVER_DETECT_PASS1 : boolean := FALSE;
     TERMINATION_CTRL : bit_vector := "10100";
     TERMINATION_IMP_0 : integer := 50;
     TERMINATION_IMP_1 : integer := 50;
     TERMINATION_OVRD : boolean := FALSE;
     TRANS_TIME_FROM_P2_0 : bit_vector := X"003c";
     TRANS_TIME_FROM_P2_1 : bit_vector := X"003c";
     TRANS_TIME_NON_P2_0 : bit_vector := X"0019";
     TRANS_TIME_NON_P2_1 : bit_vector := X"0019";
     TRANS_TIME_TO_P2_0 : bit_vector := X"0064";
     TRANS_TIME_TO_P2_1 : bit_vector := X"0064";
     TXRX_INVERT_0 : bit_vector := "00000";
     TXRX_INVERT_1 : bit_vector := "00000";
     TX_BUFFER_USE_0 : boolean := TRUE;
     TX_BUFFER_USE_1 : boolean := TRUE;
     TX_DIFF_BOOST_0 : boolean := TRUE;
     TX_DIFF_BOOST_1 : boolean := TRUE;
     TX_SYNC_FILTERB : integer := 1;
     TX_XCLK_SEL_0 : string := "TXUSR";
     TX_XCLK_SEL_1 : string := "TXUSR";
     TimingChecksOn : boolean := TRUE;
     Xon : boolean := TRUE;
     thold_DADDR_DCLK_negedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     thold_DADDR_DCLK_posedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     thold_DEN_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_DEN_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_DI_DCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_DI_DCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_DWE_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_DWE_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PRBSCNTRESET0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_PRBSCNTRESET0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_PRBSCNTRESET1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_PRBSCNTRESET1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXCHBONDI0_RXUSRCLK0_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_RXCHBONDI0_RXUSRCLK0_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_RXCHBONDI1_RXUSRCLK1_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_RXCHBONDI1_RXUSRCLK1_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_RXCOMMADETUSE0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXCOMMADETUSE0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXCOMMADETUSE1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXCOMMADETUSE1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXDEC8B10BUSE0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXDEC8B10BUSE0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXDEC8B10BUSE1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXDEC8B10BUSE1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXENCHANSYNC0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXENCHANSYNC0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXENCHANSYNC1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXENCHANSYNC1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXENMCOMMAALIGN0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXENMCOMMAALIGN0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXENMCOMMAALIGN1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXENMCOMMAALIGN1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXENPCOMMAALIGN0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXENPCOMMAALIGN0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXENPCOMMAALIGN1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXENPCOMMAALIGN1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXENPRBSTST0_RXUSRCLK20_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_RXENPRBSTST0_RXUSRCLK20_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_RXENPRBSTST1_RXUSRCLK21_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_RXENPRBSTST1_RXUSRCLK21_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_RXENSAMPLEALIGN0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXENSAMPLEALIGN0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXENSAMPLEALIGN1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXENSAMPLEALIGN1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXPOLARITY0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXPOLARITY0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXPOLARITY1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXPOLARITY1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXSLIDE0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXSLIDE0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXSLIDE1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXSLIDE1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXBYPASS8B10B0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXBYPASS8B10B0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXBYPASS8B10B1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXBYPASS8B10B1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXCHARDISPMODE0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXCHARDISPMODE0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXCHARDISPMODE1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXCHARDISPMODE1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXCHARDISPVAL0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXCHARDISPVAL0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXCHARDISPVAL1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXCHARDISPVAL1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXCHARISK0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXCHARISK0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXCHARISK1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXCHARISK1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXCOMSTART0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXCOMSTART0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXCOMSTART1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXCOMSTART1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXCOMTYPE0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXCOMTYPE0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXCOMTYPE1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXCOMTYPE1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXDATA0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_TXDATA0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_TXDATA1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_TXDATA1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_TXDETECTRX0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXDETECTRX0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXDETECTRX1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXDETECTRX1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXENC8B10BUSE0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXENC8B10BUSE0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXENC8B10BUSE1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXENC8B10BUSE1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXENPRBSTST0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXENPRBSTST0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXENPRBSTST1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXENPRBSTST1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXINHIBIT0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXINHIBIT0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXINHIBIT1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXINHIBIT1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXPOLARITY0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXPOLARITY0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXPOLARITY1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXPOLARITY1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     ticd_DCLK : VitalDelayType := 0 ps;
     ticd_RXUSRCLK0 : VitalDelayType := 0 ps;
     ticd_RXUSRCLK1 : VitalDelayType := 0 ps;
     ticd_RXUSRCLK20 : VitalDelayType := 0 ps;
     ticd_RXUSRCLK21 : VitalDelayType := 0 ps;
     ticd_TXUSRCLK20 : VitalDelayType := 0 ps;
     ticd_TXUSRCLK21 : VitalDelayType := 0 ps;
     tipd_CLKIN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DADDR : VitalDelayArrayType01 (6 downto 0) := (others => (0 ps, 0 ps));
     tipd_DCLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DEN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DI : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
     tipd_DWE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_GTPRESET : VitalDelayType01 := (0 ps, 0 ps);
     tipd_GTPTEST : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_INTDATAWIDTH : VitalDelayType01 := (0 ps, 0 ps);
     tipd_LOOPBACK0 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_LOOPBACK1 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_PLLLKDETEN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PLLPOWERDOWN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PRBSCNTRESET0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PRBSCNTRESET1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_REFCLKPWRDNB : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXBUFRESET0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXBUFRESET1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXCDRRESET0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXCDRRESET1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXCHBONDI0 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXCHBONDI1 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXCOMMADETUSE0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXCOMMADETUSE1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXDATAWIDTH0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXDATAWIDTH1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXDEC8B10BUSE0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXDEC8B10BUSE1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXELECIDLERESET0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXELECIDLERESET1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENCHANSYNC0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENCHANSYNC1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENELECIDLERESETB : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENEQB0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENEQB1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENMCOMMAALIGN0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENMCOMMAALIGN1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENPCOMMAALIGN0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENPCOMMAALIGN1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENPRBSTST0 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXENPRBSTST1 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXENSAMPLEALIGN0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENSAMPLEALIGN1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXEQMIX0 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXEQMIX1 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXEQPOLE0 : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXEQPOLE1 : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXN0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXN1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXP0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXP1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXPMASETPHASE0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXPMASETPHASE1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXPOLARITY0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXPOLARITY1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXPOWERDOWN0 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXPOWERDOWN1 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXRESET0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXRESET1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXSLIDE0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXSLIDE1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXUSRCLK0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXUSRCLK1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXUSRCLK20 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXUSRCLK21 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXBUFDIFFCTRL0 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXBUFDIFFCTRL1 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXBYPASS8B10B0 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXBYPASS8B10B1 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXCHARDISPMODE0 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXCHARDISPMODE1 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXCHARDISPVAL0 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXCHARDISPVAL1 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXCHARISK0 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXCHARISK1 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXCOMSTART0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXCOMSTART1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXCOMTYPE0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXCOMTYPE1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXDATA0 : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXDATA1 : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXDATAWIDTH0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXDATAWIDTH1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXDETECTRX0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXDETECTRX1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXDIFFCTRL0 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXDIFFCTRL1 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXELECIDLE0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXELECIDLE1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXENC8B10BUSE0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXENC8B10BUSE1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXENPMAPHASEALIGN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXENPRBSTST0 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXENPRBSTST1 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXINHIBIT0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXINHIBIT1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXPMASETPHASE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXPOLARITY0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXPOLARITY1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXPOWERDOWN0 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXPOWERDOWN1 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXPREEMPHASIS0 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXPREEMPHASIS1 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXRESET0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXRESET1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXUSRCLK0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXUSRCLK1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXUSRCLK20 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXUSRCLK21 : VitalDelayType01 := (0 ps, 0 ps);
     tisd_DADDR_DCLK : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     tisd_DEN_DCLK : VitalDelayType := 0 ps;
     tisd_DI_DCLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tisd_DWE_DCLK : VitalDelayType := 0 ps;
     tisd_PRBSCNTRESET0_RXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_PRBSCNTRESET1_RXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_RXCHBONDI0_RXUSRCLK0 : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_RXCHBONDI1_RXUSRCLK1 : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_RXCOMMADETUSE0_RXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_RXCOMMADETUSE1_RXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_RXDEC8B10BUSE0_RXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_RXDEC8B10BUSE1_RXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_RXENCHANSYNC0_RXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_RXENCHANSYNC1_RXUSRCLK21: VitalDelayType := 0 ps;
     tisd_RXENMCOMMAALIGN0_RXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_RXENMCOMMAALIGN1_RXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_RXENPCOMMAALIGN0_RXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_RXENPCOMMAALIGN1_RXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_RXENPRBSTST0_RXUSRCLK20 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_RXENPRBSTST1_RXUSRCLK21 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_RXENSAMPLEALIGN0_TXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_RXENSAMPLEALIGN1_TXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_RXPOLARITY0_RXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_RXPOLARITY1_RXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_RXSLIDE0_RXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_RXSLIDE1_RXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_TXBYPASS8B10B0_TXUSRCLK20 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_TXBYPASS8B10B1_TXUSRCLK21 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_TXCHARDISPMODE0_TXUSRCLK20 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_TXCHARDISPMODE1_TXUSRCLK21 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_TXCHARDISPVAL0_TXUSRCLK20 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_TXCHARDISPVAL1_TXUSRCLK21 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_TXCHARISK0_TXUSRCLK20 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_TXCHARISK1_TXUSRCLK21 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_TXCOMSTART0_TXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_TXCOMSTART1_TXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_TXCOMTYPE0_TXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_TXCOMTYPE1_TXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_TXDATA0_TXUSRCLK20 : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tisd_TXDATA1_TXUSRCLK21 : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tisd_TXDETECTRX0_TXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_TXDETECTRX1_TXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_TXENC8B10BUSE0_TXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_TXENC8B10BUSE1_TXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_TXENPRBSTST0_TXUSRCLK20 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_TXENPRBSTST1_TXUSRCLK21 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_TXINHIBIT0_TXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_TXINHIBIT1_TXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_TXPOLARITY0_TXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_TXPOLARITY1_TXUSRCLK21 : VitalDelayType := 0 ps;
     tpd_CLKIN_REFCLKOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_DCLK_DO : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
     tpd_DCLK_DRDY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK0_RXCHBONDO0 : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK1_RXCHBONDO1 : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_PHYSTATUS0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK20_RXBUFSTATUS0 : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_RXBYTEISALIGNED0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK20_RXBYTEREALIGN0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK20_RXCHANBONDSEQ0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK20_RXCHANISALIGNED0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK20_RXCHANREALIGN0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK20_RXCHARISCOMMA0 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_RXCHARISK0 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_RXCLKCORCNT0 : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_RXCOMMADET0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK20_RXDATA0 : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_RXDISPERR0 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_RXLOSSOFSYNC0 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_RXNOTINTABLE0 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_RXPRBSERR0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK20_RXRUNDISP0 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_RXSTATUS0 : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_RXVALID0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK21_RXBUFSTATUS1 : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_RXBYTEISALIGNED1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK21_RXBYTEREALIGN1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK21_RXCHANBONDSEQ1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK21_RXCHANISALIGNED1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK21_RXCHANREALIGN1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK21_RXCHARISCOMMA1 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_RXCHARISK1 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_RXCLKCORCNT1 : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_RXCOMMADET1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK21_RXDATA1 : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_RXDISPERR1 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_RXLOSSOFSYNC1 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_RXNOTINTABLE1 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_RXPRBSERR1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK21_RXRUNDISP1 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_RXSTATUS1 : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_RXVALID1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_TXUSRCLK20_RXOVERSAMPLEERR0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_TXUSRCLK20_TXBUFSTATUS0 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_TXUSRCLK20_TXKERR0 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_TXUSRCLK20_TXRUNDISP0 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_TXUSRCLK21_RXOVERSAMPLEERR1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_TXUSRCLK21_TXBUFSTATUS1 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_TXUSRCLK21_TXKERR1 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_TXUSRCLK21_TXRUNDISP1 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tsetup_DADDR_DCLK_negedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     tsetup_DADDR_DCLK_posedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     tsetup_DEN_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_DEN_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_DI_DCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_DI_DCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_DWE_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_DWE_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PRBSCNTRESET0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PRBSCNTRESET0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PRBSCNTRESET1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PRBSCNTRESET1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXCHBONDI0_RXUSRCLK0_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_RXCHBONDI0_RXUSRCLK0_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_RXCHBONDI1_RXUSRCLK1_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_RXCHBONDI1_RXUSRCLK1_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_RXCOMMADETUSE0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXCOMMADETUSE0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXCOMMADETUSE1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXCOMMADETUSE1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXDEC8B10BUSE0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXDEC8B10BUSE0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXDEC8B10BUSE1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXDEC8B10BUSE1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENCHANSYNC0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENCHANSYNC0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENCHANSYNC1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENCHANSYNC1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENMCOMMAALIGN0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENMCOMMAALIGN0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENMCOMMAALIGN1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENMCOMMAALIGN1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENPCOMMAALIGN0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENPCOMMAALIGN0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENPCOMMAALIGN1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENPCOMMAALIGN1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENPRBSTST0_RXUSRCLK20_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_RXENPRBSTST0_RXUSRCLK20_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_RXENPRBSTST1_RXUSRCLK21_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_RXENPRBSTST1_RXUSRCLK21_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_RXENSAMPLEALIGN0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENSAMPLEALIGN0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENSAMPLEALIGN1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENSAMPLEALIGN1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXPOLARITY0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXPOLARITY0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXPOLARITY1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXPOLARITY1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXSLIDE0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXSLIDE0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXSLIDE1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXSLIDE1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXBYPASS8B10B0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXBYPASS8B10B0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXBYPASS8B10B1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXBYPASS8B10B1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXCHARDISPMODE0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXCHARDISPMODE0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXCHARDISPMODE1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXCHARDISPMODE1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXCHARDISPVAL0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXCHARDISPVAL0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXCHARDISPVAL1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXCHARDISPVAL1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXCHARISK0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXCHARISK0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXCHARISK1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXCHARISK1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXCOMSTART0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXCOMSTART0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXCOMSTART1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXCOMSTART1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXCOMTYPE0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXCOMTYPE0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXCOMTYPE1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXCOMTYPE1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXDATA0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_TXDATA0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_TXDATA1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_TXDATA1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_TXDETECTRX0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXDETECTRX0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXDETECTRX1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXDETECTRX1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXENC8B10BUSE0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXENC8B10BUSE0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXENC8B10BUSE1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXENC8B10BUSE1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXENPRBSTST0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXENPRBSTST0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXENPRBSTST1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXENPRBSTST1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXINHIBIT0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXINHIBIT0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXINHIBIT1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXINHIBIT1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXPOLARITY0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXPOLARITY0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXPOLARITY1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXPOLARITY1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     DO : out std_logic_vector(15 downto 0);
     DRDY : out std_ulogic;
     PHYSTATUS0 : out std_ulogic;
     PHYSTATUS1 : out std_ulogic;
     PLLLKDET : out std_ulogic;
     REFCLKOUT : out std_ulogic;
     RESETDONE0 : out std_ulogic;
     RESETDONE1 : out std_ulogic;
     RXBUFSTATUS0 : out std_logic_vector(2 downto 0);
     RXBUFSTATUS1 : out std_logic_vector(2 downto 0);
     RXBYTEISALIGNED0 : out std_ulogic;
     RXBYTEISALIGNED1 : out std_ulogic;
     RXBYTEREALIGN0 : out std_ulogic;
     RXBYTEREALIGN1 : out std_ulogic;
     RXCHANBONDSEQ0 : out std_ulogic;
     RXCHANBONDSEQ1 : out std_ulogic;
     RXCHANISALIGNED0 : out std_ulogic;
     RXCHANISALIGNED1 : out std_ulogic;
     RXCHANREALIGN0 : out std_ulogic;
     RXCHANREALIGN1 : out std_ulogic;
     RXCHARISCOMMA0 : out std_logic_vector(1 downto 0);
     RXCHARISCOMMA1 : out std_logic_vector(1 downto 0);
     RXCHARISK0 : out std_logic_vector(1 downto 0);
     RXCHARISK1 : out std_logic_vector(1 downto 0);
     RXCHBONDO0 : out std_logic_vector(2 downto 0);
     RXCHBONDO1 : out std_logic_vector(2 downto 0);
     RXCLKCORCNT0 : out std_logic_vector(2 downto 0);
     RXCLKCORCNT1 : out std_logic_vector(2 downto 0);
     RXCOMMADET0 : out std_ulogic;
     RXCOMMADET1 : out std_ulogic;
     RXDATA0 : out std_logic_vector(15 downto 0);
     RXDATA1 : out std_logic_vector(15 downto 0);
     RXDISPERR0 : out std_logic_vector(1 downto 0);
     RXDISPERR1 : out std_logic_vector(1 downto 0);
     RXELECIDLE0 : out std_ulogic;
     RXELECIDLE1 : out std_ulogic;
     RXLOSSOFSYNC0 : out std_logic_vector(1 downto 0);
     RXLOSSOFSYNC1 : out std_logic_vector(1 downto 0);
     RXNOTINTABLE0 : out std_logic_vector(1 downto 0);
     RXNOTINTABLE1 : out std_logic_vector(1 downto 0);
     RXOVERSAMPLEERR0 : out std_ulogic;
     RXOVERSAMPLEERR1 : out std_ulogic;
     RXPRBSERR0 : out std_ulogic;
     RXPRBSERR1 : out std_ulogic;
     RXRECCLK0 : out std_ulogic;
     RXRECCLK1 : out std_ulogic;
     RXRUNDISP0 : out std_logic_vector(1 downto 0);
     RXRUNDISP1 : out std_logic_vector(1 downto 0);
     RXSTATUS0 : out std_logic_vector(2 downto 0);
     RXSTATUS1 : out std_logic_vector(2 downto 0);
     RXVALID0 : out std_ulogic;
     RXVALID1 : out std_ulogic;
     TXBUFSTATUS0 : out std_logic_vector(1 downto 0);
     TXBUFSTATUS1 : out std_logic_vector(1 downto 0);
     TXKERR0 : out std_logic_vector(1 downto 0);
     TXKERR1 : out std_logic_vector(1 downto 0);
     TXN0 : out std_ulogic;
     TXN1 : out std_ulogic;
     TXOUTCLK0 : out std_ulogic;
     TXOUTCLK1 : out std_ulogic;
     TXP0 : out std_ulogic;
     TXP1 : out std_ulogic;
     TXRUNDISP0 : out std_logic_vector(1 downto 0);
     TXRUNDISP1 : out std_logic_vector(1 downto 0);
     CLKIN : in std_ulogic;
     DADDR : in std_logic_vector(6 downto 0);
     DCLK : in std_ulogic;
     DEN : in std_ulogic;
     DI : in std_logic_vector(15 downto 0);
     DWE : in std_ulogic;
     GTPRESET : in std_ulogic;
     GTPTEST : in std_logic_vector(3 downto 0);
     INTDATAWIDTH : in std_ulogic;
     LOOPBACK0 : in std_logic_vector(2 downto 0);
     LOOPBACK1 : in std_logic_vector(2 downto 0);
     PLLLKDETEN : in std_ulogic;
     PLLPOWERDOWN : in std_ulogic;
     PRBSCNTRESET0 : in std_ulogic;
     PRBSCNTRESET1 : in std_ulogic;
     REFCLKPWRDNB : in std_ulogic;
     RXBUFRESET0 : in std_ulogic;
     RXBUFRESET1 : in std_ulogic;
     RXCDRRESET0 : in std_ulogic;
     RXCDRRESET1 : in std_ulogic;
     RXCHBONDI0 : in std_logic_vector(2 downto 0);
     RXCHBONDI1 : in std_logic_vector(2 downto 0);
     RXCOMMADETUSE0 : in std_ulogic;
     RXCOMMADETUSE1 : in std_ulogic;
     RXDATAWIDTH0 : in std_ulogic;
     RXDATAWIDTH1 : in std_ulogic;
     RXDEC8B10BUSE0 : in std_ulogic;
     RXDEC8B10BUSE1 : in std_ulogic;
     RXELECIDLERESET0 : in std_ulogic;
     RXELECIDLERESET1 : in std_ulogic;
     RXENCHANSYNC0 : in std_ulogic;
     RXENCHANSYNC1 : in std_ulogic;
     RXENELECIDLERESETB : in std_ulogic;
     RXENEQB0 : in std_ulogic;
     RXENEQB1 : in std_ulogic;
     RXENMCOMMAALIGN0 : in std_ulogic;
     RXENMCOMMAALIGN1 : in std_ulogic;
     RXENPCOMMAALIGN0 : in std_ulogic;
     RXENPCOMMAALIGN1 : in std_ulogic;
     RXENPRBSTST0 : in std_logic_vector(1 downto 0);
     RXENPRBSTST1 : in std_logic_vector(1 downto 0);
     RXENSAMPLEALIGN0 : in std_ulogic;
     RXENSAMPLEALIGN1 : in std_ulogic;
     RXEQMIX0 : in std_logic_vector(1 downto 0);
     RXEQMIX1 : in std_logic_vector(1 downto 0);
     RXEQPOLE0 : in std_logic_vector(3 downto 0);
     RXEQPOLE1 : in std_logic_vector(3 downto 0);
     RXN0 : in std_ulogic;
     RXN1 : in std_ulogic;
     RXP0 : in std_ulogic;
     RXP1 : in std_ulogic;
     RXPMASETPHASE0 : in std_ulogic;
     RXPMASETPHASE1 : in std_ulogic;
     RXPOLARITY0 : in std_ulogic;
     RXPOLARITY1 : in std_ulogic;
     RXPOWERDOWN0 : in std_logic_vector(1 downto 0);
     RXPOWERDOWN1 : in std_logic_vector(1 downto 0);
     RXRESET0 : in std_ulogic;
     RXRESET1 : in std_ulogic;
     RXSLIDE0 : in std_ulogic;
     RXSLIDE1 : in std_ulogic;
     RXUSRCLK0 : in std_ulogic;
     RXUSRCLK1 : in std_ulogic;
     RXUSRCLK20 : in std_ulogic;
     RXUSRCLK21 : in std_ulogic;
     TXBUFDIFFCTRL0 : in std_logic_vector(2 downto 0);
     TXBUFDIFFCTRL1 : in std_logic_vector(2 downto 0);
     TXBYPASS8B10B0 : in std_logic_vector(1 downto 0);
     TXBYPASS8B10B1 : in std_logic_vector(1 downto 0);
     TXCHARDISPMODE0 : in std_logic_vector(1 downto 0);
     TXCHARDISPMODE1 : in std_logic_vector(1 downto 0);
     TXCHARDISPVAL0 : in std_logic_vector(1 downto 0);
     TXCHARDISPVAL1 : in std_logic_vector(1 downto 0);
     TXCHARISK0 : in std_logic_vector(1 downto 0);
     TXCHARISK1 : in std_logic_vector(1 downto 0);
     TXCOMSTART0 : in std_ulogic;
     TXCOMSTART1 : in std_ulogic;
     TXCOMTYPE0 : in std_ulogic;
     TXCOMTYPE1 : in std_ulogic;
     TXDATA0 : in std_logic_vector(15 downto 0);
     TXDATA1 : in std_logic_vector(15 downto 0);
     TXDATAWIDTH0 : in std_ulogic;
     TXDATAWIDTH1 : in std_ulogic;
     TXDETECTRX0 : in std_ulogic;
     TXDETECTRX1 : in std_ulogic;
     TXDIFFCTRL0 : in std_logic_vector(2 downto 0);
     TXDIFFCTRL1 : in std_logic_vector(2 downto 0);
     TXELECIDLE0 : in std_ulogic;
     TXELECIDLE1 : in std_ulogic;
     TXENC8B10BUSE0 : in std_ulogic;
     TXENC8B10BUSE1 : in std_ulogic;
     TXENPMAPHASEALIGN : in std_ulogic;
     TXENPRBSTST0 : in std_logic_vector(1 downto 0);
     TXENPRBSTST1 : in std_logic_vector(1 downto 0);
     TXINHIBIT0 : in std_ulogic;
     TXINHIBIT1 : in std_ulogic;
     TXPMASETPHASE : in std_ulogic;
     TXPOLARITY0 : in std_ulogic;
     TXPOLARITY1 : in std_ulogic;
     TXPOWERDOWN0 : in std_logic_vector(1 downto 0);
     TXPOWERDOWN1 : in std_logic_vector(1 downto 0);
     TXPREEMPHASIS0 : in std_logic_vector(2 downto 0);
     TXPREEMPHASIS1 : in std_logic_vector(2 downto 0);
     TXRESET0 : in std_ulogic;
     TXRESET1 : in std_ulogic;
     TXUSRCLK0 : in std_ulogic;
     TXUSRCLK1 : in std_ulogic;
     TXUSRCLK20 : in std_ulogic;
     TXUSRCLK21 : in std_ulogic
  );
end component;

----- component X_GTXE1 -----
component X_GTXE1
  generic (
     AC_CAP_DIS : boolean := TRUE;
     ALIGN_COMMA_WORD : integer := 1;
     BGTEST_CFG : bit_vector := "00";
     BIAS_CFG : bit_vector := X"00000";
     CDR_PH_ADJ_TIME : bit_vector := "10100";
     CHAN_BOND_1_MAX_SKEW : integer := 7;
     CHAN_BOND_2_MAX_SKEW : integer := 1;
     CHAN_BOND_KEEP_ALIGN : boolean := FALSE;
     CHAN_BOND_SEQ_1_1 : bit_vector := "0101111100";
     CHAN_BOND_SEQ_1_2 : bit_vector := "0001001010";
     CHAN_BOND_SEQ_1_3 : bit_vector := "0001001010";
     CHAN_BOND_SEQ_1_4 : bit_vector := "0110111100";
     CHAN_BOND_SEQ_1_ENABLE : bit_vector := "1111";
     CHAN_BOND_SEQ_2_1 : bit_vector := "0100111100";
     CHAN_BOND_SEQ_2_2 : bit_vector := "0100111100";
     CHAN_BOND_SEQ_2_3 : bit_vector := "0110111100";
     CHAN_BOND_SEQ_2_4 : bit_vector := "0100111100";
     CHAN_BOND_SEQ_2_CFG : bit_vector := "00000";
     CHAN_BOND_SEQ_2_ENABLE : bit_vector := "1111";
     CHAN_BOND_SEQ_2_USE : boolean := FALSE;
     CHAN_BOND_SEQ_LEN : integer := 1;
     CLK_CORRECT_USE : boolean := TRUE;
     CLK_COR_ADJ_LEN : integer := 1;
     CLK_COR_DET_LEN : integer := 1;
     CLK_COR_INSERT_IDLE_FLAG : boolean := FALSE;
     CLK_COR_KEEP_IDLE : boolean := FALSE;
     CLK_COR_MAX_LAT : integer := 20;
     CLK_COR_MIN_LAT : integer := 18;
     CLK_COR_PRECEDENCE : boolean := TRUE;
     CLK_COR_REPEAT_WAIT : integer := 0;
     CLK_COR_SEQ_1_1 : bit_vector := "0100011100";
     CLK_COR_SEQ_1_2 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_3 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_4 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_ENABLE : bit_vector := "1111";
     CLK_COR_SEQ_2_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_2 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_3 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_4 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_ENABLE : bit_vector := "1111";
     CLK_COR_SEQ_2_USE : boolean := FALSE;
     CM_TRIM : bit_vector := "01";
     COMMA_10B_ENABLE : bit_vector := "1111111111";
     COMMA_DOUBLE : boolean := FALSE;
     COM_BURST_VAL : bit_vector := "1111";
     DEC_MCOMMA_DETECT : boolean := TRUE;
     DEC_PCOMMA_DETECT : boolean := TRUE;
     DEC_VALID_COMMA_ONLY : boolean := TRUE;
     DFE_CAL_TIME : bit_vector := "01100";
     DFE_CFG : bit_vector := "00011011";
     GEARBOX_ENDEC : bit_vector := "000";
     GEN_RXUSRCLK : boolean := TRUE;
     GEN_TXUSRCLK : boolean := TRUE;
     GTX_CFG_PWRUP : boolean := TRUE;
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MCOMMA_10B_VALUE : bit_vector := "1010000011";
     MCOMMA_DETECT : boolean := TRUE;
     MsgOn : boolean := FALSE;
     OOBDETECT_THRESHOLD : bit_vector := "011";
     PCI_EXPRESS_MODE : boolean := FALSE;
     PCOMMA_10B_VALUE : bit_vector := "0101111100";
     PCOMMA_DETECT : boolean := TRUE;
     PMA_CAS_CLK_EN : boolean := FALSE;
     PMA_CDR_SCAN : bit_vector := X"640404C";
     PMA_CFG : bit_vector := X"0040000040000000003";
     PMA_RXSYNC_CFG : bit_vector := X"00";
     PMA_RX_CFG : bit_vector := X"05CE048";
     PMA_TX_CFG : bit_vector := X"00082";
     POWER_SAVE : bit_vector := "0000110100";
     RCV_TERM_GND : boolean := FALSE;
     RCV_TERM_VTTRX : boolean := TRUE;
     RXGEARBOX_USE : boolean := FALSE;
     RXPLL_COM_CFG : bit_vector := X"21680A";
     RXPLL_CP_CFG : bit_vector := X"00";
     RXPLL_DIVSEL45_FB : integer := 5;
     RXPLL_DIVSEL_FB : integer := 2;
     RXPLL_DIVSEL_OUT : integer := 1;
     RXPLL_DIVSEL_REF : integer := 1;
     RXPLL_LKDET_CFG : bit_vector := "111";
     RXPRBSERR_LOOPBACK : bit := '0';
     RXRECCLK_CTRL : string := "RXRECCLKPCS";
     RXRECCLK_DLY : bit_vector := "0000000000";
     RXUSRCLK_DLY : bit_vector := X"0000";
     RX_BUFFER_USE : boolean := TRUE;
     RX_CLK25_DIVIDER : integer := 6;
     RX_DATA_WIDTH : integer := 20;
     RX_DECODE_SEQ_MATCH : boolean := TRUE;
     RX_DLYALIGN_CTRINC : bit_vector := "0100";
     RX_DLYALIGN_EDGESET : bit_vector := "00110";
     RX_DLYALIGN_LPFINC : bit_vector := "0111";
     RX_DLYALIGN_MONSEL : bit_vector := "000";
     RX_DLYALIGN_OVRDSETTING : bit_vector := "00000000";
     RX_EN_IDLE_HOLD_CDR : boolean := FALSE;
     RX_EN_IDLE_HOLD_DFE : boolean := TRUE;
     RX_EN_IDLE_RESET_BUF : boolean := TRUE;
     RX_EN_IDLE_RESET_FR : boolean := TRUE;
     RX_EN_IDLE_RESET_PH : boolean := TRUE;
     RX_EN_MODE_RESET_BUF : boolean := TRUE;
     RX_EN_RATE_RESET_BUF : boolean := TRUE;
     RX_EN_REALIGN_RESET_BUF : boolean := FALSE;
     RX_EN_REALIGN_RESET_BUF2 : boolean := FALSE;
     RX_EYE_OFFSET : bit_vector := X"4C";
     RX_EYE_SCANMODE : bit_vector := "00";
     RX_FIFO_ADDR_MODE : string := "FULL";
     RX_IDLE_HI_CNT : bit_vector := "1000";
     RX_IDLE_LO_CNT : bit_vector := "0000";
     RX_LOSS_OF_SYNC_FSM : boolean := FALSE;
     RX_LOS_INVALID_INCR : integer := 1;
     RX_LOS_THRESHOLD : integer := 4;
     RX_OVERSAMPLE_MODE : boolean := FALSE;
     RX_SLIDE_AUTO_WAIT : integer := 5;
     RX_SLIDE_MODE : string := "OFF";
     RX_XCLK_SEL : string := "RXREC";
     SAS_MAX_COMSAS : integer := 52;
     SAS_MIN_COMSAS : integer := 40;
     SATA_BURST_VAL : bit_vector := "100";
     SATA_IDLE_VAL : bit_vector := "100";
     SATA_MAX_BURST : integer := 7;
     SATA_MAX_INIT : integer := 22;
     SATA_MAX_WAKE : integer := 7;
     SATA_MIN_BURST : integer := 4;
     SATA_MIN_INIT : integer := 12;
     SATA_MIN_WAKE : integer := 4;
     SHOW_REALIGN_COMMA : boolean := TRUE;
     SIM_GTXRESET_SPEEDUP : integer := 1;
     SIM_RECEIVER_DETECT_PASS : boolean := TRUE;
     SIM_RXREFCLK_SOURCE : bit_vector := "000";
     SIM_TXREFCLK_SOURCE : bit_vector := "000";
     SIM_TX_ELEC_IDLE_LEVEL : string := "X";
     SIM_VERSION : string := "2.0";
     TERMINATION_CTRL : bit_vector := "10100";
     TERMINATION_OVRD : boolean := FALSE;
     TRANS_TIME_FROM_P2 : bit_vector := X"03C";
     TRANS_TIME_NON_P2 : bit_vector := X"19";
     TRANS_TIME_RATE : bit_vector := X"0E";
     TRANS_TIME_TO_P2 : bit_vector := X"064";
     TST_ATTR : bit_vector := X"00000000";
     TXDRIVE_LOOPBACK_HIZ : boolean := FALSE;
     TXDRIVE_LOOPBACK_PD : boolean := FALSE;
     TXGEARBOX_USE : boolean := FALSE;
     TXOUTCLK_CTRL : string := "TXOUTCLKPCS";
     TXOUTCLK_DLY : bit_vector := "0000000000";
     TXPLL_COM_CFG : bit_vector := X"21680A";
     TXPLL_CP_CFG : bit_vector := X"00";
     TXPLL_DIVSEL45_FB : integer := 5;
     TXPLL_DIVSEL_FB : integer := 2;
     TXPLL_DIVSEL_OUT : integer := 1;
     TXPLL_DIVSEL_REF : integer := 1;
     TXPLL_LKDET_CFG : bit_vector := "111";
     TXPLL_SATA : bit_vector := "00";
     TX_BUFFER_USE : boolean := TRUE;
     TX_BYTECLK_CFG : bit_vector := X"00";
     TX_CLK25_DIVIDER : integer := 6;
     TX_CLK_SOURCE : string := "RXPLL";
     TX_DATA_WIDTH : integer := 20;
     TX_DEEMPH_0 : bit_vector := "11010";
     TX_DEEMPH_1 : bit_vector := "10000";
     TX_DETECT_RX_CFG : bit_vector := X"1832";
     TX_DLYALIGN_CTRINC : bit_vector := "0100";
     TX_DLYALIGN_LPFINC : bit_vector := "0110";
     TX_DLYALIGN_MONSEL : bit_vector := "000";
     TX_DLYALIGN_OVRDSETTING : bit_vector := "10000000";
     TX_DRIVE_MODE : string := "DIRECT";
     TX_EN_RATE_RESET_BUF : boolean := TRUE;
     TX_IDLE_ASSERT_DELAY : bit_vector := "100";
     TX_IDLE_DEASSERT_DELAY : bit_vector := "010";
     TX_MARGIN_FULL_0 : bit_vector := "1001110";
     TX_MARGIN_FULL_1 : bit_vector := "1001001";
     TX_MARGIN_FULL_2 : bit_vector := "1000101";
     TX_MARGIN_FULL_3 : bit_vector := "1000010";
     TX_MARGIN_FULL_4 : bit_vector := "1000000";
     TX_MARGIN_LOW_0 : bit_vector := "1000110";
     TX_MARGIN_LOW_1 : bit_vector := "1000100";
     TX_MARGIN_LOW_2 : bit_vector := "1000010";
     TX_MARGIN_LOW_3 : bit_vector := "1000000";
     TX_MARGIN_LOW_4 : bit_vector := "1000000";
     TX_OVERSAMPLE_MODE : boolean := FALSE;
     TX_PMADATA_OPT : bit := '0';
     TX_TDCC_CFG : bit_vector := "11";
     TX_USRCLK_CFG : bit_vector := X"00";
     TX_XCLK_SEL : string := "TXUSR";
     TimingChecksOn : boolean := TRUE;
     Xon : boolean := TRUE;
     thold_DADDR_DCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_DADDR_DCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_DEN_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_DEN_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_DFECLKDLYADJ_RXUSRCLK2_negedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     thold_DFECLKDLYADJ_RXUSRCLK2_posedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     thold_DFEDLYOVRD_RXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     thold_DFEDLYOVRD_RXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     thold_DFETAP1_RXUSRCLK2_negedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     thold_DFETAP1_RXUSRCLK2_posedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     thold_DFETAP2_RXUSRCLK2_negedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     thold_DFETAP2_RXUSRCLK2_posedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     thold_DFETAP3_RXUSRCLK2_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_DFETAP3_RXUSRCLK2_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_DFETAP4_RXUSRCLK2_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_DFETAP4_RXUSRCLK2_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_DFETAPOVRD_RXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     thold_DFETAPOVRD_RXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     thold_DI_DCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_DI_DCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_DWE_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_DWE_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PRBSCNTRESET_RXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     thold_PRBSCNTRESET_RXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXCHBONDI_RXUSRCLK2_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_RXCHBONDI_RXUSRCLK2_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_RXCHBONDI_RXUSRCLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_RXCHBONDI_RXUSRCLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_RXCHBONDLEVEL_RXUSRCLK2_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_RXCHBONDLEVEL_RXUSRCLK2_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_RXCHBONDMASTER_RXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXCHBONDMASTER_RXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXCHBONDSLAVE_RXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXCHBONDSLAVE_RXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXCOMMADETUSE_RXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXCOMMADETUSE_RXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXDEC8B10BUSE_RXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXDEC8B10BUSE_RXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXENCHANSYNC_RXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXENCHANSYNC_RXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXENMCOMMAALIGN_RXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXENMCOMMAALIGN_RXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXENPCOMMAALIGN_RXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXENPCOMMAALIGN_RXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXENPRBSTST_RXUSRCLK2_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_RXENPRBSTST_RXUSRCLK2_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_RXENSAMPLEALIGN_RXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXENSAMPLEALIGN_RXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXGEARBOXSLIP_RXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXGEARBOXSLIP_RXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXPOLARITY_RXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXPOLARITY_RXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXRATE_RXUSRCLK2_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_RXRATE_RXUSRCLK2_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_RXSLIDE_RXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXSLIDE_RXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXBYPASS8B10B_TXUSRCLK2_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXBYPASS8B10B_TXUSRCLK2_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXCHARDISPMODE_TXUSRCLK2_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXCHARDISPMODE_TXUSRCLK2_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXCHARDISPVAL_TXUSRCLK2_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXCHARDISPVAL_TXUSRCLK2_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXCHARISK_TXUSRCLK2_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXCHARISK_TXUSRCLK2_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXCOMINIT_TXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXCOMINIT_TXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXCOMSAS_TXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXCOMSAS_TXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXCOMWAKE_TXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXCOMWAKE_TXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXDATA_TXUSRCLK2_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     thold_TXDATA_TXUSRCLK2_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     thold_TXDETECTRX_TXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXDETECTRX_TXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXELECIDLE_TXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXELECIDLE_TXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXENC8B10BUSE_TXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXENC8B10BUSE_TXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXENPRBSTST_TXUSRCLK2_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_TXENPRBSTST_TXUSRCLK2_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_TXHEADER_TXUSRCLK2_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_TXHEADER_TXUSRCLK2_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_TXINHIBIT_TXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXINHIBIT_TXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXPOLARITY_TXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXPOLARITY_TXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXPOWERDOWN_TXUSRCLK2_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXPOWERDOWN_TXUSRCLK2_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXPRBSFORCEERR_TXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXPRBSFORCEERR_TXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXRATE_TXUSRCLK2_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXRATE_TXUSRCLK2_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXSEQUENCE_TXUSRCLK2_negedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     thold_TXSEQUENCE_TXUSRCLK2_posedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     thold_TXSTARTSEQ_TXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXSTARTSEQ_TXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     thold_USRCODEERR_RXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     thold_USRCODEERR_RXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     ticd_DCLK : VitalDelayType := 0 ps;
     ticd_MGTREFCLKRX : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     ticd_MGTREFCLKTX : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     ticd_NORTHREFCLKRX : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     ticd_NORTHREFCLKTX : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     ticd_RXUSRCLK : VitalDelayType := 0 ps;
     ticd_RXUSRCLK2 : VitalDelayType := 0 ps;
     ticd_SOUTHREFCLKRX : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     ticd_SOUTHREFCLKTX : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     ticd_TXUSRCLK : VitalDelayType := 0 ps;
     ticd_TXUSRCLK2 : VitalDelayType := 0 ps;
     tipd_DADDR : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
     tipd_DCLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DEN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DFECLKDLYADJ : VitalDelayArrayType01 (5 downto 0) := (others => (0 ps, 0 ps));
     tipd_DFEDLYOVRD : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DFETAP1 : VitalDelayArrayType01 (4 downto 0) := (others => (0 ps, 0 ps));
     tipd_DFETAP2 : VitalDelayArrayType01 (4 downto 0) := (others => (0 ps, 0 ps));
     tipd_DFETAP3 : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_DFETAP4 : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_DFETAPOVRD : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DI : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
     tipd_DWE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_GATERXELECIDLE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_GREFCLKRX : VitalDelayType01 := (0 ps, 0 ps);
     tipd_GREFCLKTX : VitalDelayType01 := (0 ps, 0 ps);
     tipd_GTXRXRESET : VitalDelayType01 := (0 ps, 0 ps);
     tipd_GTXTEST : VitalDelayArrayType01 (12 downto 0) := (others => (0 ps, 0 ps));
     tipd_GTXTXRESET : VitalDelayType01 := (0 ps, 0 ps);
     tipd_IGNORESIGDET : VitalDelayType01 := (0 ps, 0 ps);
     tipd_LOOPBACK : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_MGTREFCLKRX : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_MGTREFCLKTX : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_NORTHREFCLKRX : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_NORTHREFCLKTX : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_PERFCLKRX : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PERFCLKTX : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PLLRXRESET : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PLLTXRESET : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PRBSCNTRESET : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXBUFRESET : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXCDRRESET : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXCHBONDI : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXCHBONDLEVEL : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXCHBONDMASTER : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXCHBONDSLAVE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXCOMMADETUSE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXDEC8B10BUSE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXDLYALIGNDISABLE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXDLYALIGNMONENB : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXDLYALIGNOVERRIDE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXDLYALIGNRESET : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXDLYALIGNSWPPRECURB : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXDLYALIGNUPDSW : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENCHANSYNC : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENMCOMMAALIGN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENPCOMMAALIGN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENPMAPHASEALIGN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENPRBSTST : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXENSAMPLEALIGN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXEQMIX : VitalDelayArrayType01 (9 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXGEARBOXSLIP : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXP : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXPLLLKDETEN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXPLLPOWERDOWN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXPLLREFSELDY : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXPMASETPHASE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXPOLARITY : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXPOWERDOWN : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXRATE : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXRESET : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXSLIDE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXUSRCLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXUSRCLK2 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_SOUTHREFCLKRX : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_SOUTHREFCLKTX : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_TSTCLK0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TSTCLK1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TSTIN : VitalDelayArrayType01 (19 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXBUFDIFFCTRL : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXBYPASS8B10B : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXCHARDISPMODE : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXCHARDISPVAL : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXCHARISK : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXCOMINIT : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXCOMSAS : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXCOMWAKE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXDATA : VitalDelayArrayType01 (31 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXDEEMPH : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXDETECTRX : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXDIFFCTRL : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXDLYALIGNDISABLE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXDLYALIGNMONENB : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXDLYALIGNOVERRIDE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXDLYALIGNRESET : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXDLYALIGNUPDSW : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXELECIDLE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXENC8B10BUSE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXENPMAPHASEALIGN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXENPRBSTST : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXHEADER : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXINHIBIT : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXMARGIN : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXPDOWNASYNCH : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXPLLLKDETEN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXPLLPOWERDOWN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXPLLREFSELDY : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXPMASETPHASE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXPOLARITY : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXPOSTEMPHASIS : VitalDelayArrayType01 (4 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXPOWERDOWN : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXPRBSFORCEERR : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXPREEMPHASIS : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXRATE : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXRESET : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXSEQUENCE : VitalDelayArrayType01 (6 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXSTARTSEQ : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXSWING : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXUSRCLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXUSRCLK2 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_USRCODEERR : VitalDelayType01 := (0 ps, 0 ps);
     tisd_DADDR_DCLK : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tisd_DEN_DCLK : VitalDelayType := 0 ps;
     tisd_DFECLKDLYADJ_RXUSRCLK2 : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     tisd_DFEDLYOVRD_RXUSRCLK2 : VitalDelayType := 0 ps;
     tisd_DFETAP1_RXUSRCLK2 : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tisd_DFETAP2_RXUSRCLK2 : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tisd_DFETAP3_RXUSRCLK2 : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_DFETAP4_RXUSRCLK2 : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_DFETAPOVRD_RXUSRCLK2 : VitalDelayType := 0 ps;
     tisd_DI_DCLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tisd_DWE_DCLK : VitalDelayType := 0 ps;
     tisd_PRBSCNTRESET_RXUSRCLK2 : VitalDelayType := 0 ps;
     tisd_RXCHBONDI_RXUSRCLK : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_RXCHBONDI_RXUSRCLK2 : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_RXCHBONDLEVEL_RXUSRCLK2 : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_RXCHBONDMASTER_RXUSRCLK2 : VitalDelayType := 0 ps;
     tisd_RXCHBONDSLAVE_RXUSRCLK2 : VitalDelayType := 0 ps;
     tisd_RXCOMMADETUSE_RXUSRCLK2 : VitalDelayType := 0 ps;
     tisd_RXDEC8B10BUSE_RXUSRCLK2 : VitalDelayType := 0 ps;
     tisd_RXENCHANSYNC_RXUSRCLK2 : VitalDelayType := 0 ps;
     tisd_RXENMCOMMAALIGN_RXUSRCLK2 : VitalDelayType := 0 ps;
     tisd_RXENPCOMMAALIGN_RXUSRCLK2 : VitalDelayType := 0 ps;
     tisd_RXENPRBSTST_RXUSRCLK2 : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_RXENSAMPLEALIGN_RXUSRCLK2 : VitalDelayType := 0 ps;
     tisd_RXGEARBOXSLIP_RXUSRCLK2 : VitalDelayType := 0 ps;
     tisd_RXPOLARITY_RXUSRCLK2 : VitalDelayType := 0 ps;
     tisd_RXRATE_RXUSRCLK2 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_RXSLIDE_RXUSRCLK2 : VitalDelayType := 0 ps;
     tisd_TXBYPASS8B10B_TXUSRCLK2 : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_TXCHARDISPMODE_TXUSRCLK2 : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_TXCHARDISPVAL_TXUSRCLK2 : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_TXCHARISK_TXUSRCLK2 : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_TXCOMINIT_TXUSRCLK2 : VitalDelayType := 0 ps;
     tisd_TXCOMSAS_TXUSRCLK2 : VitalDelayType := 0 ps;
     tisd_TXCOMWAKE_TXUSRCLK2 : VitalDelayType := 0 ps;
     tisd_TXDATA_TXUSRCLK2 : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tisd_TXDETECTRX_TXUSRCLK2 : VitalDelayType := 0 ps;
     tisd_TXELECIDLE_TXUSRCLK2 : VitalDelayType := 0 ps;
     tisd_TXENC8B10BUSE_TXUSRCLK2 : VitalDelayType := 0 ps;
     tisd_TXENPRBSTST_TXUSRCLK2 : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_TXHEADER_TXUSRCLK2 : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_TXINHIBIT_TXUSRCLK2 : VitalDelayType := 0 ps;
     tisd_TXPOLARITY_TXUSRCLK2 : VitalDelayType := 0 ps;
     tisd_TXPOWERDOWN_TXUSRCLK2 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_TXPRBSFORCEERR_TXUSRCLK2 : VitalDelayType := 0 ps;
     tisd_TXRATE_TXUSRCLK2 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_TXSEQUENCE_TXUSRCLK2 : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     tisd_TXSTARTSEQ_TXUSRCLK2 : VitalDelayType := 0 ps;
     tisd_USRCODEERR_RXUSRCLK2 : VitalDelayType := 0 ps;
     tpd_DCLK_DRDY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_DCLK_DRPDO : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
     tpd_MGTREFCLKRX_MGTREFCLKFAB : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_MGTREFCLKTX_MGTREFCLKFAB : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_NORTHREFCLKRX_MGTREFCLKFAB : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_NORTHREFCLKTX_MGTREFCLKFAB : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK2_COMINITDET : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK2_COMSASDET : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK2_COMWAKEDET : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK2_DFECLKDLYADJMON : VitalDelayArrayType01(5 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK2_DFEEYEDACMON : VitalDelayArrayType01(4 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK2_DFESENSCAL : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK2_DFETAP1MONITOR : VitalDelayArrayType01(4 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK2_DFETAP2MONITOR : VitalDelayArrayType01(4 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK2_DFETAP3MONITOR : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK2_DFETAP4MONITOR : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK2_PHYSTATUS : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK2_RXBUFSTATUS : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK2_RXBYTEISALIGNED : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK2_RXBYTEREALIGN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK2_RXCHANBONDSEQ : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK2_RXCHANISALIGNED : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK2_RXCHANREALIGN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK2_RXCHARISCOMMA : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK2_RXCHARISK : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK2_RXCHBONDO : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK2_RXCLKCORCNT : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK2_RXCOMMADET : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK2_RXDATA : VitalDelayArrayType01(31 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK2_RXDATAVALID : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK2_RXDISPERR : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK2_RXHEADER : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK2_RXHEADERVALID : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK2_RXLOSSOFSYNC : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK2_RXNOTINTABLE : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK2_RXOVERSAMPLEERR : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK2_RXPRBSERR : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK2_RXRATEDONE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK2_RXRESETDONE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK2_RXRUNDISP : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK2_RXSTARTOFSEQ : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK2_RXSTATUS : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK2_RXVALID : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK_RXCHBONDO : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_SOUTHREFCLKRX_MGTREFCLKFAB : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_SOUTHREFCLKTX_MGTREFCLKFAB : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_TXUSRCLK2_COMFINISH : VitalDelayType01 := (0 ps, 0 ps);
     tpd_TXUSRCLK2_TXBUFSTATUS : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_TXUSRCLK2_TXGEARBOXREADY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_TXUSRCLK2_TXKERR : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_TXUSRCLK2_TXRATEDONE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_TXUSRCLK2_TXRESETDONE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_TXUSRCLK2_TXRUNDISP : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tperiod_DCLK_posedge : VitalDelayType := 0 ps;
     tperiod_GREFCLKRX_posedge : VitalDelayType := 0 ps;
     tperiod_GREFCLKTX_posedge : VitalDelayType := 0 ps;
     tperiod_MGTREFCLKRX_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tperiod_MGTREFCLKTX_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tperiod_NORTHREFCLKRX_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tperiod_NORTHREFCLKTX_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tperiod_PERFCLKRX_posedge : VitalDelayType := 0 ps;
     tperiod_PERFCLKTX_posedge : VitalDelayType := 0 ps;
     tperiod_RXUSRCLK2_posedge : VitalDelayType := 0 ps;
     tperiod_RXUSRCLK_posedge : VitalDelayType := 0 ps;
     tperiod_SOUTHREFCLKRX_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tperiod_SOUTHREFCLKTX_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tperiod_TSTCLK0_posedge : VitalDelayType := 0 ps;
     tperiod_TSTCLK1_posedge : VitalDelayType := 0 ps;
     tperiod_TXUSRCLK2_posedge : VitalDelayType := 0 ps;
     tperiod_TXUSRCLK_posedge : VitalDelayType := 0 ps;
     tsetup_DADDR_DCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_DADDR_DCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_DEN_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_DEN_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_DFECLKDLYADJ_RXUSRCLK2_negedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     tsetup_DFECLKDLYADJ_RXUSRCLK2_posedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     tsetup_DFEDLYOVRD_RXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_DFEDLYOVRD_RXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_DFETAP1_RXUSRCLK2_negedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tsetup_DFETAP1_RXUSRCLK2_posedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tsetup_DFETAP2_RXUSRCLK2_negedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tsetup_DFETAP2_RXUSRCLK2_posedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tsetup_DFETAP3_RXUSRCLK2_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_DFETAP3_RXUSRCLK2_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_DFETAP4_RXUSRCLK2_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_DFETAP4_RXUSRCLK2_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_DFETAPOVRD_RXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_DFETAPOVRD_RXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_DI_DCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_DI_DCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_DWE_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_DWE_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PRBSCNTRESET_RXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PRBSCNTRESET_RXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXCHBONDI_RXUSRCLK2_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_RXCHBONDI_RXUSRCLK2_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_RXCHBONDI_RXUSRCLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_RXCHBONDI_RXUSRCLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_RXCHBONDLEVEL_RXUSRCLK2_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_RXCHBONDLEVEL_RXUSRCLK2_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_RXCHBONDMASTER_RXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXCHBONDMASTER_RXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXCHBONDSLAVE_RXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXCHBONDSLAVE_RXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXCOMMADETUSE_RXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXCOMMADETUSE_RXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXDEC8B10BUSE_RXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXDEC8B10BUSE_RXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENCHANSYNC_RXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENCHANSYNC_RXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENMCOMMAALIGN_RXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENMCOMMAALIGN_RXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENPCOMMAALIGN_RXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENPCOMMAALIGN_RXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENPRBSTST_RXUSRCLK2_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_RXENPRBSTST_RXUSRCLK2_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_RXENSAMPLEALIGN_RXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENSAMPLEALIGN_RXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXGEARBOXSLIP_RXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXGEARBOXSLIP_RXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXPOLARITY_RXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXPOLARITY_RXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXRATE_RXUSRCLK2_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_RXRATE_RXUSRCLK2_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_RXSLIDE_RXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXSLIDE_RXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXBYPASS8B10B_TXUSRCLK2_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXBYPASS8B10B_TXUSRCLK2_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXCHARDISPMODE_TXUSRCLK2_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXCHARDISPMODE_TXUSRCLK2_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXCHARDISPVAL_TXUSRCLK2_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXCHARDISPVAL_TXUSRCLK2_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXCHARISK_TXUSRCLK2_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXCHARISK_TXUSRCLK2_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXCOMINIT_TXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXCOMINIT_TXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXCOMSAS_TXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXCOMSAS_TXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXCOMWAKE_TXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXCOMWAKE_TXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXDATA_TXUSRCLK2_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tsetup_TXDATA_TXUSRCLK2_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tsetup_TXDETECTRX_TXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXDETECTRX_TXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXELECIDLE_TXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXELECIDLE_TXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXENC8B10BUSE_TXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXENC8B10BUSE_TXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXENPRBSTST_TXUSRCLK2_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_TXENPRBSTST_TXUSRCLK2_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_TXHEADER_TXUSRCLK2_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_TXHEADER_TXUSRCLK2_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_TXINHIBIT_TXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXINHIBIT_TXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXPOLARITY_TXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXPOLARITY_TXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXPOWERDOWN_TXUSRCLK2_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXPOWERDOWN_TXUSRCLK2_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXPRBSFORCEERR_TXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXPRBSFORCEERR_TXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXRATE_TXUSRCLK2_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXRATE_TXUSRCLK2_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXSEQUENCE_TXUSRCLK2_negedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     tsetup_TXSEQUENCE_TXUSRCLK2_posedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     tsetup_TXSTARTSEQ_TXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXSTARTSEQ_TXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_USRCODEERR_RXUSRCLK2_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_USRCODEERR_RXUSRCLK2_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     COMFINISH : out std_ulogic;
     COMINITDET : out std_ulogic;
     COMSASDET : out std_ulogic;
     COMWAKEDET : out std_ulogic;
     DFECLKDLYADJMON : out std_logic_vector(5 downto 0);
     DFEEYEDACMON : out std_logic_vector(4 downto 0);
     DFESENSCAL : out std_logic_vector(2 downto 0);
     DFETAP1MONITOR : out std_logic_vector(4 downto 0);
     DFETAP2MONITOR : out std_logic_vector(4 downto 0);
     DFETAP3MONITOR : out std_logic_vector(3 downto 0);
     DFETAP4MONITOR : out std_logic_vector(3 downto 0);
     DRDY : out std_ulogic;
     DRPDO : out std_logic_vector(15 downto 0);
     MGTREFCLKFAB : out std_logic_vector(1 downto 0);
     PHYSTATUS : out std_ulogic;
     RXBUFSTATUS : out std_logic_vector(2 downto 0);
     RXBYTEISALIGNED : out std_ulogic;
     RXBYTEREALIGN : out std_ulogic;
     RXCHANBONDSEQ : out std_ulogic;
     RXCHANISALIGNED : out std_ulogic;
     RXCHANREALIGN : out std_ulogic;
     RXCHARISCOMMA : out std_logic_vector(3 downto 0);
     RXCHARISK : out std_logic_vector(3 downto 0);
     RXCHBONDO : out std_logic_vector(3 downto 0);
     RXCLKCORCNT : out std_logic_vector(2 downto 0);
     RXCOMMADET : out std_ulogic;
     RXDATA : out std_logic_vector(31 downto 0);
     RXDATAVALID : out std_ulogic;
     RXDISPERR : out std_logic_vector(3 downto 0);
     RXDLYALIGNMONITOR : out std_logic_vector(7 downto 0);
     RXELECIDLE : out std_ulogic;
     RXHEADER : out std_logic_vector(2 downto 0);
     RXHEADERVALID : out std_ulogic;
     RXLOSSOFSYNC : out std_logic_vector(1 downto 0);
     RXNOTINTABLE : out std_logic_vector(3 downto 0);
     RXOVERSAMPLEERR : out std_ulogic;
     RXPLLLKDET : out std_ulogic;
     RXPRBSERR : out std_ulogic;
     RXRATEDONE : out std_ulogic;
     RXRECCLK : out std_ulogic;
     RXRECCLKPCS : out std_ulogic;
     RXRESETDONE : out std_ulogic;
     RXRUNDISP : out std_logic_vector(3 downto 0);
     RXSTARTOFSEQ : out std_ulogic;
     RXSTATUS : out std_logic_vector(2 downto 0);
     RXVALID : out std_ulogic;
     TSTOUT : out std_logic_vector(9 downto 0);
     TXBUFSTATUS : out std_logic_vector(1 downto 0);
     TXDLYALIGNMONITOR : out std_logic_vector(7 downto 0);
     TXGEARBOXREADY : out std_ulogic;
     TXKERR : out std_logic_vector(3 downto 0);
     TXN : out std_ulogic;
     TXOUTCLK : out std_ulogic;
     TXOUTCLKPCS : out std_ulogic;
     TXP : out std_ulogic;
     TXPLLLKDET : out std_ulogic;
     TXRATEDONE : out std_ulogic;
     TXRESETDONE : out std_ulogic;
     TXRUNDISP : out std_logic_vector(3 downto 0);
     DADDR : in std_logic_vector(7 downto 0);
     DCLK : in std_ulogic;
     DEN : in std_ulogic;
     DFECLKDLYADJ : in std_logic_vector(5 downto 0);
     DFEDLYOVRD : in std_ulogic;
     DFETAP1 : in std_logic_vector(4 downto 0);
     DFETAP2 : in std_logic_vector(4 downto 0);
     DFETAP3 : in std_logic_vector(3 downto 0);
     DFETAP4 : in std_logic_vector(3 downto 0);
     DFETAPOVRD : in std_ulogic;
     DI : in std_logic_vector(15 downto 0);
     DWE : in std_ulogic;
     GATERXELECIDLE : in std_ulogic;
     GREFCLKRX : in std_ulogic;
     GREFCLKTX : in std_ulogic;
     GTXRXRESET : in std_ulogic;
     GTXTEST : in std_logic_vector(12 downto 0);
     GTXTXRESET : in std_ulogic;
     IGNORESIGDET : in std_ulogic;
     LOOPBACK : in std_logic_vector(2 downto 0);
     MGTREFCLKRX : in std_logic_vector(1 downto 0);
     MGTREFCLKTX : in std_logic_vector(1 downto 0);
     NORTHREFCLKRX : in std_logic_vector(1 downto 0);
     NORTHREFCLKTX : in std_logic_vector(1 downto 0);
     PERFCLKRX : in std_ulogic;
     PERFCLKTX : in std_ulogic;
     PLLRXRESET : in std_ulogic;
     PLLTXRESET : in std_ulogic;
     PRBSCNTRESET : in std_ulogic;
     RXBUFRESET : in std_ulogic;
     RXCDRRESET : in std_ulogic;
     RXCHBONDI : in std_logic_vector(3 downto 0);
     RXCHBONDLEVEL : in std_logic_vector(2 downto 0);
     RXCHBONDMASTER : in std_ulogic;
     RXCHBONDSLAVE : in std_ulogic;
     RXCOMMADETUSE : in std_ulogic;
     RXDEC8B10BUSE : in std_ulogic;
     RXDLYALIGNDISABLE : in std_ulogic;
     RXDLYALIGNMONENB : in std_ulogic := 'H';
     RXDLYALIGNOVERRIDE : in std_ulogic;
     RXDLYALIGNRESET : in std_ulogic;
     RXDLYALIGNSWPPRECURB : in std_ulogic;
     RXDLYALIGNUPDSW : in std_ulogic;
     RXENCHANSYNC : in std_ulogic;
     RXENMCOMMAALIGN : in std_ulogic;
     RXENPCOMMAALIGN : in std_ulogic;
     RXENPMAPHASEALIGN : in std_ulogic;
     RXENPRBSTST : in std_logic_vector(2 downto 0);
     RXENSAMPLEALIGN : in std_ulogic;
     RXEQMIX : in std_logic_vector(9 downto 0);
     RXGEARBOXSLIP : in std_ulogic;
     RXN : in std_ulogic;
     RXP : in std_ulogic;
     RXPLLLKDETEN : in std_ulogic;
     RXPLLPOWERDOWN : in std_ulogic;
     RXPLLREFSELDY : in std_logic_vector(2 downto 0);
     RXPMASETPHASE : in std_ulogic;
     RXPOLARITY : in std_ulogic;
     RXPOWERDOWN : in std_logic_vector(1 downto 0);
     RXRATE : in std_logic_vector(1 downto 0);
     RXRESET : in std_ulogic;
     RXSLIDE : in std_ulogic;
     RXUSRCLK : in std_ulogic;
     RXUSRCLK2 : in std_ulogic;
     SOUTHREFCLKRX : in std_logic_vector(1 downto 0);
     SOUTHREFCLKTX : in std_logic_vector(1 downto 0);
     TSTCLK0 : in std_ulogic;
     TSTCLK1 : in std_ulogic;
     TSTIN : in std_logic_vector(19 downto 0);
     TXBUFDIFFCTRL : in std_logic_vector(2 downto 0);
     TXBYPASS8B10B : in std_logic_vector(3 downto 0);
     TXCHARDISPMODE : in std_logic_vector(3 downto 0);
     TXCHARDISPVAL : in std_logic_vector(3 downto 0);
     TXCHARISK : in std_logic_vector(3 downto 0);
     TXCOMINIT : in std_ulogic;
     TXCOMSAS : in std_ulogic;
     TXCOMWAKE : in std_ulogic;
     TXDATA : in std_logic_vector(31 downto 0);
     TXDEEMPH : in std_ulogic;
     TXDETECTRX : in std_ulogic;
     TXDIFFCTRL : in std_logic_vector(3 downto 0);
     TXDLYALIGNDISABLE : in std_ulogic;
     TXDLYALIGNMONENB : in std_ulogic := 'H';
     TXDLYALIGNOVERRIDE : in std_ulogic;
     TXDLYALIGNRESET : in std_ulogic;
     TXDLYALIGNUPDSW : in std_ulogic;
     TXELECIDLE : in std_ulogic;
     TXENC8B10BUSE : in std_ulogic;
     TXENPMAPHASEALIGN : in std_ulogic;
     TXENPRBSTST : in std_logic_vector(2 downto 0);
     TXHEADER : in std_logic_vector(2 downto 0);
     TXINHIBIT : in std_ulogic;
     TXMARGIN : in std_logic_vector(2 downto 0);
     TXPDOWNASYNCH : in std_ulogic;
     TXPLLLKDETEN : in std_ulogic;
     TXPLLPOWERDOWN : in std_ulogic;
     TXPLLREFSELDY : in std_logic_vector(2 downto 0);
     TXPMASETPHASE : in std_ulogic;
     TXPOLARITY : in std_ulogic;
     TXPOSTEMPHASIS : in std_logic_vector(4 downto 0);
     TXPOWERDOWN : in std_logic_vector(1 downto 0);
     TXPRBSFORCEERR : in std_ulogic;
     TXPREEMPHASIS : in std_logic_vector(3 downto 0);
     TXRATE : in std_logic_vector(1 downto 0);
     TXRESET : in std_ulogic;
     TXSEQUENCE : in std_logic_vector(6 downto 0);
     TXSTARTSEQ : in std_ulogic;
     TXSWING : in std_ulogic;
     TXUSRCLK : in std_ulogic;
     TXUSRCLK2 : in std_ulogic;
     USRCODEERR : in std_ulogic
  );
end component;

----- component X_GTX_DUAL -----
component X_GTX_DUAL
  generic (
     AC_CAP_DIS_0 : boolean := TRUE;
     AC_CAP_DIS_1 : boolean := TRUE;
     ALIGN_COMMA_WORD_0 : integer := 1;
     ALIGN_COMMA_WORD_1 : integer := 1;
     CB2_INH_CC_PERIOD_0 : integer := 8;
     CB2_INH_CC_PERIOD_1 : integer := 8;
     CDR_PH_ADJ_TIME : bit_vector := "01010";
     CHAN_BOND_1_MAX_SKEW_0 : integer := 7;
     CHAN_BOND_1_MAX_SKEW_1 : integer := 7;
     CHAN_BOND_2_MAX_SKEW_0 : integer := 7;
     CHAN_BOND_2_MAX_SKEW_1 : integer := 7;
     CHAN_BOND_KEEP_ALIGN_0 : boolean := FALSE;
     CHAN_BOND_KEEP_ALIGN_1 : boolean := FALSE;
     CHAN_BOND_LEVEL_0 : integer := 0;
     CHAN_BOND_LEVEL_1 : integer := 0;
     CHAN_BOND_MODE_0 : string := "OFF";
     CHAN_BOND_MODE_1 : string := "OFF";
     CHAN_BOND_SEQ_1_1_0 : bit_vector := "0101111100";
     CHAN_BOND_SEQ_1_1_1 : bit_vector := "0101111100";
     CHAN_BOND_SEQ_1_2_0 : bit_vector := "0000000000";
     CHAN_BOND_SEQ_1_2_1 : bit_vector := "0000000000";
     CHAN_BOND_SEQ_1_3_0 : bit_vector := "0000000000";
     CHAN_BOND_SEQ_1_3_1 : bit_vector := "0000000000";
     CHAN_BOND_SEQ_1_4_0 : bit_vector := "0000000000";
     CHAN_BOND_SEQ_1_4_1 : bit_vector := "0000000000";
     CHAN_BOND_SEQ_1_ENABLE_0 : bit_vector := "0001";
     CHAN_BOND_SEQ_1_ENABLE_1 : bit_vector := "0001";
     CHAN_BOND_SEQ_2_1_0 : bit_vector := "0000000000";
     CHAN_BOND_SEQ_2_1_1 : bit_vector := "0000000000";
     CHAN_BOND_SEQ_2_2_0 : bit_vector := "0000000000";
     CHAN_BOND_SEQ_2_2_1 : bit_vector := "0000000000";
     CHAN_BOND_SEQ_2_3_0 : bit_vector := "0000000000";
     CHAN_BOND_SEQ_2_3_1 : bit_vector := "0000000000";
     CHAN_BOND_SEQ_2_4_0 : bit_vector := "0000000000";
     CHAN_BOND_SEQ_2_4_1 : bit_vector := "0000000000";
     CHAN_BOND_SEQ_2_ENABLE_0 : bit_vector := "0000";
     CHAN_BOND_SEQ_2_ENABLE_1 : bit_vector := "0000";
     CHAN_BOND_SEQ_2_USE_0 : boolean := FALSE;
     CHAN_BOND_SEQ_2_USE_1 : boolean := FALSE;
     CHAN_BOND_SEQ_LEN_0 : integer := 1;
     CHAN_BOND_SEQ_LEN_1 : integer := 1;
     CLK25_DIVIDER : integer := 10;
     CLKINDC_B : boolean := TRUE;
     CLKRCV_TRST : boolean := TRUE;
     CLK_CORRECT_USE_0 : boolean := TRUE;
     CLK_CORRECT_USE_1 : boolean := TRUE;
     CLK_COR_ADJ_LEN_0 : integer := 1;
     CLK_COR_ADJ_LEN_1 : integer := 1;
     CLK_COR_DET_LEN_0 : integer := 1;
     CLK_COR_DET_LEN_1 : integer := 1;
     CLK_COR_INSERT_IDLE_FLAG_0 : boolean := FALSE;
     CLK_COR_INSERT_IDLE_FLAG_1 : boolean := FALSE;
     CLK_COR_KEEP_IDLE_0 : boolean := FALSE;
     CLK_COR_KEEP_IDLE_1 : boolean := FALSE;
     CLK_COR_MAX_LAT_0 : integer := 20;
     CLK_COR_MAX_LAT_1 : integer := 20;
     CLK_COR_MIN_LAT_0 : integer := 18;
     CLK_COR_MIN_LAT_1 : integer := 18;
     CLK_COR_PRECEDENCE_0 : boolean := TRUE;
     CLK_COR_PRECEDENCE_1 : boolean := TRUE;
     CLK_COR_REPEAT_WAIT_0 : integer := 0;
     CLK_COR_REPEAT_WAIT_1 : integer := 0;
     CLK_COR_SEQ_1_1_0 : bit_vector := "0100011100";
     CLK_COR_SEQ_1_1_1 : bit_vector := "0100011100";
     CLK_COR_SEQ_1_2_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_2_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_3_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_3_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_4_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_4_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_ENABLE_0 : bit_vector := "0001";
     CLK_COR_SEQ_1_ENABLE_1 : bit_vector := "0001";
     CLK_COR_SEQ_2_1_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_1_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_2_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_2_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_3_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_3_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_4_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_4_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_ENABLE_0 : bit_vector := "0000";
     CLK_COR_SEQ_2_ENABLE_1 : bit_vector := "0000";
     CLK_COR_SEQ_2_USE_0 : boolean := FALSE;
     CLK_COR_SEQ_2_USE_1 : boolean := FALSE;
     CM_TRIM_0 : bit_vector := "10";
     CM_TRIM_1 : bit_vector := "10";
     COMMA_10B_ENABLE_0 : bit_vector := "0001111111";
     COMMA_10B_ENABLE_1 : bit_vector := "0001111111";
     COMMA_DOUBLE_0 : boolean := FALSE;
     COMMA_DOUBLE_1 : boolean := FALSE;
     COM_BURST_VAL_0 : bit_vector := "1111";
     COM_BURST_VAL_1 : bit_vector := "1111";
     DEC_MCOMMA_DETECT_0 : boolean := TRUE;
     DEC_MCOMMA_DETECT_1 : boolean := TRUE;
     DEC_PCOMMA_DETECT_0 : boolean := TRUE;
     DEC_PCOMMA_DETECT_1 : boolean := TRUE;
     DEC_VALID_COMMA_ONLY_0 : boolean := TRUE;
     DEC_VALID_COMMA_ONLY_1 : boolean := TRUE;
     DFE_CAL_TIME : bit_vector := "00110";
     DFE_CFG_0 : bit_vector := "1101111011";
     DFE_CFG_1 : bit_vector := "1101111011";
     GEARBOX_ENDEC_0 : bit_vector := "000";
     GEARBOX_ENDEC_1 : bit_vector := "000";
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MCOMMA_10B_VALUE_0 : bit_vector := "1010000011";
     MCOMMA_10B_VALUE_1 : bit_vector := "1010000011";
     MCOMMA_DETECT_0 : boolean := TRUE;
     MCOMMA_DETECT_1 : boolean := TRUE;
     MsgOn : boolean := FALSE;
     OOBDETECT_THRESHOLD_0 : bit_vector := "110";
     OOBDETECT_THRESHOLD_1 : bit_vector := "110";
     OOB_CLK_DIVIDER : integer := 6;
     OVERSAMPLE_MODE : boolean := FALSE;
     PCI_EXPRESS_MODE_0 : boolean := FALSE;
     PCI_EXPRESS_MODE_1 : boolean := FALSE;
     PCOMMA_10B_VALUE_0 : bit_vector := "0101111100";
     PCOMMA_10B_VALUE_1 : bit_vector := "0101111100";
     PCOMMA_DETECT_0 : boolean := TRUE;
     PCOMMA_DETECT_1 : boolean := TRUE;
     PLL_COM_CFG : bit_vector := X"21680a";
     PLL_CP_CFG : bit_vector := X"00";
     PLL_DIVSEL_FB : integer := 2;
     PLL_DIVSEL_REF : integer := 1;
     PLL_FB_DCCEN : boolean := FALSE;
     PLL_LKDET_CFG : bit_vector := "101";
     PLL_RXDIVSEL_OUT_0 : integer := 1;
     PLL_RXDIVSEL_OUT_1 : integer := 1;
     PLL_SATA_0 : boolean := FALSE;
     PLL_SATA_1 : boolean := FALSE;
     PLL_TDCC_CFG : bit_vector := "000";
     PLL_TXDIVSEL_OUT_0 : integer := 1;
     PLL_TXDIVSEL_OUT_1 : integer := 1;
     PMA_CDR_SCAN_0 : bit_vector := X"6404035";
     PMA_CDR_SCAN_1 : bit_vector := X"6404035";
     PMA_COM_CFG : bit_vector := X"000000000000000000";
     PMA_RXSYNC_CFG_0 : bit_vector := X"00";
     PMA_RXSYNC_CFG_1 : bit_vector := X"00";
     PMA_RX_CFG_0 : bit_vector := X"0f44089";
     PMA_RX_CFG_1 : bit_vector := X"0f44089";
     PMA_TX_CFG_0 : bit_vector := X"80082";
     PMA_TX_CFG_1 : bit_vector := X"80082";
     PRBS_ERR_THRESHOLD_0 : bit_vector := X"00000001";
     PRBS_ERR_THRESHOLD_1 : bit_vector := X"00000001";
     RCV_TERM_GND_0 : boolean := FALSE;
     RCV_TERM_GND_1 : boolean := FALSE;
     RCV_TERM_VTTRX_0 : boolean := FALSE;
     RCV_TERM_VTTRX_1 : boolean := FALSE;
     RXGEARBOX_USE_0 : boolean := FALSE;
     RXGEARBOX_USE_1 : boolean := FALSE;
     RX_BUFFER_USE_0 : boolean := TRUE;
     RX_BUFFER_USE_1 : boolean := TRUE;
     RX_DECODE_SEQ_MATCH_0 : boolean := TRUE;
     RX_DECODE_SEQ_MATCH_1 : boolean := TRUE;
     RX_EN_IDLE_HOLD_CDR : boolean := FALSE;
     RX_EN_IDLE_HOLD_DFE_0 : boolean := TRUE;
     RX_EN_IDLE_HOLD_DFE_1 : boolean := TRUE;
     RX_EN_IDLE_RESET_BUF_0 : boolean := TRUE;
     RX_EN_IDLE_RESET_BUF_1 : boolean := TRUE;
     RX_EN_IDLE_RESET_FR : boolean := TRUE;
     RX_EN_IDLE_RESET_PH : boolean := TRUE;
     RX_IDLE_HI_CNT_0 : bit_vector := "1000";
     RX_IDLE_HI_CNT_1 : bit_vector := "1000";
     RX_IDLE_LO_CNT_0 : bit_vector := "0000";
     RX_IDLE_LO_CNT_1 : bit_vector := "0000";
     RX_LOSS_OF_SYNC_FSM_0 : boolean := FALSE;
     RX_LOSS_OF_SYNC_FSM_1 : boolean := FALSE;
     RX_LOS_INVALID_INCR_0 : integer := 1;
     RX_LOS_INVALID_INCR_1 : integer := 1;
     RX_LOS_THRESHOLD_0 : integer := 4;
     RX_LOS_THRESHOLD_1 : integer := 4;
     RX_SLIDE_MODE_0 : string := "PCS";
     RX_SLIDE_MODE_1 : string := "PCS";
     RX_STATUS_FMT_0 : string := "PCIE";
     RX_STATUS_FMT_1 : string := "PCIE";
     RX_XCLK_SEL_0 : string := "RXREC";
     RX_XCLK_SEL_1 : string := "RXREC";
     SATA_BURST_VAL_0 : bit_vector := "100";
     SATA_BURST_VAL_1 : bit_vector := "100";
     SATA_IDLE_VAL_0 : bit_vector := "100";
     SATA_IDLE_VAL_1 : bit_vector := "100";
     SATA_MAX_BURST_0 : integer := 7;
     SATA_MAX_BURST_1 : integer := 7;
     SATA_MAX_INIT_0 : integer := 22;
     SATA_MAX_INIT_1 : integer := 22;
     SATA_MAX_WAKE_0 : integer := 7;
     SATA_MAX_WAKE_1 : integer := 7;
     SATA_MIN_BURST_0 : integer := 4;
     SATA_MIN_BURST_1 : integer := 4;
     SATA_MIN_INIT_0 : integer := 12;
     SATA_MIN_INIT_1 : integer := 12;
     SATA_MIN_WAKE_0 : integer := 4;
     SATA_MIN_WAKE_1 : integer := 4;
     SIM_GTXRESET_SPEEDUP : integer := 1;
     SIM_MODE : string := "FAST";
     SIM_PLL_PERDIV2 : bit_vector := X"140";
     SIM_RECEIVER_DETECT_PASS_0 : boolean := TRUE;
     SIM_RECEIVER_DETECT_PASS_1 : boolean := TRUE;
     TERMINATION_CTRL : bit_vector := "10100";
     TERMINATION_IMP_0 : integer := 50;
     TERMINATION_IMP_1 : integer := 50;
     TERMINATION_OVRD : boolean := FALSE;
     TRANS_TIME_FROM_P2_0 : bit_vector := X"03c";
     TRANS_TIME_FROM_P2_1 : bit_vector := X"03c";
     TRANS_TIME_NON_P2_0 : bit_vector := X"19";
     TRANS_TIME_NON_P2_1 : bit_vector := X"19";
     TRANS_TIME_TO_P2_0 : bit_vector := X"064";
     TRANS_TIME_TO_P2_1 : bit_vector := X"064";
     TXGEARBOX_USE_0 : boolean := FALSE;
     TXGEARBOX_USE_1 : boolean := FALSE;
     TXRX_INVERT_0 : bit_vector := "011";
     TXRX_INVERT_1 : bit_vector := "011";
     TX_BUFFER_USE_0 : boolean := TRUE;
     TX_BUFFER_USE_1 : boolean := TRUE;
     TX_DETECT_RX_CFG_0 : bit_vector := X"1832";
     TX_DETECT_RX_CFG_1 : bit_vector := X"1832";
     TX_IDLE_DELAY_0 : bit_vector := "010";
     TX_IDLE_DELAY_1 : bit_vector := "010";
     TX_XCLK_SEL_0 : string := "TXOUT";
     TX_XCLK_SEL_1 : string := "TXOUT";
     TimingChecksOn : boolean := TRUE;
     Xon : boolean := TRUE;
     thold_DADDR_DCLK_negedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     thold_DADDR_DCLK_posedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     thold_DEN_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_DEN_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_DFECLKDLYADJ0_RXUSRCLK20_negedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     thold_DFECLKDLYADJ0_RXUSRCLK20_posedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     thold_DFECLKDLYADJ1_RXUSRCLK21_negedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     thold_DFECLKDLYADJ1_RXUSRCLK21_posedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     thold_DFETAP10_RXUSRCLK20_negedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     thold_DFETAP10_RXUSRCLK20_posedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     thold_DFETAP11_RXUSRCLK21_negedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     thold_DFETAP11_RXUSRCLK21_posedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     thold_DFETAP20_RXUSRCLK20_negedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     thold_DFETAP20_RXUSRCLK20_posedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     thold_DFETAP21_RXUSRCLK21_negedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     thold_DFETAP21_RXUSRCLK21_posedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     thold_DFETAP30_RXUSRCLK20_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_DFETAP30_RXUSRCLK20_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_DFETAP31_RXUSRCLK21_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_DFETAP31_RXUSRCLK21_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_DFETAP40_RXUSRCLK20_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_DFETAP40_RXUSRCLK20_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_DFETAP41_RXUSRCLK21_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_DFETAP41_RXUSRCLK21_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_DI_DCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_DI_DCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_DWE_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_DWE_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PRBSCNTRESET0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_PRBSCNTRESET0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_PRBSCNTRESET1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_PRBSCNTRESET1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXCHBONDI0_RXUSRCLK0_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_RXCHBONDI0_RXUSRCLK0_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_RXCHBONDI1_RXUSRCLK1_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_RXCHBONDI1_RXUSRCLK1_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_RXCOMMADETUSE0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXCOMMADETUSE0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXCOMMADETUSE1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXCOMMADETUSE1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXDEC8B10BUSE0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXDEC8B10BUSE0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXDEC8B10BUSE1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXDEC8B10BUSE1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXENCHANSYNC0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXENCHANSYNC0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXENCHANSYNC1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXENCHANSYNC1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXENMCOMMAALIGN0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXENMCOMMAALIGN0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXENMCOMMAALIGN1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXENMCOMMAALIGN1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXENPCOMMAALIGN0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXENPCOMMAALIGN0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXENPCOMMAALIGN1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXENPCOMMAALIGN1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXENPRBSTST0_RXUSRCLK20_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_RXENPRBSTST0_RXUSRCLK20_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_RXENPRBSTST1_RXUSRCLK21_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_RXENPRBSTST1_RXUSRCLK21_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_RXENSAMPLEALIGN0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXENSAMPLEALIGN0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXENSAMPLEALIGN1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXENSAMPLEALIGN1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXGEARBOXSLIP0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXGEARBOXSLIP0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXGEARBOXSLIP1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXGEARBOXSLIP1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXPOLARITY0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXPOLARITY0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXPOLARITY1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXPOLARITY1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXSLIDE0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXSLIDE0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_RXSLIDE1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_RXSLIDE1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXBYPASS8B10B0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXBYPASS8B10B0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXBYPASS8B10B1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXBYPASS8B10B1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXCHARDISPMODE0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXCHARDISPMODE0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXCHARDISPMODE1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXCHARDISPMODE1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXCHARDISPVAL0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXCHARDISPVAL0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXCHARDISPVAL1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXCHARDISPVAL1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXCHARISK0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXCHARISK0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXCHARISK1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXCHARISK1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_TXCOMSTART0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXCOMSTART0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXCOMSTART1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXCOMSTART1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXCOMTYPE0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXCOMTYPE0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXCOMTYPE1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXCOMTYPE1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXDATA0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     thold_TXDATA0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     thold_TXDATA1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     thold_TXDATA1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     thold_TXDETECTRX0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXDETECTRX0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXDETECTRX1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXDETECTRX1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXELECIDLE0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXELECIDLE0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXELECIDLE1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXELECIDLE1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXENC8B10BUSE0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXENC8B10BUSE0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXENC8B10BUSE1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXENC8B10BUSE1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXENPRBSTST0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXENPRBSTST0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXENPRBSTST1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXENPRBSTST1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_TXHEADER0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_TXHEADER0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_TXHEADER1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_TXHEADER1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_TXINHIBIT0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXINHIBIT0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXINHIBIT1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXINHIBIT1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXPOLARITY0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXPOLARITY0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXPOLARITY1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXPOLARITY1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXSEQUENCE0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     thold_TXSEQUENCE0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     thold_TXSEQUENCE1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     thold_TXSEQUENCE1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     thold_TXSTARTSEQ0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXSTARTSEQ0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     thold_TXSTARTSEQ1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     thold_TXSTARTSEQ1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     ticd_DCLK : VitalDelayType := 0 ps;
     ticd_RXUSRCLK0 : VitalDelayType := 0 ps;
     ticd_RXUSRCLK1 : VitalDelayType := 0 ps;
     ticd_RXUSRCLK20 : VitalDelayType := 0 ps;
     ticd_RXUSRCLK21 : VitalDelayType := 0 ps;
     ticd_TXUSRCLK20 : VitalDelayType := 0 ps;
     ticd_TXUSRCLK21 : VitalDelayType := 0 ps;
     tipd_CLKIN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DADDR : VitalDelayArrayType01 (6 downto 0) := (others => (0 ps, 0 ps));
     tipd_DCLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DEN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DFECLKDLYADJ0 : VitalDelayArrayType01 (5 downto 0) := (others => (0 ps, 0 ps));
     tipd_DFECLKDLYADJ1 : VitalDelayArrayType01 (5 downto 0) := (others => (0 ps, 0 ps));
     tipd_DFETAP10 : VitalDelayArrayType01 (4 downto 0) := (others => (0 ps, 0 ps));
     tipd_DFETAP11 : VitalDelayArrayType01 (4 downto 0) := (others => (0 ps, 0 ps));
     tipd_DFETAP20 : VitalDelayArrayType01 (4 downto 0) := (others => (0 ps, 0 ps));
     tipd_DFETAP21 : VitalDelayArrayType01 (4 downto 0) := (others => (0 ps, 0 ps));
     tipd_DFETAP30 : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_DFETAP31 : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_DFETAP40 : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_DFETAP41 : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_DI : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
     tipd_DWE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_GTXRESET : VitalDelayType01 := (0 ps, 0 ps);
     tipd_GTXTEST : VitalDelayArrayType01 (13 downto 0) := (others => (0 ps, 0 ps));
     tipd_INTDATAWIDTH : VitalDelayType01 := (0 ps, 0 ps);
     tipd_LOOPBACK0 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_LOOPBACK1 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_PLLLKDETEN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PLLPOWERDOWN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PRBSCNTRESET0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PRBSCNTRESET1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_REFCLKPWRDNB : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXBUFRESET0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXBUFRESET1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXCDRRESET0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXCDRRESET1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXCHBONDI0 : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXCHBONDI1 : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXCOMMADETUSE0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXCOMMADETUSE1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXDATAWIDTH0 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXDATAWIDTH1 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXDEC8B10BUSE0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXDEC8B10BUSE1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENCHANSYNC0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENCHANSYNC1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENEQB0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENEQB1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENMCOMMAALIGN0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENMCOMMAALIGN1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENPCOMMAALIGN0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENPCOMMAALIGN1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENPMAPHASEALIGN0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENPMAPHASEALIGN1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENPRBSTST0 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXENPRBSTST1 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXENSAMPLEALIGN0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXENSAMPLEALIGN1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXEQMIX0 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXEQMIX1 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXEQPOLE0 : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXEQPOLE1 : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXGEARBOXSLIP0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXGEARBOXSLIP1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXN0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXN1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXP0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXP1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXPMASETPHASE0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXPMASETPHASE1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXPOLARITY0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXPOLARITY1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXPOWERDOWN0 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXPOWERDOWN1 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_RXRESET0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXRESET1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXSLIDE0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXSLIDE1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXUSRCLK0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXUSRCLK1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXUSRCLK20 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RXUSRCLK21 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXBUFDIFFCTRL0 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXBUFDIFFCTRL1 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXBYPASS8B10B0 : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXBYPASS8B10B1 : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXCHARDISPMODE0 : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXCHARDISPMODE1 : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXCHARDISPVAL0 : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXCHARDISPVAL1 : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXCHARISK0 : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXCHARISK1 : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXCOMSTART0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXCOMSTART1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXCOMTYPE0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXCOMTYPE1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXDATA0 : VitalDelayArrayType01 (31 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXDATA1 : VitalDelayArrayType01 (31 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXDATAWIDTH0 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXDATAWIDTH1 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXDETECTRX0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXDETECTRX1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXDIFFCTRL0 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXDIFFCTRL1 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXELECIDLE0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXELECIDLE1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXENC8B10BUSE0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXENC8B10BUSE1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXENPMAPHASEALIGN0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXENPMAPHASEALIGN1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXENPRBSTST0 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXENPRBSTST1 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXHEADER0 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXHEADER1 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXINHIBIT0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXINHIBIT1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXPMASETPHASE0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXPMASETPHASE1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXPOLARITY0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXPOLARITY1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXPOWERDOWN0 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXPOWERDOWN1 : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXPREEMPHASIS0 : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXPREEMPHASIS1 : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXRESET0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXRESET1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXSEQUENCE0 : VitalDelayArrayType01 (6 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXSEQUENCE1 : VitalDelayArrayType01 (6 downto 0) := (others => (0 ps, 0 ps));
     tipd_TXSTARTSEQ0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXSTARTSEQ1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXUSRCLK0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXUSRCLK1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXUSRCLK20 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TXUSRCLK21 : VitalDelayType01 := (0 ps, 0 ps);
     tisd_DADDR_DCLK : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     tisd_DEN_DCLK : VitalDelayType := 0 ps;
     tisd_DFECLKDLYADJ0_RXUSRCLK20 : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     tisd_DFECLKDLYADJ1_RXUSRCLK21 : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     tisd_DFETAP10_RXUSRCLK20 : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tisd_DFETAP11_RXUSRCLK21 : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tisd_DFETAP20_RXUSRCLK20 : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tisd_DFETAP21_RXUSRCLK21 : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tisd_DFETAP30_RXUSRCLK20 : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_DFETAP31_RXUSRCLK21 : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_DFETAP40_RXUSRCLK20 : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_DFETAP41_RXUSRCLK21 : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_DI_DCLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tisd_DWE_DCLK : VitalDelayType := 0 ps;
     tisd_PRBSCNTRESET0_RXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_PRBSCNTRESET1_RXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_RXCHBONDI0_RXUSRCLK0 : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_RXCHBONDI1_RXUSRCLK1 : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_RXCOMMADETUSE0_RXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_RXCOMMADETUSE1_RXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_RXDEC8B10BUSE0_RXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_RXDEC8B10BUSE1_RXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_RXENCHANSYNC0_RXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_RXENCHANSYNC1_RXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_RXENMCOMMAALIGN0_RXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_RXENMCOMMAALIGN1_RXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_RXENPCOMMAALIGN0_RXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_RXENPCOMMAALIGN1_RXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_RXENPRBSTST0_RXUSRCLK20 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_RXENPRBSTST1_RXUSRCLK21 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_RXENSAMPLEALIGN0_RXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_RXENSAMPLEALIGN1_RXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_RXGEARBOXSLIP0_RXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_RXGEARBOXSLIP1_RXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_RXPOLARITY0_RXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_RXPOLARITY1_RXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_RXSLIDE0_RXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_RXSLIDE1_RXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_TXBYPASS8B10B0_TXUSRCLK20 : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_TXBYPASS8B10B1_TXUSRCLK21 : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_TXCHARDISPMODE0_TXUSRCLK20 : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_TXCHARDISPMODE1_TXUSRCLK21 : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_TXCHARDISPVAL0_TXUSRCLK20 : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_TXCHARDISPVAL1_TXUSRCLK21 : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_TXCHARISK0_TXUSRCLK20 : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_TXCHARISK1_TXUSRCLK21 : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_TXCOMSTART0_TXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_TXCOMSTART1_TXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_TXCOMTYPE0_TXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_TXCOMTYPE1_TXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_TXDATA0_TXUSRCLK20 : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tisd_TXDATA1_TXUSRCLK21 : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tisd_TXDETECTRX0_TXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_TXDETECTRX1_TXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_TXELECIDLE0_TXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_TXELECIDLE1_TXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_TXENC8B10BUSE0_TXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_TXENC8B10BUSE1_TXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_TXENPRBSTST0_TXUSRCLK20 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_TXENPRBSTST1_TXUSRCLK21 : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_TXHEADER0_TXUSRCLK20 : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_TXHEADER1_TXUSRCLK21 : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_TXINHIBIT0_TXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_TXINHIBIT1_TXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_TXPOLARITY0_TXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_TXPOLARITY1_TXUSRCLK21 : VitalDelayType := 0 ps;
     tisd_TXSEQUENCE0_TXUSRCLK20 : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     tisd_TXSEQUENCE1_TXUSRCLK21 : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     tisd_TXSTARTSEQ0_TXUSRCLK20 : VitalDelayType := 0 ps;
     tisd_TXSTARTSEQ1_TXUSRCLK21 : VitalDelayType := 0 ps;
     tpd_CLKIN_REFCLKOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_DCLK_DO : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
     tpd_DCLK_DRDY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK0_RXCHBONDO0 : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK1_RXCHBONDO1 : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_DFECLKDLYADJMONITOR0 : VitalDelayArrayType01(5 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_DFEEYEDACMONITOR0 : VitalDelayArrayType01(4 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_DFESENSCAL0 : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_DFETAP1MONITOR0 : VitalDelayArrayType01(4 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_DFETAP2MONITOR0 : VitalDelayArrayType01(4 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_DFETAP3MONITOR0 : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_DFETAP4MONITOR0 : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_PHYSTATUS0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK20_RXBUFSTATUS0 : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_RXBYTEISALIGNED0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK20_RXBYTEREALIGN0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK20_RXCHANBONDSEQ0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK20_RXCHANISALIGNED0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK20_RXCHANREALIGN0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK20_RXCHARISCOMMA0 : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_RXCHARISK0 : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_RXCLKCORCNT0 : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_RXCOMMADET0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK20_RXDATA0 : VitalDelayArrayType01(31 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_RXDATAVALID0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK20_RXDISPERR0 : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_RXHEADER0 : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_RXHEADERVALID0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK20_RXLOSSOFSYNC0 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_RXNOTINTABLE0 : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_RXOVERSAMPLEERR0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK20_RXPRBSERR0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK20_RXRUNDISP0 : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_RXSTARTOFSEQ0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK20_RXSTATUS0 : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK20_RXVALID0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK21_DFECLKDLYADJMONITOR1 : VitalDelayArrayType01(5 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_DFEEYEDACMONITOR1 : VitalDelayArrayType01(4 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_DFESENSCAL1 : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_DFETAP1MONITOR1 : VitalDelayArrayType01(4 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_DFETAP2MONITOR1 : VitalDelayArrayType01(4 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_DFETAP3MONITOR1 : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_DFETAP4MONITOR1 : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_PHYSTATUS1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK21_RXBUFSTATUS1 : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_RXBYTEISALIGNED1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK21_RXBYTEREALIGN1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK21_RXCHANBONDSEQ1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK21_RXCHANISALIGNED1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK21_RXCHANREALIGN1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK21_RXCHARISCOMMA1 : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_RXCHARISK1 : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_RXCLKCORCNT1 : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_RXCOMMADET1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK21_RXDATA1 : VitalDelayArrayType01(31 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_RXDATAVALID1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK21_RXDISPERR1 : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_RXHEADER1 : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_RXHEADERVALID1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK21_RXLOSSOFSYNC1 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_RXNOTINTABLE1 : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_RXOVERSAMPLEERR1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK21_RXPRBSERR1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK21_RXRUNDISP1 : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_RXSTARTOFSEQ1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RXUSRCLK21_RXSTATUS1 : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_RXUSRCLK21_RXVALID1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_TXUSRCLK20_TXBUFSTATUS0 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_TXUSRCLK20_TXGEARBOXREADY0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_TXUSRCLK20_TXKERR0 : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_TXUSRCLK20_TXRUNDISP0 : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_TXUSRCLK21_TXBUFSTATUS1 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_TXUSRCLK21_TXGEARBOXREADY1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_TXUSRCLK21_TXKERR1 : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_TXUSRCLK21_TXRUNDISP1 : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tsetup_DADDR_DCLK_negedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     tsetup_DADDR_DCLK_posedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     tsetup_DEN_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_DEN_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_DFECLKDLYADJ0_RXUSRCLK20_negedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     tsetup_DFECLKDLYADJ0_RXUSRCLK20_posedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     tsetup_DFECLKDLYADJ1_RXUSRCLK21_negedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     tsetup_DFECLKDLYADJ1_RXUSRCLK21_posedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     tsetup_DFETAP10_RXUSRCLK20_negedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tsetup_DFETAP10_RXUSRCLK20_posedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tsetup_DFETAP11_RXUSRCLK21_negedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tsetup_DFETAP11_RXUSRCLK21_posedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tsetup_DFETAP20_RXUSRCLK20_negedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tsetup_DFETAP20_RXUSRCLK20_posedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tsetup_DFETAP21_RXUSRCLK21_negedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tsetup_DFETAP21_RXUSRCLK21_posedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tsetup_DFETAP30_RXUSRCLK20_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_DFETAP30_RXUSRCLK20_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_DFETAP31_RXUSRCLK21_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_DFETAP31_RXUSRCLK21_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_DFETAP40_RXUSRCLK20_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_DFETAP40_RXUSRCLK20_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_DFETAP41_RXUSRCLK21_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_DFETAP41_RXUSRCLK21_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_DI_DCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_DI_DCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_DWE_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_DWE_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PRBSCNTRESET0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PRBSCNTRESET0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PRBSCNTRESET1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PRBSCNTRESET1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXCHBONDI0_RXUSRCLK0_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_RXCHBONDI0_RXUSRCLK0_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_RXCHBONDI1_RXUSRCLK1_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_RXCHBONDI1_RXUSRCLK1_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_RXCOMMADETUSE0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXCOMMADETUSE0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXCOMMADETUSE1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXCOMMADETUSE1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXDEC8B10BUSE0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXDEC8B10BUSE0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXDEC8B10BUSE1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXDEC8B10BUSE1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENCHANSYNC0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENCHANSYNC0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENCHANSYNC1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENCHANSYNC1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENMCOMMAALIGN0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENMCOMMAALIGN0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENMCOMMAALIGN1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENMCOMMAALIGN1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENPCOMMAALIGN0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENPCOMMAALIGN0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENPCOMMAALIGN1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENPCOMMAALIGN1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENPRBSTST0_RXUSRCLK20_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_RXENPRBSTST0_RXUSRCLK20_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_RXENPRBSTST1_RXUSRCLK21_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_RXENPRBSTST1_RXUSRCLK21_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_RXENSAMPLEALIGN0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENSAMPLEALIGN0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENSAMPLEALIGN1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXENSAMPLEALIGN1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXGEARBOXSLIP0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXGEARBOXSLIP0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXGEARBOXSLIP1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXGEARBOXSLIP1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXPOLARITY0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXPOLARITY0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXPOLARITY1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXPOLARITY1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXSLIDE0_RXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXSLIDE0_RXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXSLIDE1_RXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RXSLIDE1_RXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXBYPASS8B10B0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXBYPASS8B10B0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXBYPASS8B10B1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXBYPASS8B10B1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXCHARDISPMODE0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXCHARDISPMODE0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXCHARDISPMODE1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXCHARDISPMODE1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXCHARDISPVAL0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXCHARDISPVAL0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXCHARDISPVAL1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXCHARDISPVAL1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXCHARISK0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXCHARISK0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXCHARISK1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXCHARISK1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_TXCOMSTART0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXCOMSTART0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXCOMSTART1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXCOMSTART1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXCOMTYPE0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXCOMTYPE0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXCOMTYPE1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXCOMTYPE1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXDATA0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tsetup_TXDATA0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tsetup_TXDATA1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tsetup_TXDATA1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tsetup_TXDETECTRX0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXDETECTRX0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXDETECTRX1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXDETECTRX1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXELECIDLE0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXELECIDLE0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXELECIDLE1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXELECIDLE1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXENC8B10BUSE0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXENC8B10BUSE0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXENC8B10BUSE1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXENC8B10BUSE1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXENPRBSTST0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXENPRBSTST0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXENPRBSTST1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXENPRBSTST1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_TXHEADER0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_TXHEADER0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_TXHEADER1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_TXHEADER1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_TXINHIBIT0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXINHIBIT0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXINHIBIT1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXINHIBIT1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXPOLARITY0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXPOLARITY0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXPOLARITY1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXPOLARITY1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXSEQUENCE0_TXUSRCLK20_negedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     tsetup_TXSEQUENCE0_TXUSRCLK20_posedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     tsetup_TXSEQUENCE1_TXUSRCLK21_negedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     tsetup_TXSEQUENCE1_TXUSRCLK21_posedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     tsetup_TXSTARTSEQ0_TXUSRCLK20_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXSTARTSEQ0_TXUSRCLK20_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXSTARTSEQ1_TXUSRCLK21_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TXSTARTSEQ1_TXUSRCLK21_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     DFECLKDLYADJMONITOR0 : out std_logic_vector(5 downto 0);
     DFECLKDLYADJMONITOR1 : out std_logic_vector(5 downto 0);
     DFEEYEDACMONITOR0 : out std_logic_vector(4 downto 0);
     DFEEYEDACMONITOR1 : out std_logic_vector(4 downto 0);
     DFESENSCAL0 : out std_logic_vector(2 downto 0);
     DFESENSCAL1 : out std_logic_vector(2 downto 0);
     DFETAP1MONITOR0 : out std_logic_vector(4 downto 0);
     DFETAP1MONITOR1 : out std_logic_vector(4 downto 0);
     DFETAP2MONITOR0 : out std_logic_vector(4 downto 0);
     DFETAP2MONITOR1 : out std_logic_vector(4 downto 0);
     DFETAP3MONITOR0 : out std_logic_vector(3 downto 0);
     DFETAP3MONITOR1 : out std_logic_vector(3 downto 0);
     DFETAP4MONITOR0 : out std_logic_vector(3 downto 0);
     DFETAP4MONITOR1 : out std_logic_vector(3 downto 0);
     DO : out std_logic_vector(15 downto 0);
     DRDY : out std_ulogic;
     PHYSTATUS0 : out std_ulogic;
     PHYSTATUS1 : out std_ulogic;
     PLLLKDET : out std_ulogic;
     REFCLKOUT : out std_ulogic;
     RESETDONE0 : out std_ulogic;
     RESETDONE1 : out std_ulogic;
     RXBUFSTATUS0 : out std_logic_vector(2 downto 0);
     RXBUFSTATUS1 : out std_logic_vector(2 downto 0);
     RXBYTEISALIGNED0 : out std_ulogic;
     RXBYTEISALIGNED1 : out std_ulogic;
     RXBYTEREALIGN0 : out std_ulogic;
     RXBYTEREALIGN1 : out std_ulogic;
     RXCHANBONDSEQ0 : out std_ulogic;
     RXCHANBONDSEQ1 : out std_ulogic;
     RXCHANISALIGNED0 : out std_ulogic;
     RXCHANISALIGNED1 : out std_ulogic;
     RXCHANREALIGN0 : out std_ulogic;
     RXCHANREALIGN1 : out std_ulogic;
     RXCHARISCOMMA0 : out std_logic_vector(3 downto 0);
     RXCHARISCOMMA1 : out std_logic_vector(3 downto 0);
     RXCHARISK0 : out std_logic_vector(3 downto 0);
     RXCHARISK1 : out std_logic_vector(3 downto 0);
     RXCHBONDO0 : out std_logic_vector(3 downto 0);
     RXCHBONDO1 : out std_logic_vector(3 downto 0);
     RXCLKCORCNT0 : out std_logic_vector(2 downto 0);
     RXCLKCORCNT1 : out std_logic_vector(2 downto 0);
     RXCOMMADET0 : out std_ulogic;
     RXCOMMADET1 : out std_ulogic;
     RXDATA0 : out std_logic_vector(31 downto 0);
     RXDATA1 : out std_logic_vector(31 downto 0);
     RXDATAVALID0 : out std_ulogic;
     RXDATAVALID1 : out std_ulogic;
     RXDISPERR0 : out std_logic_vector(3 downto 0);
     RXDISPERR1 : out std_logic_vector(3 downto 0);
     RXELECIDLE0 : out std_ulogic;
     RXELECIDLE1 : out std_ulogic;
     RXHEADER0 : out std_logic_vector(2 downto 0);
     RXHEADER1 : out std_logic_vector(2 downto 0);
     RXHEADERVALID0 : out std_ulogic;
     RXHEADERVALID1 : out std_ulogic;
     RXLOSSOFSYNC0 : out std_logic_vector(1 downto 0);
     RXLOSSOFSYNC1 : out std_logic_vector(1 downto 0);
     RXNOTINTABLE0 : out std_logic_vector(3 downto 0);
     RXNOTINTABLE1 : out std_logic_vector(3 downto 0);
     RXOVERSAMPLEERR0 : out std_ulogic;
     RXOVERSAMPLEERR1 : out std_ulogic;
     RXPRBSERR0 : out std_ulogic;
     RXPRBSERR1 : out std_ulogic;
     RXRECCLK0 : out std_ulogic;
     RXRECCLK1 : out std_ulogic;
     RXRUNDISP0 : out std_logic_vector(3 downto 0);
     RXRUNDISP1 : out std_logic_vector(3 downto 0);
     RXSTARTOFSEQ0 : out std_ulogic;
     RXSTARTOFSEQ1 : out std_ulogic;
     RXSTATUS0 : out std_logic_vector(2 downto 0);
     RXSTATUS1 : out std_logic_vector(2 downto 0);
     RXVALID0 : out std_ulogic;
     RXVALID1 : out std_ulogic;
     TXBUFSTATUS0 : out std_logic_vector(1 downto 0);
     TXBUFSTATUS1 : out std_logic_vector(1 downto 0);
     TXGEARBOXREADY0 : out std_ulogic;
     TXGEARBOXREADY1 : out std_ulogic;
     TXKERR0 : out std_logic_vector(3 downto 0);
     TXKERR1 : out std_logic_vector(3 downto 0);
     TXN0 : out std_ulogic;
     TXN1 : out std_ulogic;
     TXOUTCLK0 : out std_ulogic;
     TXOUTCLK1 : out std_ulogic;
     TXP0 : out std_ulogic;
     TXP1 : out std_ulogic;
     TXRUNDISP0 : out std_logic_vector(3 downto 0);
     TXRUNDISP1 : out std_logic_vector(3 downto 0);
     CLKIN : in std_ulogic;
     DADDR : in std_logic_vector(6 downto 0);
     DCLK : in std_ulogic;
     DEN : in std_ulogic;
     DFECLKDLYADJ0 : in std_logic_vector(5 downto 0);
     DFECLKDLYADJ1 : in std_logic_vector(5 downto 0);
     DFETAP10 : in std_logic_vector(4 downto 0);
     DFETAP11 : in std_logic_vector(4 downto 0);
     DFETAP20 : in std_logic_vector(4 downto 0);
     DFETAP21 : in std_logic_vector(4 downto 0);
     DFETAP30 : in std_logic_vector(3 downto 0);
     DFETAP31 : in std_logic_vector(3 downto 0);
     DFETAP40 : in std_logic_vector(3 downto 0);
     DFETAP41 : in std_logic_vector(3 downto 0);
     DI : in std_logic_vector(15 downto 0);
     DWE : in std_ulogic;
     GTXRESET : in std_ulogic;
     GTXTEST : in std_logic_vector(13 downto 0);
     INTDATAWIDTH : in std_ulogic;
     LOOPBACK0 : in std_logic_vector(2 downto 0);
     LOOPBACK1 : in std_logic_vector(2 downto 0);
     PLLLKDETEN : in std_ulogic;
     PLLPOWERDOWN : in std_ulogic;
     PRBSCNTRESET0 : in std_ulogic;
     PRBSCNTRESET1 : in std_ulogic;
     REFCLKPWRDNB : in std_ulogic;
     RXBUFRESET0 : in std_ulogic;
     RXBUFRESET1 : in std_ulogic;
     RXCDRRESET0 : in std_ulogic;
     RXCDRRESET1 : in std_ulogic;
     RXCHBONDI0 : in std_logic_vector(3 downto 0);
     RXCHBONDI1 : in std_logic_vector(3 downto 0);
     RXCOMMADETUSE0 : in std_ulogic;
     RXCOMMADETUSE1 : in std_ulogic;
     RXDATAWIDTH0 : in std_logic_vector(1 downto 0);
     RXDATAWIDTH1 : in std_logic_vector(1 downto 0);
     RXDEC8B10BUSE0 : in std_ulogic;
     RXDEC8B10BUSE1 : in std_ulogic;
     RXENCHANSYNC0 : in std_ulogic;
     RXENCHANSYNC1 : in std_ulogic;
     RXENEQB0 : in std_ulogic;
     RXENEQB1 : in std_ulogic;
     RXENMCOMMAALIGN0 : in std_ulogic;
     RXENMCOMMAALIGN1 : in std_ulogic;
     RXENPCOMMAALIGN0 : in std_ulogic;
     RXENPCOMMAALIGN1 : in std_ulogic;
     RXENPMAPHASEALIGN0 : in std_ulogic;
     RXENPMAPHASEALIGN1 : in std_ulogic;
     RXENPRBSTST0 : in std_logic_vector(1 downto 0);
     RXENPRBSTST1 : in std_logic_vector(1 downto 0);
     RXENSAMPLEALIGN0 : in std_ulogic;
     RXENSAMPLEALIGN1 : in std_ulogic;
     RXEQMIX0 : in std_logic_vector(1 downto 0);
     RXEQMIX1 : in std_logic_vector(1 downto 0);
     RXEQPOLE0 : in std_logic_vector(3 downto 0);
     RXEQPOLE1 : in std_logic_vector(3 downto 0);
     RXGEARBOXSLIP0 : in std_ulogic;
     RXGEARBOXSLIP1 : in std_ulogic;
     RXN0 : in std_ulogic;
     RXN1 : in std_ulogic;
     RXP0 : in std_ulogic;
     RXP1 : in std_ulogic;
     RXPMASETPHASE0 : in std_ulogic;
     RXPMASETPHASE1 : in std_ulogic;
     RXPOLARITY0 : in std_ulogic;
     RXPOLARITY1 : in std_ulogic;
     RXPOWERDOWN0 : in std_logic_vector(1 downto 0);
     RXPOWERDOWN1 : in std_logic_vector(1 downto 0);
     RXRESET0 : in std_ulogic;
     RXRESET1 : in std_ulogic;
     RXSLIDE0 : in std_ulogic;
     RXSLIDE1 : in std_ulogic;
     RXUSRCLK0 : in std_ulogic;
     RXUSRCLK1 : in std_ulogic;
     RXUSRCLK20 : in std_ulogic;
     RXUSRCLK21 : in std_ulogic;
     TXBUFDIFFCTRL0 : in std_logic_vector(2 downto 0);
     TXBUFDIFFCTRL1 : in std_logic_vector(2 downto 0);
     TXBYPASS8B10B0 : in std_logic_vector(3 downto 0);
     TXBYPASS8B10B1 : in std_logic_vector(3 downto 0);
     TXCHARDISPMODE0 : in std_logic_vector(3 downto 0);
     TXCHARDISPMODE1 : in std_logic_vector(3 downto 0);
     TXCHARDISPVAL0 : in std_logic_vector(3 downto 0);
     TXCHARDISPVAL1 : in std_logic_vector(3 downto 0);
     TXCHARISK0 : in std_logic_vector(3 downto 0);
     TXCHARISK1 : in std_logic_vector(3 downto 0);
     TXCOMSTART0 : in std_ulogic;
     TXCOMSTART1 : in std_ulogic;
     TXCOMTYPE0 : in std_ulogic;
     TXCOMTYPE1 : in std_ulogic;
     TXDATA0 : in std_logic_vector(31 downto 0);
     TXDATA1 : in std_logic_vector(31 downto 0);
     TXDATAWIDTH0 : in std_logic_vector(1 downto 0);
     TXDATAWIDTH1 : in std_logic_vector(1 downto 0);
     TXDETECTRX0 : in std_ulogic;
     TXDETECTRX1 : in std_ulogic;
     TXDIFFCTRL0 : in std_logic_vector(2 downto 0);
     TXDIFFCTRL1 : in std_logic_vector(2 downto 0);
     TXELECIDLE0 : in std_ulogic;
     TXELECIDLE1 : in std_ulogic;
     TXENC8B10BUSE0 : in std_ulogic;
     TXENC8B10BUSE1 : in std_ulogic;
     TXENPMAPHASEALIGN0 : in std_ulogic;
     TXENPMAPHASEALIGN1 : in std_ulogic;
     TXENPRBSTST0 : in std_logic_vector(1 downto 0);
     TXENPRBSTST1 : in std_logic_vector(1 downto 0);
     TXHEADER0 : in std_logic_vector(2 downto 0);
     TXHEADER1 : in std_logic_vector(2 downto 0);
     TXINHIBIT0 : in std_ulogic;
     TXINHIBIT1 : in std_ulogic;
     TXPMASETPHASE0 : in std_ulogic;
     TXPMASETPHASE1 : in std_ulogic;
     TXPOLARITY0 : in std_ulogic;
     TXPOLARITY1 : in std_ulogic;
     TXPOWERDOWN0 : in std_logic_vector(1 downto 0);
     TXPOWERDOWN1 : in std_logic_vector(1 downto 0);
     TXPREEMPHASIS0 : in std_logic_vector(3 downto 0);
     TXPREEMPHASIS1 : in std_logic_vector(3 downto 0);
     TXRESET0 : in std_ulogic;
     TXRESET1 : in std_ulogic;
     TXSEQUENCE0 : in std_logic_vector(6 downto 0);
     TXSEQUENCE1 : in std_logic_vector(6 downto 0);
     TXSTARTSEQ0 : in std_ulogic;
     TXSTARTSEQ1 : in std_ulogic;
     TXUSRCLK0 : in std_ulogic;
     TXUSRCLK1 : in std_ulogic;
     TXUSRCLK20 : in std_ulogic;
     TXUSRCLK21 : in std_ulogic
  );
end component;

----- component X_IBUFDS -----
component X_IBUFDS
  generic (
     CAPACITANCE : string := "DONT_CARE";
     DIFF_TERM : boolean := FALSE;
     IBUF_DELAY_VALUE : string := "0";
     IFD_DELAY_VALUE : string := "AUTO";
     IOSTANDARD : string := "DEFAULT";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     Xon : boolean := true;
     tipd_I : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_IB : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_IB_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;

----- component X_IBUFDS_DLY_ADJ -----
component X_IBUFDS_DLY_ADJ
  generic (
     DELAY_OFFSET : string := "OFF";
     DIFF_TERM : boolean := FALSE;
     IOSTANDARD : string := "DEFAULT";
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     SIM_DELAY0 : integer := 0;
     SIM_DELAY1 : integer := 0;
     SIM_DELAY10 : integer := 0;
     SIM_DELAY11 : integer := 0;
     SIM_DELAY12 : integer := 0;
     SIM_DELAY13 : integer := 0;
     SIM_DELAY14 : integer := 0;
     SIM_DELAY15 : integer := 0;
     SIM_DELAY16 : integer := 0;
     SIM_DELAY2 : integer := 0;
     SIM_DELAY3 : integer := 0;
     SIM_DELAY4 : integer := 0;
     SIM_DELAY5 : integer := 0;
     SIM_DELAY6 : integer := 0;
     SIM_DELAY7 : integer := 0;
     SIM_DELAY8 : integer := 0;
     SIM_DELAY9 : integer := 0;
     SIM_TAPDELAY_VALUE : integer := 200;
     SPECTRUM_OFFSET_DELAY : time := 1600 ps;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     tipd_I : VitalDelayType01 := (0 ps, 0 ps);
     tipd_IB : VitalDelayType01 := (0 ps, 0 ps);
     tpd_IB_O : VitalDelayType01 := (0 ps, 0 ps);
     tpd_I_O : VitalDelayType01 := (0 ps, 0 ps)
  );
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic;
     S : in std_logic_vector (2 downto 0)
  );
end component;

----- component X_IBUFDS_GTHE1 -----
component X_IBUFDS_GTHE1
  generic (
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     tipd_I : VitalDelayType01 := (0 ps, 0 ps);
     tipd_IB : VitalDelayType01 := (0 ps, 0 ps);
     tpd_IB_O : VitalDelayType01 := (0 ps, 0 ps);
     tpd_I_O : VitalDelayType01 := (0 ps, 0 ps)
  );
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;

----- component X_IBUFDS_GTXE1 -----
component X_IBUFDS_GTXE1
  generic (
     CLKCM_CFG : boolean := TRUE;
     CLKRCV_TRST : boolean := TRUE;
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     REFCLKOUT_DLY : bit_vector := b"0000000000";
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     ticd_I : VitalDelayType := 0 ps;
     ticd_IB : VitalDelayType := 0 ps;
     tipd_CEB : VitalDelayType01 := (0 ps, 0 ps);
     tipd_I : VitalDelayType01 := (0 ps, 0 ps);
     tipd_IB : VitalDelayType01 := (0 ps, 0 ps);
     tisd_CEB_I : VitalDelayType := 0 ps;
     tpd_CEB_O : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CEB_ODIV2 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_IB_O : VitalDelayType01 := (0 ps, 0 ps);
     tpd_IB_ODIV2 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_I_O : VitalDelayType01 := (0 ps, 0 ps);
     tpd_I_ODIV2 : VitalDelayType01 := (0 ps, 0 ps);
     tperiod_IB_posedge : VitalDelayType := 0 ps;
     tperiod_I_posedge : VitalDelayType := 0 ps
  );
  port (
     O : out std_ulogic;
     ODIV2 : out std_ulogic;
     CEB : in std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;

----- component X_IBUF_DLY_ADJ -----
component X_IBUF_DLY_ADJ
  generic (
     DELAY_OFFSET : string := "OFF";
     IOSTANDARD : string := "DEFAULT";
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     SIM_DELAY0 : integer := 0;
     SIM_DELAY1 : integer := 0;
     SIM_DELAY10 : integer := 0;
     SIM_DELAY11 : integer := 0;
     SIM_DELAY12 : integer := 0;
     SIM_DELAY13 : integer := 0;
     SIM_DELAY14 : integer := 0;
     SIM_DELAY15 : integer := 0;
     SIM_DELAY16 : integer := 0;
     SIM_DELAY2 : integer := 0;
     SIM_DELAY3 : integer := 0;
     SIM_DELAY4 : integer := 0;
     SIM_DELAY5 : integer := 0;
     SIM_DELAY6 : integer := 0;
     SIM_DELAY7 : integer := 0;
     SIM_DELAY8 : integer := 0;
     SIM_DELAY9 : integer := 0;
     SIM_TAPDELAY_VALUE : integer := 200;
     SPECTRUM_OFFSET_DELAY : time := 1600 ps;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     tipd_I : VitalDelayType01 := (0 ps, 0 ps);
     tpd_I_O : VitalDelayType01 := (0 ps, 0 ps)
  );
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     S : in std_logic_vector (2 downto 0)
  );
end component;

----- component X_ICAP_SPARTAN6 -----
component X_ICAP_SPARTAN6
  generic (
     DEVICE_ID : bit_vector := X"02000093";
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := FALSE;
     SIM_CFG_FILE_NAME : string := "NONE";
     TimingChecksOn : boolean := TRUE;
     Xon : boolean := TRUE;
     thold_CE_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CE_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_I_CLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_I_CLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_WRITE_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_WRITE_CLK_posedge_posedge : VitalDelayType := 0 ps;
     ticd_CLK : VitalDelayType := 0 ps;
     tipd_CE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_I : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
     tipd_WRITE : VitalDelayType01 := (0 ps, 0 ps);
     tisd_CE_CLK : VitalDelayType := 0 ps;
     tisd_I_CLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tisd_WRITE_CLK : VitalDelayType := 0 ps;
     tpd_CLK_BUSY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CLK_O : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
     tperiod_CLK_posedge : VitalDelayType := 0 ps;
     tsetup_CE_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CE_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_I_CLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_I_CLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_WRITE_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_WRITE_CLK_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     BUSY : out std_ulogic := '1';
     O : out std_logic_vector(15 downto 0);
     CE : in std_ulogic;
     CLK : in std_ulogic;
     I : in std_logic_vector(15 downto 0);
     WRITE : in std_ulogic
  );
end component;

----- component X_ICAP_VIRTEX6 -----
component X_ICAP_VIRTEX6
  generic (
     DEVICE_ID : bit_vector := X"04244093";
     ICAP_WIDTH : string := "X8";
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := FALSE;
     SIM_CFG_FILE_NAME : string := "NONE";
     TimingChecksOn : boolean := TRUE;
     Xon : boolean := TRUE;
     thold_CSB_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CSB_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_I_CLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     thold_I_CLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     thold_RDWRB_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RDWRB_CLK_posedge_posedge : VitalDelayType := 0 ps;
     ticd_CLK : VitalDelayType := 0 ps;
     tipd_CLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CSB : VitalDelayType01 := (0 ps, 0 ps);
     tipd_I : VitalDelayArrayType01 (31 downto 0) := (others => (0 ps, 0 ps));
     tipd_RDWRB : VitalDelayType01 := (0 ps, 0 ps);
     tisd_CSB_CLK : VitalDelayType := 0 ps;
     tisd_I_CLK : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tisd_RDWRB_CLK : VitalDelayType := 0 ps;
     tpd_CLK_BUSY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CLK_O : VitalDelayArrayType01(31 downto 0) := (others => (0 ps, 0 ps));
     tperiod_CLK_posedge : VitalDelayType := 0 ps;
     tsetup_CSB_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CSB_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_I_CLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tsetup_I_CLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tsetup_RDWRB_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RDWRB_CLK_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     BUSY : out std_ulogic := '1';
     O : out std_logic_vector(31 downto 0);
     CLK : in std_ulogic;
     CSB : in std_ulogic;
     I : in std_logic_vector(31 downto 0);
     RDWRB : in std_ulogic
  );
end component;

----- component X_IDDR -----
component X_IDDR
  generic (
     DDR_CLK_EDGE : string := "OPPOSITE_EDGE";
     INIT_Q1 : bit := '0';
     INIT_Q2 : bit := '0';
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     SRTYPE : string := "SYNC";
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     thold_CE_C_negedge_negedge : VitalDelayType := 0 ps;
     thold_CE_C_negedge_posedge : VitalDelayType := 0 ps;
     thold_CE_C_posedge_negedge : VitalDelayType := 0 ps;
     thold_CE_C_posedge_posedge : VitalDelayType := 0 ps;
     thold_D_C_negedge_negedge : VitalDelayType := 0 ps;
     thold_D_C_negedge_posedge : VitalDelayType := 0 ps;
     thold_D_C_posedge_negedge : VitalDelayType := 0 ps;
     thold_D_C_posedge_posedge : VitalDelayType := 0 ps;
     thold_R_C_negedge_negedge : VitalDelayType := 0 ps;
     thold_R_C_negedge_posedge : VitalDelayType := 0 ps;
     thold_R_C_posedge_negedge : VitalDelayType := 0 ps;
     thold_R_C_posedge_posedge : VitalDelayType := 0 ps;
     thold_S_C_negedge_negedge : VitalDelayType := 0 ps;
     thold_S_C_negedge_posedge : VitalDelayType := 0 ps;
     thold_S_C_posedge_negedge : VitalDelayType := 0 ps;
     thold_S_C_posedge_posedge : VitalDelayType := 0 ps;
     ticd_C : VitalDelayType := 0 ps;
     tipd_C : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_D : VitalDelayType01 := (0 ps, 0 ps);
     tipd_R : VitalDelayType01 := (0 ps, 0 ps);
     tipd_S : VitalDelayType01 := (0 ps, 0 ps);
     tisd_CE_C : VitalDelayType := 0 ps;
     tisd_D_C : VitalDelayType := 0 ps;
     tisd_R_C : VitalDelayType := 0 ps;
     tisd_S_C : VitalDelayType := 0 ps;
     tpd_C_Q1 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_C_Q2 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_R_Q1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_R_Q2 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_S_Q1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_S_Q2 : VitalDelayType01 := (0 ps, 0 ps);
     tperiod_C_posedge : VitalDelayType := 0 ps;
     tpw_C_negedge : VitalDelayType := 0 ps;
     tpw_C_posedge : VitalDelayType := 0 ps;
     tpw_R_posedge : VitalDelayType := 0 ps;
     tpw_S_posedge : VitalDelayType := 0 ps;
     trecovery_R_C_negedge_negedge : VitalDelayType := 0 ps;
     trecovery_R_C_negedge_posedge : VitalDelayType := 0 ps;
     trecovery_R_C_posedge_negedge : VitalDelayType := 0 ps;
     trecovery_R_C_posedge_posedge : VitalDelayType := 0 ps;
     trecovery_S_C_negedge_negedge : VitalDelayType := 0 ps;
     trecovery_S_C_negedge_posedge : VitalDelayType := 0 ps;
     trecovery_S_C_posedge_negedge : VitalDelayType := 0 ps;
     trecovery_S_C_posedge_posedge : VitalDelayType := 0 ps;
     tremoval_R_C_negedge_negedge : VitalDelayType := 0 ps;
     tremoval_R_C_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_R_C_posedge_negedge : VitalDelayType := 0 ps;
     tremoval_R_C_posedge_posedge : VitalDelayType := 0 ps;
     tremoval_S_C_negedge_negedge : VitalDelayType := 0 ps;
     tremoval_S_C_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_S_C_posedge_negedge : VitalDelayType := 0 ps;
     tremoval_S_C_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CE_C_negedge_negedge : VitalDelayType := 0 ps;
     tsetup_CE_C_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CE_C_posedge_negedge : VitalDelayType := 0 ps;
     tsetup_CE_C_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_D_C_negedge_negedge : VitalDelayType := 0 ps;
     tsetup_D_C_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_D_C_posedge_negedge : VitalDelayType := 0 ps;
     tsetup_D_C_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_R_C_negedge_negedge : VitalDelayType := 0 ps;
     tsetup_R_C_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_R_C_posedge_negedge : VitalDelayType := 0 ps;
     tsetup_R_C_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_S_C_negedge_negedge : VitalDelayType := 0 ps;
     tsetup_S_C_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_S_C_posedge_negedge : VitalDelayType := 0 ps;
     tsetup_S_C_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     Q1 : out std_ulogic;
     Q2 : out std_ulogic;
     C : in std_ulogic;
     CE : in std_ulogic;
     D : in std_ulogic;
     R : in std_ulogic := 'L';
     S : in std_ulogic := 'L'
  );
end component;

----- component X_IDDR2 -----
component X_IDDR2
  generic (
     DDR_ALIGNMENT : string := "NONE";
     INIT_Q0 : bit := '0';
     INIT_Q1 : bit := '0';
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     SRTYPE : string := "SYNC";
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     tbpd_R_Q0_C0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tbpd_R_Q1_C1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tbpd_S_Q0_C0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tbpd_S_Q1_C1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     thold_CE_C0_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE_C0_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE_C1_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE_C1_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_D_C0_negedge_posedge : VitalDelayType := 0 ps;
     thold_D_C0_posedge_posedge : VitalDelayType := 0 ps;
     thold_D_C1_negedge_posedge : VitalDelayType := 0 ps;
     thold_D_C1_posedge_posedge : VitalDelayType := 0 ps;
     thold_R_C0_negedge_posedge : VitalDelayType := 0 ps;
     thold_R_C0_posedge_posedge : VitalDelayType := 0 ps;
     thold_R_C1_negedge_posedge : VitalDelayType := 0 ps;
     thold_R_C1_posedge_posedge : VitalDelayType := 0 ps;
     thold_S_C0_negedge_posedge : VitalDelayType := 0 ps;
     thold_S_C0_posedge_posedge : VitalDelayType := 0 ps;
     thold_S_C1_negedge_posedge : VitalDelayType := 0 ps;
     thold_S_C1_posedge_posedge : VitalDelayType := 0 ps;
     ticd_C0 : VitalDelayType := 0.0 ps;
     ticd_C1 : VitalDelayType := 0.0 ps;
     tipd_C0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_C1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_D : VitalDelayType01 := (0 ps, 0 ps);
     tipd_R : VitalDelayType01 := (0 ps, 0 ps);
     tipd_S : VitalDelayType01 := (0 ps, 0 ps);
     tisd_CE_C0 : VitalDelayType := 0.0 ps;
     tisd_CE_C1 : VitalDelayType := 0.0 ps;
     tisd_D_C0 : VitalDelayType := 0.0 ps;
     tisd_D_C1 : VitalDelayType := 0.0 ps;
     tisd_R_C0 : VitalDelayType := 0.0 ps;
     tisd_R_C1 : VitalDelayType := 0.0 ps;
     tisd_S_C0 : VitalDelayType := 0.0 ps;
     tisd_S_C1 : VitalDelayType := 0.0 ps;
     tpd_C0_Q0 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_C0_Q1 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_C1_Q0 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_C1_Q1 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_R_Q0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_R_Q1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_S_Q0 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_S_Q1 : VitalDelayType01 := (0 ps, 0 ps);
     tperiod_C0_posedge : VitalDelayType := 0 ps;
     tperiod_C1_posedge : VitalDelayType := 0 ps;
     tpw_C0_negedge : VitalDelayType := 0 ps;
     tpw_C0_posedge : VitalDelayType := 0 ps;
     tpw_C1_negedge : VitalDelayType := 0 ps;
     tpw_C1_posedge : VitalDelayType := 0 ps;
     tpw_R_posedge : VitalDelayType := 0 ps;
     tpw_S_posedge : VitalDelayType := 0 ps;
     trecovery_R_C0_negedge_posedge : VitalDelayType := 0 ps;
     trecovery_R_C1_negedge_posedge : VitalDelayType := 0 ps;
     trecovery_S_C0_negedge_posedge : VitalDelayType := 0 ps;
     trecovery_S_C1_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_R_C0_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_R_C1_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_S_C0_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_S_C1_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CE_C0_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE_C0_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE_C1_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE_C1_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D_C0_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_D_C0_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_D_C1_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_D_C1_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_R_C0_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_R_C0_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_R_C1_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_R_C1_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_S_C0_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_S_C0_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_S_C1_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_S_C1_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     Q0 : out std_ulogic;
     Q1 : out std_ulogic;
     C0 : in std_ulogic;
     C1 : in std_ulogic;
     CE : in std_ulogic := 'H';
     D : in std_ulogic;
     R : in std_ulogic := 'L';
     S : in std_ulogic := 'L'
  );
end component;

----- component X_IDDR_2CLK -----
component X_IDDR_2CLK
  generic (
     DDR_CLK_EDGE : string := "OPPOSITE_EDGE";
     INIT_Q1 : bit := '0';
     INIT_Q2 : bit := '0';
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     SRTYPE : string := "SYNC";
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     tbpd_R_Q1_C : VitalDelayType01 := (0 ps, 0 ps);
     tbpd_R_Q1_CB : VitalDelayType01 := (0 ps, 0 ps);
     tbpd_R_Q2_C : VitalDelayType01 := (0 ps, 0 ps);
     tbpd_R_Q2_CB : VitalDelayType01 := (0 ps, 0 ps);
     tbpd_S_Q1_C : VitalDelayType01 := (0 ps, 0 ps);
     tbpd_S_Q1_CB : VitalDelayType01 := (0 ps, 0 ps);
     tbpd_S_Q2_C : VitalDelayType01 := (0 ps, 0 ps);
     tbpd_S_Q2_CB : VitalDelayType01 := (0 ps, 0 ps);
     thold_CE_CB_negedge_negedge : VitalDelayType := 0 ps;
     thold_CE_CB_negedge_posedge : VitalDelayType := 0 ps;
     thold_CE_CB_posedge_negedge : VitalDelayType := 0 ps;
     thold_CE_CB_posedge_posedge : VitalDelayType := 0 ps;
     thold_CE_C_negedge_negedge : VitalDelayType := 0 ps;
     thold_CE_C_negedge_posedge : VitalDelayType := 0 ps;
     thold_CE_C_posedge_negedge : VitalDelayType := 0 ps;
     thold_CE_C_posedge_posedge : VitalDelayType := 0 ps;
     thold_D_CB_negedge_negedge : VitalDelayType := 0 ps;
     thold_D_CB_negedge_posedge : VitalDelayType := 0 ps;
     thold_D_CB_posedge_negedge : VitalDelayType := 0 ps;
     thold_D_CB_posedge_posedge : VitalDelayType := 0 ps;
     thold_D_C_negedge_negedge : VitalDelayType := 0 ps;
     thold_D_C_negedge_posedge : VitalDelayType := 0 ps;
     thold_D_C_posedge_negedge : VitalDelayType := 0 ps;
     thold_D_C_posedge_posedge : VitalDelayType := 0 ps;
     thold_R_CB_negedge_negedge : VitalDelayType := 0 ps;
     thold_R_CB_negedge_posedge : VitalDelayType := 0 ps;
     thold_R_CB_posedge_negedge : VitalDelayType := 0 ps;
     thold_R_CB_posedge_posedge : VitalDelayType := 0 ps;
     thold_R_C_negedge_negedge : VitalDelayType := 0 ps;
     thold_R_C_negedge_posedge : VitalDelayType := 0 ps;
     thold_R_C_posedge_negedge : VitalDelayType := 0 ps;
     thold_R_C_posedge_posedge : VitalDelayType := 0 ps;
     thold_S_CB_negedge_negedge : VitalDelayType := 0 ps;
     thold_S_CB_negedge_posedge : VitalDelayType := 0 ps;
     thold_S_CB_posedge_negedge : VitalDelayType := 0 ps;
     thold_S_CB_posedge_posedge : VitalDelayType := 0 ps;
     thold_S_C_negedge_negedge : VitalDelayType := 0 ps;
     thold_S_C_negedge_posedge : VitalDelayType := 0 ps;
     thold_S_C_posedge_negedge : VitalDelayType := 0 ps;
     thold_S_C_posedge_posedge : VitalDelayType := 0 ps;
     ticd_C : VitalDelayType := 0 ps;
     ticd_CB : VitalDelayType := 0 ps;
     tipd_C : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CB : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_D : VitalDelayType01 := (0 ps, 0 ps);
     tipd_R : VitalDelayType01 := (0 ps, 0 ps);
     tipd_S : VitalDelayType01 := (0 ps, 0 ps);
     tisd_CE_C : VitalDelayType := 0 ps;
     tisd_CE_CB : VitalDelayType := 0 ps;
     tisd_D_C : VitalDelayType := 0 ps;
     tisd_D_CB : VitalDelayType := 0 ps;
     tisd_R_C : VitalDelayType := 0 ps;
     tisd_R_CB : VitalDelayType := 0 ps;
     tisd_S_C : VitalDelayType := 0 ps;
     tisd_S_CB : VitalDelayType := 0 ps;
     tpd_CB_Q1 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CB_Q2 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_C_Q1 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_C_Q2 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_R_Q1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_R_Q2 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_S_Q1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_S_Q2 : VitalDelayType01 := (0 ps, 0 ps);
     tperiod_CB_posedge : VitalDelayType := 0 ps;
     tperiod_C_posedge : VitalDelayType := 0 ps;
     tpw_CB_negedge : VitalDelayType := 0 ps;
     tpw_CB_posedge : VitalDelayType := 0 ps;
     tpw_C_negedge : VitalDelayType := 0 ps;
     tpw_C_posedge : VitalDelayType := 0 ps;
     tpw_R_posedge : VitalDelayType := 0 ps;
     tpw_S_posedge : VitalDelayType := 0 ps;
     trecovery_R_CB_negedge_negedge : VitalDelayType := 0 ps;
     trecovery_R_CB_negedge_posedge : VitalDelayType := 0 ps;
     trecovery_R_CB_posedge_negedge : VitalDelayType := 0 ps;
     trecovery_R_CB_posedge_posedge : VitalDelayType := 0 ps;
     trecovery_R_C_negedge_negedge : VitalDelayType := 0 ps;
     trecovery_R_C_negedge_posedge : VitalDelayType := 0 ps;
     trecovery_R_C_posedge_negedge : VitalDelayType := 0 ps;
     trecovery_R_C_posedge_posedge : VitalDelayType := 0 ps;
     trecovery_S_CB_negedge_negedge : VitalDelayType := 0 ps;
     trecovery_S_CB_negedge_posedge : VitalDelayType := 0 ps;
     trecovery_S_CB_posedge_negedge : VitalDelayType := 0 ps;
     trecovery_S_CB_posedge_posedge : VitalDelayType := 0 ps;
     trecovery_S_C_negedge_negedge : VitalDelayType := 0 ps;
     trecovery_S_C_negedge_posedge : VitalDelayType := 0 ps;
     trecovery_S_C_posedge_negedge : VitalDelayType := 0 ps;
     trecovery_S_C_posedge_posedge : VitalDelayType := 0 ps;
     tremoval_R_CB_negedge_negedge : VitalDelayType := 0 ps;
     tremoval_R_CB_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_R_CB_posedge_negedge : VitalDelayType := 0 ps;
     tremoval_R_CB_posedge_posedge : VitalDelayType := 0 ps;
     tremoval_R_C_negedge_negedge : VitalDelayType := 0 ps;
     tremoval_R_C_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_R_C_posedge_negedge : VitalDelayType := 0 ps;
     tremoval_R_C_posedge_posedge : VitalDelayType := 0 ps;
     tremoval_S_CB_negedge_negedge : VitalDelayType := 0 ps;
     tremoval_S_CB_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_S_CB_posedge_negedge : VitalDelayType := 0 ps;
     tremoval_S_CB_posedge_posedge : VitalDelayType := 0 ps;
     tremoval_S_C_negedge_negedge : VitalDelayType := 0 ps;
     tremoval_S_C_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_S_C_posedge_negedge : VitalDelayType := 0 ps;
     tremoval_S_C_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CE_CB_negedge_negedge : VitalDelayType := 0 ps;
     tsetup_CE_CB_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CE_CB_posedge_negedge : VitalDelayType := 0 ps;
     tsetup_CE_CB_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CE_C_negedge_negedge : VitalDelayType := 0 ps;
     tsetup_CE_C_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CE_C_posedge_negedge : VitalDelayType := 0 ps;
     tsetup_CE_C_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_D_CB_negedge_negedge : VitalDelayType := 0 ps;
     tsetup_D_CB_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_D_CB_posedge_negedge : VitalDelayType := 0 ps;
     tsetup_D_CB_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_D_C_negedge_negedge : VitalDelayType := 0 ps;
     tsetup_D_C_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_D_C_posedge_negedge : VitalDelayType := 0 ps;
     tsetup_D_C_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_R_CB_negedge_negedge : VitalDelayType := 0 ps;
     tsetup_R_CB_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_R_CB_posedge_negedge : VitalDelayType := 0 ps;
     tsetup_R_CB_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_R_C_negedge_negedge : VitalDelayType := 0 ps;
     tsetup_R_C_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_R_C_posedge_negedge : VitalDelayType := 0 ps;
     tsetup_R_C_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_S_CB_negedge_negedge : VitalDelayType := 0 ps;
     tsetup_S_CB_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_S_CB_posedge_negedge : VitalDelayType := 0 ps;
     tsetup_S_CB_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_S_C_negedge_negedge : VitalDelayType := 0 ps;
     tsetup_S_C_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_S_C_posedge_negedge : VitalDelayType := 0 ps;
     tsetup_S_C_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     Q1 : out std_ulogic;
     Q2 : out std_ulogic;
     C : in std_ulogic;
     CB : in std_ulogic;
     CE : in std_ulogic;
     D : in std_ulogic;
     R : in std_ulogic;
     S : in std_ulogic
  );
end component;

----- component X_IDELAY -----
component X_IDELAY
  generic (
     IOBDELAY_TYPE : string := "DEFAULT";
     IOBDELAY_VALUE : integer := 0;
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     SIM_DELAY_D : integer := 0;
     SIM_TAPDELAY_VALUE : integer := 75;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     thold_CE_C_negedge_posedge : VitalDelayType := 0 ps;
     thold_CE_C_posedge_posedge : VitalDelayType := 0 ps;
     thold_INC_C_negedge_posedge : VitalDelayType := 0 ps;
     thold_INC_C_posedge_posedge : VitalDelayType := 0 ps;
     thold_I_C_negedge_posedge : VitalDelayType := 0 ps;
     thold_I_C_posedge_posedge : VitalDelayType := 0 ps;
     thold_RST_C_negedge_posedge : VitalDelayType := 0 ps;
     thold_RST_C_posedge_posedge : VitalDelayType := 0 ps;
     ticd_C : VitalDelayType := 0.0 ps;
     tipd_C : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_I : VitalDelayType01 := (0 ps, 0 ps);
     tipd_INC : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RST : VitalDelayType01 := (0 ps, 0 ps);
     tpd_C_O : VitalDelayType01 := (100 ps, 100 ps);
     tpd_I_O : VitalDelayType01 := (100 ps, 100 ps);
     tperiod_C_posedge : VitalDelayType := 0 ps;
     tpw_C_posedge : VitalDelayType := 0 ps;
     tsetup_CE_C_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CE_C_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_INC_C_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_INC_C_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_I_C_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_I_C_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RST_C_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RST_C_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     O : out std_ulogic;
     C : in std_ulogic;
     CE : in std_ulogic;
     I : in std_ulogic;
     INC : in std_ulogic;
     RST : in std_ulogic
  );
end component;

----- component X_IDELAYCTRL -----
component X_IDELAYCTRL
  generic (
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     thold_RST_REFCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RST_REFCLK_posedge_posedge : VitalDelayType := 0 ps;
     ticd_REFCLK : VitalDelayType := 0.0 ps;
     tipd_REFCLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RST : VitalDelayType01 := (0 ps, 0 ps);
     tisd_RST_REFCLK : VitalDelayType := 0.0 ps;
     tpd_REFCLK_RDY : VitalDelayType01 := (100 ps, 100 ps);
     tpd_RST_RDY : VitalDelayType01 := (0 ps, 0 ps);
     tperiod_REFCLK_posedge : VitalDelayType := 0 ps;
     tpw_REFCLK_posedge : VitalDelayType := 0 ps;
     tsetup_RST_REFCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RST_REFCLK_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     RDY : out std_ulogic;
     REFCLK : in std_ulogic;
     RST : in std_ulogic
  );
end component;

----- component X_INV -----
component X_INV
  generic (
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     PATHPULSE : time := 0 ps;
     Xon : boolean := true;
     tipd_I : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;

----- component X_IODELAY -----
component X_IODELAY
  generic (
     DELAY_SRC : string := "I";
     D_IODELAY_OFFSET : real := 0.0;
     HIGH_PERFORMANCE_MODE : boolean := true;
     IDELAY_TYPE : string := "DEFAULT";
     IDELAY_VALUE : integer := 0;
     ILEAK_ADJUST : real := 1.0;
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     ODELAY_VALUE : integer := 0;
     REFCLK_FREQUENCY : real := 200.0;
     SIGNAL_PATTERN : string := "DATA";
     SIM_DELAY_D : integer := 0;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     thold_CE_C_negedge_posedge : VitalDelayType := 0 ps;
     thold_CE_C_posedge_posedge : VitalDelayType := 0 ps;
     thold_DATAIN_C_negedge_posedge : VitalDelayType := 0 ps;
     thold_DATAIN_C_posedge_posedge : VitalDelayType := 0 ps;
     thold_IDATAIN_C_negedge_posedge : VitalDelayType := 0 ps;
     thold_IDATAIN_C_posedge_posedge : VitalDelayType := 0 ps;
     thold_INC_C_negedge_posedge : VitalDelayType := 0 ps;
     thold_INC_C_posedge_posedge : VitalDelayType := 0 ps;
     thold_RST_C_negedge_posedge : VitalDelayType := 0 ps;
     thold_RST_C_posedge_posedge : VitalDelayType := 0 ps;
     ticd_C : VitalDelayType := 0.0 ps;
     tipd_C : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DATAIN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_IDATAIN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_INC : VitalDelayType01 := (0 ps, 0 ps);
     tipd_ODATAIN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RST : VitalDelayType01 := (0 ps, 0 ps);
     tipd_T : VitalDelayType01 := (0 ps, 0 ps);
     tisd_CE_C : VitalDelayType := 0.0 ps;
     tisd_INC_C : VitalDelayType := 0.0 ps;
     tisd_RST_C : VitalDelayType := 0.0 ps;
     tpd_C_DATAOUT : VitalDelayType01 := (100 ps, 100 ps);
     tpd_DATAIN_DATAOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_IDATAIN_DATAOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_ODATAIN_DATAOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_T_DATAOUT : VitalDelayType01 := (0 ps, 0 ps);
     tperiod_C_posedge : VitalDelayType := 0 ps;
     tpw_C_posedge : VitalDelayType := 0 ps;
     tsetup_CE_C_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CE_C_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_DATAIN_C_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_DATAIN_C_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_IDATAIN_C_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_IDATAIN_C_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_INC_C_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_INC_C_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RST_C_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RST_C_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     DATAOUT : out std_ulogic;
     C : in std_ulogic;
     CE : in std_ulogic;
     DATAIN : in std_ulogic;
     IDATAIN : in std_ulogic;
     INC : in std_ulogic;
     ODATAIN : in std_ulogic;
     RST : in std_ulogic;
     T : in std_ulogic
  );
end component;

----- component X_IODELAY2 -----
component X_IODELAY2
  generic (
     COUNTER_WRAPAROUND : string := "WRAPAROUND";
     DATA_RATE : string := "SDR";
     DELAY_SRC : string := "IO";
     IDELAY2_VALUE : integer := 0;
     IDELAY_MODE : string := "NORMAL";
     IDELAY_TYPE : string := "DEFAULT";
     IDELAY_VALUE : integer := 0;
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := FALSE;
     ODELAY_VALUE : integer := 0;
     SERDES_MODE : string := "NONE";
     SIM_IDATAIN_INDELAY : integer := 110;
     SIM_ODATAIN_INDELAY : integer := 110;
     SIM_TAPDELAY_VALUE : integer := 75;
     TimingChecksOn : boolean := TRUE;
     Xon : boolean := TRUE;
     thold_CAL_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CAL_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CE_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CE_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_INC_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_INC_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RST_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RST_CLK_posedge_posedge : VitalDelayType := 0 ps;
     ticd_CLK : VitalDelayType := 0 ps;
     ticd_IDATAIN : VitalDelayType := 0 ps;
     ticd_ODATAIN : VitalDelayType := 0 ps;
     ticd_T : VitalDelayType := 0 ps;
     tipd_CAL : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_IDATAIN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_INC : VitalDelayType01 := (0 ps, 0 ps);
     tipd_IOCLK0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_IOCLK1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_ODATAIN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RST : VitalDelayType01 := (0 ps, 0 ps);
     tipd_T : VitalDelayType01 := (0 ps, 0 ps);
     tisd_CAL_CLK : VitalDelayType := 0 ps;
     tisd_CE_CLK : VitalDelayType := 0 ps;
     tisd_INC_CLK : VitalDelayType := 0 ps;
     tisd_RST_CLK : VitalDelayType := 0 ps;
     tpd_CLK_BUSY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_T_TOUT : VitalDelayType01 := (0 ps, 0 ps);
     tsetup_CAL_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CAL_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CE_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CE_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_INC_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_INC_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RST_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RST_CLK_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     BUSY : out std_ulogic;
     DATAOUT : out std_ulogic;
     DATAOUT2 : out std_ulogic;
     DOUT : out std_ulogic;
     TOUT : out std_ulogic;
     CAL : in std_ulogic;
     CE : in std_ulogic;
     CLK : in std_ulogic;
     IDATAIN : in std_ulogic;
     INC : in std_ulogic;
     IOCLK0 : in std_ulogic;
     IOCLK1 : in std_ulogic;
     ODATAIN : in std_ulogic;
     RST : in std_ulogic;
     T : in std_ulogic
  );
end component;

----- component X_IODELAYE1 -----
component X_IODELAYE1
  generic (
     CINVCTRL_SEL : boolean := FALSE;
     DELAY_SRC : string := "I";
     D_IODELAY_OFFSET : real := 0.0;
     HIGH_PERFORMANCE_MODE : boolean := FALSE;
     IDELAY_TYPE : string := "DEFAULT";
     IDELAY_VALUE : integer := 0;
     ILEAK_ADJUST : real := 1.0;
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     ODELAY_TYPE : string := "FIXED";
     ODELAY_VALUE : integer := 0;
     REFCLK_FREQUENCY : real := 200.0;
     SIGNAL_PATTERN : string := "DATA";
     SIM_DELAY_D : integer := 0;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     thold_CE_C_negedge_posedge : VitalDelayType := 0 ps;
     thold_CE_C_posedge_posedge : VitalDelayType := 0 ps;
     thold_CNTVALUEIN_C_negedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     thold_CNTVALUEIN_C_posedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     thold_DATAIN_C_negedge_posedge : VitalDelayType := 0 ps;
     thold_DATAIN_C_posedge_posedge : VitalDelayType := 0 ps;
     thold_IDATAIN_C_negedge_posedge : VitalDelayType := 0 ps;
     thold_IDATAIN_C_posedge_posedge : VitalDelayType := 0 ps;
     thold_INC_C_negedge_posedge : VitalDelayType := 0 ps;
     thold_INC_C_posedge_posedge : VitalDelayType := 0 ps;
     thold_RST_C_negedge_posedge : VitalDelayType := 0 ps;
     thold_RST_C_posedge_posedge : VitalDelayType := 0 ps;
     ticd_C : VitalDelayType := 0.0 ps;
     ticd_CLKIN : VitalDelayType := 0.0 ps;
     tipd_C : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CINVCTRL : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLKIN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CNTVALUEIN : VitalDelayArrayType01 (4 downto 0) := (others => (0 ps, 0 ps));
     tipd_DATAIN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_IDATAIN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_INC : VitalDelayType01 := (0 ps, 0 ps);
     tipd_ODATAIN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RST : VitalDelayType01 := (0 ps, 0 ps);
     tipd_T : VitalDelayType01 := (0 ps, 0 ps);
     tisd_CE_C : VitalDelayType := 0.0 ps;
     tisd_CINVCTRL_C : VitalDelayType := 0.0 ps;
     tisd_CNTVALUEIN_C : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tisd_INC_C : VitalDelayType := 0.0 ps;
     tisd_RST_C : VitalDelayType := 0.0 ps;
     tpd_CINVCTRL_CNTVALUEOUT : VitalDelayArrayType01(4 downto 0) := (others => (0 ps, 0 ps));
     tpd_CINVCTRL_DATAOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CLKIN_DATAOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_C_CNTVALUEOUT : VitalDelayArrayType01(4 downto 0) := (others => (0 ps, 0 ps));
     tpd_C_DATAOUT : VitalDelayType01 := (100 ps, 100 ps);
     tpd_DATAIN_DATAOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_IDATAIN_DATAOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_ODATAIN_DATAOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_T_CNTVALUEOUT : VitalDelayArrayType01(4 downto 0) := (others => (0 ps, 0 ps));
     tpd_T_DATAOUT : VitalDelayType01 := (0 ps, 0 ps);
     tperiod_C_posedge : VitalDelayType := 0 ps;
     tpw_C_posedge : VitalDelayType := 0 ps;
     tsetup_CE_C_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CE_C_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CNTVALUEIN_C_negedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tsetup_CNTVALUEIN_C_posedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tsetup_DATAIN_C_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_DATAIN_C_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_IDATAIN_C_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_IDATAIN_C_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_INC_C_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_INC_C_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RST_C_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RST_C_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     CNTVALUEOUT : out std_logic_vector(4 downto 0);
     DATAOUT : out std_ulogic;
     C : in std_ulogic;
     CE : in std_ulogic;
     CINVCTRL : in std_ulogic;
     CLKIN : in std_ulogic;
     CNTVALUEIN : in std_logic_vector(4 downto 0);
     DATAIN : in std_ulogic;
     IDATAIN : in std_ulogic;
     INC : in std_ulogic;
     ODATAIN : in std_ulogic;
     RST : in std_ulogic;
     T : in std_ulogic
  );
end component;

----- component X_IODRP2 -----
component X_IODRP2
  generic (
     DATA_RATE : string := "SDR";
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := FALSE;
     SIM_TAPDELAY_VALUE : integer := 75;
     TimingChecksOn : boolean := TRUE;
     Xon : boolean := TRUE;
     thold_ADD_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_ADD_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_BKST_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_BKST_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CS_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CS_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_SDI_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_SDI_CLK_posedge_posedge : VitalDelayType := 0 ps;
     ticd_CLK : VitalDelayType := 0 ps;
     ticd_IDATAIN : VitalDelayType := 0 ps;
     ticd_ODATAIN : VitalDelayType := 0 ps;
     ticd_T : VitalDelayType := 0 ps;
     tipd_ADD : VitalDelayType01 := (0 ps, 0 ps);
     tipd_BKST : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CS : VitalDelayType01 := (0 ps, 0 ps);
     tipd_IDATAIN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_IOCLK0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_IOCLK1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_ODATAIN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_SDI : VitalDelayType01 := (0 ps, 0 ps);
     tipd_T : VitalDelayType01 := (0 ps, 0 ps);
     tisd_ADD_CLK : VitalDelayType := 0 ps;
     tisd_BKST_CLK : VitalDelayType := 0 ps;
     tisd_CS_CLK : VitalDelayType := 0 ps;
     tisd_SDI_CLK : VitalDelayType := 0 ps;
     tpd_CLK_SDO : VitalDelayType01 := (0 ps, 0 ps);
     tpd_IDATAIN_DATAOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_IDATAIN_DATAOUT2 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_ODATAIN_DOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_T_TOUT : VitalDelayType01 := (0 ps, 0 ps);
     tsetup_ADD_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_ADD_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_BKST_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_BKST_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CS_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CS_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_SDI_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_SDI_CLK_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     DATAOUT : out std_ulogic;
     DATAOUT2 : out std_ulogic;
     DOUT : out std_ulogic;
     SDO : out std_ulogic;
     TOUT : out std_ulogic;
     ADD : in std_ulogic;
     BKST : in std_ulogic;
     CLK : in std_ulogic;
     CS : in std_ulogic;
     IDATAIN : in std_ulogic;
     IOCLK0 : in std_ulogic;
     IOCLK1 : in std_ulogic;
     ODATAIN : in std_ulogic;
     SDI : in std_ulogic;
     T : in std_ulogic
  );
end component;

----- component X_IODRP2_MCB -----
component X_IODRP2_MCB
  generic (
     DATA_RATE : string := "SDR";
     IDELAY_VALUE : integer := 0;
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MCB_ADDRESS : integer := 0;
     MsgOn : boolean := FALSE;
     ODELAY_VALUE : integer := 0;
     SERDES_MODE : string := "NONE";
     SIM_TAPDELAY_VALUE : integer := 75;
     TimingChecksOn : boolean := TRUE;
     Xon : boolean := TRUE;
     thold_ADD_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_ADD_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_BKST_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_BKST_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CS_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CS_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_SDI_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_SDI_CLK_posedge_posedge : VitalDelayType := 0 ps;
     ticd_CLK : VitalDelayType := 0 ps;
     ticd_IDATAIN : VitalDelayType := 0 ps;
     ticd_ODATAIN : VitalDelayType := 0 ps;
     ticd_T : VitalDelayType := 0 ps;
     tipd_ADD : VitalDelayType01 := (0 ps, 0 ps);
     tipd_AUXADDR : VitalDelayArrayType01 (4 downto 0) := (others => (0 ps, 0 ps));
     tipd_AUXSDOIN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_BKST : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CS : VitalDelayType01 := (0 ps, 0 ps);
     tipd_IDATAIN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_IOCLK0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_IOCLK1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_MEMUPDATE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_ODATAIN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_SDI : VitalDelayType01 := (0 ps, 0 ps);
     tipd_T : VitalDelayType01 := (0 ps, 0 ps);
     tisd_ADD_CLK : VitalDelayType := 0 ps;
     tisd_BKST_CLK : VitalDelayType := 0 ps;
     tisd_CS_CLK : VitalDelayType := 0 ps;
     tisd_SDI_CLK : VitalDelayType := 0 ps;
     tpd_CLK_SDO : VitalDelayType01 := (0 ps, 0 ps);
     tpd_IDATAIN_DATAOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_IDATAIN_DATAOUT2 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_ODATAIN_DOUT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_T_TOUT : VitalDelayType01 := (0 ps, 0 ps);
     tsetup_ADD_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_ADD_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_BKST_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_BKST_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CS_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CS_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_SDI_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_SDI_CLK_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     AUXSDO : out std_ulogic;
     DATAOUT : out std_ulogic;
     DATAOUT2 : out std_ulogic;
     DOUT : out std_ulogic;
     DQSOUTN : out std_ulogic;
     DQSOUTP : out std_ulogic;
     SDO : out std_ulogic;
     TOUT : out std_ulogic;
     ADD : in std_ulogic;
     AUXADDR : in std_logic_vector(4 downto 0);
     AUXSDOIN : in std_ulogic;
     BKST : in std_ulogic;
     CLK : in std_ulogic;
     CS : in std_ulogic;
     IDATAIN : in std_ulogic;
     IOCLK0 : in std_ulogic;
     IOCLK1 : in std_ulogic;
     MEMUPDATE : in std_ulogic;
     ODATAIN : in std_ulogic;
     SDI : in std_ulogic;
     T : in std_ulogic
  );
end component;

----- component X_IPAD -----
component X_IPAD
  generic (
     LOC : string := "UNPLACED"
  );
  port (
     PAD : in std_ulogic
  );
end component;

----- component X_ISERDES -----
component X_ISERDES
  generic (
     BITSLIP_ENABLE : boolean := false;
     DATA_RATE : string := "DDR";
     DATA_WIDTH : integer := 4;
     INIT_Q1 : bit := '0';
     INIT_Q2 : bit := '0';
     INIT_Q3 : bit := '0';
     INIT_Q4 : bit := '0';
     INTERFACE_TYPE : string := "MEMORY";
     IOBDELAY : string := "NONE";
     IOBDELAY_TYPE : string := "DEFAULT";
     IOBDELAY_VALUE : integer := 0;
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     NUM_CE : integer := 2;
     SERDES_MODE : string := "MASTER";
     SIM_DELAY_D : integer := 0;
     SIM_HOLD_D_CLK : integer := 0;
     SIM_SETUP_D_CLK : integer := 0;
     SRVAL_Q1 : bit := '0';
     SRVAL_Q2 : bit := '0';
     SRVAL_Q3 : bit := '0';
     SRVAL_Q4 : bit := '0';
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     thold_BITSLIP_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_BITSLIP_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE1_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE1_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE1_CLK_negedge_negedge : VitalDelayType := 0.0 ps;
     thold_CE1_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE1_CLK_posedge_negedge : VitalDelayType := 0.0 ps;
     thold_CE1_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE2_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE2_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_DLYCE_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_DLYCE_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_DLYINC_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_DLYINC_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_DLYRST_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_DLYRST_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_D_CLK_negedge_negedge : VitalDelayType := 0.0 ps;
     thold_D_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_D_CLK_posedge_negedge : VitalDelayType := 0.0 ps;
     thold_D_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_REV_CLKDIV_negedge_negedge : VitalDelayType := 0.0 ps;
     thold_REV_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_REV_CLKDIV_posedge_negedge : VitalDelayType := 0.0 ps;
     thold_REV_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_SR_CLKDIV_negedge_negedge : VitalDelayType := 0.0 ps;
     thold_SR_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_SR_CLKDIV_posedge_negedge : VitalDelayType := 0.0 ps;
     thold_SR_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     ticd_CLK : VitalDelayType := 0.0 ps;
     ticd_CLKDIV : VitalDelayType := 0.0 ps;
     ticd_OCLK : VitalDelayType := 0.0 ps;
     tipd_BITSLIP : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CE1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CE2 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLKDIV : VitalDelayType01 := (0 ps, 0 ps);
     tipd_D : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DLYCE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DLYINC : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DLYRST : VitalDelayType01 := (0 ps, 0 ps);
     tipd_OCLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_REV : VitalDelayType01 := (0 ps, 0 ps);
     tipd_SHIFTIN1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_SHIFTIN2 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_SR : VitalDelayType01 := (0 ps, 0 ps);
     tisd_BITSLIP_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_CE1_CLK : VitalDelayType := 0.0 ps;
     tisd_CE1_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_CE2_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_DLYCE_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_DLYINC_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_DLYRST_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_D_CLK : VitalDelayType := 0.0 ps;
     tisd_REV_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_SHIFTIN1_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_SHIFTIN2_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_SR_CLKDIV : VitalDelayType := 0.0 ps;
     tpd_CLKDIV_Q1 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKDIV_Q2 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKDIV_Q3 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKDIV_Q4 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKDIV_Q5 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKDIV_Q6 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_D_O : VitalDelayType01 := (0 ps, 0 ps);
     tpd_SR_Q1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_SR_Q2 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_SR_Q3 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_SR_Q4 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_SR_Q5 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_SR_Q6 : VitalDelayType01 := (0 ps, 0 ps);
     tperiod_CLK_posedge : VitalDelayType := 0 ps;
     tpw_CLK_posedge : VitalDelayType := 0 ps;
     tpw_REV_posedge : VitalDelayType := 0 ps;
     tpw_SR_posedge : VitalDelayType := 0 ps;
     trecovery_REV_CLK_negedge_posedge : VitalDelayType := 0 ps;
     trecovery_SR_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_REV_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_SR_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_BITSLIP_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_BITSLIP_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE1_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE1_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE1_CLK_negedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_CE1_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE1_CLK_posedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_CE1_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE2_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE2_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_DLYCE_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_DLYCE_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_DLYINC_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_DLYINC_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_DLYRST_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_DLYRST_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D_CLK_negedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_D_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D_CLK_posedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_D_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_REV_CLKDIV_negedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_REV_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_REV_CLKDIV_posedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_REV_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_SR_CLKDIV_negedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_SR_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_SR_CLKDIV_posedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_SR_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps
  );
  port (
     O : out std_ulogic;
     Q1 : out std_ulogic;
     Q2 : out std_ulogic;
     Q3 : out std_ulogic;
     Q4 : out std_ulogic;
     Q5 : out std_ulogic;
     Q6 : out std_ulogic;
     SHIFTOUT1 : out std_ulogic;
     SHIFTOUT2 : out std_ulogic;
     BITSLIP : in std_ulogic;
     CE1 : in std_ulogic;
     CE2 : in std_ulogic;
     CLK : in std_ulogic;
     CLKDIV : in std_ulogic;
     D : in std_ulogic;
     DLYCE : in std_ulogic;
     DLYINC : in std_ulogic;
     DLYRST : in std_ulogic;
     OCLK : in std_ulogic;
     REV : in std_ulogic;
     SHIFTIN1 : in std_ulogic;
     SHIFTIN2 : in std_ulogic;
     SR : in std_ulogic
  );
end component;

----- component X_ISERDES2 -----
component X_ISERDES2
  generic (
     BITSLIP_ENABLE : boolean := FALSE;
     DATA_RATE : string := "SDR";
     DATA_WIDTH : integer := 1;
     INTERFACE_TYPE : string := "NETWORKING";
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := FALSE;
     SERDES_MODE : string := "NONE";
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     tbpd_D_DFB_CLK0 : VitalDelayType01 := (100 ps, 100 ps);
     tbpd_D_DFB_CLK1 : VitalDelayType01 := (100 ps, 100 ps);
     tbpd_D_FABRICOUT_CLK0 : VitalDelayType01 := (100 ps, 100 ps);
     tbpd_D_FABRICOUT_CLK1 : VitalDelayType01 := (100 ps, 100 ps);
     thold_BITSLIP_CLKDIV_negedge_posedge : VitalDelayType := 0 ps;
     thold_BITSLIP_CLKDIV_posedge_posedge : VitalDelayType := 0 ps;
     thold_CE0_CLK0_negedge_posedge : VitalDelayType := 0 ps;
     thold_CE0_CLK0_posedge_posedge : VitalDelayType := 0 ps;
     thold_CE0_CLK1_negedge_posedge : VitalDelayType := 0 ps;
     thold_CE0_CLK1_posedge_posedge : VitalDelayType := 0 ps;
     thold_D_CLK0_negedge_posedge : VitalDelayType := 0 ps;
     thold_D_CLK0_posedge_posedge : VitalDelayType := 0 ps;
     thold_D_CLK1_negedge_posedge : VitalDelayType := 0 ps;
     thold_D_CLK1_posedge_posedge : VitalDelayType := 0 ps;
     ticd_CLK0 : VitalDelayType := 0 ps;
     ticd_CLK1 : VitalDelayType := 0 ps;
     ticd_CLKDIV : VitalDelayType := 0 ps;
     tipd_BITSLIP : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CE0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLK0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLK1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLKDIV : VitalDelayType01 := (0 ps, 0 ps);
     tipd_D : VitalDelayType01 := (0 ps, 0 ps);
     tipd_IOCE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RST : VitalDelayType01 := (0 ps, 0 ps);
     tipd_SHIFTIN : VitalDelayType01 := (0 ps, 0 ps);
     tisd_BITSLIP_CLKDIV : VitalDelayType := 0 ps;
     tisd_CE0_CLK0 : VitalDelayType := 0 ps;
     tisd_CE0_CLK1 : VitalDelayType := 0 ps;
     tisd_D_CLK0 : VitalDelayType := 0 ps;
     tisd_D_CLK1 : VitalDelayType := 0 ps;
     tpd_CLK0_CFB0 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK0_Q1 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK0_Q2 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK0_Q3 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK0_Q4 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK1_CFB1 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK1_Q1 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK1_Q2 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK1_Q3 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK1_Q4 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKDIV_INCDEC : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKDIV_Q1 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKDIV_Q2 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKDIV_Q3 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKDIV_Q4 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKDIV_VALID : VitalDelayType01 := (100 ps, 100 ps);
     tpd_D_DFB : VitalDelayType01 := (100 ps, 100 ps);
     tpd_D_FABRICOUT : VitalDelayType01 := (100 ps, 100 ps);
     tpd_RST_Q1 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_RST_Q2 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_RST_Q3 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_RST_Q4 : VitalDelayType01 := (100 ps, 100 ps);
     tsetup_BITSLIP_CLKDIV_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_BITSLIP_CLKDIV_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CE0_CLK0_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CE0_CLK0_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CE0_CLK1_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CE0_CLK1_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_D_CLK0_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_D_CLK0_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_D_CLK1_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_D_CLK1_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     CFB0 : out std_ulogic;
     CFB1 : out std_ulogic;
     DFB : out std_ulogic;
     FABRICOUT : out std_ulogic;
     INCDEC : out std_ulogic;
     Q1 : out std_ulogic;
     Q2 : out std_ulogic;
     Q3 : out std_ulogic;
     Q4 : out std_ulogic;
     SHIFTOUT : out std_ulogic;
     VALID : out std_ulogic;
     BITSLIP : in std_ulogic := 'L';
     CE0 : in std_ulogic := 'H';
     CLK0 : in std_ulogic;
     CLK1 : in std_ulogic;
     CLKDIV : in std_ulogic;
     D : in std_ulogic;
     IOCE : in std_ulogic := 'H';
     RST : in std_ulogic := 'L';
     SHIFTIN : in std_ulogic
  );
end component;

----- component X_ISERDESE1 -----
component X_ISERDESE1
  generic (
     DATA_RATE : string := "DDR";
     DATA_WIDTH : integer := 4;
     DYN_CLKDIV_INV_EN : boolean := FALSE;
     DYN_CLK_INV_EN : boolean := FALSE;
     INIT_Q1 : bit := '0';
     INIT_Q2 : bit := '0';
     INIT_Q3 : bit := '0';
     INIT_Q4 : bit := '0';
     INTERFACE_TYPE : string := "MEMORY";
     IOBDELAY : string := "NONE";
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     NUM_CE : integer := 2;
     OFB_USED : boolean := FALSE;
     SERDES_MODE : string := "MASTER";
     SRVAL_Q1 : bit := '0';
     SRVAL_Q2 : bit := '0';
     SRVAL_Q3 : bit := '0';
     SRVAL_Q4 : bit := '0';
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     tbpd_DDLY_O_CLK : VitalDelayType01 := (0 ps, 0 ps);
     tbpd_DDLY_O_CLKB : VitalDelayType01 := (0 ps, 0 ps);
     tbpd_D_O_CLK : VitalDelayType01 := (0 ps, 0 ps);
     tbpd_D_O_CLKB : VitalDelayType01 := (0 ps, 0 ps);
     tbpd_OFB_O_CLK : VitalDelayType01 := (0 ps, 0 ps);
     tbpd_OFB_O_CLKB : VitalDelayType01 := (0 ps, 0 ps);
     thold_BITSLIP_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_BITSLIP_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE1_CLKB_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE1_CLKB_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE1_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE1_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE1_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE1_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE2_CLKB_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE2_CLKB_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE2_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE2_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE2_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE2_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_DDLY_CLKB_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_DDLY_CLKB_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_DDLY_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_DDLY_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_D_CLKB_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_D_CLKB_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_D_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_D_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_OFB_CLKB_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_OFB_CLKB_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_OFB_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_OFB_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_RST_CLKB_negedge_negedge : VitalDelayType := 0.0 ps;
     thold_RST_CLKB_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_RST_CLKB_posedge_negedge : VitalDelayType := 0.0 ps;
     thold_RST_CLKB_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_RST_CLKDIV_negedge_negedge : VitalDelayType := 0.0 ps;
     thold_RST_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_RST_CLKDIV_posedge_negedge : VitalDelayType := 0.0 ps;
     thold_RST_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_RST_CLK_negedge_negedge : VitalDelayType := 0.0 ps;
     thold_RST_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_RST_CLK_posedge_negedge : VitalDelayType := 0.0 ps;
     thold_RST_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_RST_OCLK_negedge_negedge : VitalDelayType := 0.0 ps;
     thold_RST_OCLK_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_RST_OCLK_posedge_negedge : VitalDelayType := 0.0 ps;
     thold_RST_OCLK_posedge_posedge : VitalDelayType := 0.0 ps;
     ticd_CLK : VitalDelayType := 0.0 ps;
     ticd_CLKB : VitalDelayType := 0.0 ps;
     ticd_CLKDIV : VitalDelayType := 0.0 ps;
     ticd_OCLK : VitalDelayType := 0.0 ps;
     tipd_BITSLIP : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CE1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CE2 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLKB : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLKDIV : VitalDelayType01 := (0 ps, 0 ps);
     tipd_D : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DDLY : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DYNCLKDIVSEL : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DYNCLKSEL : VitalDelayType01 := (0 ps, 0 ps);
     tipd_OCLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_OFB : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RST : VitalDelayType01 := (0 ps, 0 ps);
     tipd_SHIFTIN1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_SHIFTIN2 : VitalDelayType01 := (0 ps, 0 ps);
     tisd_BITSLIP_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_CE1_CLK : VitalDelayType := 0.0 ps;
     tisd_CE1_CLKB : VitalDelayType := 0.0 ps;
     tisd_CE1_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_CE2_CLK : VitalDelayType := 0.0 ps;
     tisd_CE2_CLKB : VitalDelayType := 0.0 ps;
     tisd_CE2_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_DDLY_CLK : VitalDelayType := 0.0 ps;
     tisd_DDLY_CLKB : VitalDelayType := 0.0 ps;
     tisd_DYNCLKDIVSEL_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_DYNCLKSEL_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_D_CLK : VitalDelayType := 0.0 ps;
     tisd_D_CLKB : VitalDelayType := 0.0 ps;
     tisd_OFB_CLK : VitalDelayType := 0.0 ps;
     tisd_OFB_CLKB : VitalDelayType := 0.0 ps;
     tisd_RST_CLK : VitalDelayType := 0.0 ps;
     tisd_RST_CLKB : VitalDelayType := 0.0 ps;
     tisd_RST_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_RST_OCLK : VitalDelayType := 0.0 ps;
     tisd_SHIFTIN1_CLK : VitalDelayType := 0.0 ps;
     tisd_SHIFTIN2_CLK : VitalDelayType := 0.0 ps;
     tpd_CLKDIV_Q1 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKDIV_Q2 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKDIV_Q3 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKDIV_Q4 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKDIV_Q5 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKDIV_Q6 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK_Q1 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK_Q2 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK_Q3 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK_Q4 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK_Q5 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK_Q6 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_DDLY_O : VitalDelayType01 := (0 ps, 0 ps);
     tpd_D_O : VitalDelayType01 := (0 ps, 0 ps);
     tpd_OFB_O : VitalDelayType01 := (0 ps, 0 ps);
     tperiod_CLKB_posedge : VitalDelayType := 0 ps;
     tperiod_CLKDIV_posedge : VitalDelayType := 0 ps;
     tperiod_CLK_posedge : VitalDelayType := 0 ps;
     tperiod_OCLK_posedge : VitalDelayType := 0 ps;
     tpw_CLKDIV_negedge: VitalDelayType := 0 ps;
     tpw_CLKDIV_posedge: VitalDelayType := 0 ps;
     tpw_CLK_negedge : VitalDelayType := 0 ps;
     tpw_CLK_posedge : VitalDelayType := 0 ps;
     tpw_OCLK_negedge : VitalDelayType := 0 ps;
     tpw_OCLK_posedge : VitalDelayType := 0 ps;
     tpw_RST_posedge : VitalDelayType := 0 ps;
     tsetup_BITSLIP_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_BITSLIP_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE1_CLKB_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE1_CLKB_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE1_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE1_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE1_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE1_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE2_CLKB_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE2_CLKB_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE2_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE2_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE2_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE2_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_DDLY_CLKB_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_DDLY_CLKB_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_DDLY_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_DDLY_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D_CLKB_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D_CLKB_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_OFB_CLKB_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_OFB_CLKB_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_OFB_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_OFB_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_RST_CLKB_negedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_RST_CLKB_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_RST_CLKB_posedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_RST_CLKB_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_RST_CLKDIV_negedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_RST_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_RST_CLKDIV_posedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_RST_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_RST_CLK_negedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_RST_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_RST_CLK_posedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_RST_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_RST_OCLK_negedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_RST_OCLK_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_RST_OCLK_posedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_RST_OCLK_posedge_posedge : VitalDelayType := 0.0 ps
  );
  port (
     O : out std_ulogic;
     Q1 : out std_ulogic;
     Q2 : out std_ulogic;
     Q3 : out std_ulogic;
     Q4 : out std_ulogic;
     Q5 : out std_ulogic;
     Q6 : out std_ulogic;
     SHIFTOUT1 : out std_ulogic;
     SHIFTOUT2 : out std_ulogic;
     BITSLIP : in std_ulogic;
     CE1 : in std_ulogic;
     CE2 : in std_ulogic;
     CLK : in std_ulogic;
     CLKB : in std_ulogic;
     CLKDIV : in std_ulogic;
     D : in std_ulogic;
     DDLY : in std_ulogic;
     DYNCLKDIVSEL : in std_ulogic;
     DYNCLKSEL : in std_ulogic;
     OCLK : in std_ulogic;
     OFB : in std_ulogic;
     RST : in std_ulogic;
     SHIFTIN1 : in std_ulogic;
     SHIFTIN2 : in std_ulogic
  );
end component;

----- component X_ISERDES_NODELAY -----
component X_ISERDES_NODELAY
  generic (
     BITSLIP_ENABLE : boolean := false;
     DATA_RATE : string := "DDR";
     DATA_WIDTH : integer := 4;
     INIT_Q1 : bit := '0';
     INIT_Q2 : bit := '0';
     INIT_Q3 : bit := '0';
     INIT_Q4 : bit := '0';
     INTERFACE_TYPE : string := "MEMORY";
     IOBDELAY : string := "NONE";
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     NUM_CE : integer := 2;
     OFB_USED : boolean := false;
     SERDES_MODE : string := "MASTER";
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     tbpd_DDLY_O_CLK : VitalDelayType01 := (0 ps, 0 ps);
     tbpd_DDLY_O_CLKB : VitalDelayType01 := (0 ps, 0 ps);
     tbpd_D_O_CLK : VitalDelayType01 := (0 ps, 0 ps);
     tbpd_D_O_CLKB : VitalDelayType01 := (0 ps, 0 ps);
     tbpd_OFB_O_CLK : VitalDelayType01 := (0 ps, 0 ps);
     tbpd_OFB_O_CLKB : VitalDelayType01 := (0 ps, 0 ps);
     tbpd_RST_Q1_CLKDIV : VitalDelayType01 := (0 ps, 0 ps);
     tbpd_RST_Q2_CLKDIV : VitalDelayType01 := (0 ps, 0 ps);
     tbpd_RST_Q3_CLKDIV : VitalDelayType01 := (0 ps, 0 ps);
     tbpd_RST_Q4_CLKDIV : VitalDelayType01 := (0 ps, 0 ps);
     tbpd_RST_Q5_CLKDIV : VitalDelayType01 := (0 ps, 0 ps);
     tbpd_RST_Q6_CLKDIV : VitalDelayType01 := (0 ps, 0 ps);
     thold_BITSLIP_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_BITSLIP_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE1_CLKB_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE1_CLKB_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE1_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE1_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE1_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE1_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE2_CLKB_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE2_CLKB_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE2_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE2_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE2_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE2_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_DDLY_CLKB_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_DDLY_CLKB_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_DDLY_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_DDLY_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_D_CLKB_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_D_CLKB_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_D_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_D_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_OFB_CLKB_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_OFB_CLKB_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_OFB_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_OFB_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_RST_CLKB_negedge_negedge : VitalDelayType := 0.0 ps;
     thold_RST_CLKB_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_RST_CLKB_posedge_negedge : VitalDelayType := 0.0 ps;
     thold_RST_CLKB_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_RST_CLKDIV_negedge_negedge : VitalDelayType := 0.0 ps;
     thold_RST_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_RST_CLKDIV_posedge_negedge : VitalDelayType := 0.0 ps;
     thold_RST_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_RST_CLK_negedge_negedge : VitalDelayType := 0.0 ps;
     thold_RST_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_RST_CLK_posedge_negedge : VitalDelayType := 0.0 ps;
     thold_RST_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_RST_OCLK_negedge_negedge : VitalDelayType := 0.0 ps;
     thold_RST_OCLK_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_RST_OCLK_posedge_negedge : VitalDelayType := 0.0 ps;
     thold_RST_OCLK_posedge_posedge : VitalDelayType := 0.0 ps;
     ticd_CLK : VitalDelayType := 0.0 ps;
     ticd_CLKB : VitalDelayType := 0.0 ps;
     ticd_CLKDIV : VitalDelayType := 0.0 ps;
     ticd_OCLK : VitalDelayType := 0.0 ps;
     tipd_BITSLIP : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CE1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CE2 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLKB : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLKDIV : VitalDelayType01 := (0 ps, 0 ps);
     tipd_D : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DDLY : VitalDelayType01 := (0 ps, 0 ps);
     tipd_OCLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_OFB : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RST : VitalDelayType01 := (0 ps, 0 ps);
     tipd_SHIFTIN1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_SHIFTIN2 : VitalDelayType01 := (0 ps, 0 ps);
     tisd_BITSLIP_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_CE1_CLK : VitalDelayType := 0.0 ps;
     tisd_CE1_CLKB : VitalDelayType := 0.0 ps;
     tisd_CE1_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_CE2_CLK : VitalDelayType := 0.0 ps;
     tisd_CE2_CLKB : VitalDelayType := 0.0 ps;
     tisd_CE2_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_DDLY_CLK : VitalDelayType := 0.0 ps;
     tisd_DDLY_CLKB : VitalDelayType := 0.0 ps;
     tisd_D_CLK : VitalDelayType := 0.0 ps;
     tisd_D_CLKB : VitalDelayType := 0.0 ps;
     tisd_OFB_CLK : VitalDelayType := 0.0 ps;
     tisd_OFB_CLKB : VitalDelayType := 0.0 ps;
     tisd_RST_CLK : VitalDelayType := 0.0 ps;
     tisd_RST_CLKB : VitalDelayType := 0.0 ps;
     tisd_RST_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_RST_OCLK : VitalDelayType := 0.0 ps;
     tisd_SHIFTIN1_CLK : VitalDelayType := 0.0 ps;
     tisd_SHIFTIN2_CLK : VitalDelayType := 0.0 ps;
     tpd_CLKDIV_Q1 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKDIV_Q2 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKDIV_Q3 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKDIV_Q4 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKDIV_Q5 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKDIV_Q6 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_DDLY_O : VitalDelayType01 := (0 ps, 0 ps);
     tpd_D_O : VitalDelayType01 := (0 ps, 0 ps);
     tpd_OFB_O : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RST_Q1 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RST_Q2 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RST_Q3 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RST_Q4 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RST_Q5 : VitalDelayType01 := (0 ps, 0 ps);
     tpd_RST_Q6 : VitalDelayType01 := (0 ps, 0 ps);
     tperiod_CLK_posedge : VitalDelayType := 0 ps;
     tpw_CLKDIV_negedge: VitalDelayType := 0 ps;
     tpw_CLKDIV_posedge: VitalDelayType := 0 ps;
     tpw_CLK_negedge : VitalDelayType := 0 ps;
     tpw_CLK_posedge : VitalDelayType := 0 ps;
     tpw_OCLK_negedge : VitalDelayType := 0 ps;
     tpw_OCLK_posedge : VitalDelayType := 0 ps;
     tpw_RST_posedge : VitalDelayType := 0 ps;
     trecovery_RST_CLKB_negedge_posedge : VitalDelayType := 0 ps;
     trecovery_RST_CLKDIV_negedge_posedge : VitalDelayType := 0 ps;
     trecovery_RST_CLK_negedge_posedge : VitalDelayType := 0 ps;
     trecovery_RST_OCLK_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_RST_CLKB_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_RST_CLKDIV_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_RST_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_RST_OCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_BITSLIP_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_BITSLIP_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE1_CLKB_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE1_CLKB_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE1_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE1_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE1_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE1_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE2_CLKB_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE2_CLKB_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE2_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE2_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE2_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE2_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_DDLY_CLKB_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_DDLY_CLKB_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_DDLY_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_DDLY_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D_CLKB_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D_CLKB_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_OFB_CLKB_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_OFB_CLKB_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_OFB_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_OFB_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_RST_CLKB_negedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_RST_CLKB_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_RST_CLKB_posedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_RST_CLKB_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_RST_CLKDIV_negedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_RST_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_RST_CLKDIV_posedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_RST_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_RST_CLK_negedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_RST_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_RST_CLK_posedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_RST_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_RST_OCLK_negedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_RST_OCLK_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_RST_OCLK_posedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_RST_OCLK_posedge_posedge : VitalDelayType := 0.0 ps
  );
  port (
     O : out std_ulogic;
     Q1 : out std_ulogic;
     Q2 : out std_ulogic;
     Q3 : out std_ulogic;
     Q4 : out std_ulogic;
     Q5 : out std_ulogic;
     Q6 : out std_ulogic;
     SHIFTOUT1 : out std_ulogic;
     SHIFTOUT2 : out std_ulogic;
     BITSLIP : in std_ulogic;
     CE1 : in std_ulogic;
     CE2 : in std_ulogic;
     CLK : in std_ulogic;
     CLKB : in std_ulogic;
     CLKDIV : in std_ulogic;
     D : in std_ulogic;
     DDLY : in std_ulogic;
     OCLK : in std_ulogic;
     OFB : in std_ulogic;
     RST : in std_ulogic;
     SHIFTIN1 : in std_ulogic;
     SHIFTIN2 : in std_ulogic
  );
end component;

----- component X_KEEPER -----
component X_KEEPER
  generic (
     LOC : string := "UNPLACED";
     tipd_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : inout std_ulogic
  );
end component;

----- component X_LATCH -----
component X_LATCH
  generic (
     INIT : bit := '0';
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     thold_I_CLK_negedge_negedge : VitalDelayType := 0.000 ns;
     thold_I_CLK_posedge_negedge : VitalDelayType := 0.000 ns;
     thold_RST_CLK_negedge_negedge : VitalDelayType := 0.000 ns;
     thold_SET_CLK_negedge_negedge : VitalDelayType := 0.000 ns;
     ticd_CLK : VitalDelayType := 0.000 ns;
     tipd_CLK : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_RST : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_SET : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tisd_I_CLK : VitalDelayType := 0.000 ns;
     tisd_RST_CLK : VitalDelayType := 0.000 ns;
     tisd_SET_CLK : VitalDelayType := 0.000 ns;
     tpd_CLK_O : VitalDelayType01 := (0.100 ns, 0.100 ns);
     tpd_I_O : VitalDelayType01 := (0.100 ns, 0.100 ns);
     tpd_RST_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_SET_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpw_CLK_negedge : VitalDelayType := 0.000 ns;
     tpw_CLK_posedge : VitalDelayType := 0.000 ns;
     tpw_RST_posedge : VitalDelayType := 0.000 ns;
     tpw_SET_posedge : VitalDelayType := 0.000 ns;
     trecovery_RST_CLK_negedge_negedge : VitalDelayType := 0.000 ns;
     trecovery_SET_CLK_negedge_negedge : VitalDelayType := 0.000 ns;
     tremoval_RST_CLK_negedge_negedge : VitalDelayType := 0.000 ns;
     tremoval_SET_CLK_negedge_negedge : VitalDelayType := 0.000 ns;
     tsetup_I_CLK_negedge_negedge : VitalDelayType := 0.000 ns;
     tsetup_I_CLK_posedge_negedge : VitalDelayType := 0.000 ns
  );
  port (
     O : out std_ulogic;
     CLK : in std_ulogic;
     I : in std_ulogic;
     RST : in std_ulogic;
     SET : in std_ulogic
  );
end component;

----- component X_LATCHE -----
component X_LATCHE
  generic (
     INIT : bit := '0';
     LOC : string := "UNPLACED";
     MSGON : boolean := true;
     TimingChecksOn : boolean := true;
     XON : boolean := true;
     thold_GE_CLK_negedge_negedge : VitalDelayType := 0.000 ns;
     thold_GE_CLK_posedge_negedge : VitalDelayType := 0.000 ns;
     thold_I_CLK_negedge_negedge : VitalDelayType := 0.000 ns;
     thold_I_CLK_posedge_negedge : VitalDelayType := 0.000 ns;
     thold_RST_CLK_negedge_negedge : VitalDelayType := 0.000 ns;
     thold_SET_CLK_negedge_negedge : VitalDelayType := 0.000 ns;
     ticd_CLK : VitalDelayType := 0.000 ns;
     tipd_CLK : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_GE : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_RST : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_SET : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tisd_GE_CLK : VitalDelayType := 0.000 ns;
     tisd_I_CLK : VitalDelayType := 0.000 ns;
     tisd_RST_CLK : VitalDelayType := 0.000 ns;
     tisd_SET_CLK : VitalDelayType := 0.000 ns;
     tpd_CLK_O : VitalDelayType01 := (0.100 ns, 0.100 ns);
     tpd_GE_O : VitalDelayType01 := (0.100 ns, 0.100 ns);
     tpd_I_O : VitalDelayType01 := (0.100 ns, 0.100 ns);
     tpd_RST_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_SET_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpw_CLK_negedge : VitalDelayType := 0.000 ns;
     tpw_CLK_posedge : VitalDelayType := 0.000 ns;
     tpw_RST_posedge : VitalDelayType := 0.000 ns;
     tpw_SET_posedge : VitalDelayType := 0.000 ns;
     trecovery_RST_CLK_negedge_negedge : VitalDelayType := 0.000 ns;
     trecovery_SET_CLK_negedge_negedge : VitalDelayType := 0.000 ns;
     tremoval_RST_CLK_negedge_negedge : VitalDelayType := 0.000 ns;
     tremoval_SET_CLK_negedge_negedge : VitalDelayType := 0.000 ns;
     tsetup_GE_CLK_negedge_negedge : VitalDelayType := 0.000 ns;
     tsetup_GE_CLK_posedge_negedge : VitalDelayType := 0.000 ns;
     tsetup_I_CLK_negedge_negedge : VitalDelayType := 0.000 ns;
     tsetup_I_CLK_posedge_negedge : VitalDelayType := 0.000 ns
  );
  port (
     O : out std_ulogic;
     CLK : in std_ulogic;
     GE : in std_ulogic;
     I : in std_ulogic;
     RST : in std_ulogic;
     SET : in std_ulogic
  );
end component;

----- component X_LATCH_CPLD -----
component X_LATCH_CPLD
  generic (
     INIT : bit := '0';
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     thold_I_CLK_negedge_negedge : VitalDelayType := 0.000 ns;
     thold_I_CLK_posedge_negedge : VitalDelayType := 0.000 ns;
     thold_RST_CLK_negedge_negedge : VitalDelayType := 0.000 ns;
     thold_SET_CLK_negedge_negedge : VitalDelayType := 0.000 ns;
     ticd_CLK : VitalDelayType := 0.000 ns;
     tipd_CLK : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_RST : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_SET : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tisd_I_CLK : VitalDelayType := 0.000 ns;
     tisd_RST_CLK : VitalDelayType := 0.000 ns;
     tisd_SET_CLK : VitalDelayType := 0.000 ns;
     tpd_CLK_O : VitalDelayType01 := (0.100 ns, 0.100 ns);
     tpd_I_O : VitalDelayType01 := (0.100 ns, 0.100 ns);
     tpd_RST_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_SET_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpw_CLK_negedge : VitalDelayType := 0.000 ns;
     tpw_CLK_posedge : VitalDelayType := 0.000 ns;
     tpw_RST_posedge : VitalDelayType := 0.000 ns;
     tpw_SET_posedge : VitalDelayType := 0.000 ns;
     trecovery_RST_CLK_negedge_negedge : VitalDelayType := 0.000 ns;
     trecovery_SET_CLK_negedge_negedge : VitalDelayType := 0.000 ns;
     tremoval_RST_CLK_negedge_negedge : VitalDelayType := 0.000 ns;
     tremoval_SET_CLK_negedge_negedge : VitalDelayType := 0.000 ns;
     tsetup_I_CLK_negedge_negedge : VitalDelayType := 0.000 ns;
     tsetup_I_CLK_posedge_negedge : VitalDelayType := 0.000 ns
  );
  port (
     O : out std_ulogic;
     CLK : in std_ulogic;
     I : in std_ulogic;
     RST : in std_ulogic;
     SET : in std_ulogic
  );
end component;

----- component X_LUT2 -----
component X_LUT2
  generic (
     INIT : bit_vector := X"0";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     Xon : boolean := true;
     tipd_ADR0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_ADR1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR0_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR1_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     ADR0 : in std_ulogic;
     ADR1 : in std_ulogic
  );
end component;

----- component X_LUT3 -----
component X_LUT3
  generic (
     INIT : bit_vector := X"00";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     Xon : boolean := true;
     tipd_ADR0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_ADR1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_ADR2 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR0_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR1_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR2_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     ADR0 : in std_ulogic;
     ADR1 : in std_ulogic;
     ADR2 : in std_ulogic
  );
end component;

----- component X_LUT4 -----
component X_LUT4
  generic (
     INIT : bit_vector := X"0000";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     Xon : boolean := true;
     tipd_ADR0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_ADR1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_ADR2 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_ADR3 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR0_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR1_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR2_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR3_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     ADR0 : in std_ulogic;
     ADR1 : in std_ulogic;
     ADR2 : in std_ulogic;
     ADR3 : in std_ulogic
  );
end component;

----- component X_LUT5 -----
component X_LUT5
  generic (
     INIT : bit_vector := X"00000000";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     Xon : boolean := true;
     tipd_ADR0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_ADR1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_ADR2 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_ADR3 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_ADR4 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR0_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR1_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR2_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR3_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR4_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     ADR0 : in std_ulogic;
     ADR1 : in std_ulogic;
     ADR2 : in std_ulogic;
     ADR3 : in std_ulogic;
     ADR4 : in std_ulogic
  );
end component;

----- component X_LUT6 -----
component X_LUT6
  generic (
     INIT : bit_vector := X"0000000000000000";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     Xon : boolean := true;
     tipd_ADR0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_ADR1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_ADR2 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_ADR3 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_ADR4 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_ADR5 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR0_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR1_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR2_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR3_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR4_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR5_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     ADR0 : in std_ulogic;
     ADR1 : in std_ulogic;
     ADR2 : in std_ulogic;
     ADR3 : in std_ulogic;
     ADR4 : in std_ulogic;
     ADR5 : in std_ulogic
  );
end component;

----- component X_LUT6_2 -----
component X_LUT6_2
  generic (
     INIT : bit_vector := X"0000000000000000";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     Xon : boolean := true;
     tipd_I0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I2 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I3 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I4 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I5 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I0_O5 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I0_O6 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I1_O5 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I1_O6 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I2_O5 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I2_O6 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I3_O5 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I3_O6 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I4_O5 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I4_O6 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I5_O5 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I5_O6 : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O5 : out std_ulogic;
     O6 : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic;
     I5 : in std_ulogic
  );
end component;

----- component X_LUT7 -----
component X_LUT7
  generic (
     INIT : bit_vector := X"00000000000000000000000000000000";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     Xon : boolean := true;
     tipd_ADR0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_ADR1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_ADR2 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_ADR3 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_ADR4 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_ADR5 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_ADR6 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR0_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR1_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR2_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR3_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR4_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR5_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR6_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     ADR0 : in std_ulogic;
     ADR1 : in std_ulogic;
     ADR2 : in std_ulogic;
     ADR3 : in std_ulogic;
     ADR4 : in std_ulogic;
     ADR5 : in std_ulogic;
     ADR6 : in std_ulogic
  );
end component;

----- component X_LUT8 -----
component X_LUT8
  generic (
     INIT : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     Xon : boolean := true;
     tipd_ADR0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_ADR1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_ADR2 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_ADR3 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_ADR4 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_ADR5 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_ADR6 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_ADR7 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR0_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR1_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR2_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR3_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR4_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR5_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR6_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_ADR7_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     ADR0 : in std_ulogic;
     ADR1 : in std_ulogic;
     ADR2 : in std_ulogic;
     ADR3 : in std_ulogic;
     ADR4 : in std_ulogic;
     ADR5 : in std_ulogic;
     ADR6 : in std_ulogic;
     ADR7 : in std_ulogic
  );
end component;

----- component X_MCB -----
component X_MCB
  generic (
     ARB_NUM_TIME_SLOTS : integer := 12;
     ARB_TIME_SLOT_0 : bit_vector := "111111111111111111";
     ARB_TIME_SLOT_1 : bit_vector := "111111111111111111";
     ARB_TIME_SLOT_10 : bit_vector := "111111111111111111";
     ARB_TIME_SLOT_11 : bit_vector := "111111111111111111";
     ARB_TIME_SLOT_2 : bit_vector := "111111111111111111";
     ARB_TIME_SLOT_3 : bit_vector := "111111111111111111";
     ARB_TIME_SLOT_4 : bit_vector := "111111111111111111";
     ARB_TIME_SLOT_5 : bit_vector := "111111111111111111";
     ARB_TIME_SLOT_6 : bit_vector := "111111111111111111";
     ARB_TIME_SLOT_7 : bit_vector := "111111111111111111";
     ARB_TIME_SLOT_8 : bit_vector := "111111111111111111";
     ARB_TIME_SLOT_9 : bit_vector := "111111111111111111";
     CAL_BA : bit_vector := X"0";
     CAL_BYPASS : string := "YES";
     CAL_CA : bit_vector := X"000";
     CAL_CALIBRATION_MODE : string := "NOCALIBRATION";
     CAL_CLK_DIV : integer := 1;
     CAL_DELAY : string := "QUARTER";
     CAL_RA : bit_vector := X"0000";
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MEM_ADDR_ORDER : string := "BANK_ROW_COLUMN";
     MEM_BA_SIZE : integer := 3;
     MEM_BURST_LEN : integer := 8;
     MEM_CAS_LATENCY : integer := 4;
     MEM_CA_SIZE : integer := 11;
     MEM_DDR1_2_ODS : string := "FULL";
     MEM_DDR2_3_HIGH_TEMP_SR : string := "NORMAL";
     MEM_DDR2_3_PA_SR : string := "FULL";
     MEM_DDR2_ADD_LATENCY : integer := 0;
     MEM_DDR2_DIFF_DQS_EN : string := "YES";
     MEM_DDR2_RTT : string := "50OHMS";
     MEM_DDR2_WRT_RECOVERY : integer := 4;
     MEM_DDR3_ADD_LATENCY : string := "OFF";
     MEM_DDR3_AUTO_SR : string := "ENABLED";
     MEM_DDR3_CAS_LATENCY : integer := 7;
     MEM_DDR3_CAS_WR_LATENCY : integer := 5;
     MEM_DDR3_DYN_WRT_ODT : string := "OFF";
     MEM_DDR3_ODS : string := "DIV7";
     MEM_DDR3_RTT : string := "DIV2";
     MEM_DDR3_WRT_RECOVERY : integer := 7;
     MEM_MDDR_ODS : string := "FULL";
     MEM_MOBILE_PA_SR : string := "FULL";
     MEM_MOBILE_TC_SR : integer := 0;
     MEM_RAS_VAL : integer := 0;
     MEM_RA_SIZE : integer := 13;
     MEM_RCD_VAL : integer := 1;
     MEM_REFI_VAL : integer := 0;
     MEM_RFC_VAL : integer := 0;
     MEM_RP_VAL : integer := 0;
     MEM_RTP_VAL : integer := 0;
     MEM_TYPE : string := "DDR3";
     MEM_WIDTH : integer := 4;
     MEM_WR_VAL : integer := 0;
     MEM_WTR_VAL : integer := 3;
     MsgOn : boolean := FALSE;
     PORT_CONFIG : string := "B32_B32_B32_B32";
     TimingChecksOn : boolean := TRUE;
     Xon : boolean := TRUE;
     thold_IOIDRPSDI_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_IOIDRPSDI_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_P0ARBEN_PLLCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_P0ARBEN_PLLCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_P0CMDBA_P0CMDCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_P0CMDBA_P0CMDCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_P0CMDBL_P0CMDCLK_negedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     thold_P0CMDBL_P0CMDCLK_posedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     thold_P0CMDCA_P0CMDCLK_negedge_posedge : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
     thold_P0CMDCA_P0CMDCLK_posedge_posedge : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
     thold_P0CMDEN_P0CMDCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_P0CMDEN_P0CMDCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_P0CMDINSTR_P0CMDCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_P0CMDINSTR_P0CMDCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_P0CMDRA_P0CMDCLK_negedge_posedge : VitalDelayArrayType(14 downto 0) := (others => 0 ps);
     thold_P0CMDRA_P0CMDCLK_posedge_posedge : VitalDelayArrayType(14 downto 0) := (others => 0 ps);
     thold_P0RDEN_P0RDCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_P0RDEN_P0RDCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_P0RWRMASK_P0WRCLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_P0RWRMASK_P0WRCLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_P0WRDATA_P0WRCLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     thold_P0WRDATA_P0WRCLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     thold_P0WREN_P0WRCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_P0WREN_P0WRCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_P1ARBEN_PLLCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_P1ARBEN_PLLCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_P1CMDBA_P1CMDCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_P1CMDBA_P1CMDCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_P1CMDBL_P1CMDCLK_negedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     thold_P1CMDBL_P1CMDCLK_posedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     thold_P1CMDCA_P1CMDCLK_negedge_posedge : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
     thold_P1CMDCA_P1CMDCLK_posedge_posedge : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
     thold_P1CMDEN_P1CMDCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_P1CMDEN_P1CMDCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_P1CMDINSTR_P1CMDCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_P1CMDINSTR_P1CMDCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_P1CMDRA_P1CMDCLK_negedge_posedge : VitalDelayArrayType(14 downto 0) := (others => 0 ps);
     thold_P1CMDRA_P1CMDCLK_posedge_posedge : VitalDelayArrayType(14 downto 0) := (others => 0 ps);
     thold_P1RDEN_P1RDCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_P1RDEN_P1RDCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_P1RWRMASK_P1WRCLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_P1RWRMASK_P1WRCLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_P1WRDATA_P1WRCLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     thold_P1WRDATA_P1WRCLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     thold_P1WREN_P1WRCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_P1WREN_P1WRCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_P2ARBEN_PLLCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_P2ARBEN_PLLCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_P2CMDBA_P2CMDCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_P2CMDBA_P2CMDCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_P2CMDBL_P2CMDCLK_negedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     thold_P2CMDBL_P2CMDCLK_posedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     thold_P2CMDCA_P2CMDCLK_negedge_posedge : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
     thold_P2CMDCA_P2CMDCLK_posedge_posedge : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
     thold_P2CMDEN_P2CMDCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_P2CMDEN_P2CMDCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_P2CMDINSTR_P2CMDCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_P2CMDINSTR_P2CMDCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_P2CMDRA_P2CMDCLK_negedge_posedge : VitalDelayArrayType(14 downto 0) := (others => 0 ps);
     thold_P2CMDRA_P2CMDCLK_posedge_posedge : VitalDelayArrayType(14 downto 0) := (others => 0 ps);
     thold_P2EN_P2CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_P2EN_P2CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_P2WRDATA_P2CLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     thold_P2WRDATA_P2CLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     thold_P2WRMASK_P2CLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_P2WRMASK_P2CLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_P3ARBEN_PLLCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_P3ARBEN_PLLCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_P3CMDBA_P3CMDCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_P3CMDBA_P3CMDCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_P3CMDBL_P3CMDCLK_negedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     thold_P3CMDBL_P3CMDCLK_posedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     thold_P3CMDCA_P3CMDCLK_negedge_posedge : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
     thold_P3CMDCA_P3CMDCLK_posedge_posedge : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
     thold_P3CMDEN_P3CMDCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_P3CMDEN_P3CMDCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_P3CMDINSTR_P3CMDCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_P3CMDINSTR_P3CMDCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_P3CMDRA_P3CMDCLK_negedge_posedge : VitalDelayArrayType(14 downto 0) := (others => 0 ps);
     thold_P3CMDRA_P3CMDCLK_posedge_posedge : VitalDelayArrayType(14 downto 0) := (others => 0 ps);
     thold_P3EN_P3CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_P3EN_P3CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_P3WRDATA_P3CLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     thold_P3WRDATA_P3CLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     thold_P3WRMASK_P3CLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_P3WRMASK_P3CLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_P4ARBEN_PLLCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_P4ARBEN_PLLCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_P4CMDBA_P4CMDCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_P4CMDBA_P4CMDCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_P4CMDBL_P4CMDCLK_negedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     thold_P4CMDBL_P4CMDCLK_posedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     thold_P4CMDCA_P4CMDCLK_negedge_posedge : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
     thold_P4CMDCA_P4CMDCLK_posedge_posedge : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
     thold_P4CMDEN_P4CMDCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_P4CMDEN_P4CMDCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_P4CMDINSTR_P4CMDCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_P4CMDINSTR_P4CMDCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_P4CMDRA_P4CMDCLK_negedge_posedge : VitalDelayArrayType(14 downto 0) := (others => 0 ps);
     thold_P4CMDRA_P4CMDCLK_posedge_posedge : VitalDelayArrayType(14 downto 0) := (others => 0 ps);
     thold_P4EN_P4CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_P4EN_P4CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_P4WRDATA_P4CLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     thold_P4WRDATA_P4CLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     thold_P4WRMASK_P4CLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_P4WRMASK_P4CLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_P5ARBEN_PLLCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_P5ARBEN_PLLCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_P5CMDBA_P5CMDCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_P5CMDBA_P5CMDCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_P5CMDBL_P5CMDCLK_negedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     thold_P5CMDBL_P5CMDCLK_posedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     thold_P5CMDCA_P5CMDCLK_negedge_posedge : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
     thold_P5CMDCA_P5CMDCLK_posedge_posedge : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
     thold_P5CMDEN_P5CMDCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_P5CMDEN_P5CMDCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_P5CMDINSTR_P5CMDCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_P5CMDINSTR_P5CMDCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_P5CMDRA_P5CMDCLK_negedge_posedge : VitalDelayArrayType(14 downto 0) := (others => 0 ps);
     thold_P5CMDRA_P5CMDCLK_posedge_posedge : VitalDelayArrayType(14 downto 0) := (others => 0 ps);
     thold_P5EN_P5CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_P5EN_P5CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_P5WRDATA_P5CLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     thold_P5WRDATA_P5CLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     thold_P5WRMASK_P5CLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_P5WRMASK_P5CLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_PLLCE_PLLCLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_PLLCE_PLLCLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_PLLLOCK_PLLCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_PLLLOCK_PLLCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_RECAL_PLLCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_RECAL_PLLCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_SELFREFRESHENTER_PLLCLK_negedge_negedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_SELFREFRESHENTER_PLLCLK_posedge_negedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_UIADDR_UICLK_negedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     thold_UIADDR_UICLK_posedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     thold_UIADD_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_UIADD_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_UIBROADCAST_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_UIBROADCAST_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_UICMDEN_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_UICMDEN_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_UICMDIN_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_UICMDIN_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_UICMD_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_UICMD_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_UICS_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_UICS_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_UIDONECAL_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_UIDONECAL_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_UIDQCOUNT_UICLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_UIDQCOUNT_UICLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_UIDQLOWERDEC_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_UIDQLOWERDEC_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_UIDQLOWERINC_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_UIDQLOWERINC_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_UIDQUPPERDEC_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_UIDQUPPERDEC_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_UIDQUPPERINC_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_UIDQUPPERINC_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_UIDRPUPDATE_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_UIDRPUPDATE_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_UILDQSDEC_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_UILDQSDEC_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_UILDQSINC_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_UILDQSINC_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_UIREAD_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_UIREAD_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_UISDI_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_UISDI_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_UIUDQSDEC_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_UIUDQSDEC_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_UIUDQSINC_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_UIUDQSINC_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     ticd_P0CMDCLK : VitalDelayType := 0 ps;
     ticd_P0RDCLK : VitalDelayType := 0 ps;
     ticd_P0WRCLK : VitalDelayType := 0 ps;
     ticd_P1CMDCLK : VitalDelayType := 0 ps;
     ticd_P1RDCLK : VitalDelayType := 0 ps;
     ticd_P1WRCLK : VitalDelayType := 0 ps;
     ticd_P2CLK : VitalDelayType := 0 ps;
     ticd_P2CMDCLK : VitalDelayType := 0 ps;
     ticd_P3CLK : VitalDelayType := 0 ps;
     ticd_P3CMDCLK : VitalDelayType := 0 ps;
     ticd_P4CLK : VitalDelayType := 0 ps;
     ticd_P4CMDCLK : VitalDelayType := 0 ps;
     ticd_P5CLK : VitalDelayType := 0 ps;
     ticd_P5CMDCLK : VitalDelayType := 0 ps;
     ticd_PLLCLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     ticd_UICLK : VitalDelayType := 0 ps;
     tipd_DQI : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
     tipd_DQSIOIN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DQSIOIP : VitalDelayType01 := (0 ps, 0 ps);
     tipd_IOIDRPSDI : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P0ARBEN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P0CMDBA : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_P0CMDBL : VitalDelayArrayType01 (5 downto 0) := (others => (0 ps, 0 ps));
     tipd_P0CMDCA : VitalDelayArrayType01 (11 downto 0) := (others => (0 ps, 0 ps));
     tipd_P0CMDCLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P0CMDEN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P0CMDINSTR : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_P0CMDRA : VitalDelayArrayType01 (14 downto 0) := (others => (0 ps, 0 ps));
     tipd_P0RDCLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P0RDEN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P0RWRMASK : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_P0WRCLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P0WRDATA : VitalDelayArrayType01 (31 downto 0) := (others => (0 ps, 0 ps));
     tipd_P0WREN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P1ARBEN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P1CMDBA : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_P1CMDBL : VitalDelayArrayType01 (5 downto 0) := (others => (0 ps, 0 ps));
     tipd_P1CMDCA : VitalDelayArrayType01 (11 downto 0) := (others => (0 ps, 0 ps));
     tipd_P1CMDCLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P1CMDEN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P1CMDINSTR : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_P1CMDRA : VitalDelayArrayType01 (14 downto 0) := (others => (0 ps, 0 ps));
     tipd_P1RDCLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P1RDEN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P1RWRMASK : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_P1WRCLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P1WRDATA : VitalDelayArrayType01 (31 downto 0) := (others => (0 ps, 0 ps));
     tipd_P1WREN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P2ARBEN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P2CLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P2CMDBA : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_P2CMDBL : VitalDelayArrayType01 (5 downto 0) := (others => (0 ps, 0 ps));
     tipd_P2CMDCA : VitalDelayArrayType01 (11 downto 0) := (others => (0 ps, 0 ps));
     tipd_P2CMDCLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P2CMDEN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P2CMDINSTR : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_P2CMDRA : VitalDelayArrayType01 (14 downto 0) := (others => (0 ps, 0 ps));
     tipd_P2EN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P2WRDATA : VitalDelayArrayType01 (31 downto 0) := (others => (0 ps, 0 ps));
     tipd_P2WRMASK : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_P3ARBEN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P3CLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P3CMDBA : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_P3CMDBL : VitalDelayArrayType01 (5 downto 0) := (others => (0 ps, 0 ps));
     tipd_P3CMDCA : VitalDelayArrayType01 (11 downto 0) := (others => (0 ps, 0 ps));
     tipd_P3CMDCLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P3CMDEN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P3CMDINSTR : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_P3CMDRA : VitalDelayArrayType01 (14 downto 0) := (others => (0 ps, 0 ps));
     tipd_P3EN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P3WRDATA : VitalDelayArrayType01 (31 downto 0) := (others => (0 ps, 0 ps));
     tipd_P3WRMASK : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_P4ARBEN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P4CLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P4CMDBA : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_P4CMDBL : VitalDelayArrayType01 (5 downto 0) := (others => (0 ps, 0 ps));
     tipd_P4CMDCA : VitalDelayArrayType01 (11 downto 0) := (others => (0 ps, 0 ps));
     tipd_P4CMDCLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P4CMDEN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P4CMDINSTR : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_P4CMDRA : VitalDelayArrayType01 (14 downto 0) := (others => (0 ps, 0 ps));
     tipd_P4EN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P4WRDATA : VitalDelayArrayType01 (31 downto 0) := (others => (0 ps, 0 ps));
     tipd_P4WRMASK : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_P5ARBEN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P5CLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P5CMDBA : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_P5CMDBL : VitalDelayArrayType01 (5 downto 0) := (others => (0 ps, 0 ps));
     tipd_P5CMDCA : VitalDelayArrayType01 (11 downto 0) := (others => (0 ps, 0 ps));
     tipd_P5CMDCLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P5CMDEN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P5CMDINSTR : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_P5CMDRA : VitalDelayArrayType01 (14 downto 0) := (others => (0 ps, 0 ps));
     tipd_P5EN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_P5WRDATA : VitalDelayArrayType01 (31 downto 0) := (others => (0 ps, 0 ps));
     tipd_P5WRMASK : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_PLLCE : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_PLLCLK : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_PLLLOCK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RECAL : VitalDelayType01 := (0 ps, 0 ps);
     tipd_SELFREFRESHENTER : VitalDelayType01 := (0 ps, 0 ps);
     tipd_SYSRST : VitalDelayType01 := (0 ps, 0 ps);
     tipd_UDQSIOIN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_UDQSIOIP : VitalDelayType01 := (0 ps, 0 ps);
     tipd_UIADD : VitalDelayType01 := (0 ps, 0 ps);
     tipd_UIADDR : VitalDelayArrayType01 (4 downto 0) := (others => (0 ps, 0 ps));
     tipd_UIBROADCAST : VitalDelayType01 := (0 ps, 0 ps);
     tipd_UICLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_UICMD : VitalDelayType01 := (0 ps, 0 ps);
     tipd_UICMDEN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_UICMDIN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_UICS : VitalDelayType01 := (0 ps, 0 ps);
     tipd_UIDONECAL : VitalDelayType01 := (0 ps, 0 ps);
     tipd_UIDQCOUNT : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_UIDQLOWERDEC : VitalDelayType01 := (0 ps, 0 ps);
     tipd_UIDQLOWERINC : VitalDelayType01 := (0 ps, 0 ps);
     tipd_UIDQUPPERDEC : VitalDelayType01 := (0 ps, 0 ps);
     tipd_UIDQUPPERINC : VitalDelayType01 := (0 ps, 0 ps);
     tipd_UIDRPUPDATE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_UILDQSDEC : VitalDelayType01 := (0 ps, 0 ps);
     tipd_UILDQSINC : VitalDelayType01 := (0 ps, 0 ps);
     tipd_UIREAD : VitalDelayType01 := (0 ps, 0 ps);
     tipd_UISDI : VitalDelayType01 := (0 ps, 0 ps);
     tipd_UIUDQSDEC : VitalDelayType01 := (0 ps, 0 ps);
     tipd_UIUDQSINC : VitalDelayType01 := (0 ps, 0 ps);
     tisd_IOIDRPSDI_UICLK : VitalDelayType := 0 ps;
     tisd_P0ARBEN_PLLCLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_P0CMDBA_P0CMDCLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_P0CMDBL_P0CMDCLK : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     tisd_P0CMDCA_P0CMDCLK : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
     tisd_P0CMDEN_P0CMDCLK : VitalDelayType := 0 ps;
     tisd_P0CMDINSTR_P0CMDCLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_P0CMDRA_P0CMDCLK : VitalDelayArrayType(14 downto 0) := (others => 0 ps);
     tisd_P0RDEN_P0RDCLK : VitalDelayType := 0 ps;
     tisd_P0RWRMASK_P0WRCLK : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_P0WRDATA_P0WRCLK : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tisd_P0WREN_P0WRCLK : VitalDelayType := 0 ps;
     tisd_P1ARBEN_PLLCLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_P1CMDBA_P1CMDCLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_P1CMDBL_P1CMDCLK : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     tisd_P1CMDCA_P1CMDCLK : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
     tisd_P1CMDEN_P1CMDCLK : VitalDelayType := 0 ps;
     tisd_P1CMDINSTR_P1CMDCLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_P1CMDRA_P1CMDCLK : VitalDelayArrayType(14 downto 0) := (others => 0 ps);
     tisd_P1RDEN_P1RDCLK : VitalDelayType := 0 ps;
     tisd_P1RWRMASK_P1WRCLK : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_P1WRDATA_P1WRCLK : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tisd_P1WREN_P1WRCLK : VitalDelayType := 0 ps;
     tisd_P2ARBEN_PLLCLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_P2CMDBA_P2CMDCLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_P2CMDBL_P2CMDCLK : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     tisd_P2CMDCA_P2CMDCLK : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
     tisd_P2CMDEN_P2CMDCLK : VitalDelayType := 0 ps;
     tisd_P2CMDINSTR_P2CMDCLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_P2CMDRA_P2CMDCLK : VitalDelayArrayType(14 downto 0) := (others => 0 ps);
     tisd_P2EN_P2CLK : VitalDelayType := 0 ps;
     tisd_P2WRDATA_P2CLK : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tisd_P2WRMASK_P2CLK : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_P3ARBEN_PLLCLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_P3CMDBA_P3CMDCLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_P3CMDBL_P3CMDCLK : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     tisd_P3CMDCA_P3CMDCLK : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
     tisd_P3CMDEN_P3CMDCLK : VitalDelayType := 0 ps;
     tisd_P3CMDINSTR_P3CMDCLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_P3CMDRA_P3CMDCLK : VitalDelayArrayType(14 downto 0) := (others => 0 ps);
     tisd_P3EN_P3CLK : VitalDelayType := 0 ps;
     tisd_P3WRDATA_P3CLK : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tisd_P3WRMASK_P3CLK : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_P4ARBEN_PLLCLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_P4CMDBA_P4CMDCLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_P4CMDBL_P4CMDCLK : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     tisd_P4CMDCA_P4CMDCLK : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
     tisd_P4CMDEN_P4CMDCLK : VitalDelayType := 0 ps;
     tisd_P4CMDINSTR_P4CMDCLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_P4CMDRA_P4CMDCLK : VitalDelayArrayType(14 downto 0) := (others => 0 ps);
     tisd_P4EN_P4CLK : VitalDelayType := 0 ps;
     tisd_P4WRDATA_P4CLK : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tisd_P4WRMASK_P4CLK : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_P5ARBEN_PLLCLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_P5CMDBA_P5CMDCLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_P5CMDBL_P5CMDCLK : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     tisd_P5CMDCA_P5CMDCLK : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
     tisd_P5CMDEN_P5CMDCLK : VitalDelayType := 0 ps;
     tisd_P5CMDINSTR_P5CMDCLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_P5CMDRA_P5CMDCLK : VitalDelayArrayType(14 downto 0) := (others => 0 ps);
     tisd_P5EN_P5CLK : VitalDelayType := 0 ps;
     tisd_P5WRDATA_P5CLK : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tisd_P5WRMASK_P5CLK : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_PLLCE_PLLCLK : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_PLLLOCK_PLLCLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_RECAL_PLLCLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_SELFREFRESHENTER_PLLCLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_UIADDR_UICLK : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tisd_UIADD_UICLK : VitalDelayType := 0 ps;
     tisd_UIBROADCAST_UICLK : VitalDelayType := 0 ps;
     tisd_UICMDEN_UICLK : VitalDelayType := 0 ps;
     tisd_UICMDIN_UICLK : VitalDelayType := 0 ps;
     tisd_UICMD_UICLK : VitalDelayType := 0 ps;
     tisd_UICS_UICLK : VitalDelayType := 0 ps;
     tisd_UIDONECAL_UICLK : VitalDelayType := 0 ps;
     tisd_UIDQCOUNT_UICLK : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_UIDQLOWERDEC_UICLK : VitalDelayType := 0 ps;
     tisd_UIDQLOWERINC_UICLK : VitalDelayType := 0 ps;
     tisd_UIDQUPPERDEC_UICLK : VitalDelayType := 0 ps;
     tisd_UIDQUPPERINC_UICLK : VitalDelayType := 0 ps;
     tisd_UIDRPUPDATE_UICLK : VitalDelayType := 0 ps;
     tisd_UILDQSDEC_UICLK : VitalDelayType := 0 ps;
     tisd_UILDQSINC_UICLK : VitalDelayType := 0 ps;
     tisd_UIREAD_UICLK : VitalDelayType := 0 ps;
     tisd_UISDI_UICLK : VitalDelayType := 0 ps;
     tisd_UIUDQSDEC_UICLK : VitalDelayType := 0 ps;
     tisd_UIUDQSINC_UICLK : VitalDelayType := 0 ps;
     tpd_P0CMDCLK_P0CMDEMPTY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P0CMDCLK_P0CMDFULL : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P0RDCLK_P0RDCOUNT : VitalDelayArrayType01(6 downto 0) := (others => (0 ps, 0 ps));
     tpd_P0RDCLK_P0RDDATA : VitalDelayArrayType01(31 downto 0) := (others => (0 ps, 0 ps));
     tpd_P0RDCLK_P0RDEMPTY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P0RDCLK_P0RDERROR : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P0RDCLK_P0RDFULL : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P0RDCLK_P0RDOVERFLOW : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P0WRCLK_P0WRCOUNT : VitalDelayArrayType01(6 downto 0) := (others => (0 ps, 0 ps));
     tpd_P0WRCLK_P0WREMPTY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P0WRCLK_P0WRERROR : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P0WRCLK_P0WRFULL : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P0WRCLK_P0WRUNDERRUN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P1CMDCLK_P1CMDEMPTY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P1CMDCLK_P1CMDFULL : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P1RDCLK_P1RDCOUNT : VitalDelayArrayType01(6 downto 0) := (others => (0 ps, 0 ps));
     tpd_P1RDCLK_P1RDDATA : VitalDelayArrayType01(31 downto 0) := (others => (0 ps, 0 ps));
     tpd_P1RDCLK_P1RDEMPTY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P1RDCLK_P1RDERROR : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P1RDCLK_P1RDFULL : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P1RDCLK_P1RDOVERFLOW : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P1WRCLK_P1WRCOUNT : VitalDelayArrayType01(6 downto 0) := (others => (0 ps, 0 ps));
     tpd_P1WRCLK_P1WREMPTY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P1WRCLK_P1WRERROR : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P1WRCLK_P1WRFULL : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P1WRCLK_P1WRUNDERRUN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P2CLK_P2COUNT : VitalDelayArrayType01(6 downto 0) := (others => (0 ps, 0 ps));
     tpd_P2CLK_P2EMPTY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P2CLK_P2ERROR : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P2CLK_P2FULL : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P2CLK_P2RDDATA : VitalDelayArrayType01(31 downto 0) := (others => (0 ps, 0 ps));
     tpd_P2CLK_P2RDOVERFLOW : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P2CLK_P2WRUNDERRUN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P2CMDCLK_P2CMDEMPTY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P2CMDCLK_P2CMDFULL : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P3CLK_P3COUNT : VitalDelayArrayType01(6 downto 0) := (others => (0 ps, 0 ps));
     tpd_P3CLK_P3EMPTY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P3CLK_P3ERROR : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P3CLK_P3FULL : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P3CLK_P3RDDATA : VitalDelayArrayType01(31 downto 0) := (others => (0 ps, 0 ps));
     tpd_P3CLK_P3RDOVERFLOW : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P3CLK_P3WRUNDERRUN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P3CMDCLK_P3CMDEMPTY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P3CMDCLK_P3CMDFULL : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P4CLK_P4COUNT : VitalDelayArrayType01(6 downto 0) := (others => (0 ps, 0 ps));
     tpd_P4CLK_P4EMPTY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P4CLK_P4ERROR : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P4CLK_P4FULL : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P4CLK_P4RDDATA : VitalDelayArrayType01(31 downto 0) := (others => (0 ps, 0 ps));
     tpd_P4CLK_P4RDOVERFLOW : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P4CLK_P4WRUNDERRUN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P4CMDCLK_P4CMDEMPTY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P4CMDCLK_P4CMDFULL : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P5CLK_P5COUNT : VitalDelayArrayType01(6 downto 0) := (others => (0 ps, 0 ps));
     tpd_P5CLK_P5EMPTY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P5CLK_P5ERROR : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P5CLK_P5FULL : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P5CLK_P5RDDATA : VitalDelayArrayType01(31 downto 0) := (others => (0 ps, 0 ps));
     tpd_P5CLK_P5RDOVERFLOW : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P5CLK_P5WRUNDERRUN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P5CMDCLK_P5CMDEMPTY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_P5CMDCLK_P5CMDFULL : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PLLCLK_DQIOWEN0 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_PLLCLK_DQSIOWEN90N : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_PLLCLK_DQSIOWEN90P : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_PLLCLK_SELFREFRESHMODE : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_UICLK_IOIDRPADD : VitalDelayType01 := (0 ps, 0 ps);
     tpd_UICLK_IOIDRPADDR : VitalDelayArrayType01(4 downto 0) := (others => (0 ps, 0 ps));
     tpd_UICLK_IOIDRPBROADCAST : VitalDelayType01 := (0 ps, 0 ps);
     tpd_UICLK_IOIDRPCLK : VitalDelayType01 := (0 ps, 0 ps);
     tpd_UICLK_IOIDRPCS : VitalDelayType01 := (0 ps, 0 ps);
     tpd_UICLK_IOIDRPSDO : VitalDelayType01 := (0 ps, 0 ps);
     tpd_UICLK_IOIDRPUPDATE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_UICLK_UOCALSTART : VitalDelayType01 := (0 ps, 0 ps);
     tpd_UICLK_UOCMDREADYIN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_UICLK_UODATA : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
     tpd_UICLK_UODATAVALID : VitalDelayType01 := (0 ps, 0 ps);
     tpd_UICLK_UODONECAL : VitalDelayType01 := (0 ps, 0 ps);
     tpd_UICLK_UOREFRSHFLAG : VitalDelayType01 := (0 ps, 0 ps);
     tpd_UICLK_UOSDO : VitalDelayType01 := (0 ps, 0 ps);
     tperiod_P0CMDCLK_posedge : VitalDelayType := 0 ps;
     tperiod_P0RDCLK_posedge : VitalDelayType := 0 ps;
     tperiod_P0WRCLK_posedge : VitalDelayType := 0 ps;
     tperiod_P1CMDCLK_posedge : VitalDelayType := 0 ps;
     tperiod_P1RDCLK_posedge : VitalDelayType := 0 ps;
     tperiod_P1WRCLK_posedge : VitalDelayType := 0 ps;
     tperiod_P2CLK_posedge : VitalDelayType := 0 ps;
     tperiod_P2CMDCLK_posedge : VitalDelayType := 0 ps;
     tperiod_P3CLK_posedge : VitalDelayType := 0 ps;
     tperiod_P3CMDCLK_posedge : VitalDelayType := 0 ps;
     tperiod_P4CLK_posedge : VitalDelayType := 0 ps;
     tperiod_P4CMDCLK_posedge : VitalDelayType := 0 ps;
     tperiod_P5CLK_posedge : VitalDelayType := 0 ps;
     tperiod_P5CMDCLK_posedge : VitalDelayType := 0 ps;
     tperiod_PLLCLK_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tperiod_SYSRST_posedge : VitalDelayType := 0 ps;
     tperiod_UICLK_posedge : VitalDelayType := 0 ps;
     tsetup_IOIDRPSDI_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_IOIDRPSDI_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_P0ARBEN_PLLCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_P0ARBEN_PLLCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_P0CMDBA_P0CMDCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_P0CMDBA_P0CMDCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_P0CMDBL_P0CMDCLK_negedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     tsetup_P0CMDBL_P0CMDCLK_posedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     tsetup_P0CMDCA_P0CMDCLK_negedge_posedge : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
     tsetup_P0CMDCA_P0CMDCLK_posedge_posedge : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
     tsetup_P0CMDEN_P0CMDCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_P0CMDEN_P0CMDCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_P0CMDINSTR_P0CMDCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_P0CMDINSTR_P0CMDCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_P0CMDRA_P0CMDCLK_negedge_posedge : VitalDelayArrayType(14 downto 0) := (others => 0 ps);
     tsetup_P0CMDRA_P0CMDCLK_posedge_posedge : VitalDelayArrayType(14 downto 0) := (others => 0 ps);
     tsetup_P0RDEN_P0RDCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_P0RDEN_P0RDCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_P0RWRMASK_P0WRCLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_P0RWRMASK_P0WRCLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_P0WRDATA_P0WRCLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tsetup_P0WRDATA_P0WRCLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tsetup_P0WREN_P0WRCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_P0WREN_P0WRCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_P1ARBEN_PLLCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_P1ARBEN_PLLCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_P1CMDBA_P1CMDCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_P1CMDBA_P1CMDCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_P1CMDBL_P1CMDCLK_negedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     tsetup_P1CMDBL_P1CMDCLK_posedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     tsetup_P1CMDCA_P1CMDCLK_negedge_posedge : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
     tsetup_P1CMDCA_P1CMDCLK_posedge_posedge : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
     tsetup_P1CMDEN_P1CMDCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_P1CMDEN_P1CMDCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_P1CMDINSTR_P1CMDCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_P1CMDINSTR_P1CMDCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_P1CMDRA_P1CMDCLK_negedge_posedge : VitalDelayArrayType(14 downto 0) := (others => 0 ps);
     tsetup_P1CMDRA_P1CMDCLK_posedge_posedge : VitalDelayArrayType(14 downto 0) := (others => 0 ps);
     tsetup_P1RDEN_P1RDCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_P1RDEN_P1RDCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_P1RWRMASK_P1WRCLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_P1RWRMASK_P1WRCLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_P1WRDATA_P1WRCLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tsetup_P1WRDATA_P1WRCLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tsetup_P1WREN_P1WRCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_P1WREN_P1WRCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_P2ARBEN_PLLCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_P2ARBEN_PLLCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_P2CMDBA_P2CMDCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_P2CMDBA_P2CMDCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_P2CMDBL_P2CMDCLK_negedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     tsetup_P2CMDBL_P2CMDCLK_posedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     tsetup_P2CMDCA_P2CMDCLK_negedge_posedge : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
     tsetup_P2CMDCA_P2CMDCLK_posedge_posedge : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
     tsetup_P2CMDEN_P2CMDCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_P2CMDEN_P2CMDCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_P2CMDINSTR_P2CMDCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_P2CMDINSTR_P2CMDCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_P2CMDRA_P2CMDCLK_negedge_posedge : VitalDelayArrayType(14 downto 0) := (others => 0 ps);
     tsetup_P2CMDRA_P2CMDCLK_posedge_posedge : VitalDelayArrayType(14 downto 0) := (others => 0 ps);
     tsetup_P2EN_P2CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_P2EN_P2CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_P2WRDATA_P2CLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tsetup_P2WRDATA_P2CLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tsetup_P2WRMASK_P2CLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_P2WRMASK_P2CLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_P3ARBEN_PLLCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_P3ARBEN_PLLCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_P3CMDBA_P3CMDCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_P3CMDBA_P3CMDCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_P3CMDBL_P3CMDCLK_negedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     tsetup_P3CMDBL_P3CMDCLK_posedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     tsetup_P3CMDCA_P3CMDCLK_negedge_posedge : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
     tsetup_P3CMDCA_P3CMDCLK_posedge_posedge : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
     tsetup_P3CMDEN_P3CMDCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_P3CMDEN_P3CMDCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_P3CMDINSTR_P3CMDCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_P3CMDINSTR_P3CMDCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_P3CMDRA_P3CMDCLK_negedge_posedge : VitalDelayArrayType(14 downto 0) := (others => 0 ps);
     tsetup_P3CMDRA_P3CMDCLK_posedge_posedge : VitalDelayArrayType(14 downto 0) := (others => 0 ps);
     tsetup_P3EN_P3CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_P3EN_P3CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_P3WRDATA_P3CLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tsetup_P3WRDATA_P3CLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tsetup_P3WRMASK_P3CLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_P3WRMASK_P3CLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_P4ARBEN_PLLCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_P4ARBEN_PLLCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_P4CMDBA_P4CMDCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_P4CMDBA_P4CMDCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_P4CMDBL_P4CMDCLK_negedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     tsetup_P4CMDBL_P4CMDCLK_posedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     tsetup_P4CMDCA_P4CMDCLK_negedge_posedge : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
     tsetup_P4CMDCA_P4CMDCLK_posedge_posedge : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
     tsetup_P4CMDEN_P4CMDCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_P4CMDEN_P4CMDCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_P4CMDINSTR_P4CMDCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_P4CMDINSTR_P4CMDCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_P4CMDRA_P4CMDCLK_negedge_posedge : VitalDelayArrayType(14 downto 0) := (others => 0 ps);
     tsetup_P4CMDRA_P4CMDCLK_posedge_posedge : VitalDelayArrayType(14 downto 0) := (others => 0 ps);
     tsetup_P4EN_P4CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_P4EN_P4CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_P4WRDATA_P4CLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tsetup_P4WRDATA_P4CLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tsetup_P4WRMASK_P4CLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_P4WRMASK_P4CLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_P5ARBEN_PLLCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_P5ARBEN_PLLCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_P5CMDBA_P5CMDCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_P5CMDBA_P5CMDCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_P5CMDBL_P5CMDCLK_negedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     tsetup_P5CMDBL_P5CMDCLK_posedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
     tsetup_P5CMDCA_P5CMDCLK_negedge_posedge : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
     tsetup_P5CMDCA_P5CMDCLK_posedge_posedge : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
     tsetup_P5CMDEN_P5CMDCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_P5CMDEN_P5CMDCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_P5CMDINSTR_P5CMDCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_P5CMDINSTR_P5CMDCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_P5CMDRA_P5CMDCLK_negedge_posedge : VitalDelayArrayType(14 downto 0) := (others => 0 ps);
     tsetup_P5CMDRA_P5CMDCLK_posedge_posedge : VitalDelayArrayType(14 downto 0) := (others => 0 ps);
     tsetup_P5EN_P5CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_P5EN_P5CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_P5WRDATA_P5CLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tsetup_P5WRDATA_P5CLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tsetup_P5WRMASK_P5CLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_P5WRMASK_P5CLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_PLLCE_PLLCLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_PLLCE_PLLCLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_PLLLOCK_PLLCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_PLLLOCK_PLLCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_RECAL_PLLCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_RECAL_PLLCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_SELFREFRESHENTER_PLLCLK_negedge_negedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_SELFREFRESHENTER_PLLCLK_posedge_negedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_UIADDR_UICLK_negedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tsetup_UIADDR_UICLK_posedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tsetup_UIADD_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_UIADD_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_UIBROADCAST_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_UIBROADCAST_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_UICMDEN_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_UICMDEN_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_UICMDIN_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_UICMDIN_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_UICMD_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_UICMD_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_UICS_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_UICS_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_UIDONECAL_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_UIDONECAL_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_UIDQCOUNT_UICLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_UIDQCOUNT_UICLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_UIDQLOWERDEC_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_UIDQLOWERDEC_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_UIDQLOWERINC_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_UIDQLOWERINC_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_UIDQUPPERDEC_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_UIDQUPPERDEC_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_UIDQUPPERINC_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_UIDQUPPERINC_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_UIDRPUPDATE_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_UIDRPUPDATE_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_UILDQSDEC_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_UILDQSDEC_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_UILDQSINC_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_UILDQSINC_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_UIREAD_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_UIREAD_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_UISDI_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_UISDI_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_UIUDQSDEC_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_UIUDQSDEC_UICLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_UIUDQSINC_UICLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_UIUDQSINC_UICLK_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     ADDR : out std_logic_vector(14 downto 0);
     BA : out std_logic_vector(2 downto 0);
     CAS : out std_ulogic;
     CKE : out std_ulogic;
     DQIOWEN0 : out std_ulogic;
     DQON : out std_logic_vector(15 downto 0);
     DQOP : out std_logic_vector(15 downto 0);
     DQSIOWEN90N : out std_ulogic;
     DQSIOWEN90P : out std_ulogic;
     IOIDRPADD : out std_ulogic;
     IOIDRPADDR : out std_logic_vector(4 downto 0);
     IOIDRPBROADCAST : out std_ulogic;
     IOIDRPCLK : out std_ulogic;
     IOIDRPCS : out std_ulogic;
     IOIDRPSDO : out std_ulogic;
     IOIDRPTRAIN : out std_ulogic;
     IOIDRPUPDATE : out std_ulogic;
     LDMN : out std_ulogic;
     LDMP : out std_ulogic;
     ODT : out std_ulogic;
     P0CMDEMPTY : out std_ulogic;
     P0CMDFULL : out std_ulogic;
     P0RDCOUNT : out std_logic_vector(6 downto 0);
     P0RDDATA : out std_logic_vector(31 downto 0);
     P0RDEMPTY : out std_ulogic;
     P0RDERROR : out std_ulogic;
     P0RDFULL : out std_ulogic;
     P0RDOVERFLOW : out std_ulogic;
     P0WRCOUNT : out std_logic_vector(6 downto 0);
     P0WREMPTY : out std_ulogic;
     P0WRERROR : out std_ulogic;
     P0WRFULL : out std_ulogic;
     P0WRUNDERRUN : out std_ulogic;
     P1CMDEMPTY : out std_ulogic;
     P1CMDFULL : out std_ulogic;
     P1RDCOUNT : out std_logic_vector(6 downto 0);
     P1RDDATA : out std_logic_vector(31 downto 0);
     P1RDEMPTY : out std_ulogic;
     P1RDERROR : out std_ulogic;
     P1RDFULL : out std_ulogic;
     P1RDOVERFLOW : out std_ulogic;
     P1WRCOUNT : out std_logic_vector(6 downto 0);
     P1WREMPTY : out std_ulogic;
     P1WRERROR : out std_ulogic;
     P1WRFULL : out std_ulogic;
     P1WRUNDERRUN : out std_ulogic;
     P2CMDEMPTY : out std_ulogic;
     P2CMDFULL : out std_ulogic;
     P2COUNT : out std_logic_vector(6 downto 0);
     P2EMPTY : out std_ulogic;
     P2ERROR : out std_ulogic;
     P2FULL : out std_ulogic;
     P2RDDATA : out std_logic_vector(31 downto 0);
     P2RDOVERFLOW : out std_ulogic;
     P2WRUNDERRUN : out std_ulogic;
     P3CMDEMPTY : out std_ulogic;
     P3CMDFULL : out std_ulogic;
     P3COUNT : out std_logic_vector(6 downto 0);
     P3EMPTY : out std_ulogic;
     P3ERROR : out std_ulogic;
     P3FULL : out std_ulogic;
     P3RDDATA : out std_logic_vector(31 downto 0);
     P3RDOVERFLOW : out std_ulogic;
     P3WRUNDERRUN : out std_ulogic;
     P4CMDEMPTY : out std_ulogic;
     P4CMDFULL : out std_ulogic;
     P4COUNT : out std_logic_vector(6 downto 0);
     P4EMPTY : out std_ulogic;
     P4ERROR : out std_ulogic;
     P4FULL : out std_ulogic;
     P4RDDATA : out std_logic_vector(31 downto 0);
     P4RDOVERFLOW : out std_ulogic;
     P4WRUNDERRUN : out std_ulogic;
     P5CMDEMPTY : out std_ulogic;
     P5CMDFULL : out std_ulogic;
     P5COUNT : out std_logic_vector(6 downto 0);
     P5EMPTY : out std_ulogic;
     P5ERROR : out std_ulogic;
     P5FULL : out std_ulogic;
     P5RDDATA : out std_logic_vector(31 downto 0);
     P5RDOVERFLOW : out std_ulogic;
     P5WRUNDERRUN : out std_ulogic;
     RAS : out std_ulogic;
     RST : out std_ulogic;
     SELFREFRESHMODE : out std_ulogic;
     STATUS : out std_logic_vector(31 downto 0);
     UDMN : out std_ulogic;
     UDMP : out std_ulogic;
     UOCALSTART : out std_ulogic;
     UOCMDREADYIN : out std_ulogic;
     UODATA : out std_logic_vector(7 downto 0);
     UODATAVALID : out std_ulogic;
     UODONECAL : out std_ulogic;
     UOREFRSHFLAG : out std_ulogic;
     UOSDO : out std_ulogic;
     WE : out std_ulogic;
     DQI : in std_logic_vector(15 downto 0);
     DQSIOIN : in std_ulogic;
     DQSIOIP : in std_ulogic;
     IOIDRPSDI : in std_ulogic;
     P0ARBEN : in std_ulogic;
     P0CMDBA : in std_logic_vector(2 downto 0);
     P0CMDBL : in std_logic_vector(5 downto 0);
     P0CMDCA : in std_logic_vector(11 downto 0);
     P0CMDCLK : in std_ulogic;
     P0CMDEN : in std_ulogic;
     P0CMDINSTR : in std_logic_vector(2 downto 0);
     P0CMDRA : in std_logic_vector(14 downto 0);
     P0RDCLK : in std_ulogic;
     P0RDEN : in std_ulogic;
     P0RWRMASK : in std_logic_vector(3 downto 0);
     P0WRCLK : in std_ulogic;
     P0WRDATA : in std_logic_vector(31 downto 0);
     P0WREN : in std_ulogic;
     P1ARBEN : in std_ulogic;
     P1CMDBA : in std_logic_vector(2 downto 0);
     P1CMDBL : in std_logic_vector(5 downto 0);
     P1CMDCA : in std_logic_vector(11 downto 0);
     P1CMDCLK : in std_ulogic;
     P1CMDEN : in std_ulogic;
     P1CMDINSTR : in std_logic_vector(2 downto 0);
     P1CMDRA : in std_logic_vector(14 downto 0);
     P1RDCLK : in std_ulogic;
     P1RDEN : in std_ulogic;
     P1RWRMASK : in std_logic_vector(3 downto 0);
     P1WRCLK : in std_ulogic;
     P1WRDATA : in std_logic_vector(31 downto 0);
     P1WREN : in std_ulogic;
     P2ARBEN : in std_ulogic;
     P2CLK : in std_ulogic;
     P2CMDBA : in std_logic_vector(2 downto 0);
     P2CMDBL : in std_logic_vector(5 downto 0);
     P2CMDCA : in std_logic_vector(11 downto 0);
     P2CMDCLK : in std_ulogic;
     P2CMDEN : in std_ulogic;
     P2CMDINSTR : in std_logic_vector(2 downto 0);
     P2CMDRA : in std_logic_vector(14 downto 0);
     P2EN : in std_ulogic;
     P2WRDATA : in std_logic_vector(31 downto 0);
     P2WRMASK : in std_logic_vector(3 downto 0);
     P3ARBEN : in std_ulogic;
     P3CLK : in std_ulogic;
     P3CMDBA : in std_logic_vector(2 downto 0);
     P3CMDBL : in std_logic_vector(5 downto 0);
     P3CMDCA : in std_logic_vector(11 downto 0);
     P3CMDCLK : in std_ulogic;
     P3CMDEN : in std_ulogic;
     P3CMDINSTR : in std_logic_vector(2 downto 0);
     P3CMDRA : in std_logic_vector(14 downto 0);
     P3EN : in std_ulogic;
     P3WRDATA : in std_logic_vector(31 downto 0);
     P3WRMASK : in std_logic_vector(3 downto 0);
     P4ARBEN : in std_ulogic;
     P4CLK : in std_ulogic;
     P4CMDBA : in std_logic_vector(2 downto 0);
     P4CMDBL : in std_logic_vector(5 downto 0);
     P4CMDCA : in std_logic_vector(11 downto 0);
     P4CMDCLK : in std_ulogic;
     P4CMDEN : in std_ulogic;
     P4CMDINSTR : in std_logic_vector(2 downto 0);
     P4CMDRA : in std_logic_vector(14 downto 0);
     P4EN : in std_ulogic;
     P4WRDATA : in std_logic_vector(31 downto 0);
     P4WRMASK : in std_logic_vector(3 downto 0);
     P5ARBEN : in std_ulogic;
     P5CLK : in std_ulogic;
     P5CMDBA : in std_logic_vector(2 downto 0);
     P5CMDBL : in std_logic_vector(5 downto 0);
     P5CMDCA : in std_logic_vector(11 downto 0);
     P5CMDCLK : in std_ulogic;
     P5CMDEN : in std_ulogic;
     P5CMDINSTR : in std_logic_vector(2 downto 0);
     P5CMDRA : in std_logic_vector(14 downto 0);
     P5EN : in std_ulogic;
     P5WRDATA : in std_logic_vector(31 downto 0);
     P5WRMASK : in std_logic_vector(3 downto 0);
     PLLCE : in std_logic_vector(1 downto 0);
     PLLCLK : in std_logic_vector(1 downto 0);
     PLLLOCK : in std_ulogic;
     RECAL : in std_ulogic;
     SELFREFRESHENTER : in std_ulogic;
     SYSRST : in std_ulogic;
     UDQSIOIN : in std_ulogic;
     UDQSIOIP : in std_ulogic;
     UIADD : in std_ulogic;
     UIADDR : in std_logic_vector(4 downto 0);
     UIBROADCAST : in std_ulogic;
     UICLK : in std_ulogic;
     UICMD : in std_ulogic;
     UICMDEN : in std_ulogic;
     UICMDIN : in std_ulogic;
     UICS : in std_ulogic;
     UIDONECAL : in std_ulogic;
     UIDQCOUNT : in std_logic_vector(3 downto 0);
     UIDQLOWERDEC : in std_ulogic;
     UIDQLOWERINC : in std_ulogic;
     UIDQUPPERDEC : in std_ulogic;
     UIDQUPPERINC : in std_ulogic;
     UIDRPUPDATE : in std_ulogic;
     UILDQSDEC : in std_ulogic;
     UILDQSINC : in std_ulogic;
     UIREAD : in std_ulogic;
     UISDI : in std_ulogic;
     UIUDQSDEC : in std_ulogic;
     UIUDQSINC : in std_ulogic
  );
end component;

----- component X_MMCM_ADV -----
component X_MMCM_ADV
  generic (
     BANDWIDTH : string := "OPTIMIZED";
     CLKFBOUT_MULT_F : real := 5.000;
     CLKFBOUT_PHASE : real := 0.000;
     CLKFBOUT_USE_FINE_PS : boolean := FALSE;
     CLKIN1_PERIOD : real := 0.000;
     CLKIN2_PERIOD : real := 0.000;
     CLKIN_FREQ_MAX : real := 800.0;
     CLKIN_FREQ_MIN : real := 10.0;
     CLKOUT0_DIVIDE_F : real := 1.000;
     CLKOUT0_DUTY_CYCLE : real := 0.500;
     CLKOUT0_PHASE : real := 0.000;
     CLKOUT0_USE_FINE_PS : boolean := FALSE;
     CLKOUT1_DIVIDE : integer := 1;
     CLKOUT1_DUTY_CYCLE : real := 0.500;
     CLKOUT1_PHASE : real := 0.000;
     CLKOUT1_USE_FINE_PS : boolean := FALSE;
     CLKOUT2_DIVIDE : integer := 1;
     CLKOUT2_DUTY_CYCLE : real := 0.500;
     CLKOUT2_PHASE : real := 0.000;
     CLKOUT2_USE_FINE_PS : boolean := FALSE;
     CLKOUT3_DIVIDE : integer := 1;
     CLKOUT3_DUTY_CYCLE : real := 0.500;
     CLKOUT3_PHASE : real := 0.000;
     CLKOUT3_USE_FINE_PS : boolean := FALSE;
     CLKOUT4_CASCADE : boolean := FALSE;
     CLKOUT4_DIVIDE : integer := 1;
     CLKOUT4_DUTY_CYCLE : real := 0.500;
     CLKOUT4_PHASE : real := 0.000;
     CLKOUT4_USE_FINE_PS : boolean := FALSE;
     CLKOUT5_DIVIDE : integer := 1;
     CLKOUT5_DUTY_CYCLE : real := 0.500;
     CLKOUT5_PHASE : real := 0.000;
     CLKOUT5_USE_FINE_PS : boolean := FALSE;
     CLKOUT6_DIVIDE : integer := 1;
     CLKOUT6_DUTY_CYCLE : real := 0.500;
     CLKOUT6_PHASE : real := 0.000;
     CLKOUT6_USE_FINE_PS : boolean := FALSE;
     CLKPFD_FREQ_MAX : real := 550.0;
     CLKPFD_FREQ_MIN : real := 10.0;
     CLOCK_HOLD : boolean := FALSE;
     COMPENSATION : string := "ZHOLD";
     DIVCLK_DIVIDE : integer := 1;
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := FALSE;
     REF_JITTER1 : real := 0.0;
     REF_JITTER2 : real := 0.0;
     STARTUP_WAIT : boolean := FALSE;
     TimingChecksOn : boolean := TRUE;
     VCOCLK_FREQ_MAX : real := 1600.0;
     VCOCLK_FREQ_MIN : real := 600.0;
     Xon : boolean := TRUE;
     thold_DADDR_DCLK_negedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     thold_DADDR_DCLK_posedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     thold_DEN_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_DEN_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_DI_DCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_DI_DCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_DWE_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_DWE_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PSEN_PSCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PSEN_PSCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PSINCDEC_PSCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PSINCDEC_PSCLK_posedge_posedge : VitalDelayType := 0 ps;
     ticd_DCLK : VitalDelayType := 0 ps;
     ticd_PSCLK : VitalDelayType := 0 ps;
     tipd_CLKFBIN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLKIN1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLKIN2 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLKINSEL : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DADDR : VitalDelayArrayType01 (6 downto 0) := (others => (0 ps, 0 ps));
     tipd_DCLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DEN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DI : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
     tipd_DWE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PSCLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PSEN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PSINCDEC : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PWRDWN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RST : VitalDelayType01 := (0 ps, 0 ps);
     tisd_DADDR_DCLK : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     tisd_DEN_DCLK : VitalDelayType := 0 ps;
     tisd_DI_DCLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tisd_DWE_DCLK : VitalDelayType := 0 ps;
     tisd_PSEN_PSCLK : VitalDelayType := 0 ps;
     tisd_PSINCDEC_PSCLK : VitalDelayType := 0 ps;
     tpd_CLKIN1_CLKFBSTOPPED : VitalDelayType01 := (0.100 ns, 0.100 ns);
     tpd_CLKIN1_CLKINSTOPPED : VitalDelayType01 := (0.100 ns, 0.100 ns);
     tpd_CLKIN1_LOCKED : VitalDelayType01 := (0.100 ns, 0.100 ns);
     tpd_CLKIN2_CLKFBSTOPPED : VitalDelayType01 := (0.100 ns, 0.100 ns);
     tpd_CLKIN2_CLKINSTOPPED : VitalDelayType01 := (0.100 ns, 0.100 ns);
     tpd_CLKIN2_LOCKED : VitalDelayType01 := (0.100 ns, 0.100 ns);
     tpd_DCLK_DO : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
     tpd_DCLK_DRDY : VitalDelayType01 := (100 ps, 100 ps);
     tpd_PSCLK_PSDONE : VitalDelayType01 := (0 ps, 0 ps);
     tperiod_CLKIN1_posedge : VitalDelayType := 0 ps;
     tperiod_CLKIN2_posedge : VitalDelayType := 0 ps;
     tperiod_DCLK_posedge : VitalDelayType := 0 ps;
     tperiod_PSCLK_posedge : VitalDelayType := 0 ps;
     tpw_CLKFBIN_negedge : VitalDelayType := 0.000 ns;
     tpw_CLKFBIN_posedge : VitalDelayType := 0.000 ns;
     tpw_CLKIN1_negedge : VitalDelayType := 0.000 ns;
     tpw_CLKIN1_posedge : VitalDelayType := 0.000 ns;
     tpw_CLKIN2_negedge : VitalDelayType := 0.000 ns;
     tpw_CLKIN2_posedge : VitalDelayType := 0.000 ns;
     tpw_DCLK_negedge : VitalDelayType := 0 ps;
     tpw_DCLK_posedge : VitalDelayType := 0 ps;
     tpw_PSCLK_negedge : VitalDelayType := 0 ps;
     tpw_PSCLK_posedge : VitalDelayType := 0 ps;
     tpw_PWRDWN_posedge : VitalDelayType := 0.000 ns;
     tpw_RST_posedge : VitalDelayType := 0.000 ns;
     tsetup_DADDR_DCLK_negedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     tsetup_DADDR_DCLK_posedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
     tsetup_DEN_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_DEN_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_DI_DCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_DI_DCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_DWE_DCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_DWE_DCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PSEN_PSCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PSEN_PSCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PSINCDEC_PSCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PSINCDEC_PSCLK_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     CLKFBOUT : out std_ulogic := '0';
     CLKFBOUTB : out std_ulogic := '0';
     CLKFBSTOPPED : out std_ulogic := '0';
     CLKINSTOPPED : out std_ulogic := '0';
     CLKOUT0 : out std_ulogic := '0';
     CLKOUT0B : out std_ulogic := '0';
     CLKOUT1 : out std_ulogic := '0';
     CLKOUT1B : out std_ulogic := '0';
     CLKOUT2 : out std_ulogic := '0';
     CLKOUT2B : out std_ulogic := '0';
     CLKOUT3 : out std_ulogic := '0';
     CLKOUT3B : out std_ulogic := '0';
     CLKOUT4 : out std_ulogic := '0';
     CLKOUT5 : out std_ulogic := '0';
     CLKOUT6 : out std_ulogic := '0';
     DO : out std_logic_vector (15 downto 0);
     DRDY : out std_ulogic := '0';
     LOCKED : out std_ulogic := '0';
     PSDONE : out std_ulogic := '0';
     CLKFBIN : in std_ulogic;
     CLKIN1 : in std_ulogic;
     CLKIN2 : in std_ulogic;
     CLKINSEL : in std_ulogic;
     DADDR : in std_logic_vector(6 downto 0);
     DCLK : in std_ulogic;
     DEN : in std_ulogic;
     DI : in std_logic_vector(15 downto 0);
     DWE : in std_ulogic;
     PSCLK : in std_ulogic;
     PSEN : in std_ulogic;
     PSINCDEC : in std_ulogic;
     PWRDWN : in std_ulogic;
     RST : in std_ulogic
  );
end component;

----- component X_MULT18X18 -----
component X_MULT18X18
  generic (
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     Xon : boolean := true;
     tpd_A_P : VitalDelayArrayType01 (647 downto 0) := (others => (0 ps, 0 ps))
  );
  port (
     P : out std_logic_vector (35 downto 0);
     A : in std_logic_vector (17 downto 0);
     B : in std_logic_vector (17 downto 0)
  );
end component;

----- component X_MULT18X18S -----
component X_MULT18X18S
  generic (
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     thold_A_C_negedge_posedge : VitalDelayArrayType (17 downto 0) := (others => 0 ps);
     thold_A_C_posedge_posedge : VitalDelayArrayType (17 downto 0) := (others => 0 ps);
     thold_B_C_negedge_posedge : VitalDelayArrayType (17 downto 0) := (others => 0 ps);
     thold_B_C_posedge_posedge : VitalDelayArrayType (17 downto 0) := (others => 0 ps);
     thold_CE_C_negedge_posedge : VitalDelayType := 0.000 ns;
     thold_CE_C_posedge_posedge : VitalDelayType := 0.000 ns;
     thold_R_C_negedge_posedge : VitalDelayType := 0.000 ns;
     thold_R_C_posedge_posedge : VitalDelayType := 0.000 ns;
     ticd_C : VitalDelayType := 0.000 ns;
     tipd_C : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_CE: VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_R : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tisd_A_C : VitalDelayArrayType (17 downto 0) := (others => 0 ps);
     tisd_B_C : VitalDelayArrayType (17 downto 0) := (others => 0 ps);
     tisd_CE_C : VitalDelayType := 0.000 ns;
     tisd_R_C : VitalDelayType := 0.000 ns;
     tpd_C_P : VitalDelayArrayType01 (35 downto 0) := (others => (100 ps, 100 ps));
     tpw_C_negedge : VitalDelayType := 0.000 ns;
     tpw_C_posedge : VitalDelayType := 0.000 ns;
     tsetup_A_C_negedge_posedge : VitalDelayArrayType (17 downto 0) := (others => 0 ps);
     tsetup_A_C_posedge_posedge : VitalDelayArrayType (17 downto 0) := (others => 0 ps);
     tsetup_B_C_negedge_posedge : VitalDelayArrayType (17 downto 0) := (others => 0 ps);
     tsetup_B_C_posedge_posedge : VitalDelayArrayType (17 downto 0) := (others => 0 ps);
     tsetup_CE_C_negedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_CE_C_posedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_R_C_negedge_posedge : VitalDelayType := 0.000 ns;
     tsetup_R_C_posedge_posedge : VitalDelayType := 0.000 ns
  );
  port (
     P : out std_logic_vector (35 downto 0);
     A : in std_logic_vector (17 downto 0);
     B : in std_logic_vector (17 downto 0);
     C : in std_ulogic;
     CE : in std_ulogic;
     R : in std_ulogic
  );
end component;

----- component X_MULT18X18SIO -----
component X_MULT18X18SIO
  generic (
     AREG : integer := 1;
     BREG : integer := 1;
     B_INPUT : string := "DIRECT";
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := false;
     PREG : integer := 1;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     thold_A_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_A_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_BCIN_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_BCIN_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_B_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_B_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     thold_CEA_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEA_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEB_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEB_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CEP_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CEP_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTA_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTA_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTB_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTB_CLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_RSTP_CLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_RSTP_CLK_posedge_posedge : VitalDelayType := 0 ps;
     ticd_CLK : VitalDelayType := 0 ps;
     tipd_CEA : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CEB : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CEP : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RSTA : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RSTB : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RSTP : VitalDelayType01 := (0 ps, 0 ps);
     tisd_A_CLK : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tisd_BCIN_CLK : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tisd_B_CLK : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tisd_CEA_CLK : VitalDelayType := 0 ps;
     tisd_CEB_CLK : VitalDelayType := 0 ps;
     tisd_CEP_CLK : VitalDelayType := 0 ps;
     tisd_RSTA_CLK : VitalDelayType := 0 ps;
     tisd_RSTB_CLK : VitalDelayType := 0 ps;
     tisd_RSTP_CLK : VitalDelayType := 0 ps;
     tpd_CLK_BCOUT : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
     tpd_CLK_P : VitalDelayArrayType01 (35 downto 0) := (others => (0 ps, 0 ps));
     tperiod_CLK_posedge : VitalDelayType := 0 ps;
     tpw_CLK_negedge : VitalDelayType := 0 ps;
     tpw_CLK_posedge : VitalDelayType := 0 ps;
     tsetup_A_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_A_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_BCIN_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_BCIN_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_B_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_B_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
     tsetup_CEA_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEA_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEB_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEB_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEP_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CEP_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTA_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTA_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTB_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTB_CLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTP_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RSTP_CLK_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     BCOUT : out std_logic_vector (17 downto 0);
     P : out std_logic_vector (35 downto 0);
     A : in std_logic_vector (17 downto 0);
     B : in std_logic_vector (17 downto 0);
     BCIN : in std_logic_vector (17 downto 0);
     CEA : in std_ulogic;
     CEB : in std_ulogic;
     CEP : in std_ulogic;
     CLK : in std_ulogic;
     RSTA : in std_ulogic;
     RSTB : in std_ulogic;
     RSTP : in std_ulogic
  );
end component;

----- component X_MUX2 -----
component X_MUX2
  generic (
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     Xon : boolean := true;
     tipd_IA : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_IB : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_SEL : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_IA_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_IB_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_SEL_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     IA : in std_ulogic;
     IB : in std_ulogic;
     SEL : in std_ulogic
  );
end component;

----- component X_OBUF -----
component X_OBUF
  generic (
     CAPACITANCE : string := "DONT_CARE";
     DRIVE : integer := 12;
     IOSTANDARD : string := "DEFAULT";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     PATHPULSE : time := 0 ps;
     SLEW : string := "SLOW";
     Xon : boolean := true;
     tipd_I : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;

----- component X_OBUFDS -----
component X_OBUFDS
  generic (
     CAPACITANCE : string := "DONT_CARE";
     IOSTANDARD : string := "DEFAULT";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     PATHPULSE : time := 0 ps;
     Xon : boolean := true;
     tipd_I : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I_OB : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     OB : out std_ulogic;
     I : in std_ulogic
  );
end component;

----- component X_OBUFT -----
component X_OBUFT
  generic (
     CAPACITANCE : string := "DONT_CARE";
     DRIVE : integer := 12;
     IOSTANDARD : string := "DEFAULT";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     PATHPULSE : time := 0 ps;
     SLEW : string := "SLOW";
     Xon : boolean := true;
     tipd_CTL : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_CTL_O : VitalDelayType01z := (0.000 ns, 0.000 ns, 0.000 ns, 0.000 ns, 0.000 ns, 0.000 ns);
     tpd_I_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     CTL : in std_ulogic;
     I : in std_ulogic
  );
end component;

----- component X_OBUFTDS -----
component X_OBUFTDS
  generic (
     CAPACITANCE : string := "DONT_CARE";
     IOSTANDARD : string := "DEFAULT";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     PATHPULSE : time := 0 ps;
     Xon : boolean := true;
     tipd_I : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_T : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I_OB : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_T_O : VitalDelayType01z := (0.000 ns, 0.000 ns, 0.000 ns, 0.000 ns, 0.000 ns, 0.000 ns);
     tpd_T_OB : VitalDelayType01z := (0.000 ns, 0.000 ns, 0.000 ns, 0.000 ns, 0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     OB : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;

----- component X_ODDR -----
component X_ODDR
  generic (
     DDR_CLK_EDGE : string := "OPPOSITE_EDGE";
     INIT : bit := '0';
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     SRTYPE : string := "SYNC";
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     thold_CE_C_negedge_negedge : VitalDelayType := 0.0 ps;
     thold_CE_C_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE_C_posedge_negedge : VitalDelayType := 0.0 ps;
     thold_CE_C_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_D1_C_negedge_negedge : VitalDelayType := 0.0 ps;
     thold_D1_C_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_D1_C_posedge_negedge : VitalDelayType := 0.0 ps;
     thold_D1_C_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_D2_C_negedge_negedge : VitalDelayType := 0.0 ps;
     thold_D2_C_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_D2_C_posedge_negedge : VitalDelayType := 0.0 ps;
     thold_D2_C_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_R_C_negedge_negedge : VitalDelayType := 0 ps;
     thold_R_C_negedge_posedge : VitalDelayType := 0 ps;
     thold_R_C_posedge_negedge : VitalDelayType := 0 ps;
     thold_R_C_posedge_posedge : VitalDelayType := 0 ps;
     thold_S_C_negedge_negedge : VitalDelayType := 0 ps;
     thold_S_C_negedge_posedge : VitalDelayType := 0 ps;
     thold_S_C_posedge_negedge : VitalDelayType := 0 ps;
     thold_S_C_posedge_posedge : VitalDelayType := 0 ps;
     ticd_C : VitalDelayType := 0.0 ps;
     tipd_C : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_D1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_D2 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_R : VitalDelayType01 := (0 ps, 0 ps);
     tipd_S : VitalDelayType01 := (0 ps, 0 ps);
     tisd_CE_C : VitalDelayType := 0.0 ps;
     tisd_D1_C : VitalDelayType := 0.0 ps;
     tisd_D2_C : VitalDelayType := 0.0 ps;
     tisd_R_C : VitalDelayType := 0.0 ps;
     tisd_S_C : VitalDelayType := 0.0 ps;
     tpd_C_Q : VitalDelayType01 := (100 ps, 100 ps);
     tpd_R_Q : VitalDelayType01 := (0 ps, 0 ps);
     tpd_S_Q : VitalDelayType01 := (0 ps, 0 ps);
     tperiod_C_posedge : VitalDelayType := 0 ps;
     tpw_C_negedge : VitalDelayType := 0 ps;
     tpw_C_posedge : VitalDelayType := 0 ps;
     tpw_R_negedge : VitalDelayType := 0 ps;
     tpw_R_posedge : VitalDelayType := 0 ps;
     tpw_S_negedge : VitalDelayType := 0 ps;
     tpw_S_posedge : VitalDelayType := 0 ps;
     trecovery_R_C_negedge_negedge : VitalDelayType := 0 ps;
     trecovery_R_C_negedge_posedge : VitalDelayType := 0 ps;
     trecovery_S_C_negedge_negedge : VitalDelayType := 0 ps;
     trecovery_S_C_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_R_C_negedge_negedge : VitalDelayType := 0 ps;
     tremoval_R_C_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_S_C_negedge_negedge : VitalDelayType := 0 ps;
     tremoval_S_C_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CE_C_negedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_CE_C_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE_C_posedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_CE_C_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D1_C_negedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_D1_C_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D1_C_posedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_D1_C_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D2_C_negedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_D2_C_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D2_C_posedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_D2_C_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_R_C_negedge_negedge : VitalDelayType := 0 ps;
     tsetup_R_C_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_R_C_posedge_negedge : VitalDelayType := 0 ps;
     tsetup_R_C_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_S_C_negedge_negedge : VitalDelayType := 0 ps;
     tsetup_S_C_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_S_C_posedge_negedge : VitalDelayType := 0 ps;
     tsetup_S_C_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     Q : out std_ulogic;
     C : in std_ulogic;
     CE : in std_ulogic;
     D1 : in std_ulogic;
     D2 : in std_ulogic;
     R : in std_ulogic := 'L';
     S : in std_ulogic := 'L'
  );
end component;

----- component X_ODDR2 -----
component X_ODDR2
  generic (
     DDR_ALIGNMENT : string := "NONE";
     INIT : bit := '0';
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     SRTYPE : string := "SYNC";
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     tbpd_R_Q_C0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tbpd_S_Q_C0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     thold_CE_C0_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE_C0_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE_C1_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_CE_C1_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_D0_C0_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_D0_C0_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_D0_C1_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_D0_C1_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_D1_C0_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_D1_C0_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_D1_C1_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_D1_C1_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_R_C0_negedge_posedge : VitalDelayType := 0 ps;
     thold_R_C0_posedge_posedge : VitalDelayType := 0 ps;
     thold_R_C1_negedge_posedge : VitalDelayType := 0 ps;
     thold_R_C1_posedge_posedge : VitalDelayType := 0 ps;
     thold_S_C0_negedge_posedge : VitalDelayType := 0 ps;
     thold_S_C0_posedge_posedge : VitalDelayType := 0 ps;
     thold_S_C1_negedge_posedge : VitalDelayType := 0 ps;
     thold_S_C1_posedge_posedge : VitalDelayType := 0 ps;
     ticd_C0 : VitalDelayType := 0.0 ps;
     ticd_C1 : VitalDelayType := 0.0 ps;
     tipd_C0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_C1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_D0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_D1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_R : VitalDelayType01 := (0 ps, 0 ps);
     tipd_S : VitalDelayType01 := (0 ps, 0 ps);
     tisd_CE_C0 : VitalDelayType := 0.0 ps;
     tisd_CE_C1 : VitalDelayType := 0.0 ps;
     tisd_D0_C0 : VitalDelayType := 0.0 ps;
     tisd_D0_C1 : VitalDelayType := 0.0 ps;
     tisd_D1_C0 : VitalDelayType := 0.0 ps;
     tisd_D1_C1 : VitalDelayType := 0.0 ps;
     tisd_R_C0 : VitalDelayType := 0.0 ps;
     tisd_R_C1 : VitalDelayType := 0.0 ps;
     tisd_S_C0 : VitalDelayType := 0.0 ps;
     tisd_S_C1 : VitalDelayType := 0.0 ps;
     tpd_C0_Q : VitalDelayType01 := (100 ps, 100 ps);
     tpd_C1_Q : VitalDelayType01 := (100 ps, 100 ps);
     tpd_R_Q : VitalDelayType01 := (0 ps, 0 ps);
     tpd_S_Q : VitalDelayType01 := (0 ps, 0 ps);
     tperiod_C0_posedge : VitalDelayType := 0 ps;
     tperiod_C1_posedge : VitalDelayType := 0 ps;
     tpw_C0_negedge : VitalDelayType := 0 ps;
     tpw_C0_posedge : VitalDelayType := 0 ps;
     tpw_C1_negedge : VitalDelayType := 0 ps;
     tpw_C1_posedge : VitalDelayType := 0 ps;
     tpw_R_posedge : VitalDelayType := 0 ps;
     tpw_S_posedge : VitalDelayType := 0 ps;
     trecovery_R_C0_negedge_posedge : VitalDelayType := 0 ps;
     trecovery_R_C1_negedge_posedge : VitalDelayType := 0 ps;
     trecovery_S_C0_negedge_posedge : VitalDelayType := 0 ps;
     trecovery_S_C1_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_R_C0_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_R_C1_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_S_C0_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_S_C1_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CE_C0_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE_C0_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE_C1_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_CE_C1_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D0_C0_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D0_C0_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D0_C1_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D0_C1_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D1_C0_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D1_C0_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D1_C1_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D1_C1_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_R_C0_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_R_C0_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_R_C1_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_R_C1_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_S_C0_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_S_C0_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_S_C1_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_S_C1_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     Q : out std_ulogic;
     C0 : in std_ulogic;
     C1 : in std_ulogic;
     CE : in std_ulogic := 'H';
     D0 : in std_ulogic;
     D1 : in std_ulogic;
     R : in std_ulogic := 'L';
     S : in std_ulogic := 'L'
  );
end component;

----- component X_ONE -----
component X_ONE
  generic (
     LOC : string := "UNPLACED"
  );
  port (
     O : out std_ulogic := '1'
  );
end component;

----- component X_OPAD -----
component X_OPAD
  generic (
     LOC : string := "UNPLACED"
  );
  port (
     PAD : out std_ulogic
  );
end component;

----- component X_OR16 -----
component X_OR16
  generic (
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     Xon : boolean := true;
     tipd_I0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I10 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I11 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I12 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I13 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I14 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I15 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I2 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I3 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I4 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I5 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I6 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I7 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I8 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I9 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I0_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I10_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I11_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I12_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I13_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I14_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I15_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I1_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I2_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I3_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I4_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I5_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I6_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I7_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I8_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I9_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I10 : in std_ulogic;
     I11 : in std_ulogic;
     I12 : in std_ulogic;
     I13 : in std_ulogic;
     I14 : in std_ulogic;
     I15 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic;
     I5 : in std_ulogic;
     I6 : in std_ulogic;
     I7 : in std_ulogic;
     I8 : in std_ulogic;
     I9 : in std_ulogic
  );
end component;

----- component X_OR2 -----
component X_OR2
  generic (
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     Xon : boolean := true;
     tipd_I0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I0_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I1_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic
  );
end component;

----- component X_OR2L -----
component X_OR2L
  generic (
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     Xon : boolean := true;
     tipd_DI : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_SRI : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_DI_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_SRI_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     DI : in std_ulogic;
     SRI : in std_ulogic
  );
end component;

----- component X_OR3 -----
component X_OR3
  generic (
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     Xon : boolean := true;
     tipd_I0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I2 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I0_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I1_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I2_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic
  );
end component;

----- component X_OR32 -----
component X_OR32
  generic (
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     Xon : boolean := true;
     tipd_I0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I10 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I11 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I12 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I13 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I14 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I15 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I16 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I17 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I18 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I19 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I2 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I20 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I21 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I22 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I23 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I24 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I25 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I26 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I27 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I28 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I29 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I3 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I30 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I31 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I4 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I5 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I6 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I7 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I8 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I9 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I0_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I10_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I11_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I12_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I13_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I14_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I15_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I16_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I17_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I18_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I19_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I1_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I20_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I21_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I22_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I23_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I24_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I25_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I26_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I27_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I28_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I29_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I2_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I30_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I31_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I3_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I4_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I5_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I6_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I7_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I8_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I9_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I10 : in std_ulogic;
     I11 : in std_ulogic;
     I12 : in std_ulogic;
     I13 : in std_ulogic;
     I14 : in std_ulogic;
     I15 : in std_ulogic;
     I16 : in std_ulogic;
     I17 : in std_ulogic;
     I18 : in std_ulogic;
     I19 : in std_ulogic;
     I2 : in std_ulogic;
     I20 : in std_ulogic;
     I21 : in std_ulogic;
     I22 : in std_ulogic;
     I23 : in std_ulogic;
     I24 : in std_ulogic;
     I25 : in std_ulogic;
     I26 : in std_ulogic;
     I27 : in std_ulogic;
     I28 : in std_ulogic;
     I29 : in std_ulogic;
     I3 : in std_ulogic;
     I30 : in std_ulogic;
     I31 : in std_ulogic;
     I4 : in std_ulogic;
     I5 : in std_ulogic;
     I6 : in std_ulogic;
     I7 : in std_ulogic;
     I8 : in std_ulogic;
     I9 : in std_ulogic
  );
end component;

----- component X_OR4 -----
component X_OR4
  generic (
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     Xon : boolean := true;
     tipd_I0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I2 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I3 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I0_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I1_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I2_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I3_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic
  );
end component;

----- component X_OR5 -----
component X_OR5
  generic (
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     Xon : boolean := true;
     tipd_I0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I2 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I3 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I4 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I0_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I1_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I2_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I3_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I4_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic
  );
end component;

----- component X_OR6 -----
component X_OR6
  generic (
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     Xon : boolean := true;
     tipd_I0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I2 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I3 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I4 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I5 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I0_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I1_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I2_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I3_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I4_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I5_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic;
     I5 : in std_ulogic
  );
end component;

----- component X_OR7 -----
component X_OR7
  generic (
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     Xon : boolean := true;
     tipd_I0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I2 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I3 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I4 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I5 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I6 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I0_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I1_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I2_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I3_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I4_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I5_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I6_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic;
     I5 : in std_ulogic;
     I6 : in std_ulogic
  );
end component;

----- component X_OR8 -----
component X_OR8
  generic (
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     Xon : boolean := true;
     tipd_I0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I2 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I3 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I4 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I5 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I6 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I7 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I0_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I1_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I2_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I3_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I4_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I5_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I6_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I7_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic;
     I5 : in std_ulogic;
     I6 : in std_ulogic;
     I7 : in std_ulogic
  );
end component;

----- component X_OR9 -----
component X_OR9
  generic (
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     Xon : boolean := true;
     tipd_I0 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I1 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I2 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I3 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I4 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I5 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I6 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I7 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tipd_I8 : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I0_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I1_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I2_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I3_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I4_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I5_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I6_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I7_O : VitalDelayType01 := (0.000 ns, 0.000 ns);
     tpd_I8_O : VitalDelayType01 := (0.000 ns, 0.000 ns)
  );
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic;
     I5 : in std_ulogic;
     I6 : in std_ulogic;
     I7 : in std_ulogic;
     I8 : in std_ulogic
  );
end component;

----- component X_OSERDES -----
component X_OSERDES
  generic (
     DATA_RATE_OQ : string := "DDR";
     DATA_RATE_TQ : string := "DDR";
     DATA_WIDTH : integer := 4;
     INIT_OQ : bit := '0';
     INIT_TQ : bit := '0';
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     SERDES_MODE : string := "MASTER";
     SRVAL_OQ : bit := '0';
     SRVAL_TQ : bit := '0';
     TRISTATE_WIDTH : integer := 4;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     tbpd_REV_OQ_CLKDIV : VitalDelayType01 := (0 ps, 0 ps);
     tbpd_REV_TQ_CLKDIV : VitalDelayType01 := (0 ps, 0 ps);
     tbpd_SR_OQ_CLKDIV : VitalDelayType01 := (0 ps, 0 ps);
     tbpd_SR_TQ_CLKDIV : VitalDelayType01 := (0 ps, 0 ps);
     tbpd_T1_TQ_CLK : VitalDelayType01 := (100 ps, 100 ps);
     thold_D1_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_D1_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_D2_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_D2_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_D3_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_D3_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_D4_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_D4_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_D5_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_D5_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_D6_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_D6_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_OCE_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_OCE_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_REV_CLKDIV_negedge_negedge : VitalDelayType := 0.0 ps;
     thold_REV_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_REV_CLKDIV_posedge_negedge : VitalDelayType := 0.0 ps;
     thold_REV_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_SR_CLKDIV_negedge_negedge : VitalDelayType := 0.0 ps;
     thold_SR_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_SR_CLKDIV_posedge_negedge : VitalDelayType := 0.0 ps;
     thold_SR_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_T1_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_T1_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_T1_CLK_negedge_negedge : VitalDelayType := 0.0 ps;
     thold_T1_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_T1_CLK_posedge_negedge : VitalDelayType := 0.0 ps;
     thold_T1_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_T2_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_T2_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_T2_CLK_negedge_negedge : VitalDelayType := 0.0 ps;
     thold_T2_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_T2_CLK_posedge_negedge : VitalDelayType := 0.0 ps;
     thold_T2_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_T3_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_T3_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_T4_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_T4_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_TCE_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_TCE_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     ticd_CLK : VitalDelayType := 0.0 ps;
     ticd_CLKDIV : VitalDelayType := 0.0 ps;
     tipd_CLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLKDIV : VitalDelayType01 := (0 ps, 0 ps);
     tipd_D1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_D2 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_D3 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_D4 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_D5 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_D6 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_OCE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_REV : VitalDelayType01 := (0 ps, 0 ps);
     tipd_SHIFTIN1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_SHIFTIN2 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_SR : VitalDelayType01 := (0 ps, 0 ps);
     tipd_T1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_T2 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_T3 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_T4 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TCE : VitalDelayType01 := (0 ps, 0 ps);
     tisd_D1_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_D2_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_D3_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_D4_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_D5_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_D6_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_OCE_CLK : VitalDelayType := 0.0 ps;
     tisd_REV_CLK : VitalDelayType := 0.0 ps;
     tisd_REV_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_SHIFTIN1_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_SHIFTIN2_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_SR_CLK : VitalDelayType := 0.0 ps;
     tisd_SR_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_T1_CLK : VitalDelayType := 0.0 ps;
     tisd_T1_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_T2_CLK : VitalDelayType := 0.0 ps;
     tisd_T2_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_T3_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_T4_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_TCE_CLK : VitalDelayType := 0.0 ps;
     tpd_CLK_OQ : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK_SHIFTOUT1 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK_SHIFTOUT2 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK_TQ : VitalDelayType01 := (100 ps, 100 ps);
     tpd_REV_OQ : VitalDelayType01 := (0 ps, 0 ps);
     tpd_REV_TQ : VitalDelayType01 := (0 ps, 0 ps);
     tpd_SR_OQ : VitalDelayType01 := (0 ps, 0 ps);
     tpd_SR_TQ : VitalDelayType01 := (0 ps, 0 ps);
     tpd_T1_TQ : VitalDelayType01 := (100 ps, 100 ps);
     tperiod_CLKDIV_posedge : VitalDelayType := 0 ps;
     tperiod_CLK_posedge : VitalDelayType := 0 ps;
     tpw_CLKDIV_negedge : VitalDelayType := 0 ps;
     tpw_CLKDIV_posedge : VitalDelayType := 0 ps;
     tpw_CLK_negedge : VitalDelayType := 0 ps;
     tpw_CLK_posedge : VitalDelayType := 0 ps;
     tpw_REV_posedge : VitalDelayType := 0 ps;
     tpw_SR_posedge : VitalDelayType := 0 ps;
     trecovery_REV_CLK_negedge_negedge : VitalDelayType := 0 ps;
     trecovery_REV_CLK_negedge_posedge : VitalDelayType := 0 ps;
     trecovery_SR_CLKDIV_negedge_posedge : VitalDelayType := 0 ps;
     trecovery_SR_CLK_negedge_negedge : VitalDelayType := 0 ps;
     trecovery_SR_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_REV_CLK_negedge_negedge : VitalDelayType := 0 ps;
     tremoval_REV_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_SR_CLKDIV_negedge_posedge : VitalDelayType := 0 ps;
     tremoval_SR_CLK_negedge_negedge : VitalDelayType := 0 ps;
     tremoval_SR_CLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_D1_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D1_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D2_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D2_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D3_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D3_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D4_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D4_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D5_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D5_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D6_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D6_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_OCE_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_OCE_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_REV_CLKDIV_negedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_REV_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_REV_CLKDIV_posedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_REV_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_SR_CLKDIV_negedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_SR_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_SR_CLKDIV_posedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_SR_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_T1_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_T1_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_T1_CLK_negedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_T1_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_T1_CLK_posedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_T1_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_T2_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_T2_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_T2_CLK_negedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_T2_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_T2_CLK_posedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_T2_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_T3_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_T3_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_T4_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_T4_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_TCE_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_TCE_CLK_posedge_posedge : VitalDelayType := 0.0 ps
  );
  port (
     OQ : out std_ulogic;
     SHIFTOUT1 : out std_ulogic;
     SHIFTOUT2 : out std_ulogic;
     TQ : out std_ulogic;
     CLK : in std_ulogic;
     CLKDIV : in std_ulogic;
     D1 : in std_ulogic;
     D2 : in std_ulogic;
     D3 : in std_ulogic;
     D4 : in std_ulogic;
     D5 : in std_ulogic;
     D6 : in std_ulogic;
     OCE : in std_ulogic;
     REV : in std_ulogic;
     SHIFTIN1 : in std_ulogic;
     SHIFTIN2 : in std_ulogic;
     SR : in std_ulogic;
     T1 : in std_ulogic;
     T2 : in std_ulogic;
     T3 : in std_ulogic;
     T4 : in std_ulogic;
     TCE : in std_ulogic
  );
end component;

----- component X_OSERDES2 -----
component X_OSERDES2
  generic (
     BYPASS_GCLK_FF : boolean := FALSE;
     DATA_RATE_OQ : string := "DDR";
     DATA_RATE_OT : string := "DDR";
     DATA_WIDTH : integer := 2;
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := FALSE;
     OUTPUT_MODE : string := "SINGLE_ENDED";
     SERDES_MODE : string := "NONE";
     TRAIN_PATTERN : integer := 0;
     TimingChecksOn : boolean := TRUE;
     Xon : boolean := TRUE;
     thold_D1_CLKDIV_negedge_posedge : VitalDelayType := 0 ps;
     thold_D1_CLKDIV_posedge_posedge : VitalDelayType := 0 ps;
     thold_D2_CLKDIV_negedge_posedge : VitalDelayType := 0 ps;
     thold_D2_CLKDIV_posedge_posedge : VitalDelayType := 0 ps;
     thold_D3_CLKDIV_negedge_posedge : VitalDelayType := 0 ps;
     thold_D3_CLKDIV_posedge_posedge : VitalDelayType := 0 ps;
     thold_D4_CLKDIV_negedge_posedge : VitalDelayType := 0 ps;
     thold_D4_CLKDIV_posedge_posedge : VitalDelayType := 0 ps;
     thold_OCE_CLKDIV_negedge_posedge : VitalDelayType := 0 ps;
     thold_OCE_CLKDIV_posedge_posedge : VitalDelayType := 0 ps;
     thold_RST_CLKDIV_negedge_posedge : VitalDelayType := 0 ps;
     thold_RST_CLKDIV_posedge_posedge : VitalDelayType := 0 ps;
     thold_T1_CLKDIV_negedge_posedge : VitalDelayType := 0 ps;
     thold_T1_CLKDIV_posedge_posedge : VitalDelayType := 0 ps;
     thold_T2_CLKDIV_negedge_posedge : VitalDelayType := 0 ps;
     thold_T2_CLKDIV_posedge_posedge : VitalDelayType := 0 ps;
     thold_T3_CLKDIV_negedge_posedge : VitalDelayType := 0 ps;
     thold_T3_CLKDIV_posedge_posedge : VitalDelayType := 0 ps;
     thold_T4_CLKDIV_negedge_posedge : VitalDelayType := 0 ps;
     thold_T4_CLKDIV_posedge_posedge : VitalDelayType := 0 ps;
     thold_TCE_CLKDIV_negedge_posedge : VitalDelayType := 0 ps;
     thold_TCE_CLKDIV_posedge_posedge : VitalDelayType := 0 ps;
     thold_TRAIN_CLK0_negedge_posedge : VitalDelayType := 0 ps;
     thold_TRAIN_CLK0_posedge_posedge : VitalDelayType := 0 ps;
     thold_TRAIN_CLK1_negedge_posedge : VitalDelayType := 0 ps;
     thold_TRAIN_CLK1_posedge_posedge : VitalDelayType := 0 ps;
     ticd_CLK0 : VitalDelayType := 0 ps;
     ticd_CLK1 : VitalDelayType := 0 ps;
     ticd_CLKDIV : VitalDelayType := 0 ps;
     tipd_CLK0 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLK1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLKDIV : VitalDelayType01 := (0 ps, 0 ps);
     tipd_D1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_D2 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_D3 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_D4 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_IOCE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_OCE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RST : VitalDelayType01 := (0 ps, 0 ps);
     tipd_SHIFTIN1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_SHIFTIN2 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_SHIFTIN3 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_SHIFTIN4 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_T1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_T2 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_T3 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_T4 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TCE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TRAIN : VitalDelayType01 := (0 ps, 0 ps);
     tisd_D1_CLKDIV : VitalDelayType := 0 ps;
     tisd_D2_CLKDIV : VitalDelayType := 0 ps;
     tisd_D3_CLKDIV : VitalDelayType := 0 ps;
     tisd_D4_CLKDIV : VitalDelayType := 0 ps;
     tisd_OCE_CLKDIV : VitalDelayType := 0 ps;
     tisd_RST_CLKDIV : VitalDelayType := 0 ps;
     tisd_T1_CLKDIV : VitalDelayType := 0 ps;
     tisd_T2_CLKDIV : VitalDelayType := 0 ps;
     tisd_T3_CLKDIV : VitalDelayType := 0 ps;
     tisd_T4_CLKDIV : VitalDelayType := 0 ps;
     tisd_TCE_CLKDIV : VitalDelayType := 0 ps;
     tisd_TRAIN_CLK0 : VitalDelayType := 0 ps;
     tisd_TRAIN_CLK1 : VitalDelayType := 0 ps;
     tpd_CLK0_OQ : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CLK0_TQ : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CLK1_OQ : VitalDelayType01 := (0 ps, 0 ps);
     tpd_CLK1_TQ : VitalDelayType01 := (0 ps, 0 ps);
     tsetup_D1_CLKDIV_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_D1_CLKDIV_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_D2_CLKDIV_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_D2_CLKDIV_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_D3_CLKDIV_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_D3_CLKDIV_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_D4_CLKDIV_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_D4_CLKDIV_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_OCE_CLKDIV_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_OCE_CLKDIV_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_RST_CLKDIV_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_RST_CLKDIV_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_T1_CLKDIV_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_T1_CLKDIV_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_T2_CLKDIV_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_T2_CLKDIV_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_T3_CLKDIV_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_T3_CLKDIV_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_T4_CLKDIV_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_T4_CLKDIV_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TCE_CLKDIV_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TCE_CLKDIV_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRAIN_CLK0_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRAIN_CLK0_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRAIN_CLK1_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRAIN_CLK1_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     OQ : out std_ulogic;
     SHIFTOUT1 : out std_ulogic;
     SHIFTOUT2 : out std_ulogic;
     SHIFTOUT3 : out std_ulogic;
     SHIFTOUT4 : out std_ulogic;
     TQ : out std_ulogic;
     CLK0 : in std_ulogic;
     CLK1 : in std_ulogic;
     CLKDIV : in std_ulogic;
     D1 : in std_ulogic;
     D2 : in std_ulogic;
     D3 : in std_ulogic;
     D4 : in std_ulogic;
     IOCE : in std_ulogic := 'H';
     OCE : in std_ulogic := 'H';
     RST : in std_ulogic;
     SHIFTIN1 : in std_ulogic;
     SHIFTIN2 : in std_ulogic;
     SHIFTIN3 : in std_ulogic;
     SHIFTIN4 : in std_ulogic;
     T1 : in std_ulogic;
     T2 : in std_ulogic;
     T3 : in std_ulogic;
     T4 : in std_ulogic;
     TCE : in std_ulogic;
     TRAIN : in std_ulogic
  );
end component;

----- component X_OSERDESE1 -----
component X_OSERDESE1
  generic (
     DATA_RATE_OQ : string := "DDR";
     DATA_RATE_TQ : string := "DDR";
     DATA_WIDTH : integer := 4;
     DDR3_DATA : integer := 1;
     INIT_OQ : bit := '0';
     INIT_TQ : bit := '0';
     INTERFACE_TYPE : string := "DEFAULT";
     InstancePath : string := "*";
     LOC : string := "UNPLACED";
     MsgOn : boolean := true;
     ODELAY_USED : integer := 0;
     SERDES_MODE : string := "MASTER";
     SRVAL_OQ : bit := '0';
     SRVAL_TQ : bit := '0';
     TRISTATE_WIDTH : integer := 4;
     TimingChecksOn : boolean := true;
     Xon : boolean := true;
     tbpd_T1_TQ_CLK : VitalDelayType01 := (100 ps, 100 ps);
     thold_D1_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_D1_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_D2_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_D2_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_D3_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_D3_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_D4_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_D4_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_D5_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_D5_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_D6_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_D6_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_OCE_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_OCE_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_ODV_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_ODV_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_RST_CLKDIV_negedge_negedge : VitalDelayType := 0.0 ps;
     thold_RST_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_RST_CLKDIV_posedge_negedge : VitalDelayType := 0.0 ps;
     thold_RST_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_T1_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_T1_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_T1_CLK_negedge_negedge : VitalDelayType := 0.0 ps;
     thold_T1_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_T1_CLK_posedge_negedge : VitalDelayType := 0.0 ps;
     thold_T1_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_T2_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_T2_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_T2_CLK_negedge_negedge : VitalDelayType := 0.0 ps;
     thold_T2_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_T2_CLK_posedge_negedge : VitalDelayType := 0.0 ps;
     thold_T2_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_T3_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_T3_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_T4_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_T4_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_TCE_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_TCE_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     thold_WC_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     thold_WC_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     ticd_CLK : VitalDelayType := 0.0 ps;
     ticd_CLKDIV : VitalDelayType := 0.0 ps;
     ticd_CLKPERF : VitalDelayType := 0.0 ps;
     ticd_CLKPERFDELAY : VitalDelayType := 0.0 ps;
     tipd_CLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLKDIV : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLKPERF : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CLKPERFDELAY : VitalDelayType01 := (0 ps, 0 ps);
     tipd_D1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_D2 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_D3 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_D4 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_D5 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_D6 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_OCE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_ODV : VitalDelayType01 := (0 ps, 0 ps);
     tipd_RST : VitalDelayType01 := (0 ps, 0 ps);
     tipd_SHIFTIN1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_SHIFTIN2 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_T1 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_T2 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_T3 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_T4 : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TCE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_WC : VitalDelayType01 := (0 ps, 0 ps);
     tisd_D1_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_D2_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_D3_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_D4_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_D5_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_D6_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_OCE_CLK : VitalDelayType := 0.0 ps;
     tisd_ODV_CLK : VitalDelayType := 0.0 ps;
     tisd_RST_CLK : VitalDelayType := 0.0 ps;
     tisd_RST_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_SHIFTIN1_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_SHIFTIN2_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_T1_CLK : VitalDelayType := 0.0 ps;
     tisd_T1_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_T2_CLK : VitalDelayType := 0.0 ps;
     tisd_T2_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_T3_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_T4_CLKDIV : VitalDelayType := 0.0 ps;
     tisd_TCE_CLK : VitalDelayType := 0.0 ps;
     tisd_WC_CLKDIV : VitalDelayType := 0.0 ps;
     tpd_CLKPERFDELAY_OCBEXTEND : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKPERFDELAY_OFB : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKPERFDELAY_OQ : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKPERFDELAY_SHIFTOUT1: VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKPERFDELAY_SHIFTOUT2: VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKPERFDELAY_TFB : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKPERFDELAY_TQ : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKPERF_OCBEXTEND : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKPERF_OFB : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKPERF_OQ : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKPERF_SHIFTOUT1 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKPERF_SHIFTOUT2 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKPERF_TFB : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLKPERF_TQ : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK_OCBEXTEND : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK_OFB : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK_OQ : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK_SHIFTOUT1 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK_SHIFTOUT2 : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK_TFB : VitalDelayType01 := (100 ps, 100 ps);
     tpd_CLK_TQ : VitalDelayType01 := (100 ps, 100 ps);
     tpd_T1_TQ : VitalDelayType01 := (100 ps, 100 ps);
     tperiod_CLKDIV_posedge : VitalDelayType := 0 ps;
     tperiod_CLK_posedge : VitalDelayType := 0 ps;
     tpw_CLKDIV_negedge : VitalDelayType := 0 ps;
     tpw_CLKDIV_posedge : VitalDelayType := 0 ps;
     tpw_CLK_negedge : VitalDelayType := 0 ps;
     tpw_CLK_posedge : VitalDelayType := 0 ps;
     tsetup_D1_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D1_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D2_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D2_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D3_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D3_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D4_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D4_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D5_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D5_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D6_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_D6_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_OCE_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_OCE_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_ODV_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_ODV_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_RST_CLKDIV_negedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_RST_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_RST_CLKDIV_posedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_RST_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_T1_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_T1_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_T1_CLK_negedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_T1_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_T1_CLK_posedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_T1_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_T2_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_T2_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_T2_CLK_negedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_T2_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_T2_CLK_posedge_negedge : VitalDelayType := 0.0 ps;
     tsetup_T2_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_T3_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_T3_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_T4_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_T4_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_TCE_CLK_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_TCE_CLK_posedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_WC_CLKDIV_negedge_posedge : VitalDelayType := 0.0 ps;
     tsetup_WC_CLKDIV_posedge_posedge : VitalDelayType := 0.0 ps
  );
  port (
     OCBEXTEND : out std_ulogic;
     OFB : out std_ulogic;
     OQ : out std_ulogic;
     SHIFTOUT1 : out std_ulogic;
     SHIFTOUT2 : out std_ulogic;
     TFB : out std_ulogic;
     TQ : out std_ulogic;
     CLK : in std_ulogic;
     CLKDIV : in std_ulogic;
     CLKPERF : in std_ulogic;
     CLKPERFDELAY : in std_ulogic;
     D1 : in std_ulogic;
     D2 : in std_ulogic;
     D3 : in std_ulogic;
     D4 : in std_ulogic;
     D5 : in std_ulogic;
     D6 : in std_ulogic;
     OCE : in std_ulogic;
     ODV : in std_ulogic;
     RST : in std_ulogic;
     SHIFTIN1 : in std_ulogic;
     SHIFTIN2 : in std_ulogic;
     T1 : in std_ulogic;
     T2 : in std_ulogic;
     T3 : in std_ulogic;
     T4 : in std_ulogic;
     TCE : in std_ulogic;
     WC : in std_ulogic
  );
end component;

----- component X_PCIE_2_0 -----
component X_PCIE_2_0
  generic (
     AER_BASE_PTR : bit_vector := X"128";
     AER_CAP_ECRC_CHECK_CAPABLE : boolean := FALSE;
     AER_CAP_ECRC_GEN_CAPABLE : boolean := FALSE;
     AER_CAP_ID : bit_vector := X"1111";
     AER_CAP_INT_MSG_NUM_MSI : bit_vector := X"0A";
     AER_CAP_INT_MSG_NUM_MSIX : bit_vector := X"15";
     AER_CAP_NEXTPTR : bit_vector := X"160";
     AER_CAP_ON : boolean := FALSE;
     AER_CAP_PERMIT_ROOTERR_UPDATE : boolean := TRUE;
     AER_CAP_VERSION : bit_vector := X"1";
     ALLOW_X8_GEN2 : boolean := FALSE;
     BAR0 : bit_vector := X"FFFFFF00";
     BAR1 : bit_vector := X"FFFF0000";
     BAR2 : bit_vector := X"FFFF000C";
     BAR3 : bit_vector := X"FFFFFFFF";
     BAR4 : bit_vector := X"00000000";
     BAR5 : bit_vector := X"00000000";
     CAPABILITIES_PTR : bit_vector := X"40";
     CARDBUS_CIS_POINTER : bit_vector := X"00000000";
     CLASS_CODE : bit_vector := X"000000";
     CMD_INTX_IMPLEMENTED : boolean := TRUE;
     CPL_TIMEOUT_DISABLE_SUPPORTED : boolean := FALSE;
     CPL_TIMEOUT_RANGES_SUPPORTED : bit_vector := X"0";
     CRM_MODULE_RSTS : bit_vector := X"00";
     DEVICE_ID : bit_vector := X"0007";
     DEV_CAP_ENABLE_SLOT_PWR_LIMIT_SCALE : boolean := TRUE;
     DEV_CAP_ENABLE_SLOT_PWR_LIMIT_VALUE : boolean := TRUE;
     DEV_CAP_ENDPOINT_L0S_LATENCY : integer := 0;
     DEV_CAP_ENDPOINT_L1_LATENCY : integer := 0;
     DEV_CAP_EXT_TAG_SUPPORTED : boolean := TRUE;
     DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE : boolean := FALSE;
     DEV_CAP_MAX_PAYLOAD_SUPPORTED : integer := 2;
     DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT : integer := 0;
     DEV_CAP_ROLE_BASED_ERROR : boolean := TRUE;
     DEV_CAP_RSVD_14_12 : integer := 0;
     DEV_CAP_RSVD_17_16 : integer := 0;
     DEV_CAP_RSVD_31_29 : integer := 0;
     DEV_CONTROL_AUX_POWER_SUPPORTED : boolean := FALSE;
     DISABLE_ASPM_L1_TIMER : boolean := FALSE;
     DISABLE_BAR_FILTERING : boolean := FALSE;
     DISABLE_ID_CHECK : boolean := FALSE;
     DISABLE_LANE_REVERSAL : boolean := FALSE;
     DISABLE_RX_TC_FILTER : boolean := FALSE;
     DISABLE_SCRAMBLING : boolean := FALSE;
     DNSTREAM_LINK_NUM : bit_vector := X"00";
     DSN_BASE_PTR : bit_vector := X"100";
     DSN_CAP_ID : bit_vector := X"0003";
     DSN_CAP_NEXTPTR : bit_vector := X"000";
     DSN_CAP_ON : boolean := TRUE;
     DSN_CAP_VERSION : bit_vector := X"1";
     ENABLE_MSG_ROUTE : bit_vector := X"000";
     ENABLE_RX_TD_ECRC_TRIM : boolean := FALSE;
     ENTER_RVRY_EI_L0 : boolean := TRUE;
     EXIT_LOOPBACK_ON_EI : boolean := TRUE;
     EXPANSION_ROM : bit_vector := X"FFFFF001";
     EXT_CFG_CAP_PTR : bit_vector := X"3F";
     EXT_CFG_XP_CAP_PTR : bit_vector := X"3FF";
     HEADER_TYPE : bit_vector := X"00";
     INFER_EI : bit_vector := X"00";
     INTERRUPT_PIN : bit_vector := X"01";
     IS_SWITCH : boolean := FALSE;
     InstancePath : string := "*";
     LAST_CONFIG_DWORD : bit_vector := X"042";
     LINK_CAP_ASPM_SUPPORT : integer := 1;
     LINK_CAP_CLOCK_POWER_MANAGEMENT : boolean := FALSE;
     LINK_CAP_DLL_LINK_ACTIVE_REPORTING_CAP : boolean := FALSE;
     LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1 : integer := 7;
     LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2 : integer := 7;
     LINK_CAP_L0S_EXIT_LATENCY_GEN1 : integer := 7;
     LINK_CAP_L0S_EXIT_LATENCY_GEN2 : integer := 7;
     LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1 : integer := 7;
     LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2 : integer := 7;
     LINK_CAP_L1_EXIT_LATENCY_GEN1 : integer := 7;
     LINK_CAP_L1_EXIT_LATENCY_GEN2 : integer := 7;
     LINK_CAP_LINK_BANDWIDTH_NOTIFICATION_CAP : boolean := FALSE;
     LINK_CAP_MAX_LINK_SPEED : bit_vector := X"1";
     LINK_CAP_MAX_LINK_WIDTH : bit_vector := X"08";
     LINK_CAP_RSVD_23_22 : integer := 0;
     LINK_CAP_SURPRISE_DOWN_ERROR_CAPABLE : boolean := FALSE;
     LINK_CONTROL_RCB : integer := 0;
     LINK_CTRL2_DEEMPHASIS : boolean := FALSE;
     LINK_CTRL2_HW_AUTONOMOUS_SPEED_DISABLE : boolean := FALSE;
     LINK_CTRL2_TARGET_LINK_SPEED : bit_vector := X"2";
     LINK_STATUS_SLOT_CLOCK_CONFIG : boolean := TRUE;
     LL_ACK_TIMEOUT : bit_vector := X"0000";
     LL_ACK_TIMEOUT_EN : boolean := FALSE;
     LL_ACK_TIMEOUT_FUNC : integer := 0;
     LL_REPLAY_TIMEOUT : bit_vector := X"0000";
     LL_REPLAY_TIMEOUT_EN : boolean := FALSE;
     LL_REPLAY_TIMEOUT_FUNC : integer := 0;
     LOC : string := "UNPLACED";
     LTSSM_MAX_LINK_WIDTH : bit_vector := X"01";
     MSIX_BASE_PTR : bit_vector := X"9C";
     MSIX_CAP_ID : bit_vector := X"11";
     MSIX_CAP_NEXTPTR : bit_vector := X"00";
     MSIX_CAP_ON : boolean := FALSE;
     MSIX_CAP_PBA_BIR : integer := 0;
     MSIX_CAP_PBA_OFFSET : bit_vector := X"00000050";
     MSIX_CAP_TABLE_BIR : integer := 0;
     MSIX_CAP_TABLE_OFFSET : bit_vector := X"00000040";
     MSIX_CAP_TABLE_SIZE : bit_vector := X"000";
     MSI_BASE_PTR : bit_vector := X"48";
     MSI_CAP_64_BIT_ADDR_CAPABLE : boolean := TRUE;
     MSI_CAP_ID : bit_vector := X"05";
     MSI_CAP_MULTIMSGCAP : integer := 0;
     MSI_CAP_MULTIMSG_EXTENSION : integer := 0;
     MSI_CAP_NEXTPTR : bit_vector := X"60";
     MSI_CAP_ON : boolean := FALSE;
     MSI_CAP_PER_VECTOR_MASKING_CAPABLE : boolean := TRUE;
     MsgOn : boolean := FALSE;
     N_FTS_COMCLK_GEN1 : integer := 255;
     N_FTS_COMCLK_GEN2 : integer := 255;
     N_FTS_GEN1 : integer := 255;
     N_FTS_GEN2 : integer := 255;
     PCIE_BASE_PTR : bit_vector := X"60";
     PCIE_CAP_CAPABILITY_ID : bit_vector := X"10";
     PCIE_CAP_CAPABILITY_VERSION : bit_vector := X"2";
     PCIE_CAP_DEVICE_PORT_TYPE : bit_vector := X"0";
     PCIE_CAP_INT_MSG_NUM : bit_vector := X"00";
     PCIE_CAP_NEXTPTR : bit_vector := X"00";
     PCIE_CAP_ON : boolean := TRUE;
     PCIE_CAP_RSVD_15_14 : integer := 0;
     PCIE_CAP_SLOT_IMPLEMENTED : boolean := FALSE;
     PCIE_REVISION : integer := 2;
     PGL0_LANE : integer := 0;
     PGL1_LANE : integer := 1;
     PGL2_LANE : integer := 2;
     PGL3_LANE : integer := 3;
     PGL4_LANE : integer := 4;
     PGL5_LANE : integer := 5;
     PGL6_LANE : integer := 6;
     PGL7_LANE : integer := 7;
     PL_AUTO_CONFIG : integer := 0;
     PL_FAST_TRAIN : boolean := FALSE;
     PM_BASE_PTR : bit_vector := X"40";
     PM_CAP_AUXCURRENT : integer := 0;
     PM_CAP_D1SUPPORT : boolean := TRUE;
     PM_CAP_D2SUPPORT : boolean := TRUE;
     PM_CAP_DSI : boolean := FALSE;
     PM_CAP_ID : bit_vector := X"11";
     PM_CAP_NEXTPTR : bit_vector := X"48";
     PM_CAP_ON : boolean := TRUE;
     PM_CAP_PMESUPPORT : bit_vector := X"0F";
     PM_CAP_PME_CLOCK : boolean := FALSE;
     PM_CAP_RSVD_04 : integer := 0;
     PM_CAP_VERSION : integer := 3;
     PM_CSR_B2B3 : boolean := FALSE;
     PM_CSR_BPCCEN : boolean := FALSE;
     PM_CSR_NOSOFTRST : boolean := TRUE;
     PM_DATA0 : bit_vector := X"01";
     PM_DATA1 : bit_vector := X"01";
     PM_DATA2 : bit_vector := X"01";
     PM_DATA3 : bit_vector := X"01";
     PM_DATA4 : bit_vector := X"01";
     PM_DATA5 : bit_vector := X"01";
     PM_DATA6 : bit_vector := X"01";
     PM_DATA7 : bit_vector := X"01";
     PM_DATA_SCALE0 : bit_vector := X"1";
     PM_DATA_SCALE1 : bit_vector := X"1";
     PM_DATA_SCALE2 : bit_vector := X"1";
     PM_DATA_SCALE3 : bit_vector := X"1";
     PM_DATA_SCALE4 : bit_vector := X"1";
     PM_DATA_SCALE5 : bit_vector := X"1";
     PM_DATA_SCALE6 : bit_vector := X"1";
     PM_DATA_SCALE7 : bit_vector := X"1";
     RECRC_CHK : integer := 0;
     RECRC_CHK_TRIM : boolean := FALSE;
     REVISION_ID : bit_vector := X"00";
     ROOT_CAP_CRS_SW_VISIBILITY : boolean := FALSE;
     SELECT_DLL_IF : boolean := FALSE;
     SIM_VERSION : string := "1.0";
     SLOT_CAP_ATT_BUTTON_PRESENT : boolean := FALSE;
     SLOT_CAP_ATT_INDICATOR_PRESENT : boolean := FALSE;
     SLOT_CAP_ELEC_INTERLOCK_PRESENT : boolean := FALSE;
     SLOT_CAP_HOTPLUG_CAPABLE : boolean := FALSE;
     SLOT_CAP_HOTPLUG_SURPRISE : boolean := FALSE;
     SLOT_CAP_MRL_SENSOR_PRESENT : boolean := FALSE;
     SLOT_CAP_NO_CMD_COMPLETED_SUPPORT : boolean := FALSE;
     SLOT_CAP_PHYSICAL_SLOT_NUM : bit_vector := X"0000";
     SLOT_CAP_POWER_CONTROLLER_PRESENT : boolean := FALSE;
     SLOT_CAP_POWER_INDICATOR_PRESENT : boolean := FALSE;
     SLOT_CAP_SLOT_POWER_LIMIT_SCALE : integer := 0;
     SLOT_CAP_SLOT_POWER_LIMIT_VALUE : bit_vector := X"00";
     SPARE_BIT0 : integer := 0;
     SPARE_BIT1 : integer := 0;
     SPARE_BIT2 : integer := 0;
     SPARE_BIT3 : integer := 0;
     SPARE_BIT4 : integer := 0;
     SPARE_BIT5 : integer := 0;
     SPARE_BIT6 : integer := 0;
     SPARE_BIT7 : integer := 0;
     SPARE_BIT8 : integer := 0;
     SPARE_BYTE0 : bit_vector := X"00";
     SPARE_BYTE1 : bit_vector := X"00";
     SPARE_BYTE2 : bit_vector := X"00";
     SPARE_BYTE3 : bit_vector := X"00";
     SPARE_WORD0 : bit_vector := X"00000000";
     SPARE_WORD1 : bit_vector := X"00000000";
     SPARE_WORD2 : bit_vector := X"00000000";
     SPARE_WORD3 : bit_vector := X"00000000";
     SUBSYSTEM_ID : bit_vector := X"0007";
     SUBSYSTEM_VENDOR_ID : bit_vector := X"10EE";
     TL_RBYPASS : boolean := FALSE;
     TL_RX_RAM_RADDR_LATENCY : integer := 0;
     TL_RX_RAM_RDATA_LATENCY : integer := 2;
     TL_RX_RAM_WRITE_LATENCY : integer := 0;
     TL_TFC_DISABLE : boolean := FALSE;
     TL_TX_CHECKS_DISABLE : boolean := FALSE;
     TL_TX_RAM_RADDR_LATENCY : integer := 0;
     TL_TX_RAM_RDATA_LATENCY : integer := 2;
     TL_TX_RAM_WRITE_LATENCY : integer := 0;
     TimingChecksOn : boolean := TRUE;
     UPCONFIG_CAPABLE : boolean := TRUE;
     UPSTREAM_FACING : boolean := TRUE;
     UR_INV_REQ : boolean := TRUE;
     USER_CLK_FREQ : integer := 3;
     VC0_CPL_INFINITE : boolean := TRUE;
     VC0_RX_RAM_LIMIT : bit_vector := X"03FF";
     VC0_TOTAL_CREDITS_CD : integer := 127;
     VC0_TOTAL_CREDITS_CH : integer := 31;
     VC0_TOTAL_CREDITS_NPH : integer := 12;
     VC0_TOTAL_CREDITS_PD : integer := 288;
     VC0_TOTAL_CREDITS_PH : integer := 32;
     VC0_TX_LASTPACKET : integer := 31;
     VC_BASE_PTR : bit_vector := X"10C";
     VC_CAP_ID : bit_vector := X"0002";
     VC_CAP_NEXTPTR : bit_vector := X"000";
     VC_CAP_ON : boolean := FALSE;
     VC_CAP_REJECT_SNOOP_TRANSACTIONS : boolean := FALSE;
     VC_CAP_VERSION : bit_vector := X"1";
     VENDOR_ID : bit_vector := X"10EE";
     VSEC_BASE_PTR : bit_vector := X"160";
     VSEC_CAP_HDR_ID : bit_vector := X"1234";
     VSEC_CAP_HDR_LENGTH : bit_vector := X"018";
     VSEC_CAP_HDR_REVISION : bit_vector := X"1";
     VSEC_CAP_ID : bit_vector := X"000B";
     VSEC_CAP_IS_LINK_VISIBLE : boolean := TRUE;
     VSEC_CAP_NEXTPTR : bit_vector := X"000";
     VSEC_CAP_ON : boolean := FALSE;
     VSEC_CAP_VERSION : bit_vector := X"1";
     Xon : boolean := TRUE;
     thold_CFGBYTEENN_USERCLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_CFGBYTEENN_USERCLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     thold_CFGDI_USERCLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     thold_CFGDI_USERCLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     thold_CFGDSBUSNUMBER_USERCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_CFGDSBUSNUMBER_USERCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_CFGDSDEVICENUMBER_USERCLK_negedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     thold_CFGDSDEVICENUMBER_USERCLK_posedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     thold_CFGDSFUNCTIONNUMBER_USERCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_CFGDSFUNCTIONNUMBER_USERCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_CFGDSN_USERCLK_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     thold_CFGDSN_USERCLK_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     thold_CFGDWADDR_USERCLK_negedge_posedge : VitalDelayArrayType(9 downto 0) := (others => 0 ps);
     thold_CFGDWADDR_USERCLK_posedge_posedge : VitalDelayArrayType(9 downto 0) := (others => 0 ps);
     thold_CFGERRACSN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGERRACSN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CFGERRAERHEADERLOG_USERCLK_negedge_posedge : VitalDelayArrayType(127 downto 0) := (others => 0 ps);
     thold_CFGERRAERHEADERLOG_USERCLK_posedge_posedge : VitalDelayArrayType(127 downto 0) := (others => 0 ps);
     thold_CFGERRCORN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGERRCORN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CFGERRCPLABORTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGERRCPLABORTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CFGERRCPLTIMEOUTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGERRCPLTIMEOUTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CFGERRCPLUNEXPECTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGERRCPLUNEXPECTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CFGERRECRCN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGERRECRCN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CFGERRLOCKEDN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGERRLOCKEDN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CFGERRPOSTEDN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGERRPOSTEDN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     thold_CFGERRURN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGERRURN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CFGINTERRUPTASSERTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGINTERRUPTASSERTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CFGINTERRUPTDI_USERCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_CFGINTERRUPTDI_USERCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_CFGINTERRUPTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGINTERRUPTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CFGPMDIRECTASPML1N_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGPMDIRECTASPML1N_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CFGPMSENDPMACKN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGPMSENDPMACKN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CFGPMSENDPMETON_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGPMSENDPMETON_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CFGPMSENDPMNAKN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGPMSENDPMNAKN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CFGPMTURNOFFOKN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGPMTURNOFFOKN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CFGPMWAKEN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGPMWAKEN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CFGPORTNUMBER_USERCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_CFGPORTNUMBER_USERCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_CFGRDENN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGRDENN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CFGTRNPENDINGN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGTRNPENDINGN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CFGWRENN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGWRENN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CFGWRREADONLYN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGWRREADONLYN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CFGWRRW1CASRWN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGWRRW1CASRWN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CMRSTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CMRSTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CMSTICKYRSTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CMSTICKYRSTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_DBGMODE_USERCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_DBGMODE_USERCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_DBGSUBMODE_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_DBGSUBMODE_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_DLRSTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_DLRSTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_DRPDADDR_DRPCLK_negedge_posedge : VitalDelayArrayType(8 downto 0) := (others => 0 ps);
     thold_DRPDADDR_DRPCLK_posedge_posedge : VitalDelayArrayType(8 downto 0) := (others => 0 ps);
     thold_DRPDEN_DRPCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_DRPDEN_DRPCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_DRPDI_DRPCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_DRPDI_DRPCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_DRPDWE_DRPCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_DRPDWE_DRPCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_FUNCLVLRSTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_FUNCLVLRSTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_LL2SENDASREQL1N_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_LL2SENDASREQL1N_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_LL2SENDENTERL1N_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_LL2SENDENTERL1N_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_LL2SENDENTERL23N_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_LL2SENDENTERL23N_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_LL2SUSPENDNOWN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_LL2SUSPENDNOWN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_LL2TLPRCVN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_LL2TLPRCVN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_MIMRXRDATA_USERCLK_negedge_posedge : VitalDelayArrayType(67 downto 0) := (others => 0 ps);
     thold_MIMRXRDATA_USERCLK_posedge_posedge : VitalDelayArrayType(67 downto 0) := (others => 0 ps);
     thold_MIMTXRDATA_USERCLK_negedge_posedge : VitalDelayArrayType(68 downto 0) := (others => 0 ps);
     thold_MIMTXRDATA_USERCLK_posedge_posedge : VitalDelayArrayType(68 downto 0) := (others => 0 ps);
     thold_PIPERX0CHANISALIGNED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX0CHANISALIGNED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX0CHARISK_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_PIPERX0CHARISK_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_PIPERX0DATA_PIPECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_PIPERX0DATA_PIPECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_PIPERX0ELECIDLE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX0ELECIDLE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX0PHYSTATUS_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX0PHYSTATUS_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX0STATUS_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_PIPERX0STATUS_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_PIPERX0VALID_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX0VALID_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX1CHANISALIGNED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX1CHANISALIGNED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX1CHARISK_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_PIPERX1CHARISK_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_PIPERX1DATA_PIPECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_PIPERX1DATA_PIPECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_PIPERX1ELECIDLE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX1ELECIDLE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX1PHYSTATUS_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX1PHYSTATUS_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX1STATUS_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_PIPERX1STATUS_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_PIPERX1VALID_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX1VALID_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX2CHANISALIGNED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX2CHANISALIGNED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX2CHARISK_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_PIPERX2CHARISK_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_PIPERX2DATA_PIPECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_PIPERX2DATA_PIPECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_PIPERX2ELECIDLE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX2ELECIDLE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX2PHYSTATUS_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX2PHYSTATUS_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX2STATUS_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_PIPERX2STATUS_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_PIPERX2VALID_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX2VALID_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX3CHANISALIGNED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX3CHANISALIGNED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX3CHARISK_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_PIPERX3CHARISK_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_PIPERX3DATA_PIPECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_PIPERX3DATA_PIPECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_PIPERX3ELECIDLE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX3ELECIDLE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX3PHYSTATUS_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX3PHYSTATUS_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX3STATUS_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_PIPERX3STATUS_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_PIPERX3VALID_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX3VALID_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX4CHANISALIGNED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX4CHANISALIGNED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX4CHARISK_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_PIPERX4CHARISK_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_PIPERX4DATA_PIPECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_PIPERX4DATA_PIPECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_PIPERX4ELECIDLE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX4ELECIDLE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX4PHYSTATUS_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX4PHYSTATUS_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX4STATUS_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_PIPERX4STATUS_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_PIPERX4VALID_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX4VALID_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX5CHANISALIGNED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX5CHANISALIGNED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX5CHARISK_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_PIPERX5CHARISK_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_PIPERX5DATA_PIPECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_PIPERX5DATA_PIPECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_PIPERX5ELECIDLE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX5ELECIDLE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX5PHYSTATUS_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX5PHYSTATUS_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX5STATUS_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_PIPERX5STATUS_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_PIPERX5VALID_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX5VALID_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX6CHANISALIGNED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX6CHANISALIGNED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX6CHARISK_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_PIPERX6CHARISK_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_PIPERX6DATA_PIPECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_PIPERX6DATA_PIPECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_PIPERX6ELECIDLE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX6ELECIDLE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX6PHYSTATUS_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX6PHYSTATUS_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX6STATUS_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_PIPERX6STATUS_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_PIPERX6VALID_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX6VALID_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX7CHANISALIGNED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX7CHANISALIGNED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX7CHARISK_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_PIPERX7CHARISK_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_PIPERX7DATA_PIPECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_PIPERX7DATA_PIPECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_PIPERX7ELECIDLE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX7ELECIDLE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX7PHYSTATUS_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX7PHYSTATUS_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX7STATUS_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_PIPERX7STATUS_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_PIPERX7VALID_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERX7VALID_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PL2DIRECTEDLSTATE_USERCLK_negedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     thold_PL2DIRECTEDLSTATE_USERCLK_posedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     thold_PLDBGMODE_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_PLDBGMODE_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_PLDIRECTEDLINKAUTON_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PLDIRECTEDLINKAUTON_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PLDIRECTEDLINKCHANGE_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_PLDIRECTEDLINKCHANGE_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_PLDIRECTEDLINKSPEED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PLDIRECTEDLINKSPEED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PLDIRECTEDLINKWIDTH_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_PLDIRECTEDLINKWIDTH_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_PLDOWNSTREAMDEEMPHSOURCE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PLDOWNSTREAMDEEMPHSOURCE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PLRSTN_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PLRSTN_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PLTRANSMITHOTRST_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PLTRANSMITHOTRST_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PLUPSTREAMPREFERDEEMPH_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PLUPSTREAMPREFERDEEMPH_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_TL2ASPMSUSPENDCREDITCHECKN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_TL2ASPMSUSPENDCREDITCHECKN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_TL2PPMSUSPENDREQN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_TL2PPMSUSPENDREQN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_TLRSTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_TLRSTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_TRNFCSEL_USERCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_TRNFCSEL_USERCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_TRNRDSTRDYN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_TRNRDSTRDYN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_TRNRNPOKN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_TRNRNPOKN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_TRNTCFGGNTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_TRNTCFGGNTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_TRNTDLLPDATA_USERCLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     thold_TRNTDLLPDATA_USERCLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     thold_TRNTDLLPSRCRDYN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_TRNTDLLPSRCRDYN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_TRNTD_USERCLK_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     thold_TRNTD_USERCLK_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     thold_TRNTECRCGENN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_TRNTECRCGENN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_TRNTEOFN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_TRNTEOFN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_TRNTERRFWDN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_TRNTERRFWDN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_TRNTREMN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_TRNTREMN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_TRNTSOFN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_TRNTSOFN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_TRNTSRCDSCN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_TRNTSRCDSCN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_TRNTSRCRDYN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_TRNTSRCRDYN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_TRNTSTRN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_TRNTSTRN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     ticd_DRPCLK : VitalDelayType := 0 ps;
     ticd_PIPECLK : VitalDelayType := 0 ps;
     ticd_USERCLK : VitalDelayType := 0 ps;
     tipd_CFGBYTEENN : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
     tipd_CFGDI : VitalDelayArrayType01 (31 downto 0) := (others => (0 ps, 0 ps));
     tipd_CFGDSBUSNUMBER : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
     tipd_CFGDSDEVICENUMBER : VitalDelayArrayType01 (4 downto 0) := (others => (0 ps, 0 ps));
     tipd_CFGDSFUNCTIONNUMBER : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_CFGDSN : VitalDelayArrayType01 (63 downto 0) := (others => (0 ps, 0 ps));
     tipd_CFGDWADDR : VitalDelayArrayType01 (9 downto 0) := (others => (0 ps, 0 ps));
     tipd_CFGERRACSN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CFGERRAERHEADERLOG : VitalDelayArrayType01 (127 downto 0) := (others => (0 ps, 0 ps));
     tipd_CFGERRCORN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CFGERRCPLABORTN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CFGERRCPLTIMEOUTN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CFGERRCPLUNEXPECTN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CFGERRECRCN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CFGERRLOCKEDN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CFGERRPOSTEDN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CFGERRTLPCPLHEADER : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tipd_CFGERRURN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CFGINTERRUPTASSERTN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CFGINTERRUPTDI : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
     tipd_CFGINTERRUPTN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CFGPMDIRECTASPML1N : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CFGPMSENDPMACKN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CFGPMSENDPMETON : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CFGPMSENDPMNAKN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CFGPMTURNOFFOKN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CFGPMWAKEN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CFGPORTNUMBER : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
     tipd_CFGRDENN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CFGTRNPENDINGN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CFGWRENN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CFGWRREADONLYN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CFGWRRW1CASRWN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CMRSTN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CMSTICKYRSTN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DBGMODE : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_DBGSUBMODE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DLRSTN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DRPCLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DRPDADDR : VitalDelayArrayType01 (8 downto 0) := (others => (0 ps, 0 ps));
     tipd_DRPDEN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_DRPDI : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
     tipd_DRPDWE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_FUNCLVLRSTN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_LL2SENDASREQL1N : VitalDelayType01 := (0 ps, 0 ps);
     tipd_LL2SENDENTERL1N : VitalDelayType01 := (0 ps, 0 ps);
     tipd_LL2SENDENTERL23N : VitalDelayType01 := (0 ps, 0 ps);
     tipd_LL2SUSPENDNOWN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_LL2TLPRCVN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_MIMRXRDATA : VitalDelayArrayType01 (67 downto 0) := (others => (0 ps, 0 ps));
     tipd_MIMTXRDATA : VitalDelayArrayType01 (68 downto 0) := (others => (0 ps, 0 ps));
     tipd_PIPECLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERX0CHANISALIGNED : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERX0CHARISK : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_PIPERX0DATA : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
     tipd_PIPERX0ELECIDLE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERX0PHYSTATUS : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERX0STATUS : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_PIPERX0VALID : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERX1CHANISALIGNED : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERX1CHARISK : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_PIPERX1DATA : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
     tipd_PIPERX1ELECIDLE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERX1PHYSTATUS : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERX1STATUS : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_PIPERX1VALID : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERX2CHANISALIGNED : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERX2CHARISK : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_PIPERX2DATA : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
     tipd_PIPERX2ELECIDLE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERX2PHYSTATUS : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERX2STATUS : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_PIPERX2VALID : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERX3CHANISALIGNED : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERX3CHARISK : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_PIPERX3DATA : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
     tipd_PIPERX3ELECIDLE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERX3PHYSTATUS : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERX3STATUS : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_PIPERX3VALID : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERX4CHANISALIGNED : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERX4CHARISK : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_PIPERX4DATA : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
     tipd_PIPERX4ELECIDLE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERX4PHYSTATUS : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERX4STATUS : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_PIPERX4VALID : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERX5CHANISALIGNED : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERX5CHARISK : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_PIPERX5DATA : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
     tipd_PIPERX5ELECIDLE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERX5PHYSTATUS : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERX5STATUS : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_PIPERX5VALID : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERX6CHANISALIGNED : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERX6CHARISK : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_PIPERX6DATA : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
     tipd_PIPERX6ELECIDLE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERX6PHYSTATUS : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERX6STATUS : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_PIPERX6VALID : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERX7CHANISALIGNED : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERX7CHARISK : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_PIPERX7DATA : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
     tipd_PIPERX7ELECIDLE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERX7PHYSTATUS : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERX7STATUS : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_PIPERX7VALID : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PL2DIRECTEDLSTATE : VitalDelayArrayType01 (4 downto 0) := (others => (0 ps, 0 ps));
     tipd_PLDBGMODE : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_PLDIRECTEDLINKAUTON : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PLDIRECTEDLINKCHANGE : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_PLDIRECTEDLINKSPEED : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PLDIRECTEDLINKWIDTH : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_PLDOWNSTREAMDEEMPHSOURCE : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PLRSTN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PLTRANSMITHOTRST : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PLUPSTREAMPREFERDEEMPH : VitalDelayType01 := (0 ps, 0 ps);
     tipd_SYSRSTN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TL2ASPMSUSPENDCREDITCHECKN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TL2PPMSUSPENDREQN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TLRSTN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TRNFCSEL : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_TRNRDSTRDYN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TRNRNPOKN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TRNTCFGGNTN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TRNTD : VitalDelayArrayType01 (63 downto 0) := (others => (0 ps, 0 ps));
     tipd_TRNTDLLPDATA : VitalDelayArrayType01 (31 downto 0) := (others => (0 ps, 0 ps));
     tipd_TRNTDLLPSRCRDYN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TRNTECRCGENN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TRNTEOFN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TRNTERRFWDN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TRNTREMN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TRNTSOFN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TRNTSRCDSCN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TRNTSRCRDYN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TRNTSTRN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_USERCLK : VitalDelayType01 := (0 ps, 0 ps);
     tisd_CFGBYTEENN_USERCLK : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tisd_CFGDI_USERCLK : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tisd_CFGDSBUSNUMBER_USERCLK : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tisd_CFGDSDEVICENUMBER_USERCLK : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tisd_CFGDSFUNCTIONNUMBER_USERCLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_CFGDSN_USERCLK : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     tisd_CFGDWADDR_USERCLK : VitalDelayArrayType(9 downto 0) := (others => 0 ps);
     tisd_CFGERRACSN_USERCLK : VitalDelayType := 0 ps;
     tisd_CFGERRAERHEADERLOG_USERCLK : VitalDelayArrayType(127 downto 0) := (others => 0 ps);
     tisd_CFGERRCORN_USERCLK : VitalDelayType := 0 ps;
     tisd_CFGERRCPLABORTN_USERCLK : VitalDelayType := 0 ps;
     tisd_CFGERRCPLTIMEOUTN_USERCLK : VitalDelayType := 0 ps;
     tisd_CFGERRCPLUNEXPECTN_USERCLK : VitalDelayType := 0 ps;
     tisd_CFGERRECRCN_USERCLK : VitalDelayType := 0 ps;
     tisd_CFGERRLOCKEDN_USERCLK : VitalDelayType := 0 ps;
     tisd_CFGERRPOSTEDN_USERCLK : VitalDelayType := 0 ps;
     tisd_CFGERRTLPCPLHEADER_USERCLK : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tisd_CFGERRURN_USERCLK : VitalDelayType := 0 ps;
     tisd_CFGINTERRUPTASSERTN_USERCLK : VitalDelayType := 0 ps;
     tisd_CFGINTERRUPTDI_USERCLK : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tisd_CFGINTERRUPTN_USERCLK : VitalDelayType := 0 ps;
     tisd_CFGPMDIRECTASPML1N_USERCLK : VitalDelayType := 0 ps;
     tisd_CFGPMSENDPMACKN_USERCLK : VitalDelayType := 0 ps;
     tisd_CFGPMSENDPMETON_USERCLK : VitalDelayType := 0 ps;
     tisd_CFGPMSENDPMNAKN_USERCLK : VitalDelayType := 0 ps;
     tisd_CFGPMTURNOFFOKN_USERCLK : VitalDelayType := 0 ps;
     tisd_CFGPMWAKEN_USERCLK : VitalDelayType := 0 ps;
     tisd_CFGPORTNUMBER_USERCLK : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tisd_CFGRDENN_USERCLK : VitalDelayType := 0 ps;
     tisd_CFGTRNPENDINGN_USERCLK : VitalDelayType := 0 ps;
     tisd_CFGWRENN_USERCLK : VitalDelayType := 0 ps;
     tisd_CFGWRREADONLYN_USERCLK : VitalDelayType := 0 ps;
     tisd_CFGWRRW1CASRWN_USERCLK : VitalDelayType := 0 ps;
     tisd_CMRSTN_USERCLK : VitalDelayType := 0 ps;
     tisd_CMSTICKYRSTN_USERCLK : VitalDelayType := 0 ps;
     tisd_DBGMODE_USERCLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_DBGSUBMODE_USERCLK : VitalDelayType := 0 ps;
     tisd_DLRSTN_USERCLK : VitalDelayType := 0 ps;
     tisd_DRPDADDR_DRPCLK : VitalDelayArrayType(8 downto 0) := (others => 0 ps);
     tisd_DRPDEN_DRPCLK : VitalDelayType := 0 ps;
     tisd_DRPDI_DRPCLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tisd_DRPDWE_DRPCLK : VitalDelayType := 0 ps;
     tisd_FUNCLVLRSTN_USERCLK : VitalDelayType := 0 ps;
     tisd_LL2SENDASREQL1N_USERCLK : VitalDelayType := 0 ps;
     tisd_LL2SENDENTERL1N_USERCLK : VitalDelayType := 0 ps;
     tisd_LL2SENDENTERL23N_USERCLK : VitalDelayType := 0 ps;
     tisd_LL2SUSPENDNOWN_USERCLK : VitalDelayType := 0 ps;
     tisd_LL2TLPRCVN_USERCLK : VitalDelayType := 0 ps;
     tisd_MIMRXRDATA_USERCLK : VitalDelayArrayType(67 downto 0) := (others => 0 ps);
     tisd_MIMTXRDATA_USERCLK : VitalDelayArrayType(68 downto 0) := (others => 0 ps);
     tisd_PIPERX0CHANISALIGNED_PIPECLK : VitalDelayType := 0 ps;
     tisd_PIPERX0CHARISK_PIPECLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_PIPERX0DATA_PIPECLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tisd_PIPERX0ELECIDLE_PIPECLK : VitalDelayType := 0 ps;
     tisd_PIPERX0PHYSTATUS_PIPECLK : VitalDelayType := 0 ps;
     tisd_PIPERX0STATUS_PIPECLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_PIPERX0VALID_PIPECLK : VitalDelayType := 0 ps;
     tisd_PIPERX1CHANISALIGNED_PIPECLK : VitalDelayType := 0 ps;
     tisd_PIPERX1CHARISK_PIPECLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_PIPERX1DATA_PIPECLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tisd_PIPERX1ELECIDLE_PIPECLK : VitalDelayType := 0 ps;
     tisd_PIPERX1PHYSTATUS_PIPECLK : VitalDelayType := 0 ps;
     tisd_PIPERX1STATUS_PIPECLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_PIPERX1VALID_PIPECLK : VitalDelayType := 0 ps;
     tisd_PIPERX2CHANISALIGNED_PIPECLK : VitalDelayType := 0 ps;
     tisd_PIPERX2CHARISK_PIPECLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_PIPERX2DATA_PIPECLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tisd_PIPERX2ELECIDLE_PIPECLK : VitalDelayType := 0 ps;
     tisd_PIPERX2PHYSTATUS_PIPECLK : VitalDelayType := 0 ps;
     tisd_PIPERX2STATUS_PIPECLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_PIPERX2VALID_PIPECLK : VitalDelayType := 0 ps;
     tisd_PIPERX3CHANISALIGNED_PIPECLK : VitalDelayType := 0 ps;
     tisd_PIPERX3CHARISK_PIPECLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_PIPERX3DATA_PIPECLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tisd_PIPERX3ELECIDLE_PIPECLK : VitalDelayType := 0 ps;
     tisd_PIPERX3PHYSTATUS_PIPECLK : VitalDelayType := 0 ps;
     tisd_PIPERX3STATUS_PIPECLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_PIPERX3VALID_PIPECLK : VitalDelayType := 0 ps;
     tisd_PIPERX4CHANISALIGNED_PIPECLK : VitalDelayType := 0 ps;
     tisd_PIPERX4CHARISK_PIPECLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_PIPERX4DATA_PIPECLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tisd_PIPERX4ELECIDLE_PIPECLK : VitalDelayType := 0 ps;
     tisd_PIPERX4PHYSTATUS_PIPECLK : VitalDelayType := 0 ps;
     tisd_PIPERX4STATUS_PIPECLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_PIPERX4VALID_PIPECLK : VitalDelayType := 0 ps;
     tisd_PIPERX5CHANISALIGNED_PIPECLK : VitalDelayType := 0 ps;
     tisd_PIPERX5CHARISK_PIPECLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_PIPERX5DATA_PIPECLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tisd_PIPERX5ELECIDLE_PIPECLK : VitalDelayType := 0 ps;
     tisd_PIPERX5PHYSTATUS_PIPECLK : VitalDelayType := 0 ps;
     tisd_PIPERX5STATUS_PIPECLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_PIPERX5VALID_PIPECLK : VitalDelayType := 0 ps;
     tisd_PIPERX6CHANISALIGNED_PIPECLK : VitalDelayType := 0 ps;
     tisd_PIPERX6CHARISK_PIPECLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_PIPERX6DATA_PIPECLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tisd_PIPERX6ELECIDLE_PIPECLK : VitalDelayType := 0 ps;
     tisd_PIPERX6PHYSTATUS_PIPECLK : VitalDelayType := 0 ps;
     tisd_PIPERX6STATUS_PIPECLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_PIPERX6VALID_PIPECLK : VitalDelayType := 0 ps;
     tisd_PIPERX7CHANISALIGNED_PIPECLK : VitalDelayType := 0 ps;
     tisd_PIPERX7CHARISK_PIPECLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_PIPERX7DATA_PIPECLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tisd_PIPERX7ELECIDLE_PIPECLK : VitalDelayType := 0 ps;
     tisd_PIPERX7PHYSTATUS_PIPECLK : VitalDelayType := 0 ps;
     tisd_PIPERX7STATUS_PIPECLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_PIPERX7VALID_PIPECLK : VitalDelayType := 0 ps;
     tisd_PL2DIRECTEDLSTATE_USERCLK : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tisd_PLDBGMODE_PIPECLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_PLDIRECTEDLINKAUTON_PIPECLK : VitalDelayType := 0 ps;
     tisd_PLDIRECTEDLINKCHANGE_PIPECLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_PLDIRECTEDLINKSPEED_PIPECLK : VitalDelayType := 0 ps;
     tisd_PLDIRECTEDLINKWIDTH_PIPECLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_PLDOWNSTREAMDEEMPHSOURCE_PIPECLK : VitalDelayType := 0 ps;
     tisd_PLRSTN_PIPECLK : VitalDelayType := 0 ps;
     tisd_PLTRANSMITHOTRST_PIPECLK : VitalDelayType := 0 ps;
     tisd_PLUPSTREAMPREFERDEEMPH_PIPECLK : VitalDelayType := 0 ps;
     tisd_TL2ASPMSUSPENDCREDITCHECKN_USERCLK : VitalDelayType := 0 ps;
     tisd_TL2PPMSUSPENDREQN_USERCLK : VitalDelayType := 0 ps;
     tisd_TLRSTN_USERCLK : VitalDelayType := 0 ps;
     tisd_TRNFCSEL_USERCLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_TRNRDSTRDYN_USERCLK : VitalDelayType := 0 ps;
     tisd_TRNRNPOKN_USERCLK : VitalDelayType := 0 ps;
     tisd_TRNTCFGGNTN_USERCLK : VitalDelayType := 0 ps;
     tisd_TRNTDLLPDATA_USERCLK : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tisd_TRNTDLLPSRCRDYN_USERCLK : VitalDelayType := 0 ps;
     tisd_TRNTD_USERCLK : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     tisd_TRNTECRCGENN_USERCLK : VitalDelayType := 0 ps;
     tisd_TRNTEOFN_USERCLK : VitalDelayType := 0 ps;
     tisd_TRNTERRFWDN_USERCLK : VitalDelayType := 0 ps;
     tisd_TRNTREMN_USERCLK : VitalDelayType := 0 ps;
     tisd_TRNTSOFN_USERCLK : VitalDelayType := 0 ps;
     tisd_TRNTSRCDSCN_USERCLK : VitalDelayType := 0 ps;
     tisd_TRNTSRCRDYN_USERCLK : VitalDelayType := 0 ps;
     tisd_TRNTSTRN_USERCLK : VitalDelayType := 0 ps;
     tpd_DRPCLK_DRPDO : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
     tpd_DRPCLK_DRPDRDY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PIPERX0POLARITY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PIPERX1POLARITY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PIPERX2POLARITY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PIPERX3POLARITY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PIPERX4POLARITY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PIPERX5POLARITY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PIPERX6POLARITY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PIPERX7POLARITY : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PIPETX0CHARISK : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_PIPECLK_PIPETX0COMPLIANCE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PIPETX0DATA : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
     tpd_PIPECLK_PIPETX0ELECIDLE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PIPETX0POWERDOWN : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_PIPECLK_PIPETX1CHARISK : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_PIPECLK_PIPETX1COMPLIANCE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PIPETX1DATA : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
     tpd_PIPECLK_PIPETX1ELECIDLE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PIPETX1POWERDOWN : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_PIPECLK_PIPETX2CHARISK : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_PIPECLK_PIPETX2COMPLIANCE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PIPETX2DATA : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
     tpd_PIPECLK_PIPETX2ELECIDLE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PIPETX2POWERDOWN : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_PIPECLK_PIPETX3CHARISK : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_PIPECLK_PIPETX3COMPLIANCE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PIPETX3DATA : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
     tpd_PIPECLK_PIPETX3ELECIDLE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PIPETX3POWERDOWN : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_PIPECLK_PIPETX4CHARISK : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_PIPECLK_PIPETX4COMPLIANCE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PIPETX4DATA : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
     tpd_PIPECLK_PIPETX4ELECIDLE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PIPETX4POWERDOWN : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_PIPECLK_PIPETX5CHARISK : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_PIPECLK_PIPETX5COMPLIANCE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PIPETX5DATA : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
     tpd_PIPECLK_PIPETX5ELECIDLE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PIPETX5POWERDOWN : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_PIPECLK_PIPETX6CHARISK : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_PIPECLK_PIPETX6COMPLIANCE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PIPETX6DATA : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
     tpd_PIPECLK_PIPETX6ELECIDLE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PIPETX6POWERDOWN : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_PIPECLK_PIPETX7CHARISK : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_PIPECLK_PIPETX7COMPLIANCE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PIPETX7DATA : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
     tpd_PIPECLK_PIPETX7ELECIDLE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PIPETX7POWERDOWN : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_PIPECLK_PIPETXDEEMPH : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PIPETXMARGIN : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_PIPECLK_PIPETXRATE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PIPETXRCVRDET : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PIPETXRESET : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PLDBGVEC : VitalDelayArrayType01(11 downto 0) := (others => (0 ps, 0 ps));
     tpd_PIPECLK_PLINITIALLINKWIDTH : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_PIPECLK_PLLANEREVERSALMODE : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_PIPECLK_PLLINKGEN2CAP : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PLLINKPARTNERGEN2SUPPORTED : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PLLINKUPCFGCAP : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PLLTSSMSTATE : VitalDelayArrayType01(5 downto 0) := (others => (0 ps, 0 ps));
     tpd_PIPECLK_PLPHYLNKUPN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PLRECEIVEDHOTRST : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PLRXPMSTATE : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_PIPECLK_PLSELLNKRATE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_PIPECLK_PLSELLNKWIDTH : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_PIPECLK_PLTXPMSTATE : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_CFGAERECRCCHECKEN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGAERECRCGENEN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGCOMMANDBUSMASTERENABLE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGCOMMANDINTERRUPTDISABLE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGCOMMANDIOENABLE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGCOMMANDMEMENABLE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGCOMMANDSERREN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGDEVCONTROL2CPLTIMEOUTDIS : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGDEVCONTROL2CPLTIMEOUTVAL : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_CFGDEVCONTROLAUXPOWEREN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGDEVCONTROLCORRERRREPORTINGEN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGDEVCONTROLENABLERO : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGDEVCONTROLEXTTAGEN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGDEVCONTROLFATALERRREPORTINGEN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGDEVCONTROLMAXPAYLOAD : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_CFGDEVCONTROLMAXREADREQ : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_CFGDEVCONTROLNONFATALREPORTINGEN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGDEVCONTROLNOSNOOPEN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGDEVCONTROLPHANTOMEN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGDEVCONTROLURERRREPORTINGEN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGDEVSTATUSCORRERRDETECTED : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGDEVSTATUSFATALERRDETECTED : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGDEVSTATUSNONFATALERRDETECTED : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGDEVSTATUSURDETECTED : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGDO : VitalDelayArrayType01(31 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_CFGERRAERHEADERLOGSETN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGERRCPLRDYN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGINTERRUPTDO : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_CFGINTERRUPTMMENABLE : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_CFGINTERRUPTMSIENABLE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGINTERRUPTMSIXENABLE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGINTERRUPTMSIXFM : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGINTERRUPTRDYN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGLINKCONTROLASPMCONTROL : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_CFGLINKCONTROLAUTOBANDWIDTHINTEN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGLINKCONTROLBANDWIDTHINTEN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGLINKCONTROLCLOCKPMEN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGLINKCONTROLCOMMONCLOCK : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGLINKCONTROLEXTENDEDSYNC : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGLINKCONTROLHWAUTOWIDTHDIS : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGLINKCONTROLLINKDISABLE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGLINKCONTROLRCB : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGLINKCONTROLRETRAINLINK : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGLINKSTATUSAUTOBANDWIDTHSTATUS : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGLINKSTATUSBANDWITHSTATUS : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGLINKSTATUSCURRENTSPEED : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_CFGLINKSTATUSDLLACTIVE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGLINKSTATUSLINKTRAINING : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGLINKSTATUSNEGOTIATEDWIDTH : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_CFGMSGDATA : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_CFGMSGRECEIVED : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGMSGRECEIVEDASSERTINTA : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGMSGRECEIVEDASSERTINTB : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGMSGRECEIVEDASSERTINTC : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGMSGRECEIVEDASSERTINTD : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGMSGRECEIVEDDEASSERTINTA : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGMSGRECEIVEDDEASSERTINTB : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGMSGRECEIVEDDEASSERTINTC : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGMSGRECEIVEDDEASSERTINTD : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGMSGRECEIVEDERRCOR : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGMSGRECEIVEDERRFATAL : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGMSGRECEIVEDERRNONFATAL : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGMSGRECEIVEDPMASNAK : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGMSGRECEIVEDPMETO : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGMSGRECEIVEDPMETOACK : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGMSGRECEIVEDPMPME : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGMSGRECEIVEDSETSLOTPOWERLIMIT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGMSGRECEIVEDUNLOCK : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGPCIELINKSTATE : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_CFGPMCSRPMEEN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGPMCSRPMESTATUS : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGPMCSRPOWERSTATE : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_CFGPMRCVASREQL1N : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGPMRCVENTERL1N : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGPMRCVENTERL23N : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGPMRCVREQACKN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGRDWRDONEN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGSLOTCONTROLELECTROMECHILCTLPULSE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGTRANSACTION : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGTRANSACTIONADDR : VitalDelayArrayType01(6 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_CFGTRANSACTIONTYPE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGVCTCVCMAP : VitalDelayArrayType01(6 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_DBGSCLRA : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_DBGSCLRB : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_DBGSCLRC : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_DBGSCLRD : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_DBGSCLRE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_DBGSCLRF : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_DBGSCLRG : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_DBGSCLRH : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_DBGSCLRI : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_DBGSCLRJ : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_DBGSCLRK : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_DBGVECA : VitalDelayArrayType01(63 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_DBGVECB : VitalDelayArrayType01(63 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_DBGVECC : VitalDelayArrayType01(11 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_LL2BADDLLPERRN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_LL2BADTLPERRN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_LL2PROTOCOLERRN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_LL2REPLAYROERRN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_LL2REPLAYTOERRN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_LL2SUSPENDOKN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_LL2TFCINIT1SEQN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_LL2TFCINIT2SEQN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_LNKCLKEN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_MIMRXRADDR : VitalDelayArrayType01(12 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_MIMRXRCE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_MIMRXREN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_MIMRXWADDR : VitalDelayArrayType01(12 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_MIMRXWDATA : VitalDelayArrayType01(67 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_MIMRXWEN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_MIMTXRADDR : VitalDelayArrayType01(12 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_MIMTXRCE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_MIMTXREN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_MIMTXWADDR : VitalDelayArrayType01(12 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_MIMTXWDATA : VitalDelayArrayType01(68 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_MIMTXWEN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_PL2LINKUPN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_PL2RECEIVERERRN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_PL2RECOVERYN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_PL2RXELECIDLE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_PL2SUSPENDOK : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_RECEIVEDFUNCLVLRSTN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_TL2ASPMSUSPENDCREDITCHECKOKN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_TL2ASPMSUSPENDREQN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_TL2PPMSUSPENDOKN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_TRNFCCPLD : VitalDelayArrayType01(11 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_TRNFCCPLH : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_TRNFCNPD : VitalDelayArrayType01(11 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_TRNFCNPH : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_TRNFCPD : VitalDelayArrayType01(11 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_TRNFCPH : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_TRNLNKUPN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_TRNRBARHITN : VitalDelayArrayType01(6 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_TRNRD : VitalDelayArrayType01(63 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_TRNRDLLPDATA : VitalDelayArrayType01(31 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_TRNRDLLPSRCRDYN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_TRNRECRCERRN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_TRNREOFN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_TRNRERRFWDN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_TRNRREMN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_TRNRSOFN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_TRNRSRCDSCN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_TRNRSRCRDYN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_TRNTBUFAV : VitalDelayArrayType01(5 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_TRNTCFGREQN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_TRNTDLLPDSTRDYN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_TRNTDSTRDYN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_TRNTERRDROPN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_USERRSTN : VitalDelayType01 := (0 ps, 0 ps);
     tperiod_DRPCLK_posedge : VitalDelayType := 0 ps;
     tperiod_PIPECLK_posedge : VitalDelayType := 0 ps;
     tperiod_USERCLK_posedge : VitalDelayType := 0 ps;
     tsetup_CFGBYTEENN_USERCLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_CFGBYTEENN_USERCLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
     tsetup_CFGDI_USERCLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tsetup_CFGDI_USERCLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tsetup_CFGDSBUSNUMBER_USERCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_CFGDSBUSNUMBER_USERCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_CFGDSDEVICENUMBER_USERCLK_negedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tsetup_CFGDSDEVICENUMBER_USERCLK_posedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tsetup_CFGDSFUNCTIONNUMBER_USERCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_CFGDSFUNCTIONNUMBER_USERCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_CFGDSN_USERCLK_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     tsetup_CFGDSN_USERCLK_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     tsetup_CFGDWADDR_USERCLK_negedge_posedge : VitalDelayArrayType(9 downto 0) := (others => 0 ps);
     tsetup_CFGDWADDR_USERCLK_posedge_posedge : VitalDelayArrayType(9 downto 0) := (others => 0 ps);
     tsetup_CFGERRACSN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGERRACSN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGERRAERHEADERLOG_USERCLK_negedge_posedge : VitalDelayArrayType(127 downto 0) := (others => 0 ps);
     tsetup_CFGERRAERHEADERLOG_USERCLK_posedge_posedge : VitalDelayArrayType(127 downto 0) := (others => 0 ps);
     tsetup_CFGERRCORN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGERRCORN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGERRCPLABORTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGERRCPLABORTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGERRCPLTIMEOUTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGERRCPLTIMEOUTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGERRCPLUNEXPECTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGERRCPLUNEXPECTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGERRECRCN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGERRECRCN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGERRLOCKEDN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGERRLOCKEDN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGERRPOSTEDN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGERRPOSTEDN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tsetup_CFGERRURN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGERRURN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGINTERRUPTASSERTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGINTERRUPTASSERTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGINTERRUPTDI_USERCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_CFGINTERRUPTDI_USERCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_CFGINTERRUPTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGINTERRUPTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGPMDIRECTASPML1N_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGPMDIRECTASPML1N_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGPMSENDPMACKN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGPMSENDPMACKN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGPMSENDPMETON_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGPMSENDPMETON_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGPMSENDPMNAKN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGPMSENDPMNAKN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGPMTURNOFFOKN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGPMTURNOFFOKN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGPMWAKEN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGPMWAKEN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGPORTNUMBER_USERCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_CFGPORTNUMBER_USERCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_CFGRDENN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGRDENN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGTRNPENDINGN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGTRNPENDINGN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGWRENN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGWRENN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGWRREADONLYN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGWRREADONLYN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGWRRW1CASRWN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGWRRW1CASRWN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CMRSTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CMRSTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CMSTICKYRSTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CMSTICKYRSTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_DBGMODE_USERCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_DBGMODE_USERCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_DBGSUBMODE_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_DBGSUBMODE_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_DLRSTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_DLRSTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_DRPDADDR_DRPCLK_negedge_posedge : VitalDelayArrayType(8 downto 0) := (others => 0 ps);
     tsetup_DRPDADDR_DRPCLK_posedge_posedge : VitalDelayArrayType(8 downto 0) := (others => 0 ps);
     tsetup_DRPDEN_DRPCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_DRPDEN_DRPCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_DRPDI_DRPCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_DRPDI_DRPCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_DRPDWE_DRPCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_DRPDWE_DRPCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_FUNCLVLRSTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_FUNCLVLRSTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_LL2SENDASREQL1N_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_LL2SENDASREQL1N_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_LL2SENDENTERL1N_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_LL2SENDENTERL1N_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_LL2SENDENTERL23N_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_LL2SENDENTERL23N_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_LL2SUSPENDNOWN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_LL2SUSPENDNOWN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_LL2TLPRCVN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_LL2TLPRCVN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_MIMRXRDATA_USERCLK_negedge_posedge : VitalDelayArrayType(67 downto 0) := (others => 0 ps);
     tsetup_MIMRXRDATA_USERCLK_posedge_posedge : VitalDelayArrayType(67 downto 0) := (others => 0 ps);
     tsetup_MIMTXRDATA_USERCLK_negedge_posedge : VitalDelayArrayType(68 downto 0) := (others => 0 ps);
     tsetup_MIMTXRDATA_USERCLK_posedge_posedge : VitalDelayArrayType(68 downto 0) := (others => 0 ps);
     tsetup_PIPERX0CHANISALIGNED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX0CHANISALIGNED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX0CHARISK_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_PIPERX0CHARISK_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_PIPERX0DATA_PIPECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_PIPERX0DATA_PIPECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_PIPERX0ELECIDLE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX0ELECIDLE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX0PHYSTATUS_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX0PHYSTATUS_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX0STATUS_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_PIPERX0STATUS_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_PIPERX0VALID_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX0VALID_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX1CHANISALIGNED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX1CHANISALIGNED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX1CHARISK_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_PIPERX1CHARISK_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_PIPERX1DATA_PIPECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_PIPERX1DATA_PIPECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_PIPERX1ELECIDLE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX1ELECIDLE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX1PHYSTATUS_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX1PHYSTATUS_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX1STATUS_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_PIPERX1STATUS_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_PIPERX1VALID_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX1VALID_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX2CHANISALIGNED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX2CHANISALIGNED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX2CHARISK_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_PIPERX2CHARISK_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_PIPERX2DATA_PIPECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_PIPERX2DATA_PIPECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_PIPERX2ELECIDLE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX2ELECIDLE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX2PHYSTATUS_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX2PHYSTATUS_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX2STATUS_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_PIPERX2STATUS_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_PIPERX2VALID_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX2VALID_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX3CHANISALIGNED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX3CHANISALIGNED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX3CHARISK_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_PIPERX3CHARISK_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_PIPERX3DATA_PIPECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_PIPERX3DATA_PIPECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_PIPERX3ELECIDLE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX3ELECIDLE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX3PHYSTATUS_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX3PHYSTATUS_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX3STATUS_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_PIPERX3STATUS_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_PIPERX3VALID_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX3VALID_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX4CHANISALIGNED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX4CHANISALIGNED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX4CHARISK_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_PIPERX4CHARISK_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_PIPERX4DATA_PIPECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_PIPERX4DATA_PIPECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_PIPERX4ELECIDLE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX4ELECIDLE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX4PHYSTATUS_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX4PHYSTATUS_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX4STATUS_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_PIPERX4STATUS_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_PIPERX4VALID_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX4VALID_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX5CHANISALIGNED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX5CHANISALIGNED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX5CHARISK_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_PIPERX5CHARISK_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_PIPERX5DATA_PIPECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_PIPERX5DATA_PIPECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_PIPERX5ELECIDLE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX5ELECIDLE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX5PHYSTATUS_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX5PHYSTATUS_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX5STATUS_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_PIPERX5STATUS_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_PIPERX5VALID_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX5VALID_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX6CHANISALIGNED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX6CHANISALIGNED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX6CHARISK_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_PIPERX6CHARISK_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_PIPERX6DATA_PIPECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_PIPERX6DATA_PIPECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_PIPERX6ELECIDLE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX6ELECIDLE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX6PHYSTATUS_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX6PHYSTATUS_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX6STATUS_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_PIPERX6STATUS_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_PIPERX6VALID_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX6VALID_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX7CHANISALIGNED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX7CHANISALIGNED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX7CHARISK_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_PIPERX7CHARISK_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_PIPERX7DATA_PIPECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_PIPERX7DATA_PIPECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_PIPERX7ELECIDLE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX7ELECIDLE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX7PHYSTATUS_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX7PHYSTATUS_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX7STATUS_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_PIPERX7STATUS_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_PIPERX7VALID_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERX7VALID_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PL2DIRECTEDLSTATE_USERCLK_negedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tsetup_PL2DIRECTEDLSTATE_USERCLK_posedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
     tsetup_PLDBGMODE_PIPECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_PLDBGMODE_PIPECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_PLDIRECTEDLINKAUTON_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PLDIRECTEDLINKAUTON_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PLDIRECTEDLINKCHANGE_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_PLDIRECTEDLINKCHANGE_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_PLDIRECTEDLINKSPEED_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PLDIRECTEDLINKSPEED_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PLDIRECTEDLINKWIDTH_PIPECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_PLDIRECTEDLINKWIDTH_PIPECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_PLDOWNSTREAMDEEMPHSOURCE_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PLDOWNSTREAMDEEMPHSOURCE_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PLRSTN_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PLRSTN_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PLTRANSMITHOTRST_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PLTRANSMITHOTRST_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PLUPSTREAMPREFERDEEMPH_PIPECLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PLUPSTREAMPREFERDEEMPH_PIPECLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TL2ASPMSUSPENDCREDITCHECKN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TL2ASPMSUSPENDCREDITCHECKN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TL2PPMSUSPENDREQN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TL2PPMSUSPENDREQN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TLRSTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TLRSTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNFCSEL_USERCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_TRNFCSEL_USERCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_TRNRDSTRDYN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNRDSTRDYN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNRNPOKN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNRNPOKN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNTCFGGNTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNTCFGGNTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNTDLLPDATA_USERCLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tsetup_TRNTDLLPDATA_USERCLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tsetup_TRNTDLLPSRCRDYN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNTDLLPSRCRDYN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNTD_USERCLK_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     tsetup_TRNTD_USERCLK_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     tsetup_TRNTECRCGENN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNTECRCGENN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNTEOFN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNTEOFN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNTERRFWDN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNTERRFWDN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNTREMN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNTREMN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNTSOFN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNTSOFN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNTSRCDSCN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNTSRCDSCN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNTSRCRDYN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNTSRCRDYN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNTSTRN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNTSTRN_USERCLK_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     CFGAERECRCCHECKEN : out std_ulogic;
     CFGAERECRCGENEN : out std_ulogic;
     CFGCOMMANDBUSMASTERENABLE : out std_ulogic;
     CFGCOMMANDINTERRUPTDISABLE : out std_ulogic;
     CFGCOMMANDIOENABLE : out std_ulogic;
     CFGCOMMANDMEMENABLE : out std_ulogic;
     CFGCOMMANDSERREN : out std_ulogic;
     CFGDEVCONTROL2CPLTIMEOUTDIS : out std_ulogic;
     CFGDEVCONTROL2CPLTIMEOUTVAL : out std_logic_vector(3 downto 0);
     CFGDEVCONTROLAUXPOWEREN : out std_ulogic;
     CFGDEVCONTROLCORRERRREPORTINGEN : out std_ulogic;
     CFGDEVCONTROLENABLERO : out std_ulogic;
     CFGDEVCONTROLEXTTAGEN : out std_ulogic;
     CFGDEVCONTROLFATALERRREPORTINGEN : out std_ulogic;
     CFGDEVCONTROLMAXPAYLOAD : out std_logic_vector(2 downto 0);
     CFGDEVCONTROLMAXREADREQ : out std_logic_vector(2 downto 0);
     CFGDEVCONTROLNONFATALREPORTINGEN : out std_ulogic;
     CFGDEVCONTROLNOSNOOPEN : out std_ulogic;
     CFGDEVCONTROLPHANTOMEN : out std_ulogic;
     CFGDEVCONTROLURERRREPORTINGEN : out std_ulogic;
     CFGDEVSTATUSCORRERRDETECTED : out std_ulogic;
     CFGDEVSTATUSFATALERRDETECTED : out std_ulogic;
     CFGDEVSTATUSNONFATALERRDETECTED : out std_ulogic;
     CFGDEVSTATUSURDETECTED : out std_ulogic;
     CFGDO : out std_logic_vector(31 downto 0);
     CFGERRAERHEADERLOGSETN : out std_ulogic;
     CFGERRCPLRDYN : out std_ulogic;
     CFGINTERRUPTDO : out std_logic_vector(7 downto 0);
     CFGINTERRUPTMMENABLE : out std_logic_vector(2 downto 0);
     CFGINTERRUPTMSIENABLE : out std_ulogic;
     CFGINTERRUPTMSIXENABLE : out std_ulogic;
     CFGINTERRUPTMSIXFM : out std_ulogic;
     CFGINTERRUPTRDYN : out std_ulogic;
     CFGLINKCONTROLASPMCONTROL : out std_logic_vector(1 downto 0);
     CFGLINKCONTROLAUTOBANDWIDTHINTEN : out std_ulogic;
     CFGLINKCONTROLBANDWIDTHINTEN : out std_ulogic;
     CFGLINKCONTROLCLOCKPMEN : out std_ulogic;
     CFGLINKCONTROLCOMMONCLOCK : out std_ulogic;
     CFGLINKCONTROLEXTENDEDSYNC : out std_ulogic;
     CFGLINKCONTROLHWAUTOWIDTHDIS : out std_ulogic;
     CFGLINKCONTROLLINKDISABLE : out std_ulogic;
     CFGLINKCONTROLRCB : out std_ulogic;
     CFGLINKCONTROLRETRAINLINK : out std_ulogic;
     CFGLINKSTATUSAUTOBANDWIDTHSTATUS : out std_ulogic;
     CFGLINKSTATUSBANDWITHSTATUS : out std_ulogic;
     CFGLINKSTATUSCURRENTSPEED : out std_logic_vector(1 downto 0);
     CFGLINKSTATUSDLLACTIVE : out std_ulogic;
     CFGLINKSTATUSLINKTRAINING : out std_ulogic;
     CFGLINKSTATUSNEGOTIATEDWIDTH : out std_logic_vector(3 downto 0);
     CFGMSGDATA : out std_logic_vector(15 downto 0);
     CFGMSGRECEIVED : out std_ulogic;
     CFGMSGRECEIVEDASSERTINTA : out std_ulogic;
     CFGMSGRECEIVEDASSERTINTB : out std_ulogic;
     CFGMSGRECEIVEDASSERTINTC : out std_ulogic;
     CFGMSGRECEIVEDASSERTINTD : out std_ulogic;
     CFGMSGRECEIVEDDEASSERTINTA : out std_ulogic;
     CFGMSGRECEIVEDDEASSERTINTB : out std_ulogic;
     CFGMSGRECEIVEDDEASSERTINTC : out std_ulogic;
     CFGMSGRECEIVEDDEASSERTINTD : out std_ulogic;
     CFGMSGRECEIVEDERRCOR : out std_ulogic;
     CFGMSGRECEIVEDERRFATAL : out std_ulogic;
     CFGMSGRECEIVEDERRNONFATAL : out std_ulogic;
     CFGMSGRECEIVEDPMASNAK : out std_ulogic;
     CFGMSGRECEIVEDPMETO : out std_ulogic;
     CFGMSGRECEIVEDPMETOACK : out std_ulogic;
     CFGMSGRECEIVEDPMPME : out std_ulogic;
     CFGMSGRECEIVEDSETSLOTPOWERLIMIT : out std_ulogic;
     CFGMSGRECEIVEDUNLOCK : out std_ulogic;
     CFGPCIELINKSTATE : out std_logic_vector(2 downto 0);
     CFGPMCSRPMEEN : out std_ulogic;
     CFGPMCSRPMESTATUS : out std_ulogic;
     CFGPMCSRPOWERSTATE : out std_logic_vector(1 downto 0);
     CFGPMRCVASREQL1N : out std_ulogic;
     CFGPMRCVENTERL1N : out std_ulogic;
     CFGPMRCVENTERL23N : out std_ulogic;
     CFGPMRCVREQACKN : out std_ulogic;
     CFGRDWRDONEN : out std_ulogic;
     CFGSLOTCONTROLELECTROMECHILCTLPULSE : out std_ulogic;
     CFGTRANSACTION : out std_ulogic;
     CFGTRANSACTIONADDR : out std_logic_vector(6 downto 0);
     CFGTRANSACTIONTYPE : out std_ulogic;
     CFGVCTCVCMAP : out std_logic_vector(6 downto 0);
     DBGSCLRA : out std_ulogic;
     DBGSCLRB : out std_ulogic;
     DBGSCLRC : out std_ulogic;
     DBGSCLRD : out std_ulogic;
     DBGSCLRE : out std_ulogic;
     DBGSCLRF : out std_ulogic;
     DBGSCLRG : out std_ulogic;
     DBGSCLRH : out std_ulogic;
     DBGSCLRI : out std_ulogic;
     DBGSCLRJ : out std_ulogic;
     DBGSCLRK : out std_ulogic;
     DBGVECA : out std_logic_vector(63 downto 0);
     DBGVECB : out std_logic_vector(63 downto 0);
     DBGVECC : out std_logic_vector(11 downto 0);
     DRPDO : out std_logic_vector(15 downto 0);
     DRPDRDY : out std_ulogic;
     LL2BADDLLPERRN : out std_ulogic;
     LL2BADTLPERRN : out std_ulogic;
     LL2PROTOCOLERRN : out std_ulogic;
     LL2REPLAYROERRN : out std_ulogic;
     LL2REPLAYTOERRN : out std_ulogic;
     LL2SUSPENDOKN : out std_ulogic;
     LL2TFCINIT1SEQN : out std_ulogic;
     LL2TFCINIT2SEQN : out std_ulogic;
     LNKCLKEN : out std_ulogic;
     MIMRXRADDR : out std_logic_vector(12 downto 0);
     MIMRXRCE : out std_ulogic;
     MIMRXREN : out std_ulogic;
     MIMRXWADDR : out std_logic_vector(12 downto 0);
     MIMRXWDATA : out std_logic_vector(67 downto 0);
     MIMRXWEN : out std_ulogic;
     MIMTXRADDR : out std_logic_vector(12 downto 0);
     MIMTXRCE : out std_ulogic;
     MIMTXREN : out std_ulogic;
     MIMTXWADDR : out std_logic_vector(12 downto 0);
     MIMTXWDATA : out std_logic_vector(68 downto 0);
     MIMTXWEN : out std_ulogic;
     PIPERX0POLARITY : out std_ulogic;
     PIPERX1POLARITY : out std_ulogic;
     PIPERX2POLARITY : out std_ulogic;
     PIPERX3POLARITY : out std_ulogic;
     PIPERX4POLARITY : out std_ulogic;
     PIPERX5POLARITY : out std_ulogic;
     PIPERX6POLARITY : out std_ulogic;
     PIPERX7POLARITY : out std_ulogic;
     PIPETX0CHARISK : out std_logic_vector(1 downto 0);
     PIPETX0COMPLIANCE : out std_ulogic;
     PIPETX0DATA : out std_logic_vector(15 downto 0);
     PIPETX0ELECIDLE : out std_ulogic;
     PIPETX0POWERDOWN : out std_logic_vector(1 downto 0);
     PIPETX1CHARISK : out std_logic_vector(1 downto 0);
     PIPETX1COMPLIANCE : out std_ulogic;
     PIPETX1DATA : out std_logic_vector(15 downto 0);
     PIPETX1ELECIDLE : out std_ulogic;
     PIPETX1POWERDOWN : out std_logic_vector(1 downto 0);
     PIPETX2CHARISK : out std_logic_vector(1 downto 0);
     PIPETX2COMPLIANCE : out std_ulogic;
     PIPETX2DATA : out std_logic_vector(15 downto 0);
     PIPETX2ELECIDLE : out std_ulogic;
     PIPETX2POWERDOWN : out std_logic_vector(1 downto 0);
     PIPETX3CHARISK : out std_logic_vector(1 downto 0);
     PIPETX3COMPLIANCE : out std_ulogic;
     PIPETX3DATA : out std_logic_vector(15 downto 0);
     PIPETX3ELECIDLE : out std_ulogic;
     PIPETX3POWERDOWN : out std_logic_vector(1 downto 0);
     PIPETX4CHARISK : out std_logic_vector(1 downto 0);
     PIPETX4COMPLIANCE : out std_ulogic;
     PIPETX4DATA : out std_logic_vector(15 downto 0);
     PIPETX4ELECIDLE : out std_ulogic;
     PIPETX4POWERDOWN : out std_logic_vector(1 downto 0);
     PIPETX5CHARISK : out std_logic_vector(1 downto 0);
     PIPETX5COMPLIANCE : out std_ulogic;
     PIPETX5DATA : out std_logic_vector(15 downto 0);
     PIPETX5ELECIDLE : out std_ulogic;
     PIPETX5POWERDOWN : out std_logic_vector(1 downto 0);
     PIPETX6CHARISK : out std_logic_vector(1 downto 0);
     PIPETX6COMPLIANCE : out std_ulogic;
     PIPETX6DATA : out std_logic_vector(15 downto 0);
     PIPETX6ELECIDLE : out std_ulogic;
     PIPETX6POWERDOWN : out std_logic_vector(1 downto 0);
     PIPETX7CHARISK : out std_logic_vector(1 downto 0);
     PIPETX7COMPLIANCE : out std_ulogic;
     PIPETX7DATA : out std_logic_vector(15 downto 0);
     PIPETX7ELECIDLE : out std_ulogic;
     PIPETX7POWERDOWN : out std_logic_vector(1 downto 0);
     PIPETXDEEMPH : out std_ulogic;
     PIPETXMARGIN : out std_logic_vector(2 downto 0);
     PIPETXRATE : out std_ulogic;
     PIPETXRCVRDET : out std_ulogic;
     PIPETXRESET : out std_ulogic;
     PL2LINKUPN : out std_ulogic;
     PL2RECEIVERERRN : out std_ulogic;
     PL2RECOVERYN : out std_ulogic;
     PL2RXELECIDLE : out std_ulogic;
     PL2SUSPENDOK : out std_ulogic;
     PLDBGVEC : out std_logic_vector(11 downto 0);
     PLINITIALLINKWIDTH : out std_logic_vector(2 downto 0);
     PLLANEREVERSALMODE : out std_logic_vector(1 downto 0);
     PLLINKGEN2CAP : out std_ulogic;
     PLLINKPARTNERGEN2SUPPORTED : out std_ulogic;
     PLLINKUPCFGCAP : out std_ulogic;
     PLLTSSMSTATE : out std_logic_vector(5 downto 0);
     PLPHYLNKUPN : out std_ulogic;
     PLRECEIVEDHOTRST : out std_ulogic;
     PLRXPMSTATE : out std_logic_vector(1 downto 0);
     PLSELLNKRATE : out std_ulogic;
     PLSELLNKWIDTH : out std_logic_vector(1 downto 0);
     PLTXPMSTATE : out std_logic_vector(2 downto 0);
     RECEIVEDFUNCLVLRSTN : out std_ulogic;
     TL2ASPMSUSPENDCREDITCHECKOKN : out std_ulogic;
     TL2ASPMSUSPENDREQN : out std_ulogic;
     TL2PPMSUSPENDOKN : out std_ulogic;
     TRNFCCPLD : out std_logic_vector(11 downto 0);
     TRNFCCPLH : out std_logic_vector(7 downto 0);
     TRNFCNPD : out std_logic_vector(11 downto 0);
     TRNFCNPH : out std_logic_vector(7 downto 0);
     TRNFCPD : out std_logic_vector(11 downto 0);
     TRNFCPH : out std_logic_vector(7 downto 0);
     TRNLNKUPN : out std_ulogic;
     TRNRBARHITN : out std_logic_vector(6 downto 0);
     TRNRD : out std_logic_vector(63 downto 0);
     TRNRDLLPDATA : out std_logic_vector(31 downto 0);
     TRNRDLLPSRCRDYN : out std_ulogic;
     TRNRECRCERRN : out std_ulogic;
     TRNREOFN : out std_ulogic;
     TRNRERRFWDN : out std_ulogic;
     TRNRREMN : out std_ulogic;
     TRNRSOFN : out std_ulogic;
     TRNRSRCDSCN : out std_ulogic;
     TRNRSRCRDYN : out std_ulogic;
     TRNTBUFAV : out std_logic_vector(5 downto 0);
     TRNTCFGREQN : out std_ulogic;
     TRNTDLLPDSTRDYN : out std_ulogic;
     TRNTDSTRDYN : out std_ulogic;
     TRNTERRDROPN : out std_ulogic;
     USERRSTN : out std_ulogic;
     CFGBYTEENN : in std_logic_vector(3 downto 0);
     CFGDI : in std_logic_vector(31 downto 0);
     CFGDSBUSNUMBER : in std_logic_vector(7 downto 0);
     CFGDSDEVICENUMBER : in std_logic_vector(4 downto 0);
     CFGDSFUNCTIONNUMBER : in std_logic_vector(2 downto 0);
     CFGDSN : in std_logic_vector(63 downto 0);
     CFGDWADDR : in std_logic_vector(9 downto 0);
     CFGERRACSN : in std_ulogic;
     CFGERRAERHEADERLOG : in std_logic_vector(127 downto 0);
     CFGERRCORN : in std_ulogic;
     CFGERRCPLABORTN : in std_ulogic;
     CFGERRCPLTIMEOUTN : in std_ulogic;
     CFGERRCPLUNEXPECTN : in std_ulogic;
     CFGERRECRCN : in std_ulogic;
     CFGERRLOCKEDN : in std_ulogic;
     CFGERRPOSTEDN : in std_ulogic;
     CFGERRTLPCPLHEADER : in std_logic_vector(47 downto 0);
     CFGERRURN : in std_ulogic;
     CFGINTERRUPTASSERTN : in std_ulogic;
     CFGINTERRUPTDI : in std_logic_vector(7 downto 0);
     CFGINTERRUPTN : in std_ulogic;
     CFGPMDIRECTASPML1N : in std_ulogic;
     CFGPMSENDPMACKN : in std_ulogic;
     CFGPMSENDPMETON : in std_ulogic;
     CFGPMSENDPMNAKN : in std_ulogic;
     CFGPMTURNOFFOKN : in std_ulogic;
     CFGPMWAKEN : in std_ulogic;
     CFGPORTNUMBER : in std_logic_vector(7 downto 0);
     CFGRDENN : in std_ulogic;
     CFGTRNPENDINGN : in std_ulogic;
     CFGWRENN : in std_ulogic;
     CFGWRREADONLYN : in std_ulogic;
     CFGWRRW1CASRWN : in std_ulogic;
     CMRSTN : in std_ulogic;
     CMSTICKYRSTN : in std_ulogic;
     DBGMODE : in std_logic_vector(1 downto 0);
     DBGSUBMODE : in std_ulogic;
     DLRSTN : in std_ulogic;
     DRPCLK : in std_ulogic;
     DRPDADDR : in std_logic_vector(8 downto 0);
     DRPDEN : in std_ulogic;
     DRPDI : in std_logic_vector(15 downto 0);
     DRPDWE : in std_ulogic;
     FUNCLVLRSTN : in std_ulogic;
     LL2SENDASREQL1N : in std_ulogic;
     LL2SENDENTERL1N : in std_ulogic;
     LL2SENDENTERL23N : in std_ulogic;
     LL2SUSPENDNOWN : in std_ulogic;
     LL2TLPRCVN : in std_ulogic;
     MIMRXRDATA : in std_logic_vector(67 downto 0);
     MIMTXRDATA : in std_logic_vector(68 downto 0);
     PIPECLK : in std_ulogic;
     PIPERX0CHANISALIGNED : in std_ulogic;
     PIPERX0CHARISK : in std_logic_vector(1 downto 0);
     PIPERX0DATA : in std_logic_vector(15 downto 0);
     PIPERX0ELECIDLE : in std_ulogic;
     PIPERX0PHYSTATUS : in std_ulogic;
     PIPERX0STATUS : in std_logic_vector(2 downto 0);
     PIPERX0VALID : in std_ulogic;
     PIPERX1CHANISALIGNED : in std_ulogic;
     PIPERX1CHARISK : in std_logic_vector(1 downto 0);
     PIPERX1DATA : in std_logic_vector(15 downto 0);
     PIPERX1ELECIDLE : in std_ulogic;
     PIPERX1PHYSTATUS : in std_ulogic;
     PIPERX1STATUS : in std_logic_vector(2 downto 0);
     PIPERX1VALID : in std_ulogic;
     PIPERX2CHANISALIGNED : in std_ulogic;
     PIPERX2CHARISK : in std_logic_vector(1 downto 0);
     PIPERX2DATA : in std_logic_vector(15 downto 0);
     PIPERX2ELECIDLE : in std_ulogic;
     PIPERX2PHYSTATUS : in std_ulogic;
     PIPERX2STATUS : in std_logic_vector(2 downto 0);
     PIPERX2VALID : in std_ulogic;
     PIPERX3CHANISALIGNED : in std_ulogic;
     PIPERX3CHARISK : in std_logic_vector(1 downto 0);
     PIPERX3DATA : in std_logic_vector(15 downto 0);
     PIPERX3ELECIDLE : in std_ulogic;
     PIPERX3PHYSTATUS : in std_ulogic;
     PIPERX3STATUS : in std_logic_vector(2 downto 0);
     PIPERX3VALID : in std_ulogic;
     PIPERX4CHANISALIGNED : in std_ulogic;
     PIPERX4CHARISK : in std_logic_vector(1 downto 0);
     PIPERX4DATA : in std_logic_vector(15 downto 0);
     PIPERX4ELECIDLE : in std_ulogic;
     PIPERX4PHYSTATUS : in std_ulogic;
     PIPERX4STATUS : in std_logic_vector(2 downto 0);
     PIPERX4VALID : in std_ulogic;
     PIPERX5CHANISALIGNED : in std_ulogic;
     PIPERX5CHARISK : in std_logic_vector(1 downto 0);
     PIPERX5DATA : in std_logic_vector(15 downto 0);
     PIPERX5ELECIDLE : in std_ulogic;
     PIPERX5PHYSTATUS : in std_ulogic;
     PIPERX5STATUS : in std_logic_vector(2 downto 0);
     PIPERX5VALID : in std_ulogic;
     PIPERX6CHANISALIGNED : in std_ulogic;
     PIPERX6CHARISK : in std_logic_vector(1 downto 0);
     PIPERX6DATA : in std_logic_vector(15 downto 0);
     PIPERX6ELECIDLE : in std_ulogic;
     PIPERX6PHYSTATUS : in std_ulogic;
     PIPERX6STATUS : in std_logic_vector(2 downto 0);
     PIPERX6VALID : in std_ulogic;
     PIPERX7CHANISALIGNED : in std_ulogic;
     PIPERX7CHARISK : in std_logic_vector(1 downto 0);
     PIPERX7DATA : in std_logic_vector(15 downto 0);
     PIPERX7ELECIDLE : in std_ulogic;
     PIPERX7PHYSTATUS : in std_ulogic;
     PIPERX7STATUS : in std_logic_vector(2 downto 0);
     PIPERX7VALID : in std_ulogic;
     PL2DIRECTEDLSTATE : in std_logic_vector(4 downto 0);
     PLDBGMODE : in std_logic_vector(2 downto 0);
     PLDIRECTEDLINKAUTON : in std_ulogic;
     PLDIRECTEDLINKCHANGE : in std_logic_vector(1 downto 0);
     PLDIRECTEDLINKSPEED : in std_ulogic;
     PLDIRECTEDLINKWIDTH : in std_logic_vector(1 downto 0);
     PLDOWNSTREAMDEEMPHSOURCE : in std_ulogic;
     PLRSTN : in std_ulogic;
     PLTRANSMITHOTRST : in std_ulogic;
     PLUPSTREAMPREFERDEEMPH : in std_ulogic;
     SYSRSTN : in std_ulogic;
     TL2ASPMSUSPENDCREDITCHECKN : in std_ulogic;
     TL2PPMSUSPENDREQN : in std_ulogic;
     TLRSTN : in std_ulogic;
     TRNFCSEL : in std_logic_vector(2 downto 0);
     TRNRDSTRDYN : in std_ulogic;
     TRNRNPOKN : in std_ulogic;
     TRNTCFGGNTN : in std_ulogic;
     TRNTD : in std_logic_vector(63 downto 0);
     TRNTDLLPDATA : in std_logic_vector(31 downto 0);
     TRNTDLLPSRCRDYN : in std_ulogic;
     TRNTECRCGENN : in std_ulogic;
     TRNTEOFN : in std_ulogic;
     TRNTERRFWDN : in std_ulogic;
     TRNTREMN : in std_ulogic;
     TRNTSOFN : in std_ulogic;
     TRNTSRCDSCN : in std_ulogic;
     TRNTSRCRDYN : in std_ulogic;
     TRNTSTRN : in std_ulogic;
     USERCLK : in std_ulogic
  );
end component;

----- component X_PCIE_A1 -----
component X_PCIE_A1
  generic (
     BAR0 : bit_vector := X"00000000";
     BAR1 : bit_vector := X"00000000";
     BAR2 : bit_vector := X"00000000";
     BAR3 : bit_vector := X"00000000";
     BAR4 : bit_vector := X"00000000";
     BAR5 : bit_vector := X"00000000";
     CARDBUS_CIS_POINTER : bit_vector := X"00000000";
     CLASS_CODE : bit_vector := X"000000";
     DEV_CAP_ENDPOINT_L0S_LATENCY : integer := 7;
     DEV_CAP_ENDPOINT_L1_LATENCY : integer := 7;
     DEV_CAP_EXT_TAG_SUPPORTED : boolean := FALSE;
     DEV_CAP_MAX_PAYLOAD_SUPPORTED : integer := 2;
     DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT : integer := 0;
     DEV_CAP_ROLE_BASED_ERROR : boolean := TRUE;
     DISABLE_BAR_FILTERING : boolean := FALSE;
     DISABLE_ID_CHECK : boolean := FALSE;
     DISABLE_SCRAMBLING : boolean := FALSE;
     ENABLE_RX_TD_ECRC_TRIM : boolean := FALSE;
     EXPANSION_ROM : bit_vector := X"000000";
     FAST_TRAIN : boolean := FALSE;
     GTP_SEL : integer := 0;
     InstancePath : string := "*";
     LINK_CAP_ASPM_SUPPORT : integer := 1;
     LINK_CAP_L0S_EXIT_LATENCY : integer := 7;
     LINK_CAP_L1_EXIT_LATENCY : integer := 7;
     LINK_STATUS_SLOT_CLOCK_CONFIG : boolean := FALSE;
     LL_ACK_TIMEOUT : bit_vector := X"0204";
     LL_ACK_TIMEOUT_EN : boolean := FALSE;
     LL_REPLAY_TIMEOUT : bit_vector := X"060D";
     LL_REPLAY_TIMEOUT_EN : boolean := FALSE;
     LOC : string := "UNPLACED";
     MSI_CAP_MULTIMSGCAP : integer := 0;
     MSI_CAP_MULTIMSG_EXTENSION : integer := 0;
     MsgOn : boolean := FALSE;
     PCIE_CAP_CAPABILITY_VERSION : bit_vector := X"1";
     PCIE_CAP_DEVICE_PORT_TYPE : bit_vector := X"0";
     PCIE_CAP_INT_MSG_NUM : bit_vector := "00000";
     PCIE_CAP_SLOT_IMPLEMENTED : boolean := FALSE;
     PCIE_GENERIC : bit_vector := X"000";
     PLM_AUTO_CONFIG : boolean := FALSE;
     PM_CAP_AUXCURRENT : integer := 0;
     PM_CAP_D1SUPPORT : boolean := TRUE;
     PM_CAP_D2SUPPORT : boolean := TRUE;
     PM_CAP_DSI : boolean := FALSE;
     PM_CAP_PMESUPPORT : bit_vector := "01111";
     PM_CAP_PME_CLOCK : boolean := FALSE;
     PM_CAP_VERSION : integer := 3;
     PM_DATA0 : bit_vector := X"1E";
     PM_DATA1 : bit_vector := X"1E";
     PM_DATA2 : bit_vector := X"1E";
     PM_DATA3 : bit_vector := X"1E";
     PM_DATA4 : bit_vector := X"1E";
     PM_DATA5 : bit_vector := X"1E";
     PM_DATA6 : bit_vector := X"1E";
     PM_DATA7 : bit_vector := X"1E";
     PM_DATA_SCALE0 : bit_vector := "01";
     PM_DATA_SCALE1 : bit_vector := "01";
     PM_DATA_SCALE2 : bit_vector := "01";
     PM_DATA_SCALE3 : bit_vector := "01";
     PM_DATA_SCALE4 : bit_vector := "01";
     PM_DATA_SCALE5 : bit_vector := "01";
     PM_DATA_SCALE6 : bit_vector := "01";
     PM_DATA_SCALE7 : bit_vector := "01";
     SIM_VERSION : string := "1.0";
     SLOT_CAP_ATT_BUTTON_PRESENT : boolean := FALSE;
     SLOT_CAP_ATT_INDICATOR_PRESENT : boolean := FALSE;
     SLOT_CAP_POWER_INDICATOR_PRESENT : boolean := FALSE;
     TL_RX_RAM_RADDR_LATENCY : integer := 1;
     TL_RX_RAM_RDATA_LATENCY : integer := 2;
     TL_RX_RAM_WRITE_LATENCY : integer := 0;
     TL_TFC_DISABLE : boolean := FALSE;
     TL_TX_CHECKS_DISABLE : boolean := FALSE;
     TL_TX_RAM_RADDR_LATENCY : integer := 0;
     TL_TX_RAM_RDATA_LATENCY : integer := 2;
     TimingChecksOn : boolean := TRUE;
     USR_CFG : boolean := FALSE;
     USR_EXT_CFG : boolean := FALSE;
     VC0_CPL_INFINITE : boolean := TRUE;
     VC0_RX_RAM_LIMIT : bit_vector := X"01E";
     VC0_TOTAL_CREDITS_CD : integer := 104;
     VC0_TOTAL_CREDITS_CH : integer := 36;
     VC0_TOTAL_CREDITS_NPH : integer := 8;
     VC0_TOTAL_CREDITS_PD : integer := 288;
     VC0_TOTAL_CREDITS_PH : integer := 32;
     VC0_TX_LASTPACKET : integer := 31;
     Xon : boolean := TRUE;
     thold_CFGDEVID_USERCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_CFGDEVID_USERCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_CFGDSN_USERCLK_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     thold_CFGDSN_USERCLK_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     thold_CFGDWADDR_USERCLK_negedge_posedge : VitalDelayArrayType(9 downto 0) := (others => 0 ps);
     thold_CFGDWADDR_USERCLK_posedge_posedge : VitalDelayArrayType(9 downto 0) := (others => 0 ps);
     thold_CFGERRCORN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGERRCORN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CFGERRCPLABORTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGERRCPLABORTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CFGERRCPLTIMEOUTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGERRCPLTIMEOUTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CFGERRECRCN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGERRECRCN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CFGERRLOCKEDN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGERRLOCKEDN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CFGERRPOSTEDN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGERRPOSTEDN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     thold_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     thold_CFGERRURN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGERRURN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CFGINTERRUPTASSERTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGINTERRUPTASSERTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CFGINTERRUPTDI_USERCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_CFGINTERRUPTDI_USERCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_CFGINTERRUPTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGINTERRUPTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CFGPMWAKEN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGPMWAKEN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CFGRDENN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGRDENN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CFGREVID_USERCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_CFGREVID_USERCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     thold_CFGSUBSYSID_USERCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_CFGSUBSYSID_USERCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_CFGSUBSYSVENID_USERCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_CFGSUBSYSVENID_USERCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_CFGTRNPENDINGN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGTRNPENDINGN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CFGTURNOFFOKN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_CFGTURNOFFOKN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_CFGVENID_USERCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_CFGVENID_USERCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_MIMRXRDATA_USERCLK_negedge_posedge : VitalDelayArrayType(34 downto 0) := (others => 0 ps);
     thold_MIMRXRDATA_USERCLK_posedge_posedge : VitalDelayArrayType(34 downto 0) := (others => 0 ps);
     thold_MIMTXRDATA_USERCLK_negedge_posedge : VitalDelayArrayType(35 downto 0) := (others => 0 ps);
     thold_MIMTXRDATA_USERCLK_posedge_posedge : VitalDelayArrayType(35 downto 0) := (others => 0 ps);
     thold_PIPEGTRESETDONEA_MGTCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPEGTRESETDONEA_MGTCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPEGTRESETDONEB_MGTCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPEGTRESETDONEB_MGTCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPEPHYSTATUSA_MGTCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPEPHYSTATUSA_MGTCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPEPHYSTATUSB_MGTCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPEPHYSTATUSB_MGTCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERXCHARISKA_MGTCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_PIPERXCHARISKA_MGTCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_PIPERXCHARISKB_MGTCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_PIPERXCHARISKB_MGTCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     thold_PIPERXDATAA_MGTCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_PIPERXDATAA_MGTCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_PIPERXDATAB_MGTCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_PIPERXDATAB_MGTCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     thold_PIPERXENTERELECIDLEA_MGTCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERXENTERELECIDLEA_MGTCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERXENTERELECIDLEB_MGTCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERXENTERELECIDLEB_MGTCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_PIPERXSTATUSA_MGTCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_PIPERXSTATUSA_MGTCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_PIPERXSTATUSB_MGTCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_PIPERXSTATUSB_MGTCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_TRNFCSEL_USERCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_TRNFCSEL_USERCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     thold_TRNRDSTRDYN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_TRNRDSTRDYN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_TRNRNPOKN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_TRNRNPOKN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_TRNTCFGGNTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_TRNTCFGGNTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_TRNTD_USERCLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     thold_TRNTD_USERCLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     thold_TRNTEOFN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_TRNTEOFN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_TRNTERRFWDN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_TRNTERRFWDN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_TRNTSOFN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_TRNTSOFN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_TRNTSRCDSCN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_TRNTSRCDSCN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_TRNTSRCRDYN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_TRNTSRCRDYN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     thold_TRNTSTRN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     thold_TRNTSTRN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     ticd_MGTCLK : VitalDelayType := 0 ps;
     ticd_USERCLK : VitalDelayType := 0 ps;
     tipd_CFGDEVID : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
     tipd_CFGDSN : VitalDelayArrayType01 (63 downto 0) := (others => (0 ps, 0 ps));
     tipd_CFGDWADDR : VitalDelayArrayType01 (9 downto 0) := (others => (0 ps, 0 ps));
     tipd_CFGERRCORN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CFGERRCPLABORTN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CFGERRCPLTIMEOUTN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CFGERRECRCN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CFGERRLOCKEDN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CFGERRPOSTEDN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CFGERRTLPCPLHEADER : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
     tipd_CFGERRURN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CFGINTERRUPTASSERTN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CFGINTERRUPTDI : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
     tipd_CFGINTERRUPTN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CFGPMWAKEN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CFGRDENN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CFGREVID : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
     tipd_CFGSUBSYSID : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
     tipd_CFGSUBSYSVENID : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
     tipd_CFGTRNPENDINGN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CFGTURNOFFOKN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_CFGVENID : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
     tipd_CLOCKLOCKED : VitalDelayType01 := (0 ps, 0 ps);
     tipd_MGTCLK : VitalDelayType01 := (0 ps, 0 ps);
     tipd_MIMRXRDATA : VitalDelayArrayType01 (34 downto 0) := (others => (0 ps, 0 ps));
     tipd_MIMTXRDATA : VitalDelayArrayType01 (35 downto 0) := (others => (0 ps, 0 ps));
     tipd_PIPEGTRESETDONEA : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPEGTRESETDONEB : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPEPHYSTATUSA : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPEPHYSTATUSB : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERXCHARISKA : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_PIPERXCHARISKB : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
     tipd_PIPERXDATAA : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
     tipd_PIPERXDATAB : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
     tipd_PIPERXENTERELECIDLEA : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERXENTERELECIDLEB : VitalDelayType01 := (0 ps, 0 ps);
     tipd_PIPERXSTATUSA : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_PIPERXSTATUSB : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_SYSRESETN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TRNFCSEL : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
     tipd_TRNRDSTRDYN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TRNRNPOKN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TRNTCFGGNTN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TRNTD : VitalDelayArrayType01 (31 downto 0) := (others => (0 ps, 0 ps));
     tipd_TRNTEOFN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TRNTERRFWDN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TRNTSOFN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TRNTSRCDSCN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TRNTSRCRDYN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_TRNTSTRN : VitalDelayType01 := (0 ps, 0 ps);
     tipd_USERCLK : VitalDelayType01 := (0 ps, 0 ps);
     tisd_CFGDEVID_USERCLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tisd_CFGDSN_USERCLK : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     tisd_CFGDWADDR_USERCLK : VitalDelayArrayType(9 downto 0) := (others => 0 ps);
     tisd_CFGERRCORN_USERCLK : VitalDelayType := 0 ps;
     tisd_CFGERRCPLABORTN_USERCLK : VitalDelayType := 0 ps;
     tisd_CFGERRCPLTIMEOUTN_USERCLK : VitalDelayType := 0 ps;
     tisd_CFGERRECRCN_USERCLK : VitalDelayType := 0 ps;
     tisd_CFGERRLOCKEDN_USERCLK : VitalDelayType := 0 ps;
     tisd_CFGERRPOSTEDN_USERCLK : VitalDelayType := 0 ps;
     tisd_CFGERRTLPCPLHEADER_USERCLK : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tisd_CFGERRURN_USERCLK : VitalDelayType := 0 ps;
     tisd_CFGINTERRUPTASSERTN_USERCLK : VitalDelayType := 0 ps;
     tisd_CFGINTERRUPTDI_USERCLK : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tisd_CFGINTERRUPTN_USERCLK : VitalDelayType := 0 ps;
     tisd_CFGPMWAKEN_USERCLK : VitalDelayType := 0 ps;
     tisd_CFGRDENN_USERCLK : VitalDelayType := 0 ps;
     tisd_CFGREVID_USERCLK : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tisd_CFGSUBSYSID_USERCLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tisd_CFGSUBSYSVENID_USERCLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tisd_CFGTRNPENDINGN_USERCLK : VitalDelayType := 0 ps;
     tisd_CFGTURNOFFOKN_USERCLK : VitalDelayType := 0 ps;
     tisd_CFGVENID_USERCLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tisd_MIMRXRDATA_USERCLK : VitalDelayArrayType(34 downto 0) := (others => 0 ps);
     tisd_MIMTXRDATA_USERCLK : VitalDelayArrayType(35 downto 0) := (others => 0 ps);
     tisd_PIPEGTRESETDONEA_MGTCLK : VitalDelayType := 0 ps;
     tisd_PIPEGTRESETDONEB_MGTCLK : VitalDelayType := 0 ps;
     tisd_PIPEPHYSTATUSA_MGTCLK : VitalDelayType := 0 ps;
     tisd_PIPEPHYSTATUSB_MGTCLK : VitalDelayType := 0 ps;
     tisd_PIPERXCHARISKA_MGTCLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_PIPERXCHARISKB_MGTCLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tisd_PIPERXDATAA_MGTCLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tisd_PIPERXDATAB_MGTCLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tisd_PIPERXENTERELECIDLEA_MGTCLK : VitalDelayType := 0 ps;
     tisd_PIPERXENTERELECIDLEB_MGTCLK : VitalDelayType := 0 ps;
     tisd_PIPERXSTATUSA_MGTCLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_PIPERXSTATUSB_MGTCLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_TRNFCSEL_USERCLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tisd_TRNRDSTRDYN_USERCLK : VitalDelayType := 0 ps;
     tisd_TRNRNPOKN_USERCLK : VitalDelayType := 0 ps;
     tisd_TRNTCFGGNTN_USERCLK : VitalDelayType := 0 ps;
     tisd_TRNTD_USERCLK : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tisd_TRNTEOFN_USERCLK : VitalDelayType := 0 ps;
     tisd_TRNTERRFWDN_USERCLK : VitalDelayType := 0 ps;
     tisd_TRNTSOFN_USERCLK : VitalDelayType := 0 ps;
     tisd_TRNTSRCDSCN_USERCLK : VitalDelayType := 0 ps;
     tisd_TRNTSRCRDYN_USERCLK : VitalDelayType := 0 ps;
     tisd_TRNTSTRN_USERCLK : VitalDelayType := 0 ps;
     tpd_MGTCLK_CFGLTSSMSTATE : VitalDelayArrayType01(4 downto 0) := (others => (0 ps, 0 ps));
     tpd_MGTCLK_PIPEGTPOWERDOWNA : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_MGTCLK_PIPEGTPOWERDOWNB : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_MGTCLK_PIPEGTTXELECIDLEA : VitalDelayType01 := (0 ps, 0 ps);
     tpd_MGTCLK_PIPEGTTXELECIDLEB : VitalDelayType01 := (0 ps, 0 ps);
     tpd_MGTCLK_PIPERXPOLARITYA : VitalDelayType01 := (0 ps, 0 ps);
     tpd_MGTCLK_PIPERXPOLARITYB : VitalDelayType01 := (0 ps, 0 ps);
     tpd_MGTCLK_PIPERXRESETA : VitalDelayType01 := (0 ps, 0 ps);
     tpd_MGTCLK_PIPERXRESETB : VitalDelayType01 := (0 ps, 0 ps);
     tpd_MGTCLK_PIPETXCHARDISPMODEA : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_MGTCLK_PIPETXCHARDISPMODEB : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_MGTCLK_PIPETXCHARDISPVALA : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_MGTCLK_PIPETXCHARDISPVALB : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_MGTCLK_PIPETXCHARISKA : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_MGTCLK_PIPETXCHARISKB : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_MGTCLK_PIPETXDATAA : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
     tpd_MGTCLK_PIPETXDATAB : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
     tpd_MGTCLK_PIPETXRCVRDETA : VitalDelayType01 := (0 ps, 0 ps);
     tpd_MGTCLK_PIPETXRCVRDETB : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGBUSNUMBER : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_CFGCOMMANDBUSMASTERENABLE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGCOMMANDINTERRUPTDISABLE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGCOMMANDIOENABLE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGCOMMANDMEMENABLE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGCOMMANDSERREN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGDEVCONTROLAUXPOWEREN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGDEVCONTROLCORRERRREPORTINGEN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGDEVCONTROLENABLERO : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGDEVCONTROLEXTTAGEN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGDEVCONTROLFATALERRREPORTINGEN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGDEVCONTROLMAXPAYLOAD : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_CFGDEVCONTROLMAXREADREQ : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_CFGDEVCONTROLNONFATALREPORTINGEN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGDEVCONTROLNOSNOOPEN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGDEVCONTROLPHANTOMEN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGDEVCONTROLURERRREPORTINGEN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGDEVICENUMBER : VitalDelayArrayType01(4 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_CFGDEVSTATUSCORRERRDETECTED : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGDEVSTATUSFATALERRDETECTED : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGDEVSTATUSNONFATALERRDETECTED : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGDEVSTATUSURDETECTED : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGDO : VitalDelayArrayType01(31 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_CFGERRCPLRDYN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGFUNCTIONNUMBER : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_CFGINTERRUPTDO : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_CFGINTERRUPTMMENABLE : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_CFGINTERRUPTMSIENABLE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGINTERRUPTRDYN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGLINKCONTOLRCB : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGLINKCONTROLASPMCONTROL : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_CFGLINKCONTROLCOMMONCLOCK : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGLINKCONTROLEXTENDEDSYNC : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGPCIELINKSTATEN : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_CFGRDWRDONEN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_CFGTOTURNOFFN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_DBGBADDLLPSTATUS : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_DBGBADTLPLCRC : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_DBGBADTLPSEQNUM : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_DBGBADTLPSTATUS : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_DBGDLPROTOCOLSTATUS : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_DBGFCPROTOCOLERRSTATUS : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_DBGMLFRMDLENGTH : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_DBGMLFRMDMPS : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_DBGMLFRMDTCVC : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_DBGMLFRMDTLPSTATUS : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_DBGMLFRMDUNRECTYPE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_DBGPOISTLPSTATUS : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_DBGRCVROVERFLOWSTATUS : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_DBGREGDETECTEDCORRECTABLE : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_DBGREGDETECTEDFATAL : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_DBGREGDETECTEDNONFATAL : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_DBGREGDETECTEDUNSUPPORTED : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_DBGRPLYROLLOVERSTATUS : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_DBGRPLYTIMEOUTSTATUS : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_DBGURNOBARHIT : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_DBGURPOISCFGWR : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_DBGURSTATUS : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_DBGURUNSUPMSG : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_MIMRXRADDR : VitalDelayArrayType01(11 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_MIMRXREN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_MIMRXWADDR : VitalDelayArrayType01(11 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_MIMRXWDATA : VitalDelayArrayType01(34 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_MIMRXWEN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_MIMTXRADDR : VitalDelayArrayType01(11 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_MIMTXREN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_MIMTXWADDR : VitalDelayArrayType01(11 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_MIMTXWDATA : VitalDelayArrayType01(35 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_MIMTXWEN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_RECEIVEDHOTRESET : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_TRNFCCPLD : VitalDelayArrayType01(11 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_TRNFCCPLH : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_TRNFCNPD : VitalDelayArrayType01(11 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_TRNFCNPH : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_TRNFCPD : VitalDelayArrayType01(11 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_TRNFCPH : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_TRNLNKUPN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_TRNRBARHITN : VitalDelayArrayType01(6 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_TRNRD : VitalDelayArrayType01(31 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_TRNREOFN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_TRNRERRFWDN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_TRNRSOFN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_TRNRSRCDSCN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_TRNRSRCRDYN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_TRNTBUFAV : VitalDelayArrayType01(5 downto 0) := (others => (0 ps, 0 ps));
     tpd_USERCLK_TRNTCFGREQN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_TRNTDSTRDYN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_TRNTERRDROPN : VitalDelayType01 := (0 ps, 0 ps);
     tpd_USERCLK_USERRSTN : VitalDelayType01 := (0 ps, 0 ps);
     tperiod_MGTCLK_posedge : VitalDelayType := 0 ps;
     tperiod_USERCLK_posedge : VitalDelayType := 0 ps;
     tsetup_CFGDEVID_USERCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_CFGDEVID_USERCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_CFGDSN_USERCLK_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     tsetup_CFGDSN_USERCLK_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
     tsetup_CFGDWADDR_USERCLK_negedge_posedge : VitalDelayArrayType(9 downto 0) := (others => 0 ps);
     tsetup_CFGDWADDR_USERCLK_posedge_posedge : VitalDelayArrayType(9 downto 0) := (others => 0 ps);
     tsetup_CFGERRCORN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGERRCORN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGERRCPLABORTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGERRCPLABORTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGERRCPLTIMEOUTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGERRCPLTIMEOUTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGERRECRCN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGERRECRCN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGERRLOCKEDN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGERRLOCKEDN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGERRPOSTEDN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGERRPOSTEDN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGERRTLPCPLHEADER_USERCLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tsetup_CFGERRTLPCPLHEADER_USERCLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
     tsetup_CFGERRURN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGERRURN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGINTERRUPTASSERTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGINTERRUPTASSERTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGINTERRUPTDI_USERCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_CFGINTERRUPTDI_USERCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_CFGINTERRUPTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGINTERRUPTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGPMWAKEN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGPMWAKEN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGRDENN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGRDENN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGREVID_USERCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_CFGREVID_USERCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
     tsetup_CFGSUBSYSID_USERCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_CFGSUBSYSID_USERCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_CFGSUBSYSVENID_USERCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_CFGSUBSYSVENID_USERCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_CFGTRNPENDINGN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGTRNPENDINGN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGTURNOFFOKN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGTURNOFFOKN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_CFGVENID_USERCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_CFGVENID_USERCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_MIMRXRDATA_USERCLK_negedge_posedge : VitalDelayArrayType(34 downto 0) := (others => 0 ps);
     tsetup_MIMRXRDATA_USERCLK_posedge_posedge : VitalDelayArrayType(34 downto 0) := (others => 0 ps);
     tsetup_MIMTXRDATA_USERCLK_negedge_posedge : VitalDelayArrayType(35 downto 0) := (others => 0 ps);
     tsetup_MIMTXRDATA_USERCLK_posedge_posedge : VitalDelayArrayType(35 downto 0) := (others => 0 ps);
     tsetup_PIPEGTRESETDONEA_MGTCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPEGTRESETDONEA_MGTCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPEGTRESETDONEB_MGTCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPEGTRESETDONEB_MGTCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPEPHYSTATUSA_MGTCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPEPHYSTATUSA_MGTCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPEPHYSTATUSB_MGTCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPEPHYSTATUSB_MGTCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERXCHARISKA_MGTCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_PIPERXCHARISKA_MGTCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_PIPERXCHARISKB_MGTCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_PIPERXCHARISKB_MGTCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
     tsetup_PIPERXDATAA_MGTCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_PIPERXDATAA_MGTCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_PIPERXDATAB_MGTCLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_PIPERXDATAB_MGTCLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
     tsetup_PIPERXENTERELECIDLEA_MGTCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERXENTERELECIDLEA_MGTCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERXENTERELECIDLEB_MGTCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERXENTERELECIDLEB_MGTCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_PIPERXSTATUSA_MGTCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_PIPERXSTATUSA_MGTCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_PIPERXSTATUSB_MGTCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_PIPERXSTATUSB_MGTCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_TRNFCSEL_USERCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_TRNFCSEL_USERCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
     tsetup_TRNRDSTRDYN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNRDSTRDYN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNRNPOKN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNRNPOKN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNTCFGGNTN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNTCFGGNTN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNTD_USERCLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tsetup_TRNTD_USERCLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
     tsetup_TRNTEOFN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNTEOFN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNTERRFWDN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNTERRFWDN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNTSOFN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNTSOFN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNTSRCDSCN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNTSRCDSCN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNTSRCRDYN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNTSRCRDYN_USERCLK_posedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNTSTRN_USERCLK_negedge_posedge : VitalDelayType := 0 ps;
     tsetup_TRNTSTRN_USERCLK_posedge_posedge : VitalDelayType := 0 ps
  );
  port (
     CFGBUSNUMBER : out std_logic_vector(7 downto 0);
     CFGCOMMANDBUSMASTERENABLE : out std_ulogic;
     CFGCOMMANDINTERRUPTDISABLE : out std_ulogic;
     CFGCOMMANDIOENABLE : out std_ulogic;
     CFGCOMMANDMEMENABLE : out std_ulogic;
     CFGCOMMANDSERREN : out std_ulogic;
     CFGDEVCONTROLAUXPOWEREN : out std_ulogic;
     CFGDEVCONTROLCORRERRREPORTINGEN : out std_ulogic;
     CFGDEVCONTROLENABLERO : out std_ulogic;
     CFGDEVCONTROLEXTTAGEN : out std_ulogic;
     CFGDEVCONTROLFATALERRREPORTINGEN : out std_ulogic;
     CFGDEVCONTROLMAXPAYLOAD : out std_logic_vector(2 downto 0);
     CFGDEVCONTROLMAXREADREQ : out std_logic_vector(2 downto 0);
     CFGDEVCONTROLNONFATALREPORTINGEN : out std_ulogic;
     CFGDEVCONTROLNOSNOOPEN : out std_ulogic;
     CFGDEVCONTROLPHANTOMEN : out std_ulogic;
     CFGDEVCONTROLURERRREPORTINGEN : out std_ulogic;
     CFGDEVICENUMBER : out std_logic_vector(4 downto 0);
     CFGDEVSTATUSCORRERRDETECTED : out std_ulogic;
     CFGDEVSTATUSFATALERRDETECTED : out std_ulogic;
     CFGDEVSTATUSNONFATALERRDETECTED : out std_ulogic;
     CFGDEVSTATUSURDETECTED : out std_ulogic;
     CFGDO : out std_logic_vector(31 downto 0);
     CFGERRCPLRDYN : out std_ulogic;
     CFGFUNCTIONNUMBER : out std_logic_vector(2 downto 0);
     CFGINTERRUPTDO : out std_logic_vector(7 downto 0);
     CFGINTERRUPTMMENABLE : out std_logic_vector(2 downto 0);
     CFGINTERRUPTMSIENABLE : out std_ulogic;
     CFGINTERRUPTRDYN : out std_ulogic;
     CFGLINKCONTOLRCB : out std_ulogic;
     CFGLINKCONTROLASPMCONTROL : out std_logic_vector(1 downto 0);
     CFGLINKCONTROLCOMMONCLOCK : out std_ulogic;
     CFGLINKCONTROLEXTENDEDSYNC : out std_ulogic;
     CFGLTSSMSTATE : out std_logic_vector(4 downto 0);
     CFGPCIELINKSTATEN : out std_logic_vector(2 downto 0);
     CFGRDWRDONEN : out std_ulogic;
     CFGTOTURNOFFN : out std_ulogic;
     DBGBADDLLPSTATUS : out std_ulogic;
     DBGBADTLPLCRC : out std_ulogic;
     DBGBADTLPSEQNUM : out std_ulogic;
     DBGBADTLPSTATUS : out std_ulogic;
     DBGDLPROTOCOLSTATUS : out std_ulogic;
     DBGFCPROTOCOLERRSTATUS : out std_ulogic;
     DBGMLFRMDLENGTH : out std_ulogic;
     DBGMLFRMDMPS : out std_ulogic;
     DBGMLFRMDTCVC : out std_ulogic;
     DBGMLFRMDTLPSTATUS : out std_ulogic;
     DBGMLFRMDUNRECTYPE : out std_ulogic;
     DBGPOISTLPSTATUS : out std_ulogic;
     DBGRCVROVERFLOWSTATUS : out std_ulogic;
     DBGREGDETECTEDCORRECTABLE : out std_ulogic;
     DBGREGDETECTEDFATAL : out std_ulogic;
     DBGREGDETECTEDNONFATAL : out std_ulogic;
     DBGREGDETECTEDUNSUPPORTED : out std_ulogic;
     DBGRPLYROLLOVERSTATUS : out std_ulogic;
     DBGRPLYTIMEOUTSTATUS : out std_ulogic;
     DBGURNOBARHIT : out std_ulogic;
     DBGURPOISCFGWR : out std_ulogic;
     DBGURSTATUS : out std_ulogic;
     DBGURUNSUPMSG : out std_ulogic;
     MIMRXRADDR : out std_logic_vector(11 downto 0);
     MIMRXREN : out std_ulogic;
     MIMRXWADDR : out std_logic_vector(11 downto 0);
     MIMRXWDATA : out std_logic_vector(34 downto 0);
     MIMRXWEN : out std_ulogic;
     MIMTXRADDR : out std_logic_vector(11 downto 0);
     MIMTXREN : out std_ulogic;
     MIMTXWADDR : out std_logic_vector(11 downto 0);
     MIMTXWDATA : out std_logic_vector(35 downto 0);
     MIMTXWEN : out std_ulogic;
     PIPEGTPOWERDOWNA : out std_logic_vector(1 downto 0);
     PIPEGTPOWERDOWNB : out std_logic_vector(1 downto 0);
     PIPEGTTXELECIDLEA : out std_ulogic;
     PIPEGTTXELECIDLEB : out std_ulogic;
     PIPERXPOLARITYA : out std_ulogic;
     PIPERXPOLARITYB : out std_ulogic;
     PIPERXRESETA : out std_ulogic;
     PIPERXRESETB : out std_ulogic;
     PIPETXCHARDISPMODEA : out std_logic_vector(1 downto 0);
     PIPETXCHARDISPMODEB : out std_logic_vector(1 downto 0);
     PIPETXCHARDISPVALA : out std_logic_vector(1 downto 0);
     PIPETXCHARDISPVALB : out std_logic_vector(1 downto 0);
     PIPETXCHARISKA : out std_logic_vector(1 downto 0);
     PIPETXCHARISKB : out std_logic_vector(1 downto 0);
     PIPETXDATAA : out std_logic_vector(15 downto 0);
     PIPETXDATAB : out std_logic_vector(15 downto 0);
     PIPETXRCVRDETA : out std_ulogic;
     PIPETXRCVRDETB : out std_ulogic;
     RECEIVEDHOTRESET : out std_ulogic;
     TRNFCCPLD : out std_logic_vector(11 downto 0);
     TRNFCCPLH : out std_logic_vector(7 downto 0);
     TRNFCNPD : out std_logic_vector(11 downto 0);
     TRNFCNPH : out std_logic_vector(7 downto 0);
     TRNFCPD : out std_logic_vector(11 downto 0);
     TRNFCPH : out std_logic_vector(7 downto 0);
     TRNLNKUPN : out std_ulogic;
     TRNRBARHITN : out std_logic_vector(6 downto 0);
     TRNRD : out std_logic_vector(31 downto 0);
     TRNREOFN : out std_ulogic;
     TRNRERRFWDN : out std_ulogic;
     TRNRSOFN : out std_ulogic;
     TRNRSRCDSCN : out std_ulogic;
     TRNRSRCRDYN : out std_ulogic;
     TRNTBUFAV : out std_logic_vector(5 downto 0);
     TRNTCFGREQN : out std_ulogic;
     TRNTDSTRDYN : out std_ulogic;
     TRNTERRDROPN : out std_ulogic;
     USERRSTN : out std_ulogic;
     CFGDEVID : in std_logic_vector(15 downto 0);
     CFGDSN : in std_logic_vector(63 downto 0);
     CFGDWADDR : in std_logic_vector(9 downto 0);
     CFGERRCORN : in std_ulogic := 'L';
     CFGERRCPLABORTN : in std_ulogic := 'L';
     CFGERRCPLTIMEOUTN : in std_ulogic := 'L';
     CFGERRECRCN : in std_ulogic := 'L';
     CFGERRLOCKEDN : in std_ulogic := 'L';
     CFGERRPOSTEDN : in std_ulogic := 'L';
     CFGERRTLPCPLHEADER : in std_logic_vector(47 downto 0);
     CFGERRURN : in std_ulogic := 'L';
     CFGINTERRUPTASSERTN : in std_ulogic := 'L';
     CFGINTERRUPTDI : in std_logic_vector(7 downto 0);
     CFGINTERRUPTN : in std_ulogic := 'L';
     CFGPMWAKEN : in std_ulogic := 'L';
     CFGRDENN : in std_ulogic := 'L';
     CFGREVID : in std_logic_vector(7 downto 0);
     CFGSUBSYSID : in std_logic_vector(15 downto 0);
     CFGSUBSYSVENID : in std_logic_vector(15 downto 0);
     CFGTRNPENDINGN : in std_ulogic := 'L';
     CFGTURNOFFOKN : in std_ulogic := 'L';
     CFGVENID : in std_logic_vector(15 downto 0);
     CLOCKLOCKED : in std_ulogic := 'L';
     MGTCLK : in std_ulogic := 'L';
     MIMRXRDATA : in std_logic_vector(34 downto 0);
     MIMTXRDATA : in std_logic_vector(35 downto 0);
     PIPEGTRESETDONEA : in std_ulogic := 'L';
     PIPEGTRESETDONEB : in std_ulogic := 'L';
     PIPEPHYSTATUSA : in std_ulogic := 'L';
     PIPEPHYSTATUSB : in std_ulogic := 'L';
     PIPERXCHARISKA : in std_logic_vector(1 downto 0);
     PIPERXCHARISKB : in std_logic_vector(1 downto 0);
     PIPERXDATAA : in std_logic_vector(15 downto 0);
     PIPERXDATAB : in std_logic_vector(15 downto 0);
     PIPERXENTERELECIDLEA : in std_ulogic := 'L';
     PIPERXENTERELECIDLEB : in std_ulogic := 'L';
     PIPERXSTATUSA : in std_logic_vector(2 downto 0);
     PIPERXSTATUSB : in std_logic_vector(2 downto 0);
     SYSRESETN : in std_ulogic := 'L';
     TRNFCSEL : in std_logic_vector(2 downto 0);
     TRNRDSTRDYN : in std_ulogic := 'L';
     TRNRNPOKN : in std_ulogic := 'L';
     TRNTCFGGNTN : in std_ulogic := 'L';
     TRNTD : in std_logic_vector(31 downto 0);
     TRNTEOFN : in std_ulogic := 'L';
     TRNTERRFWDN : in std_ulogic := 'L';
     TRNTSOFN : in std_ulogic := 'L';
     TRNTSRCDSCN : in std_ulogic := 'L';
     TRNTSRCRDYN : in std_ulogic := 'L';
     TRNTSTRN : in std_ulogic := 'L';
     USERCLK : in std_ulogic := 'L'
  );
end component;

----- component X_PCIE_INTERNAL_1_1 -----
component X_PCIE_INTERNAL_1_1
  generic (
     ACTIVELANESIN : bit_vector := X"01";
     AERBASEPTR : bit_vector := X"110";
     AERCAPABILITYECRCCHECKCAPABLE : boolean := FALSE;
     AERCAPABILITYECRCGENCAPABLE : boolean := FALSE;
     AERCAPABILITYNEXTPTR : bit_vector := X"138";
     BAR0ADDRWIDTH : integer := 0;
     BAR0EXIST : boolean := TRUE;
     BAR0IOMEMN : integer := 0;
     BAR0MASKWIDTH : bit_vector := X"14";
     BAR0PREFETCHABLE : boolean := TRUE;
     BAR1ADDRWIDTH : integer := 0;
     BAR1EXIST : boolean := FALSE;
     BAR1IOMEMN : integer := 0;
     BAR1MASKWIDTH : bit_vector := X"00";
     BAR1PREFETCHABLE : boolean := FALSE;
     BAR2ADDRWIDTH : integer := 0;
     BAR2EXIST : boolean := FALSE;
     BAR2IOMEMN : integer := 0;
     BAR2MASKWIDTH : bit_vector := X"00";
     BAR2PREFETCHABLE : boolean := FALSE;
     BAR3ADDRWIDTH : integer := 0;
     BAR3EXIST : boolean := FALSE;
     BAR3IOMEMN : integer := 0;
     BAR3MASKWIDTH : bit_vector := X"00";
     BAR3PREFETCHABLE : boolean := FALSE;
     BAR4ADDRWIDTH : integer := 0;
     BAR4EXIST : boolean := FALSE;
     BAR4IOMEMN : integer := 0;
     BAR4MASKWIDTH : bit_vector := X"00";
     BAR4PREFETCHABLE : boolean := FALSE;
     BAR5EXIST : boolean := FALSE;
     BAR5IOMEMN : integer := 0;
     BAR5MASKWIDTH : bit_vector := X"00";
     BAR5PREFETCHABLE : boolean := FALSE;
     CAPABILITIESPOINTER : bit_vector := X"40";
     CARDBUSCISPOINTER : bit_vector := X"00000000";
     CLASSCODE : bit_vector := X"058000";
     CLKDIVIDED : boolean := FALSE;
     CONFIGROUTING : bit_vector := X"1";
     DEVICECAPABILITYENDPOINTL0SLATENCY : bit_vector := X"0";
     DEVICECAPABILITYENDPOINTL1LATENCY : bit_vector := X"0";
     DEVICEID : bit_vector := X"5050";
     DEVICESERIALNUMBER : bit_vector := X"E000000001000A35";
     DSNBASEPTR : bit_vector := X"148";
     DSNCAPABILITYNEXTPTR : bit_vector 